.wh -5 fo
.ce 4
.it"MC Reference Manual"
.sp 2
R. Arikan

Computer Systems Laboratory
.br
Queen Mary College

.sp 4
.it"INTRODUCTION"

.ti+5
.it "MC"
is a programming language and a compiler, producing Unix M6800[1]
assembler code, available on QMC Unix.
The syntax of 
.it "MC"
agree, to a great extent, with the C[2] language.

.it "1. TOKENS"

.ti+5
Tokens consist of keywords, identifiers, constants, strings,
operators and separators. Token separators may be blanks, tabs,
newlines or comments. Semicolon separate statetments.


.it "1.1 Keywords"

.ti+5
The following identifiers are reserved keywords :

			int	for
			char	do
			break	while
			loop	switch
			return	case
			goto	default
			if	else

.it "1.2 Comments"

.ti+5
Comments are introduced by the characters /* and
terminated by */.


.it "1.3 Identifier"

.ti+5
An identifier is a sequence of letters, underscore and
digits; the first character must not be digit. Upper and
lower case letters are considered different. Only the first
six characters are significant.


.it "1.4 Constants"

1.4.1 Numeric constants

.ti+5
A number is taken to be octal if it begins with 0. The hexadecimal
digits a - f (or A - F) are also recognised if the digits are preceded
by dollar '$'.

1.4.2 Character Constants

.ti+5
A character constant is 1 or 2 characters enclosed in single
quotes. Back-slash "\\" is the escape character for certain
non-graphic characters, and "\\" itself.


.it "1.5 Strings"

.ti+5
A string is a sequence of characters surrounded by double
quotes. A null byte is automatically placed by the compiler
at the end of each string.


.it "2. VARIABLES; TYPES & STORAGE CLASSES"

.ti+5
There are two basic types of variables :

.ti+15
.it "char"
one byte 8 bit
.br
.ti+15
.it "int"
double bytes 16 bit

.ti+5
There are also
.it "arrays"
of these basic types,
.it "pointers"
to objects of a given type and
.it "functions"
that may return pointers.

.ti+5
All variables must be declared before their use.

There are two storage classes :
.br
.ti+5
Local variables are local to each invocation of a function
and are not available on return.

.ti+5
Global variables are external to all functions and are
available to all functions.

.ti+5
The arguments to a function are local to the function.


.it "3. LVALUES"

.ti+5
Lvalues are places where values are stored. Simply, lvalues
are legal on the left side of an assignment. The value
of an lvalue is the value stored in the place named.



.it "4. EXPRESSIONS"

.it "4.1 Primitive Expressions"

4.1.1 Identifier

.ti+5
The type of an identifier is specified by its declaration.

4.1.2 identifier[expression]

.ti+5
Subscripted elements are primitive expressions.

4.1.3 identifier([expression[,expression])

.ti+5
A function call consist of a function name followed by
parantheses containing a possibly empty, comma separated
list of expressions, which are the arguments to the function.

.ti+5
Any actual argument of type
.it "char"
is converted to
.it "int"
before the call.

.ti+5
All function arguments are passed by value. As a result,
changes made to formal parameters cannot affect the value
of the actual parameter. However, it is possible to pass
a pointer so that the function may change the value of the
element pointed by the pointer.

.ti+5
If the function terminates by executing a return statement,
the value of the function is the value of the expression in
the parantheses of the return statement. If the type of
the identifier is not specified an integer
valued function is assumed by default.


4.1.4 constant

.ti+5
A decimal, hexadecimal, octal or character constant is an
expression. Its type is
.it"char"
if absolute value of the constant is less than 256.

4.1.5 string

.ti+5
The type of a string is 'pointer to array of char' and
the result is a pointer to the first character in the
string.

4.1.6 (expression)

.ti+5
Parantheses may surround any expression without altering
the type and value of the expression.

.it "4.2 Unary operators"

.ti+5
These operators group right-to-left.

4.2.1 - expression

.ti+5
The result is the negative of the expression.

4.2.2 ! expression

.ti+5
The result is 1 if the value of the expression is 0,
0 if the value of the expression is non-zero.

4.2.3 * expression

.ti+5
The result is an lvalue referring to the element to
which the expression points. The expression must be a
pointer.

4.2.4 & expression

.ti+5
The result is a pointer to the element referred by the
expression. The expression must be an lvalue.

4.2.5 ~ expression

.ti+5
The result is the one's complement of the expression.

4.2.6 ++ expression

.ti+5
The expression, which must be an lvalue, is incremented.
The result is the value of the expression after incrementing.
If the expression is an integer pointer it is incremented
by two, otherwise by one.

4.2.7 -- expression

.ti+5
The lvalue expression is decremented in the same way as for
the ++ operator.

4.2.8 expression ++

.ti+5
The lvalue expression is incremented in the same way as for
the prefix ++ operator. The result is the value of the
expression before incrementing.

4.2.9 expression --

.ti+5
The lvalue expression is decremented. The result is the value
of the expression before decrementing.

.it "4.3 Multiplicative operators"

.ti+5
The operators *, /, and % bind left-to-right. The type of the
result produced by these operators is
.it "int".

4.3.1 expression * expression

.ti+5
The result is the product of two expressions. 


4.3.2 expression / expression

.ti+5
The result is the quotient of the expression.

4.3.3 expression % expression

.ti+5
The % operator produces the remainder of the division
of the two expressions. The remainder has the same sign as
the dividend.

.it "4.4 Additive operators"

.ti+5
The operators + and - bind left-to-right.

4.4.1 expression + expression

.ti+5
The result is the sum of the two expressions. If both
operands are
.it "char"
the result is also
.it "char."
Otherwise the result is
.it "int."

4.4.2 expression - expression

.ti+5
The result is the difference of the operands. The same

type of consideration as for + apply.

.it "4.5 Shift Operators"

.ti+5
The operators << and >> bind left-to-right.

4.5.1 expression << expression
.br
4.5.2 expression >> expression

.ti+5
If both operands are
.it "char"
the result is
.it "char."
Otherwise the result is
.it "int"
If the second operand is negative, the result is undefined.


.it "4.6 Relational operators"

.ti+5
The relational operators group left-to-right.

4.6.1 expression <  expression
.br
4.6.2 expression >  expression
.br
4.6.3 expression <= expression
.br
4.6.4 expression >= expression
.br
4.6.5 expression == expression
.br
4.6.6 expression != expression

.ti+5
The result of pointer comparision depends on the
relative location in storage of the pointer to objects.


4.7 expression & expression

.ti+5
The bit wise logical
.it "and"
operator & bind left-to-right. The result is
.it "char"
if both operands are
.it "char ;"
otherwise it is
.it "int".

4.8 expression | expression

.ti+5
The bit wise exclusive
.it "or"
operator | binds left-to-right. The result is
.it "char"
if both operands are 
.it "char"
;
.it "int"
otherwise

4.9 expression && expression

.ti+5
The && operator return 1 if both operands are non-zero, 0
otherwise. Left to right evaluation is guaranteed.


4.10 expression || expression

.ti+5
The || operator returns 1 if either of its operands is
non-zero, 0 otherwise. Left to right evaluation is guaranteed.


.it "4.11 Assignment operators"

.ti+5
The assignment operators group right-to-left.

4.11.1 lvalue = expression

.ti+5
The expression results in assigning the value of the expression
on the right to the lvalue expression on the left.

.ti+5
If the lvalue is 
.it "char"
type and expression is
.it "int,"
only the low 8 bits of the expression is stored.

4.11.2  lvalue =+  expression
.br
4.11.3  lvalue =-  expression
.br
4.11.4  lvalue =*  expression
.br
4.11.5  lvalue =/  expression
.br
4.11.6  lvalue =%  expression
.br
4.11.7  lvalue =>> expression
.br
4.11.8  lvalue =<< expression
.br
4.11.9  lvalue =&  expression
.br
4.11.10 lvalue =|  expression
.br
4.11.11 lvalue =~  expression

.ti+5
The result of the above expressions is equivalent to
"lvalue = lvalue OP expression".


.it "5. STATEMENTS"

.ti+5
Statements must be separated by semicolon. Except where altered by
control statements, statements are executed in sequence.

.it "5.1 Expression Statements"

.ti+5
Usually these are assignments or function calls. The
general form is :

	expression ;

.it "5.2 Compound Statements"

.ti+5
Statements may be grouped together and used when one
statement is expected by surrounding them with { }.

.ti+5
At least one ';' must be contained in a compound statement.


.it "5.3 If Statements"

	if ( expression ) statement1
.br
	if ( expression ) statement1 else statement2

.ti+5
In both cases the expression is evaluated and if it is
non-zero, the statement1 is executed. In the second case
statement2 is executed if the expression evaluates to 0. The
.it "else"
ambiguity is resolved by connecting an
.it "else"
with the last encountered elseless
.it "if"
.


.it "5.4 While statement"

	while ( expr ) stat

.ti+5
The statement is executed while the expression is non-zero.
The test occur before each execution of the statement.


.it "5.5 Do statement"

.ti+7
.it "do"
statement
.it "while"
( expression )

.ti+5
The statement is executed while the expression is non-zero.
The test occurs after each execution of the statement.


.it "5.6 For statement"

.ti+7
.it "for"
( expr1 ; expr2 ; expr3 ) statement

.ti+5
The
.it "for"
statement is equivalent to :

.ti+20
expr1
.br
.ti+20
.it "while"
( expr2 ) {
.br
.ti+20
statement
.br
.ti+20
expr3;
.br
.ti+20
}

.ti+5
Any or all of the expressions may not be present.

.it "5.7 Switch statement"

.ti+7
.it "switch"
( expression ) statement

.ti+5
The statement is typically compound. Each statement within
the statement may be labelled with
.it "case":

.ti+7
.it "case"
constant : statement

.ti+5
The
.it "case"
constants must be distinct.

.ti+5
There may also be one statement of the form 

.ti+7
.it "default"
: statement.

.ti+5
The expression after the
.it "switch"
is evaluated. If one of the
.it "case"
constants is equal to the value of the expression, control
is passed to the statement following the matched
.it "case"
label. If no
.it "case"
constant matches the expression, and if there is a
.it "default"
label, control passes to its statement. Otherwise control
passes to the point just after the switch statement.

.it "5.8 Break statement"

.ti+7
.it "break"
;

.ti+5
Causes termination of the smallest enclosing
.it "for,"
.it "while,"
.it "do,"
or
.it "switch"
statement.

.it "5.9 Loop statement"

.ti+7
.it "loop"
;

.ti+5
Causes control to pass to the end of the smallest enclosing
.it "for,"
.it "do,"
or
.it "while"
statement.

.it "5.10 Return statement"

.ti+7
.it "return ;"
.br
.ti+7
.it "return"
( expression ) ;

.ti+5
The return statement causes the termination of a function.
In the first case no value is returned. In the second case the
value of the expression is returned to the caller of the
function.

.it "5.11 Goto statement"

.ti+7
.it "goto"
identifier :

.ti+5
Causes an unconditional transfer to the
identifier, which must be a label.

.it "5.12 Labelled statement"

.ti+7
[identifier :] statement

.ti+5
Any statement may be preceded by a label. Only local labels are
permitted.

.it "5.13 Null statement"

.ti+5
The form is :

.ti+7
;

.ti+5
Each compound statement must at least contain this.

.it"5.14 Machine code statement"

.ti+7
? mcode ?

.ti+5
Where "mcode" is any sequence of characters, the "?" may be
escaped with a back-slash.


.it "6. DECLARATIONS"

.ti+5
Before a name may be used in a
.it"MC"
program it must be declared.

.ti+5
The syntatic form of the declaration is :
.br
.ti+20
type-sp declarator-list ;
.br
If the type-sp is missing from a declaration, it
is taken to be
.it "int".


.it "6.1 Type-sp"

.ti+5
The type specifiers are :
.br
.ti+20
.it "int"
.br
.ti+20
.it "char"


.it "6.2 Declarator-list"

.ti+5
In a declaration, a possibly empty comma-separated
sequence of declarators form a declarator-list.

.ti+5
The syntatic form of
.it"declarators"
is :

.ti+5
declarator :
.in+20
.br
identifier
.br
* identifier
.br
declarator[constant-expr]
.in-20

.ti+5
If the 
.it "constant-expr" 
is not present its value is assumed to be 1.

.ti+5
Only one dimensional arrays are permitted.



.it"7. PROGRAMS"

.ti+5
A
.it"MC"
program is a collection of external definitions. There are five
types of external definitions : data definition, function definition,
defined constants, include file definition and machine code
definition.

.it"7.1 Data definition"

.ti+5
The syntatic form is :
.br
.ti+20
type-sp init-decl-list ;

.ti+5
init-decl-list :
.br
.ti+20
[init-declarator [, init-decl-list]]

.ti+5
init-declarator :
.br
.ti+20
declarator initializer

.ti+5
An
.it"initializer"
is a possibly empty expression, or a comma separated
list of expressions surrounded by braces. The braces
may be ommitted if the expression is a plain constant.
.br
.ti+5
initializer :
.in+20
.br
empty
.br
&identifier
.br
&identifier[constant-expr]
.br
numeric constant
.br
character constant
.br
string
.br
{ compile-time-expr }
.in-20

.ti+5
compile-time-expr :
.in+20
.br
&identifier
.br
&identifier[constant-expr]
.br
constant-expr
.br
string
.br
compile-time-expr[, compile-time-expr]
.in-20

.ti+5
constant-expr :
.br
These expressions are built up from numeric constants, character
constants and defined constants. The following operators are
available :

.ti+5
the unary operators :
.br
.ti+20
-   !   ~
.br
.ti+5
and the binary operators :
.br
.ti+20
+   -   *   /   %   &   |   ^   >>   <<

.it"7.2 Defined constants"

.ti+5
The syntatic form is :
.br
.ti+20
.it"define"
identifier constant-expr

.ti+5
The constant-expr is evaluated at compile time and its
value is associated with the identifier which remains
the same throughout execution.

.it"7.3 Function definition"

.ti+5
The syntatic form is :
.br
.ti+20
function-declarator function-body
.br
.ti+20
type-sp function-declarator function-body

.ti+5
function-declarator :
.br
.in+20
declarator()
.br
declarator(idnetifier1,.....,identifierN)
.br
declarator(identifier1,.....,identifierN) type-decl-list
.in-20

Where
.it"type-decl-list"
is a form of declaration which give the type of the formal
parameters.

.ti+5
The
.it"function-body"
is a compound statement with optional declarations at the start.

.ti+5
function-body :
.br
.in+20
{ stat1,.....,statN }
.br
{ declaration stat1,.....,statN }
.in-20

Wher stat1 to statN are statements.

.it"7.4 Included files"

.ti+5
The syntatic form is :
.br
.ti+20
.it"include"
"filename"

At compile time the file given by the
.it"filename"
may be included in the source. Nested includes are not allowed.

.it"7.5 Machine code definition"

.ti+5
The syntatic form is :
.br
.ti+20
identifier ? mcode ?
.br
.ti+20
? mcode ?

.ti+5
The
.it"mcode"
may possibly be empty.
.br
.ti+5
In the first case the identifier is entered into
the symbol table. If "mcode" is empty the machine code library
is searched for that name. Otherwise the library is not searched.
Thus one can redefine the library routines.



.it"8. SCOPE RULES"

.ti+5
The scope of a formal parameter list of a function definition
or the scope of names declared in the body of the function is
the body of the function.

.ti+5
The scope of names declared in external definitions extends
from their definition through the end of the program.

.ti+5
If two variables have identical scopes then they must have
distinct names.
.sp 6
.it"REFERENCES"

[1] J. Rowson, "The Unix Motorola M6800 Assembler Reference Manual".
.br
[2] D.M. Ritchie, "C Reference Manual".
