/*
 * Text structure.
 * One allocated per pure
 * procedure on swap device.
 * Manipulated by text.c
 */
struct text
{
	int	x_daddr;	/* disk address of segment */
	int	x_caddr;	/* core address, if loaded */
	int	x_size;		/* size (*64) */
	int	*x_iptr;	/* inode of prototype */
	char	x_count;	/* reference count */
	char	x_ccount;	/* number of loaded references */
} text[NTEXT];

/*
 * x_iptr flags for shared data areas.
 *
 * Document # 14.
 */
#define	XBUSY	1	/* sda being swapped out; don't swap in. */
#define	XWANT	2	/* want to swap in. */
#define	XSDAP	4	/* entry is for sda, not free. */
