.th POP VII 6/22/76
.sh NAME
pop \*- `windowing' functions for cursor addressable vdus
.sh SYNOPSIS
.bd "/lib/libw.a"
.sh OUTLINE
The POP library functions
allow programs to select and position
various ``pieces of perspex'' on cursor addressable vdus.
Each piece of perspex (POP) can then be used
as a distinct IO channel
with independent dynamic display capabilities.
A complete character map of the contents of the POPs
is maintained at all times by the system
and functions are provided which enable the contents to
be examined.
A line editor is also included to allow the terminal
user to create a text line exactly as it appears on the screen.
In addition, some generalized `menu' functions are available in conjunction
with the POP functions.
.s3
Much of the design has been influenced by the characteristics
of tty compatible vdus.
Therefore many compromises have been made
in order to reduce
the amount of cursor positioning necesssary.
Since the display and clearing of large areas
of the screen takes a significant time
no sensible overlapping policy is implemented.
.s3
The POP system controls the tty mode of the
terminal line and is set at the first call to open a POP.
This tty mode should not be changed externally, nor should
any other IO be interspered with the use of these functions.
The system operates in RARE mode which is precisely the
same as RAW mode except that the interrupt and quit
characters are trapped by the tty driver and signals
sent as in COOKED mode.
(This is not essential and RAW mode does suffice.)
.s3
In the following descriptions
any specific references to screen sizes
or characters refer to the system
as used on the modified ITT 3210 terminals
at the Computer Systems Laboratory, Queen Mary College.
.sh DESCRIPTION
When each POP is created, you provide information describing where
on the screen it should be positioned.
Thereafter a POP may not be moved within the two dimensions
of the video screen.
POPs may however move in a notional 3rd. dimension,
the concept being introduced
to describe the visible consequences
of overlapping POPs.
.s3
Only the current top POP may be written to.
The function
.it pselect
will raise a POP to the top permanently until the next
call of the function.
The top POP selected by a call to
.it pselect
is named
.it popout
and an external variable with this name
may be used for referring to this top POP.
The value of
.it popout
must not be changed directly, but only through
.it "pselect."
Various POP IO functions will however raise a POP temporarily to the
top for the duration of the call, and then push
.it popout
back to the top.
This arrangement has been implemented
in order to
reduce the amount of
cursor positioning necessary before character output
and for programming convenience
when doing a large amount of
IO on one POP.
.s3
The visible consequence of this arrangement
is that all POPS are displayed at all times.
However,
when output takes place on a POP, any
text directly underneath on other POPs will
be permanently obscured.
This also applies when a POP is cleared by writing ``spaces''.
.sh "POP OUTPUT"
Associated with each POP is a Felt Tip marker, an
IO mode and a tabset.
The effect of writing a character onto a POP
is dependent on these variables as well as the
class of the character written.
.s3
The current position of the FT indicates the position
at which the POP will next be addressed when an
IO function is requested.
The screen cursor indicates the position of the FT
for the current top POP.
.s3
Each of the characters 0 thru 0177 has a POP IO character class
which may vary depending on the vdu in use.
The following descriptions
define the result of writing a single character of the
specified class onto a POP.
.s3
.ti-5
.it "class ONE"
(040 thru 0172 excluding 0140):
.br
The character is written to the POP
replacing
any existing character at FT.
Then the FT is moved
forward one character position to the right.
If this takes the FT off the POP by one position
all further output to the POP will then be ignored
until the FT is moved to the left or reset.
.s3
.ti-5
.it "class NL"
(012):
.br
The FT is moved to the start of the
next POP line.
If this results in the FT being moved below
the bottom of the POP and neither ROLL nor PAGE
mode is set, any futher output will be ignored
until the FT is reset.
.s3
If ROLL mode is set, then the POP is
treated as a circular drum and the line below
the current FT line is always kept clear.
When line overflow occurs at the bottom of the POP,
the FT is moved to the top line again.
.s3
If PAGE mode is set and line overflow occurs due
to the output of a character of class NL
all further output is suspended
until a character is typed at the keyboard.
The POP is then cleared and subsequent output
continues from the `home' position.
.s3
.ti-5
.it "class CR"
(015):
.br
The FT is moved to the start of the current line.
.s3
.ti-5
.it "class TAB"
(011):
.br
If the POP tabset is zero, the character
is treated as if it is of class IGN.
Otherwise, the appropriate number of ``space''
characters (class ONE) are written to move
the FT to the next tab position
on the current line.
.s3
.ti-5
.it "class BELL"
(07):
.br
Are treated as class IGN except that the character is output
to the terminal directly (used for local terminal
features like bells).
.s3
.ti-5
.it "class RIGHT"
(01):
.br
Moves the FT one character position to the right.
If this takes the FT off the POP, all further
output in the POP is ignored until
the FT is moved back onto the POP
(by a `seek' or output of a character
of class LEFT, CR or NL).
.s3
.ti-5
.it "class LEFT"
(010):
.br
Moves the FT one position to the left unless it is already
at the left edge of the POP.
.s3
.ti-5
.it "class IGN"
(0 thru 037, 0177 excluding those given previously):
.br
These characters are completely ignored.
.s3
.ti-5
.it "class MAP"
(0140, 0173 thru 0176):
.br
These are the printing characters which cannot
be displayed on the terminal.
They are instead represented by \c
where ``c'' is a suitable character of class ONE
(as is ``\\'').
The output mapping only occurs if ITT mode is set
in the POP.
Otherwise, the characters are treated as if of class IGN.
.sh "SCREEN CHARACTER MAP"
For the duration of the POP system, a character array of the
current screen contents is maintained.
Initially, the map is initialized to spaces to correspond
with the screen clear performed at the first
.it popen
call.
As output occurs to a POP (through an output
function or echoed by an input function)
the map is updated to contain exactly what is displayed
on the screen.
.s3
In addition to the screen map functions described below, the
map has one other important use.
At initialization time, the POP system sets a trap for the
quit signal (only possible if in RARE mode).
On every occurrence of catching a quit, the screen is cleared
(by sending the appropriate character codes)
and the map is used to recreate the screen.
This is not always successful (e.g. if the quit is caught
in the middle of the cursor positioning function), but
a repetition of the signal should usually recreate
the display correctly.
.s3
Only the characters of POP class ONE
are stored in the map.
.sh "BASIC FUNCTIONS"
.s1
.ti-5
.bd "popen(sp)"
.br
.it Sp
is the address of a structure of the form:
.ne 8
.in+10
.s3
struct screenpos {
.in+8
.br
int hmin;
.br
int hmax;
.br
int vmin;
.br
int vmax;
.in-8
.br
};
.in-10
.s3
.it Hmin
and
.it hmax
describe respectively the left-most and right-most character
positions (1-80)
on the screen for the new POP.
.it Vmin
and
.it vmax
describe respectively the top and the bottom lines (1-18) on the
screen for the new POP.
The POP is opened with modes ROLL, ECHO and ITT set by default.
.s3
If any of these values is invalid or there are
already the maximum number of POPs open
(at present 32), -1 is returned.
Otherwise the POP descriptor (0-31) is returned.
.s1
.ti-5
.bd
pclose(popid)
.br
If
.it popid
is a valid POP descriptor (i.e. refers to an open POP)
then the POP is closed and no further
IO may take place on it (even to clear it).
This releases the descriptor for use in a further
.bd popen
call.
-1 is returned for an invalid
.it "popid,"
otherwise 0.
.s1
.ti-5
.bd pexit()
.br
It is not necessary to call this function on program exit,
but it will reset the original tty mode,
flush any remaining POP output,
move the cursor to the bottom of the screen and then exit.
.s1
.ti-5
.bd pflush()
.br
Flushes any output in the buffers.
All output is buffered in screen size quantities and is only
flushed to the terminal when this function is called.
This is done automatically by any input functions
and by the exit function
.it "pexit."
.s1
.ti-5
.bd pclear(popid)
.br
Clears the POP defined by POP descriptor
.it popid
and sets the POP FT to the top left of the POP.
-1 is returned for an invalid
.it "popid,"
else 0.
.s1
.ti-5
.bd "pselect(popid)"
.br
If
.it popid
is a valid POP descriptor, it is moved to the top
of the stack of POPs.
.bd Popout
is set to
.it "popid,"
and any IO functions called
which refer to 
.it popout
will now use this POP.
-1 is returned for an invalid
.it popid
otherwise 0.
.s1
.ti-5
.bd "pvseek(popid, switch, offset)"
.br
The FT for
.it popid
is moved to the specified position
depending on the value of
.it switch
as follows:
.s3
.in+10
.in+15
.ti-15
.it switch
is 0    FT is moved to
.it offset
lines down from the top of the POP
.br
.ti-15
.it switch
is 1    FT is moved
.it offset
lines up or down from its current position.
If
.it offset
is positive the movement is down, otherwise up.
.br
.ti-15
.it switch
is 2    FT is moved to
.it offset
lines up from the bottom line
of the POP.
.in-15
.in-10
.s3
If the new position of FT is not on the POP
or if
.it popid
is invalid, the call has no effect and -1 is returned.
Otherwise, 0 is returned.
.s1
.ti-5
.bd "phseek(popid, switch, offset)"
.br
The FT for
.it popid
is moved to the specified position
depending on the value of
.it switch
as follows:
.s3
.in+25
.ti-15
.it switch
is 0    FT is moved to
.it offset
character positions from the left-hand side of the POP.
.br
.ti-15
.it switch
is 1    FT is moved
.it offset
character positions to the right or left of its
current position.
A positive value of
.it offset
indicates a move to the right.
.br
.ti-15
.it switch
is 2     FT is moved to
.it offset
character positions from the right of the POP.
.in-25
.s3
For an invalid move or an invalid
.it popid
-1 is returned, else 0.
.s1
.ti-5
.bd "pborder(popid, hc, vc)"
.br
.ti-5
.it "char hc, vc;"
.br
Draws a border of single
characters around the specified POP.
The border is drawn outside the POP
with
.it hc
characters on the horizontal border and with
.it vc
characters on the vertical border.
The FT is unaffected by this function.
.s3
Note that to clear the border of a POP, it is only
necessary to call
.bd pborder
with both character arguments
equal to ``space''.
.s1
.ti-5
.bd "pcline(popid, lineno)"
.br
Clears the POP line specified by
.it "lineno."
The FT is unaffected by this function.
-1 is returned for invalid arguments, otherwise 0.
.s1
.ti-5
.bd "pcoord(popid, sp)"
.br
.it Sp
should be the address of 4 words in the form of the structure
.it screenpos
defined in
.bd "popen."
The screen coordinates of the specified POP will be written into the
structure.
.s1
.ti-5
.bd "pwhere(popid, cpos)"
.br
.it Cpos
should be the address of a structure of the form
.s3
.ne 4
.in+10
struct {
.ti+8
int hpos;
.br
.ti+8
int vpos;
.br
};
.in-10
.br
The current position of the FT for
.it popid
will be written into the structure.
.sh "POP IO MODE SETTING FUNCTIONS"
.s3
Each IO mode is defined by a bit as follows:
.in+10
.s3
ECHO   01
.br
ITT    02
.br
LBREAK 04 (unimplemented)
.br
PAGE   010
.br
ROLL   020
.in-10
.s3
.ti-5
.bd "pgmode(popid)"
.br
Returns the currently set POP mode for
.it popid
if valid, else -1.
.s1
.ti-5
.bd "psmode(popid, mode)"
.br
Sets the IO mode of
.it popid
to be
.it "mode."
If
.it popid
is invalid, -1 is returned and the mode
remains unchanged.
Otherwise, 0 is returned.
.s1
.ti-5
.bd "pgtabs(popid)"
.br
Returns the current tabset for the POP
.it "popid."
A value of 0 indicates that no tab expansion
is set.
-1 is returned for an invalid argument.
.s1
.ti-5
.bd "pstabs(popid, n)"
.br
The tab setting for
.it popid
is set to
.it "n."
To remove expansion of tabs, n should be 0.
-1 is returned for an invalid
.it "popid,"
else 0.
.s3
There are usually a number of functions in existence for setting
POP modes and tabs without resorting to bits.
For those currently available
see Miscellaneous Functions.
.sh "OUTPUT FUNCTIONS"
There are two similar corresponding sets of output
functions.
Those named ``pf...'' take a POP descriptor as the first
argument and will output onto this POP.
The previous top POP, if any, is then reselected
before return to the calling program.
Those named ``p...'' output onto
.bd popout
if any POP has been selected, otherwise no output is done.
Only one description for each pair of functions is given.
.s1
.ti-5
.bd "pwrite(buffer, nbytes)"
.br
.ti-5
.bd "pfwrite(popid, buffer, nbytes)"
.br
.it Buffer
is the address of
.it nbytes
contiguous bytes which are written on the specified POP.
-1 is returned if the output POP specified
is invalid, else 0.
.s1
.ti-5
.bd "pprintf(format, args...)"
.ti-5
.br
.bd "pfprintf(popid, format, args...)"
.br
For a description of
.it format
and
.it args
see
.bd "printf(III)."
These functions work in exactly the same manner, the output
being sent to the specfied POP.
.s1
.ti-5
.bd "pputc(c)"
.br
.ti-5
.bd "pfputc(popid, c)"
.br
The character
.it c
is written to the specified POP as described
above.
If character or line overflow occurs as a
result of the output, -1 is returned.
If the character is of class IGN or is treated as such due to
the current mode of the POP, then 0 is returned.
If PAGE mode is set and the paging scheme is initiated
as a result of writing this character (of class NL only)
then the CLEAR character (014, class IGN) is returned.
Otherwise, the character
.it c
is returned as the value of the function.
.sh "INPUT FUNCTIONS"
The naming of POP input functions with ``pf...''
and ``p...'' follows the same philosophy as that
for POP output.
.s3
For large amounts of input, it is preferable to use
the line editor rather than the character input functions.
Echoing is done locally by the character functions, while
the line editor turns on
echoing in the tty driver.
.s1
.ti-5
.bd "pread()"
.br
.ti-5
.bd "pfread(popid)"
.br
A character is read from the specified POP.
It is only echoed if the POP is in ECHO mode (see above).
Characters of class IGN and BELL are read
but have no effect on the screen and so are not echoed
(bell is a local terminal feature).
Characters of class LEFT and RIGHT are echoed to
position the
FT as usual.
The character read is returned.
.s3
If the character is a `break' (see below)
the break action is performed after echoing
and update of the display.
.s1
.ti-5
.bd "pedit(buffer)"
.br
.ti-5
.bd "pfedit(popid, buffer)"
.br
The line editor allows the terminal user to build a POP line
consisitng of characters of class ONE
in
the specified POP at the current FT position.
Echoing is turned on in the tty driver regardless of
whether ECHO mode is set.
The echoing of characters of class LEFT, RIGHT, TAB, CR
and NL
is however still performed by the line editor.
BELL and IGN characters are not echoed and are ignored.
.s3
Character deletions can be made by moving the screen
cursor to the character to be deleted and by typing
another over it.
.s3
When ``newline'' is typed, the line
as it appears on the screen
is then copied by the screen map function
.it pgetl
into
.it "buffer."
Any necessary character conversions are performed by
.it pgetl
and the value of the call is returned as the value of
.it "pedit."
.s3
Break actions are operative after echoing and display
of the break character.
If ``newline'' is a break character, the break
action will be performed before return from
.it "pedit."
.sh "SCREEN MAP FUNCTIONS"
The following functions describe how the screen character
map may be used to examine the contents of
each open POP.
.s1
.ti-5
.bd "pgetc(popid, h, v)"
.br
Returns the character (only of class ONE) at relative
character position
.it h
and relative line
.it v
within popid.
If
.it popid
is invalid or the position is not on the POP
then -1 is returned.
No ITT character conversion is performed.
.s1
.ti-5
.bd "pgetl(popid, lineno, buffer)"
.br
The displayed line at
.it lineno
within
.it popid
is copied into
.it buffer
from the screen map.
Any character conversions necessary for undisplayable
characters (class MAP) are performed if ITT mode
is set in the POP.
Trailing spaces at the end of the POP line are
not copied and the resulting string in
.it buffer
is null terminated.
The number of characters copied (excluding the null)
is returned as the value of the function.
Thus for a clear line, 0 is returned.
.sh "SIGNALLING and BREAKING"
.br
The POP functions operate in RARE mode allowing
conventional UNIX signalling.
The `quit' signal is reserved by the POP system
for redisplay of the entire screen.
The `interrupt' signal is available as usual.
.s3
In addition,
up to 4 (at present) different `break' characters
may be selected for each POP.
Whenever any of these characters is input in the POP
(including at the PAGE mode interaction)
the break action specified
will immediately be taken
after the break character has been
echoed and the display updated.
.s1
.ti-5
.bd "pbreak(popid, c, act)"
.br
Sets
.it c
as a break character in
.it "popid."
The break action set depends on the value of
.it act
as follows:
.s1
If 
.it act
is 0, the action is to exit by calling
.it "pexit."
.br
If
.it act
is even, it is interpreted as the address of
a user-defined
function to be called as the break action.
.s1
To reset a character so that it is not treated as 
a break,
.it pbreak
should be called with
.it act
equal to an odd value.
.sh "MISCELLANEOUS FUNCTIONS"
.s1
.ti-5
.bd "pmove(popid, h, v)"
.br
Equivalent to:
.s3
.ti+15
.bd "pvseek(popid, 0, v)"
.br
.ti+15
.bd "phseek(popid, 0, h)"
.s3
If either of these calls returns -1, -1 is returned
otherwise 0.
.s1
.ti-5
.bd "phome(popid)"
.br
Equivalent to:
.br
.ti+15
.bd "pmove(popid, 0, 0)"
.s1
.ti-5
.bd "pecho(popid)"
.br
Sets ECHO mode in popid.
.br
.ti-5
.bd "pnoecho(popid)"
.br
Turns off ECHO in popid.
.s1
.ti-5
.bd "pnorm(popid)"
.br
Turns off dynamic output modes (i.e. ROLL and PAGE) in
.it "popid."
.s1
.ti-5
.bd "ppage(popid)"
.br
Sets PAGE mode in
.it "popid."
.s1
.ti-5
.bd "proll(popid)"
.br
Sets ROLL mode in
.it "popid."
.sh "MENU FUNCTIONS"
The following two functions can be used together with the
POP functions, for convenient
display and selection of groups of menu items.
A menu item is a structure of the form:
.s3
.in+10
struct menuitem {
.in+8
.br
char *mstring;
.br
int mpad[2];
.in-8
.br
};
.in-10
.s3
The 2nd. and 3rd. words of the item maybe of
any type.
.s3
The layout of a menu is described by a structure of the form:
.s3
.in+10
struct menudesc {
.in+8
.br
int hmin;
.br
int vmin;
.br
int nlines;
.br
int ncols;
.br
int colwidth;
.br
.in-8
};
.in-10
.s3
.it Hmin
gives the character position and
.it vmin
the line position on the screen of the top-left corner of the
POP in which the menu is to be displayed.
.it Nlines
states the number of lines to be allocated to the menu POP.
.it Ncols
should state the number of columns in which the menu should
be formatted and
.it colwidth
the number of characters for each column.
.s1
.ti-5
.bd "msetup(menulists,mdesc)"
.br
.ti-5
.bd "struct menuitem **menulists;"
.br
.ti-5
.bd "struct menudesc *mdesc;"
.s3
The list of pointers to menu lists given by
.it menulists
should be null terminated.
Each of these pointers should point to a list
of
.it menuitem
structures, which should be terminated by an
.it mstring
element pointer equal to 0.
.s3
.it Msetup
will open a POP of the appropriate size in the position specified
and will display the strings
(as defined by
.it "mstring)"
associated with each menu item in the list.
The POP descriptor of the POP in which the menu has been created
is returned as the value of
.it "msetup."
.s3
Menu items are displayed in columns until all the lines have been
filled, at which point the next column is started.
If there is not another column, the remaining items are not displayed
and cannot be selected.
.s1
.ti-5
.bd "mselect(popid, menulists, mdesc)"
.br
.ti-5
.bd "struct menuitem **menulists;"
.br
.ti-5
.bd "struct menudesc *mdesc;"
.s3
Allows selection of a menu item from within a
menu previously set up with
.it "msetup."
Movement through the menu items is made by sending
one of 4 characters for each of the 4 directional movements.
These are currently set up as the characters
sent by the arrowed function keys on the modified ITT 3210s.
They correspond as follows:
.br
.ti+15
LEFT   010
.br
.ti+15
RIGHT  040
.br
.ti+15
UP     033
.br
.ti+15
DOWN   012
.br
A single item is selected by the `SEND' ITT function key
which sends 056.
.s3
.it Popid
must be the value returned from the
.it msetup
call relating to this menu.
.it Menulists
and
.it mdesc
should point to exactly the same
lists as in the
.it msetup
call.
.s3
The returned value is of type
.it "*menuitem,"
and points to the menu item selected.
.sh BUGS
The menu
functions provide an inconsistent structure.
That is, sets of lists are passed as arguments
to allow multi-level menus easily to be displayed
as single-level menus.
However, only one menu descriptor for the layout
of the menu is provided.
.s3
It is difficult to cross-reference the positions of
menu POPs and normal POPs with each other due to the different
manner in which the position and size of each are defined.
.s3
The basic core of the POP system dealing
with POP allocation and output should be part of
the driver.
This would allow different processes
to use the screen simultaneously in a sensible
way.
