/
/ c code tables-- compile to register
/

.globl	_regtab

.data
_regtab=.
	106.;	cr106
	30.;	cr70
	31.;	cr70
	32.;	cr32
	33.;	cr32
	37.;	cr37
	38.;	cr37
	98.;	cr100
	99.;	cr100
	80.;	cr80
	40.;	cr40
	41.;	cr40	/ - like +
	42.;	cr42
	43.;	cr43
	14.;	cr43
	44.;	cr43
	45.;	cr45
	46.;	cr40
	55.; 	cr40
	48.;	cr40
	49.;	cr49
	70.;	cr70
	71.;	cr70
	72.;	cr72
	73.;	cr73
	74.;	cr74
	75.;	cr75
	76.;	cr72
	78.;	cr70
	85.;	cr70
	79.;	cr79
	102.;	cr102
	52.;	cr52
	56.;	cr56
	58.;	cr58
	59.;	cr59
	91.;	cr91
	82.;	cr82
	83.;	cr82
	84.;	cr82
	86.;	cr86
	87.;	cr86
	88.;	cr86
	0
.text

/ goto
cr102:
%a,n
	jmp	A1

%n*,n
	F*
	jmp	#1(R)

/ call
cr100:
%a,n
	jsr	pc,IA1

%n*,n
	F*
	jsr	pc,#1(R)

%n,n
	F
	jsr	pc,(R)

/ addressible
cr106:
%z,n
	clr	R

%a,n
	movB1	A1,R

%n*,n
	F*
	movB1	#1(R),R

%al,n
	mov	A1+,R+
	mov	A1,R

%nl*,n
	F*
	mov	#1+2(R),R+
	mov	#1(R),R

/ ++,-- postfix
cr32:
%a,1
	movB1	A1',R
	I'B1	A1

%aw,n
	mov	A1',R
	I	A2,A1

%e*,1
	F1*
	movB1	#1(R1),R
	I'B1	#1(R1)

%n*,1
	F*
	movB1	#1(R),-(sp)
	I'B1	#1(R)
	movB1	(sp)+,R

%ew*,n
	F1*
	mov	#1(R1),R
	I	A2,#1(R1)

%nw*,n
	F*
	mov	#1(R),-(sp)
	I	A2,#1(R)
	mov	(sp)+,R

%al,1
	F
	I	$1,A1+
	V	A1

%el*,1
	F1*
	mov	#1+2(R1),R+
	mov	#1(R1),R
	I	$1,#1+2(R1)
	V	#1(R1)

%nl*,1
	F*
	mov	#1+2(R),-(sp)
	mov	#1(R),-(sp)
	add	$1,#1+2(R)
	V	#1(R)
	mov	(sp)+,R
	mov	(sp)+,R+

/ - unary, ~
cr37:
%n,n
	F
	IBF	R

%nl,n
	F
	I	R
	I	R+
	V	R

/ =
cr80:
%a,n
	S
	movB1	R,A1

%n*,a
	F*
	movB1	A2,#1(R)
	movB1	#1(R),R

%n*,e
	F*
	S1
	movB1	R1,#1(R)
	movB1	R1,R

%n*,n
	FS*
	S
	movB1	R,*(sp)+

/ +, -, |, &~, <<
cr40:
%n,z
	F

%n,1
	F
	I'	R

%[add1:]
%n,aw
	F
	IB2	A2,R

%[add2:]
%n,ew*
	F
	S1*
	IB2	#2(R1),R

%[add3:]
%n,e
	F
	S1
	IBF	R1,R

%[add4:]
%n,nw*
	SS*
	F
	IB2	*(sp)+,R

%[add5:]
%n,n
	SS
	F
	IBF	(sp)+,R

%nl,c
	F
	I	A2,R+
	V	R

%nl,al
	F
	I	A2,R
	I	A2+,R+
	V	R

%[addl1:]
%nl,el
	F
	S1
	I	R1+,R+
	V	R
	I	R1,R

%[addl2:]
%nl,nl
	SS
	F
	I	(sp)+,R
	I	(sp)+,R+
	V	R

/ ^ -- xor
cr49:
%n,e
%	[add3]

%n,n
	FS
	S
	xor	R,(sp)
	mov	(sp)+,R

%nl,el
%	[addl1]

%nl,nl
%	[addl2]

/ >> (all complicated cases taken care of by << -)
cr45:
%n,1
	F
	asr	R

/ * -- R must be odd on integers
cr42:
%n,aw
%	[add1]

%n,ew*
%	[add2]

%n,e
%	[add3]

%n,n
%	[add5]

/ / R must be odd on integers
cr43:
%n,aw
	F
	T
	div	A2,R-

%n,ew*
	F
	T
	S1*
	div	#2(R1),R-

%n,e
	F
	T
	S1
	div	R1,R-

%n,n
	SS
	F
	T
	div	(sp)+,R-

/ =+, =-, =|, =&~
cr70:
%[addq1:]
%aw,aw
	I	A2,A1'
	mov	A1,R

%[addq1a:]
%a,aw
	movB1	A1',R
	IBF	A2,R
	movB1	R,A1

%[addq2:]
%aw,nw*
	S*
	I	#2(R),A1'
	mov	A1,R

%[addq3:]
%aw,n
	S
	I	R,A1'
	mov	A1,R

%[addq4:]
%ew*,nw*
	S*
	F1*
	I	#2(R),#1(R1)
	mov	#1(R1),R

%[addq5:]
%a,n
	SS
	movB1	A1',R
	IBF	(sp)+,R
	movB1	R,A1

%[addq7:]
%ew*,n
	S
	F1*
	I	R,#1(R1)
	mov	#1(R1),R

%[addq8:]
%nw*,n
	SS
	F*
	I	(sp)+,#1(R)
	mov	#1(R),R

%[addq9:]
%n*,n
	FS*
	SS
	movB1	*2(sp),R
	IBF	(sp)+,R
	movB1	R,*(sp)+

/ =*, =<< (for integer multiply, R must be odd)
cr72:
%a,aw
%	[addq1a]

%a,n
%	[addq5]

%n*,n
%	[addq9]

/ =/ ;  R must be odd on integers
cr73:
%a,aw
	movB1	A1',R
	sxt	R-
	divBF	A2,R-
	movB1	R-,A1

%a,n
	SS
	movB1	A1',R
	sxt	R-
	div	(sp)+,R-
	movB1	R-,A1

%e*,n
	SS
	F1*
	movB1	#1(R1),R
	sxt	R-
	div	(sp)+,R-
	movB1	R-,#1(R1)

%n*,n
	FS*
	SS
	movB1	*2(sp),R
	sxt	R-
	div	(sp)+,R-
	movB1	R-,*(sp)+

/ =mod; R must be odd on integers
cr74:
%a,aw
	movB1	A1',R
	sxt	R-
	div	A2,R-
	movB1	R,A1

%a,n
	SS
	movB1	A1',R
	sxt	R-
	div	(sp)+,R-
	movB1	R,A1

%e*,n
	SS
	F1*
	movB1	#1(R1),R
	sxt	R-
	div	(sp)+,R-
	movB1	R,#1(R1)

%n*,n
	FS*
	SS
	movB1	*2(sp),R
	sxt	R-
	div	(sp)+,R-
	mov	R,*(sp)+

/ =^ -- =xor
cr79:
%aw,n
%	[addq3]

%ab,n
	SS
	movb	A1',R
	xor	R,(sp)
	mov	(sp)+,R
	movb	R,A1

%n*,n
	FS*
	movB1	*(sp),-(sp)
	S
	xor	R,(sp)
	movB1	(sp)+,R
	movB1	R,*(sp)+

/ =>> (all complicated cases done by =<< -)
cr75:
%a,1
	asrB1	A1'
	movB1	A1,R

%n*,1
	F*
	asrB1	#1(R)
	movB1	#1(R),R

/ << for longs
cr91:
%nl,aw
%	[add1]

%nl,ew*
%	[add2]

%nl,e
%	[add3]

%nl,nw*
%	[add4]

%nl,n
%	[add5]

/ float (double) to int
cr52:
%nf,n
	FS
	jsr	pc,fisdtoi
	mov	(sp)+,R

/ float (double) to long
cr56:
%nf,n
	FS
	jsr	pc,fisdtol
	mov	(sp)+,R
	mov	(sp)+,R+

/ integer to long
cr58:
%n,n
	F1!
	sxt	R

/ long to integer
cr59:
%al,n
	mov	A1+,R

%nl*,n
	F*
	mov	#1+2(R),R

%nl,n
	F
	mov	R+,R

/ *, /, remainder for longs.
cr82:
%nl,nl
	SS
	FS
	jsr	pc,I
	add	$10,sp

/ =*, =/, =rem for longs
/ Operands of the form &x op y, so stack space is known.
cr86:
%n,nl
	SS
	FS
	jsr	pc,I
	add	$6,sp

/
/ c code tables -- compile for side effects.
/ Also set condition codes properly (except for ++, --)
/ (and except for float and double stuff)	/ado
/

.globl	_efftab

.data
_efftab=.
	30.;	ci70
	31.;	ci70
	32.;	ci70
	33.;	ci70
	80.;	ci80
	70.;	ci70
	71.;	ci70	/ - like +
	72.;	ci72	/ =*	/ado
	73.;	ci72	/ =/	/ado
	78.;	ci78
	79.;	ci79
	85.;	ci78
	75.;	ci75
	76.;	ci76
	92.;	ci92
	106.;	ci106	/load	/ado
	0
.text

/load	/ado
ci106:
%nf,n
	FS
	add	$010,sp

/ =
ci80:
%[move1:]
%a,z
	I'B1	A1

%[move2:]
%n*,z
	F*
	I'B1	#1(R)

%[move3:]
%a,aw
%ab,a
	IBE	A2,A1

%[move4:]
%ab,n*
%a,nw*
	S*
	IBE	#2(R),A1

%[move5:]
%a,n
	S
	IB1	R,A1

%[move6:]
%n*,aw
%nb*,a
	F*
	IBE	A2,#1(R)

%[move7:]
%n*,ew*
%nb*,e*
	F*
	S1*
	IBE	#2(R1),#1(R)

%[move8:]
%n*,e
	F*
	S1
	IB1	R1,#1(R)

%[move9:]
%e*,nw*
%eb*,n*
	S*
	F1*
	IBE	#2(R),#1(R1)

%[move10:]
%e*,n
	S
	F1*
	IB1	R,#1(R1)

%[move11:]
%n*,nw*
%nb*,n*
	FS*
	S*
	IBE	#2(R),*(sp)+

%[move12:]
%n*,n
	FS*
	S
	IB1	R,*(sp)+

%al,z
	clr	A1
	clr	A1+

%nl*,z
	F*
	clr	#1(R)
	clr	2+#1(R)

%[move13a:]
%al,c
	I	A2,A1+
	V	A1

%al,aw
	mov	A2,A1+
	sxt	A1

%al,nw*
	S*
	mov	#2(R),A1+
	sxt	A1

%al,n
	S
	mov	R,A1+
	sxt	A1

%[move13:]
%al,al
	I	A2,A1
	I	A2+,A1+
	V	A1

%[move14:]
%al,nl*
	S*
	I	#2(R),A1
	I	#2+2(R),A1+
	V	A1

%[move14a:]
%nl*,c
	F*
	I	A2,2+#1(R)
	V	#1(R)

%[move15:]
%al,nl
	S
	I	R,A1
	I	R+,A1+
	V	A1

%nl*,aw
	F*
	mov	A2,#1+2(R)
	sxt	#1(R)

%[move16:]
%el*,nl
	S
	F1*
	I	R+,#1+2(R1)
	V	#1(R1)
	I	R,#1(R1)

%nl*,n
	SS
	F*
	mov	(sp)+,#1+2(R)
	sxt	#1(R)

%[move17:]
%nl*,nl
	SS
	F*
	I	(sp)+,#1(R)
	I	(sp)+,#1+2(R)
	V	#1(R)

%a,nf
	SS
	jsr	pc,fisdtoi
	movB1	(sp)+,A1

%n*,nf
	SS
	jsr	pc,fisdtoi
	F*
	movB1	(sp)+,#1(R)

%ad,nf
	SS
	mov	(sp)+,A1
	mov	(sp)+,2+A1
	mov	(sp)+,4+A1
	mov	(sp)+,6+A1

%nd*,nf
	SS
	F*
	mov	(sp)+,#1(R)
	mov	(sp)+,2+#1(R)
	mov	(sp)+,4+#1(R)
	mov	(sp)+,6+#1(R)

%af,zf
	clr	A1
	clr	A1+

%nf*,zf
	F*
	clr	#1(R)
	clr	2+#1(R)

%af,cf
	mov	A2,A1
	clr	A1+

%nf*,cf
	F*
	mov	A2,#1(R)
	clr	2+#1(R)

%af,af
	mov	A2,A1
	mov	2+A2,A1+

%nf*,af
	F*
	mov	A2,#1(R)
	mov	2+A2,2+#1(R)

%af,nf*
	S*
	mov	#2(R),A1
	mov	2+#2(R),A1+

%ef*,nf*
	S*
	F1*
	mov	#2(R),#1(R1)
	mov	2+#2(R),2+#1(R1)

%af,nf
	SS
	mov	(sp)+,A1
	mov	(sp)+,A1+
	cmp	(sp)+,(sp)+

%nf*,nf
	SS
	F*
	mov	(sp)+,#1(R)
	mov	(sp)+,2+#1(R)
	cmp	(sp)+,(sp)+

/ =| and =& ~
ci78:
%a,a
%	[move3]

%a,n
%	[move5]

%n*,a
%	[move6]

%n*,e*
%	[move7]

%n*,e
%	[move8]

%e*,n*
%	[move9]

%e*,n
%	[move10]

%n*,n*
%	[move11]

%n*,n
%	[move12]

%al,c
%	[move13a]

%al,al
%	[move13]

%al,nl*
%	[move14]

%al,nl
%	[move15]

%nl*,c
%	[move14a]

%el*,nl
%	[move16]

%nl*,nl
%	[move17]

/ =^
ci79:
%al,nl
%	[move15]

%el*,nl
%	[move16]

%nl*,nl
	FS*
	S
	I	R,*(sp)
	mov	(sp)+,R
	I	R+,2(R)

/ =+
ci70:
%n*,z
%a,z

%a,1
	I'B1	A1

%aw,aw
%	[move3]

%aw,nw*
%	[move4]

%aw,n
%	[move5]

%n*,1
%	[move2]

%ew*,nw*
%	[move9]

%a,nw*
	S*
	movB1	A1',R1
	I	#2(R),R1
	movB1	R1,A1

%a,n
	S
	movB1	A1',R1
	I	R,R1
	movB1	R1,A1

%ew*,n
%	[move10]

%nw*,n
%	[move12]

%n*,n
	SS
	F*
	movB1	#1(R),R1
	I	(sp)+,R1
	movB1	R1,#1(R)

%al,c
%	[move13a]

%al,al
%	[move13]

%al,nl*
%	[move14]

%al,nl
%	[move15]

%nl*,c
%	[move14a]

%el*,nl
%	[move16]

%nl*,nl
%	[move17]

%[ci701:]
%ad,nf
	SS
	mov	A1,4(sp)
	mov	A1+,6(sp)
	fI	sp
	mov	(sp)+,A1
	mov	(sp)+,A1+
	clr	4+A1
	clr	6+A1

%[ci702:]
%nd*,nf
	SS
	F*
	mov	#1(R),4(sp)
	mov	2+#1(R),6(sp)
	fI	sp
	mov	(sp)+,#1(R)
	mov	(sp)+,2+#1(R)
	clr	4+#1(R)
	clr	6+#1(R)

%[ci703:]
%af,cf
	mov	A1+,-(sp)
	mov	A1,-(sp)
	clr	-(sp)
	mov	A2,-(sp)
	fI	sp
	mov	(sp)+,A1
	mov	(sp)+,A1+

%[ci704:]
%nf*,cf
	F*
	mov	2+#1(R),-(sp)
	mov	#1(R),-(sp)
	clr	-(sp)
	mov	A2,-(sp)
	fI	sp
	mov	(sp)+,#1(R)
	mov	(sp)+,2+#1(R)

%[ci705:]
%af,af
	mov	A1+,-(sp)
	mov	A1,-(sp)
	mov	2+A2,-(sp)
	mov	A2,-(sp)
	fI	sp
	mov	(sp)+,A1
	mov	(sp)+,A1+

%[ci706:]
%nf*,af
	F*
	mov	2+#1(R),-(sp)
	mov	#1(R),-(sp)
	mov	2+A2,-(sp)
	mov	A2,-(sp)
	fI	sp
	mov	(sp)+,#1(R)
	mov	(sp)+,2+#1(R)

%[ci707:]
%af,nf*
	mov	A1+,-(sp)
	mov	A1,-(sp)
	S*
	mov	2+#2(R),-(sp)
	mov	#2(R),-(sp)
	fI	sp
	mov	(sp)+,A1
	mov	(sp)+,A1+

%[ci708:]
%ef*,nf*
	S*
	F1*
	mov	2+#1(R1),-(sp)
	mov	#1(R1),-(sp)
	mov	2+#2(R),-(sp)
	mov	#2(R),-(sp)
	fI	sp
	mov	(sp)+,#1(R1)
	mov	(sp)+,2+#1(R1)

%[ci709:]
%af,nf
	SS
	mov	A1,4(sp)
	mov	A1+,6(sp)
	fI	sp
	mov	(sp)+,A1
	mov	(sp)+,A1+

%[ci70a:]
%nf*,nf
	SS
	F*
	mov	#1(R),4(sp)
	mov	2+#1(R),6(sp)
	fI	sp
	mov	(sp)+,#1(R)
	mov	(sp)+,2+#1(R)

/ =*, =/	/ado
ci72:
%ad,nf
%	[ci701]

%nd*,nf
%	[ci702]

%af,cf
%	[ci703]

%nf*,cf
%	[ci704]

%af,af
%	[ci705]

%nf*,af
%	[ci706]

%af,nf*
%	[ci707]

%ef*,nf*
%	[ci708]

%af,nf
%	[ci709]

%nf*,nf
%	[ci70a]

/ =>> (all harder cases handled by =<< -)
ci75:
%a,1
	asrB1	A1

%n*,1
	F*
	asrB1	#1(R)

/ =<<
ci76:
%a,1
	aslB1	A1

%n*,1
	F*
	aslB1	#1(R)

%r,aw
	ash	A2,A1

%r,nw*
	S*
	ash	#2(R),A1

%r,n
	S
	ash	R,A1

/ =<< for longs
ci92:
%al,aw
	F
	ashc	A2,R
	mov	R,A1
	mov	R+,A1+

%al,n
	SS
	F
	ashc	(sp)+,R
	mov	R,A1
	mov	R+,A1+

%nl*,n
	FS*
	SS
	mov	2(sp),R
	mov	2(R),R+
	mov	(R),R
	ashc	(sp)+,R
	mov	R,*(sp)
	mov	(sp)+,R
	mov	R+,2(R)

/
/ c code tables-- set condition codes
/

.globl	_cctab

.data
_cctab=.
	106.;	cc60
	28.;	rest
	55.;	rest
	34.;	rest
	35.;	rest
	36.;	rest
	37.;	rest
	40.;	rest
	41.;	rest
	42.;	rest
	43.;	rest
	45.;	rest
	46.;	rest
	81.;	cc81	/ & as in "if ((a&b)==0)"
	48.;	rest
	60.;	cc60
	61.;	cc60
	62.;	cc60
	63.;	cc60
	64.;	cc60
	65.;	cc60
	66.;	cc60
	67.;	cc60
	68.;	cc60
	69.;	cc60
	72.;	rest
	73.;	rest
	79.;	rest
	0
.text

/ relationals
cc60:
%a,z
%	[move1]

%n*,z
%	[move2]

%n,z
	FC

%nf,zf
	FS
	jsr	pc,fiststf

%nf,nf
	FS
	SS
	jsr	pc,fiscmpf

%aw,aw
%ab,ab
%	[move3]

%nw*,aw
%nb*,ab
%	[move6]

%n,aw
%	[add1]

%nw*,ew*
%nb*,eb*
%	[move7]

%nw*,e
%	[move8]

%n,ew*
%	[add2]

%n,e
%	[add3]

%nw*,nw*
%nb*,nb*
%	[move11]

%nw*,n
%	[move12]

%n,n
%	[add5]

/ & as in "if ((a&b) ==0)"
cc81:
%a,a
%	[move3]

%n*,a
%	[move6]

%n,a
%	[add1]

%n,e
%	[add3]

%n,n
%	[add5]

/ set codes right
rest:
%n,n
%nf,nf
	H

/
/ c code tables-- expression to -(sp)
/

.globl	_sptab

.data
_sptab=.
	106.;	cs106
	37.;	cs37	/ unary -	/ado
	40.;	cs40
	41.;	cs40
	42.;	cs42	/ *	/ado
	43.;	cs42	/ /	/ado
	55.;	cs40
	48.;	cs40
	58.;	cs58
	51.;	cs51	/ int to float (double)	/ado
	52.;	cs52	/ float (double) to int	/ado
	56.;	cs56	/ float (double) to long	/ado
	57.;	cs57	/ long to float (double)	/ado
	70.;	cs70	/ =+	/ado
	71.;	cs70	/ =-	/ado
	72.;	cs70	/ =*	/ado
	73.;	cs70	/ =/	/ado
	80.;	cs80	/ =	/ado
	0
.text

/ unary -	/ado
cs37:
%nf,n
	FS
	jsr	pc,fisnegf

/ +, -, |, &~	/ado
cs40:
%[fop1:]
%nd,cf
	FS
	clr	4(sp)
	clr	6(sp)
	clr	-(sp)
	mov	A2,-(sp)
	fI	sp

%[fop2:]
%nf,cf
	FS
	clr	-(sp)
	mov	A2,-(sp)
	fI	sp

%[fop3:]
%nd,af
	FS
	clr	4(sp)
	clr	6(sp)
	mov	2+A2,-(sp)
	mov	A2,-(sp)
	fI	sp

%[fop4:]
%nf,af
	FS
	mov	2+A2,-(sp)
	mov	A2,-(sp)
	fI	sp

%[fop5:]
%nd,nf*
	FS
	clr	4(sp)
	clr	6(sp)
	S*
	mov	2+#2(R),-(sp)
	mov	#2(R),-(sp)
	fI	sp

%[fop6:]
%nf,nf*
	FS
	S*
	mov	2+#2(R),-(sp)
	mov	#2(R),-(sp)
	fI	sp

%[fop7:]
%nd,nf
	FS
	clr	4(sp)
	clr	6(sp)
	SS
	mov	(sp)+,2(sp)
	mov	(sp)+,2(sp)
	fI	sp

%[fop8:]
%nf,nf
	FS
	SS
	mov	(sp)+,2(sp)
	mov	(sp)+,2(sp)
	fI	sp

%n,1
	FS
	I'	(sp)

%n,aw
	FS
	I	A2,(sp)

%n,nw*
	FS
	S*
	I	#2(R),(sp)

%n,n
	FS
	S
	I	R,(sp)

/ *, /	/ado
cs42:
%nd,cf
%	[fop1]

%nf,cf
%	[fop2]

%nd,af
%	[fop3]

%nf,af
%	[fop4]

%nd,nf*
%	[fop5]

%nf,nf*
%	[fop6]

%nd,nf
%	[fop7]

%nf,nf
%	[fop8]

/ int to float (double)	/ado
cs51:
%n,n
	FS
	jsr	pc,fisitod

/ float (double) to int	/ado
cs52:
%nf,n
	FS
	jsr	pc,fisdtoi

/ float (double) to long	/ado
cs56:
%nf,n
	FS
	jsr	pc,fisdtol

/ long to float (double)	/ado
cs57:
%nl,n
	FS
	jsr	pc,fisltod

/ =+, =-, =*, =/	/ado
cs70:
%ad,nf
	clr	-(sp)
	clr	-(sp)
	SS
	mov	A1,4(sp)
	mov	A1+,6(sp)
	fI	sp
	mov	(sp),A1
	mov	2(sp),2+A1
	clr	4+A1
	clr	6+A1

%nd*,nf
	clr	-(sp)
	clr	-(sp)
	SS
	F*
	mov	#1(R),4(sp)
	mov	2+#1(R),6(sp)
	fI	sp
	mov	(sp),#1(R)
	mov	2(sp),2+#1(R)
	clr	4+#1(R)
	clr	6+#1(R)

%af,nf
	clr	-(sp)
	clr	-(sp)
	SS
	mov	A1,4(sp)
	mov	A1+,6(sp)
	fI	sp
	mov	(sp),A1
	mov	2(sp),A1+

%nf*,nf
	clr	-(sp)
	clr	-(sp)
	SS
	F*
	mov	#1(R),4(sp)
	mov	2+#1(R),6(sp)
	fI	sp
	mov	(sp),#1(R)
	mov	2(sp),2+#1(R)

/ =	/ado
cs80:
%ad,nf
	SS
	mov	(sp),A1
	mov	2(sp),2+A1
	mov	4(sp),4+A1
	mov	6(sp),6+A1

%nd*,nf
	SS
	F*
	mov	(sp),#1(R)
	mov	2(sp),2+#1(R)
	mov	4(sp),4+#1(R)
	mov	6(sp),6+#1(R)

%af,nf
	SS
	mov	(sp),A1
	mov	2(sp),A1+

%nf*,nf
	SS
	F*
	mov	(sp),#1(R)
	mov	2(sp),2+#1(R)

/ name
cs106:
%zf,n
	clr	-(sp)
	clr	-(sp)
	clr	-(sp)
	clr	-(sp)

%cf,n
	clr	-(sp)
	clr	-(sp)
	clr	-(sp)
	mov	A1,-(sp)

%ad,n
	mov	6+A1,-(sp)
	mov	4+A1,-(sp)
	mov	2+A1,-(sp)
	mov	A1,-(sp)

%nd*,n
	F*
	mov	6+#1(R),-(sp)
	mov	4+#1(R),-(sp)
	mov	2+#1(R),-(sp)
	mov	#1(R),-(sp)

%af,n
	clr	-(sp)
	clr	-(sp)
	mov	2+A1,-(sp)
	mov	A1,-(sp)

%nf*,n
	F*
	clr	-(sp)
	clr	-(sp)
	mov	2+#1(R),-(sp)
	mov	#1(R),-(sp)

%z,n
	clrB1	-(sp)

%aw,n
	mov	A1,-(sp)

%nw*,n
	F*
	mov	#1(R),-(sp)

%al,n
	mov	A1+,-(sp)
	mov	A1,-(sp)

%nl*,n
	F*
	mov	2+#1(R),-(sp)
	mov	#1(R),-(sp)

/ integer to long
cs58:
%n,n
	FS
	sxt	-(sp)

