'/* Dick Roistacher's style file, modified to run under the new NROFF */
'/*    by Jim Gast. Most of the modifications:
'/*	the system registers .p, .v, nl, dn, and .l now return units
'/*       rather than lines or character as they used to.
'/*     two outright bugs were fixed in the footnote stuff.
'/*
'/*     This file provides two systems of headings, both of which will
'/* automatically be tabulated in the table of contents.  The unnumbered
'/* headings follow the publication style manual of the American Psycho-
'/* logical association. APA headings can be generated by the commands
'/* ".h1", ".h2", ".h3", and ".h4".  First order headings are UPPER CASE
'/* and centered, second order headings are Capitalized, underlined, and
'/* centered; third order headings are Capitalized, underlined, and flush
'/* with the left margin; fourth order headings are short underlined
'/* sentence fragments indented at the beginning of a paragraph.
'/*     This file has a switch which will suppress the inclusion of fourth
'/* order headings in the table of contents.
'/*
'/*     A second set of heading commands will provided numbered paragraphs
'/* with optional titles. The commands ".p1", ".p2", ".p3", and ".p4" will
'/* produce paragraphs numbered 1, 1.1, 1.1.1, etc., with the numbers set
'/* to appropriate values.
'/*
'/*     Full use of this file is explained in CAC Document ###, "An nroff
'/* Style File" by Richard C. Roistacher.
'/*
'/*     The following constants are used in the new nroff:
'/* UL is the number of units per line (height). 240 units per inch, */
'/*   and 6 lines per inch */
'/* .nr UL 240/6 0
'/* UC is the number of units per character (width) */
'/* .nr UC 240/10 0
'/* This file can be used with the old nroff by setting both UL and
'/* UC to 1, since the old nroff registers return lines and characters.
.nr UL 1 0
.nr UC 1 0
'/*
'/* aesthetics factors:
'/* FU is the number of lines up from the bottom of the page blank for margin
.nr FU 8 0
.nr N1 0 1
.ds dc January
.if \n(mo-1 .ds dc February
.if \n(mo-2 .ds dc March
.if \n(mo-3 .ds dc April
.if \n(mo-4 .ds dc May
.if \n(mo-5 .ds dc June
.if \n(mo-6 .ds dc July
.if \n(mo-7 .ds dc August
.if \n(mo-8 .ds dc September
.if \n(mo-9 .ds dc October
.if \n(mo-10 .ds dc November
.if \n(mo-11 .ds dc December
'/* the dc string provides the date: example 12 January 1976
.ds dc \n(dy \*(dc 19\n(yr
'/*
'/* the dt macro provides the date centered with space above and below
.de dt
.sp
.ce
\\*(dc
.sp
.ns
..
.nh
'/*
'/* the pt macro is used to specify the page titles. The two arguments
'/* are first_line_title and second_line_title
.de pt
.ds t1 \\$1
.ds t2 \\$2
..
'/*
'/* the NE macro does the 'need' function of the .ne command, but takes
'/* into account the current line spacing.
'/* NE should be called with one argument, the number of text lines
'/* you want to fit on the page.
.de NE
.nr NE $1
.nr NE \\n(.v*\\n(NE/\\n(UL
.ne \\n(NE
..
.po 10
.ll 60
.ls 1
'/*
'/* Dick was never renowned for modesty!
'/* Other authors should write similar macros for themselves
.de rr
.sp 
.ce 4
Richard C. Roistacher
Center for Advanced Computation
University of Illinois
Urbana, IL 61801
.sp 
.ns
..
.de rn
.sp 
.ce 4
Richard C. Roistacher and Barbara B. Noble
Center for Advanced Computation
University of Illinois
Urbana, IL 61801
.sp 
.ns
..
'/*
'/* the pg macro is used to start each paragraph. It makes sure
'/* a reasonable amount of the page is left, and it indents the
'/* paragraph
.de pg
.if \\n(.v-\\n(UL .br
.if !\\n(.v-\\n(UL .sp 1
.NE 3
.ti +5
..
.nr HA 0 Counter value of 0 for no alternating headings, 1 for alternating
.nr HE 1 0
'/* HE is used in the titling macros HB and HC as the number of the last
'/* page on which the titles are to be suppressed.  HE is set to 1 in the
'/* body of the text and to 0 in the contents section, since the titles
'/* should normally appear on page i of the introduction.
'/*
'/* the HB macro actually puts out the header title. User never calls
'/* it directly. It gets called for left edge page numbers.
.de HB
.if \\n%-\\n(HE .tl '\\*(t1''%'
.if \\n%-\\n(HE .tl '\\*(t2'
..
'/* the HC macro gets called for alternating-edge page numbers. It
'/* puts out the actual titles. User never calls it directly.
.de HC
.if \\n%-\\n(HE .if o .tl '\\*(t1''%'
.if \\n%-\\n(HE .if o .tl '\\*(t2'''
.if \\n%-\\n(HE .if e .tl '%''\\*(t1'
.if \\n%-\\n(HE .if e .tl '''\\*(t2'
..
'/* hd is the header macro. It gets sprung as a trap automatically
'/* at the top of every page. User never calls it directly.
.de hd
.ev 1
.lt 60
'sp 3
.if !\\n(HA .HB
.if  \\n(HA .HC
'sp 2
.ns
.ev
.if \\n%-9 .CD
.if \\n%-99 .CE
..
.wh 0 hd
.nr CG 1 Switch for continuation line in table of contents, normally on.
'/*
'/* CA is the basic contents macro. While the document is being read and
'/* processed, the CA macro is built up, containing the table of
'/* contents. At the end of the document, the user should spring this
'/* macro. Many other macros append to this macro.
.de CA
.nr HE 0 Print title on page i.
.de hd New header definition
.lt 60
'sp 3
.RO
.if !\\n(HA .HB
.if  \\n(HA .HC
.ar
'sp 2
.ns
.ev
\\..
.bp 1
.nf
.ta 3 6 9 \\n(.l/\\n(UC
.sp 3
.ce
Table of Contents
.sp
..
'/*
'/* CB is the tab position for the page number on each table_of_contents
'/* line. It gets changed at pages 10 and 100
.nr CB \n(.l/\n(UC
'/* CC is the table of contents continuation page macro
.de CC
.sp 2
.ce
Table of Contents (Continued)
..
'/* CD moves the tab setting for the page number when page number is 10
.de CD
.nr CB \\n(.l/\\n(UC-1
.rm CD
..
'/* CE moves page_number_tab when page number is 100
.de CE
.nr CB \\n(.l/\\n(UC-2
.rm CE
..
'/*
'/* CF adds a line of contents into the table_of_contents.
.de CF
.am CA
.ta \\$1 \\n(CB
	\\*(L1\\n%
\\..
..
.nr C4 1 Include header 4 in table of contents.
'/*
'/* h1: APA first-level heading. centered UPPER CASE.
.de h1
.sp
.if !\\n(.v-\\n(UL .sp Space another line if document is single spaced.
.NE 10
.ds L1 \\$1
.ce
\\*(L1
.sp
.ns
.am CA
.br
.ta \\n(CB
\\*(L1\\n%
\\..
..
'/* APA centered and underlined second order heading.
.de h2
.ds L1 \\$1
.sp
.if !\\n(.v-\\n(UL .sp Space another line if document is single spaced.
.ce
.NE 8
.ul
\\*(L1
.sp
.ns
.am CA
.br
.ta 2 \\n(CB
	\\*(L1\\n%
\\..
..
'/* APA Third level heading, underlined flush side heading
.de h3
.sp
.NE 6
.if !\\n(.v-\\n(UL .sp Space another line if document is single spaced.
.ds L1 \\$1
.ul
\\*(L1
.sp
.ns
.am CA
.ta 4 \\n(CB
	\\*(L1\\n%
\\..
..
'/* APA paragraph heading.
.de h4
.ds L1 \\$1
.NE 4
.pg
.ul
\\*(L1
.am CA 
.ta 6 \\n(CB
	\\*(L1\\n%
\\..
..
.nr P1 0 1 Start of numbered paragraph section.
.nr P2 0 1
.nr P3 0 1
.nr P4 0 1
'/*
'/* P1: first-level numbered paragraph
.de p1
.nr P2 0 1
.nr P3 0 1
.nr P4 0 1
.if \\n(.$-1 .nr P1 \\$2-1
.NE 8
.sp
.ds L1 \\n+(P1.\ \\$1
.am CA
.br
.ta \\n(CB
\\*(L1\\n%
\\..
\\*(L1
.if \\n(.$ .pg
..
'/* p2: level-two numbered paragraph (5.6)
.de p2
.nr P3 0 1
.nr P4 0 1
.if \\n(.$-1 .nr P1 \\$2-1 1
.if \\n(.$-2 .nr P2 \\$3-1 1
.NE 6
.sp
.ds L1 \\n(P1.\\n+(P2\ \\$1
.am CA
.br
.ta \\n(CB
\\*(L1\\n%
\\..
\\*(L1
.if \\n(.$ .pg
..
'/* p3: level-three numbered paragraph (5.6.3)
.de p3
.nr P4 0 1
.if \\n(.$-1 .nr P1 \\$2-1 1
.if \\n(.$-2 .nr P2 \\$3-1 1
.if \\n(.$-3 .nr P3 \\$4-1 1
.NE 5
.sp
.ds L1 \\n(P1.\\n(P2.\\n+(P3\ \\$1
.am CA
.br
.ta \\n(CB
\\*(L1\\n%
\\..
\\*(L1
.if \\n(.$ .pg
..
'/* p4: level-four numbered paragraph (5.6.3.1)
.de p4
.if \\n(.$-1 .nr P1 \\$2-1 1
.if \\n(.$-2 .nr P2 \\$3-1 1
.if \\n(.$-3 .nr P3 \\$4-1 1
.if \\n(.$-4 .nr P4 \\$5-1 1
.NE 5
.sp
.ds L1 \\n(P1.\\n(P2.\\n(P3.\\n+(P4\ \\$1
.am CA
.br
.ta \\n(CB
\\*(L1\\n%
\\..
\\*(L1
.if \\n(.$ .pg
..
.nr IT 0
.nr tn 0  1
'/*
'/* tb reserves space for a table, and numbers the table
.de tb
.ne 4
.ev 1
.ce 3 
.ne 3
--------------------------
INSERT TABLE \\n+(tn ABOUT HERE
--------------------------
.sp
.ev
..
.nr IF 0  Figure insertion switch. 0=insert reference, 1= insert figure.
.nr fn 0 1 Figure counter.
'/* Figure reference.
.de fr
.if \\n(.$ .nr fn \\$1
.if !\\n(.$ .nr fn +1
.ne 4
.ev 1
.sp
.ce 3
.ne 3
---------------------------
INSERT FIGURE \\n(fn ABOUT HERE
---------------------------
.sp
.ev
..
.nr FA 0 Automatic figure insertion switch
'/* FB is the Automatic figure inserter.
.de FB
.if \\n(FA .FD \\$1
.if !\\n(FA .FE \\$1
..
'/* FD is called by FB if the figure insertion switch is set. It
'/* generates a .so command to go get the figure.
.de FD
.sp
.if \\n(.$ .nr fn \\$1
.if !\\n(.$ .nr fn +1
.so fig\\n(fn.nroff
..
'/* FF: Queue of file inserts for figures.
.de FF
..
.de FE
.fr \\$1
\\n(fn  ***
.am FF
\\n(fn ****
.so fig\\n(fn.nroff
\\..
..
'/*
'/* the footnoter
'/* Abandon hope all ye who enter here. Some of the most arcane of the
'/* black arts are practiced herein.
'/*
'/* the fo macro is sprung on pages which have footnotes. It prints out
'/* a separator (minuses) and then the text of the footnotes.
.de fo
.ev 1
.ls 1
.nf
.if \\nd .fs
.nr x 1 0 Turn on footnote switch in case of .ft trap spring.
.nr d 0 0 Reset to "Nothing deferred".
.nr dn 0 0 
.FN
.di
.nr x 0 0 Turn the footnoting switch off.
.rm FN
.if \\n(dn .fz
.ev
'bp
..
'/* print the separator (start of footnotes)
.de fs
.sp 1
---------------
.sp 1
..
'/*
'/* The macro "fn" is used to begin footnotes.  It takes an optional
'/* argument, which is the string to which the footnote number will
'/* be tied.  Use of the argument allows the footnoting of centered
'/* titles and prevents the footnote number from being placed at the
'/* beginning of a new line.  The footnote text begins on the line
'/* after the ".fn" call and is ended by a call to ".ef".  The foot-
'/* note itself is single spaced and indented.
'/*
'/*     The counter HL is used to indicate that the document is being
'/* printed on a device with a reverse half line spacing capability.
'/* If HL is set to 1, the footnote number will be printed as a super-
'/* script. If HL is set to 0, (the default), the footnote number is
'/* printed in brackets.
.de fn
.nr y +1
.if \\n(HL .if !\\n(.$\u\\ny\d 
.if !\\n(HL .if !\\n(.$[\\ny]
.if \\n(HL .if \\n(.$ \\$1\u\\ny\d
.if !\\n(HL .if \\n(.$ \\$1[\\ny]
.da FN
.ev2
.ll 60
.ne 2
.ti 5
[\\ny]\ \c
.nh
..
'/* the ef macro is called to end footnote reference text.
.de ef
.sp 1
.ev
.da
.af
'/* convert the unit number of the next line to a line number */
.nr NL \\n(nl/\\n(UL 0
.if \\n(NL-\\ns+1 .nr s \\n(NL+1 0 IF THE WHOLE FOOTNOTE WONT FIT
'/* Check to see if even the separator will fit */
'/* NOTE: nl and .p are units, and must be divided by UL to get lines */
'/* NOTE: the separator takes 3 lines, plus the footnote hence the 4 */
.if \\n(nl-\\n(.p/\\n(UL+\\n(FU+4 .nr s 99 0
.fm
..
'/* af calculates where to set the .fo trap */
.de af
'/* add these deferred lines into d, the counter of total lines deferred, but
'/*      not yet sprung */
.nr d \\n(dn/\\n(UL+\\nd
'/* s is where to set the footnote trap, and 3 is the size of the separator */
.nr s \\n(.p/\\n(UL-\n(FU-3-\\nd
..
'/* fm moves the .fo trap (the footnote barrier) up.
.de fm
.ch \\nt \\ns
.nr t \\ns
..
'/*
'/* the ft macro (footer, foot of page) gets called automatically at the
'/* foot of every page. If you want page numbers at the bottoms of
'/* your pages you must add that before the 'bp
.de ft
'bp
'/* put the footnote macro off the bottom of the page */
.nr s 99
'/* set the deferred count to zero */
.nr dn 0 0
.if \\nd .af
.fm
.if \\nx .fx
..
'/* the fx macro saves footnotes that didn't fit on this page
.de fx
.di FY
..
'/* the fz macro puts back macros that didn't fit on the previous page
.de fz
.di FN
.nf
.FY
.fi
.di
.af
.fm
..
.nr d 0 0  HOW MANY LINES OF FOOTNOTES (TOTAL) ARE CURRENTLY DEFERED
.nr y 0 1 THE CURRENT FOOTNOTE NUMBER
.nr s 0 0 LINE NUMBER THE FOOTNOTE BARRIER WOULD BE MOVED TO (SEE .fm,.af)
.wh 99 fo
.nr t 99 0 LINE NUMBER OF THE .fo TRAP (OR 99 IF NO FOOTNOTES DEFERED)
.wh -\n(FU ft
.pt Test
.dt
.rr
