#include "/h/param.h"
#include "/h/submit.h"

/*
 * Init code spawned by the system to bring up
 * the world. This version is peculiar to Harvard,
 * and has no relevence to the rest of the world.
 *
 *	bsb feb '76
 *	bsb Feb '77
 */

#define	all	p = ttab; p < ttabe; p++

char	*shell		"/bin/sh";
char	*login		"/bin/login";	/* su goes to login now */
char	*runc		"/etc/rc";
char	*updat		"/etc/update";
char	*ttynames	"/etc/ttynames";
char	*dev_cty	"/dev/cty";
char	*cty		"cty";

struct	tab {
	int	t_pid;
	char	t_name[16];
} *ttab, *ttabe;


main()
{
	register i;
	register struct tab *p, *q;
	int j;
	char *cp, line[16];

	signal (2,1); signal(3,1);	/* signal for ^c, ^b */
	signal (13,1); signal(-1,1);	/* pull out epipe, and break */

	/*
	 * Check switches for magic values
	 */

	while(getcsw()&SW_MULTI) {		/* single user */
		if((i = fork()) == 0) {
			execl(login, "-", cty, 0);
			open(dev_cty, 2);
			dup(0); dup(0);
			execl(shell, shell, 0);
			exit();
		}
		while(wait() != i);
	}

	/*
	 * If not single user,
	 * run shell sequence.
	 */

	if((i = fork()) == 0) {
		open(dev_cty, 2);
		dup(0); dup(0);
		execl(shell, shell, runc, 0);
		exit();
	}
	while(wait() != i);
	if(fork() == 0) {
		execl(updat, updat, 0);
		exit();
	}

	/*
	 * Here we initialize (zero) the active user file
	 * and read in the ttynames for all terminals.
	 */

	i = open(ttynames, 0);
	for(;;) {
		if((j = readline(i, line, 16)) <= 0 || line[0] == PTY_IND)
			break;
		q = sbrk(sizeof *q);
		if(!ttab) ttab = q;
		cp = line;
		while(*cp != ',')
			cp++;
		*cp = 0;
		copy(line, &q->t_name);
	}
	ttabe = q + 1;
	close(i);
	sync();
	if(ttab == 0) {
		i = open(dev_cty, 1);
		type(i, "No terminals online!!!\n");
		for(;;);
	}

	/*
	 * Spawn a login on all of the defined terminals.
	 */

	for(all)
		dfork(p);

	/*
	 * Main loop to wait for any and all
	 * children to die. If I created them
	 * (ie they are not grand children) then
	 * create them afresh.
	 */

	for(;;) {
		i = wait();
		for(all)
			if(p->t_pid == i || p->t_pid == -1)
				dfork(p);
	}
}


/*
 * dfork creates the children and keeps track
 * of them in ttab for future reference.
 */

dfork(ap)
struct tab *ap;
{
	register i;
	register char *tty;
	register struct tab *p;

	p = ap;
	tty = cat("/dev/", p->t_name);
	chown(tty, 0);
	if((i = fork()) == 0) {
		execl(login, "-", &p->t_name, 0);
		exit();
	}
	p->t_pid = i;
}
