#include	"pop.h"

#define T_ECHO	010

extern popout;
extern pop popdesc[];
extern char ctab[];
extern tmode[];



/* POP line editor.
 * Turns on echo in the tty driver
 * as local echoing
 * in a user process is slow and nasty.
 *
 * The final POP line when NL is typed
 * is copied into buf by the pgetl function.
 * Trailing spaces are thus ignored and
 * the line is terminated by 0.
 */

do_edit(buf)
char *buf;
{
register pop *p;
register v;
char c;

	p = &popdesc[popout];
	v = p->cv - p->vmin;	/* get current line offset */

	if ((p->ch <= p->hmax) && (p->cv <= p->vmax))
		echo_on();

	do {
		pflush();
		read(0,&c,1);
		switch (ctab[c&0177]) {	/* switch on char class */

		case CR:
		case LEFT:
			echo_on();
		case NL:
		case TAB:
		case RIGHT:
			do_putc(c);

		case BELL:
		case IGN:
			break;

		/* For default classes, as echo is on
		 * the screen cursor is automatically moved
		 * forward one character position after display.
		 */
		default:
			if (p->ch <= p->hmax) {
				m_store(c,p);
				p->ch++;
			}
		}

		if (p->ch > p->hmax)
			echo_off();
		pflush();		/* flush before break action */
		do_break(p,c);
	} while (c != '\n');

	echo_off();

	/* The resulting POP line is now copied
	 * into buf by the POP getline function.
	 */

	return(pgetl(popout,v,buf));
}


echo_on()
{

	if ((tmode[2] & T_ECHO) == 0) {
		tmode[2] =| T_ECHO;
		stty(0,tmode);
	}
}

echo_off()
{
	if (tmode[2] & T_ECHO) {
		tmode[2] =& ~T_ECHO;
		stty(0,tmode);
	}
}
