#include	"damdefs.h"

/* display routines for dam.c */
#define	DELAY	6

extern int mvnr,game[],conv[],bord[],*gp;
extern int timew,timeb;

int pb  	1;	/* nonzero if at begin of line */
int disp	0;	/* nonzero if HP display desired */
int dirt	0;	/* nonzero if garbage printed below board */
int prall	1;	/* if nonzero the display is rewritten */

char prtarr[]	".wzWZ?";
char *dsparr[] {
	"\033&dJ  \0xxxxxx",
	"w \0xxxxxxxxxx",
	"z \0xxxxxxxxxx",
	"W \0xxxxxxxxxx",
	"Z \0xxxxxxxxxx",
	"? "
};

char *emparr[]{
/* 0 */	"  ",
/* 1 */	"\033&dJ  ",
	0 };

char *fularr[]{
/* 0 */	"w ","z ","W ","Z ",
/* 1 */ "w ","z ","WW","ZZ",
/* 2 */ "w ","b ","W ","B ",
/* 3 */	"o ","x ","O ","X ",
/* 4 */	"\016V \017","\016$ \017","\016VV\017","\016$$\017",
	0 };

/* cursor home and clear screen */
home(){
	printf("\033H\033J");
	dirt = 0;
}

/* position cursor */
int lastrow;
posit(l,c) int l,c; {
	printf("\033&a%dr%dC",l,c);
	lastrow = l;
	delay();
}

/* read cursor position */
rdcursor(){
char line[12],*lp;
int row,col;
	printf("\033a\021");
	lp = line;
	while((*lp++ = getchar()) != '\n')
		if(lp == line+12) lp--;
	lp = line;
	if(*lp++ != '\033') goto err;
	if(*lp++ != '&') goto err;
	if(*lp++ != 'a') goto err;
	col = atoi(lp);
	if(*(lp+3) != 'c') goto err;
	row = atoi(lp+4);
	if(*(lp+7) != 'R') goto err;
	return(row<<8 + col);
err:
	return(-1);
}

/* print string inverted (i.e. against white background) */
whstr(s) char *s; {
	printf("\033&dB%s\033&d@",s);
	delay();
}

/* delay is necessary after changes of color or position */
delay(){
register int ct;
	ct = DELAY;
	while(ct--) putchar('\177');
}

#define	COL1	24
#define	COL2	54
#define	COLW	14	/* width of column of moves */
#define	ROW0	14	/* row of conversation below the board */

/* define printing position before printing a move */
int rowdif;

prmvnr(){
int cl,rw,clr;
	clr = 0;
	rw = (mvnr>>1) + rowdif;
	while(rw > 88) rw =- 44;
	if(rw > 66){
		rw =- 66;
		cl = COL2;
		clr = 80-COL2;
	} else if(rw > 44){
		rw =- 44;
		cl = COL1;
		clr = COL2-COL1;
	} else if(rw > 22){
		rw =- 22;
		cl = COL2;
	} else	cl = COL1;
	if(mvnr&1){
		if(pb){
			rowdif++;
			rw++;
			if(clr) clear(rw,cl,clr);
			if(disp) posit(rw,cl);
			printf("%2d.  ...\t", mvnr>>1);
		}
		if(disp) posit(rw, cl+COLW);
	} else {
		if(clr) clear(rw,cl,clr);
		if(disp) posit(rw, cl);
		printf("%2d. ", mvnr>>1);
	}
}

/* clear the line below the given line, and
   the given line only if it is line 1 */
clear(rw,cl,ct) int rw,cl,ct; {
register int i;
	if(!disp) return;
	if(rw == 1){
		posit(rw,cl);
		for(i=ct; i--; ) putchar(' ');
	}
	posit(rw+1,cl);
	for(i=ct; i--; ) putchar(' ');
}

int prev_bord[66];	/* remember, and print differences only */
int prbwait	0;	/* delay after each prbord() */

pbundef(){	/* force printing of entire board */
register int i;
	for(i=0; i<66; i++) prev_bord[i] = -1;
}

prbord(){
register int i,*mp1;
int bdi,xi,yi;
	if(prall) {
		if(disp) home();
		pbundef();
	}
	if(!disp){
		if(!pb){
			putchar('\n');
			pb++;
		}
		putchar('\n');
	}
	if(disp){	/* write times above board */
		posit(1,3);
		printf("%s%4d \016:\017 %4d %s",
			dsparr[3],timew,timeb,dsparr[4]);
	}
	for(i=1; i<=50; i++){
		bdi = bord[conv[i]];
		if(disp && (prev_bord[conv[i]] == bdi)) continue;
		if((i/10)*10+1 == i)
			if(!disp) putchar(' ');
		switch(bdi){
		case EMPTY:
			bdi = 0; break;
		case WHITE:
			bdi = 1; break;
		case BLACK:
			bdi = 2; break;
		case WHITE+DAM:
			bdi = 3; break;
		case BLACK+DAM:
			bdi = 4; break;
		default:
			bdi = 5;
		}
		if(disp) {
			/* first compute position */
			yi = (i-1)/5;
			xi = 4*(i - 5*yi) - 2;
			if(yi&1) xi--; else xi++;
			/* then display it there */
			posit(yi+2, xi);
			whstr(dsparr[bdi]);
		} else {
			putchar(prtarr[bdi]);
			if((i/5)*5 == i) putchar('\n');
			else putchar(' ');
		}
	}
	if(prall) {
		prall = 0;
		if(disp){
			rowdif = 0;
			i = mvnr;	/* save temporarily */
			mvnr = 1;
			for(mp1 = game; mp1<gp; ){
				mvnr++;
				prmove(mp1);
				mp1 =+ 2;
				mp1 =+ *mp1++;
			}
			mvnr = i;
		}
	} else
	for(i = (dirt ? 22 : ROW0-1); i >= ROW0-1; i--)
		clear(i,0,COL1);
	dirt = 0;
	if(disp) posit(ROW0,0);
	else putchar('\n');
	for(i=0; i<66; i++) prev_bord[i] = bord[i];
	if(prbwait) sleep(prbwait);
}

int fieldw,linpos;
putcr(c) char c; {
	if(putchar(c) == '\n') linpos = 0;
	else if(++linpos == COL1){
		putchar('\n');
		linpos = 0;
	}
}

printo(n) int n; {
	if(n){
		fieldw--;
		printo((n>>3) & 017777);
	}
	for(fieldw--; fieldw>0; fieldw--)
		putcr(' ');
	putcr('0' + (n & 07));
}

printd(n) int n; {
int a;
	if(a = n/10){
		fieldw--;
		printd(a);
	}
	for(fieldw--; fieldw > 0; fieldw--)
		putcr(' ');
	putcr('0' + n%10);
}

pmesg(fmt,args) char *fmt; int *args; {
int x;
register char *s,c;
register int *ap;
struct {char *cp;};	/* convert int into string */
	ap = &args;
	if(disp && lastrow != ROW0) posit(ROW0,0);
	dirt++;
	while(c = *fmt++){
		fieldw = -1;
		if(c != '%') putcr(c);
		else {
			c = *fmt++;
			if(c >= '0' && c <= '9'){
				fieldw = c-'0';
				c = *fmt++;
			}
			switch(c){
			case 'o':
				printo(*ap++);
				continue;
			case 'd':
				x = *ap++;
				if(x < 0){
					putcr('-');
					printd(-x);
				} else	printd(x);
				continue;
			case 's':
				s = ap++->cp;
				while(c = *s++) putcr(c);
				continue;
			default:	/* in particular when c=0 */
				error("bad string?");
			}
		}
	}
}
