#include "/h/libg.h"
#include "/h/cinfo.h"
#include "/h/sgtty.h"
#include "/h/errors.h"
#include "/h/ttylimits.h"
#include "/h/iobuf.h"
#include "/h/ttynames.h"

/*	Harvard login
 *
 *	Bruce Borden	September 74
 *
 *	to compile :
 *		cc login.c -O newslog.o -n -lg -lh
 *
 *	two formats of call:
 *
 *	from init:   login ttyname
 *	from submit: login ptyname logname input-file output-file
 *
 *		note: newslog and minor changes by psl
 *		      comments and minor changes by jrs
 *
 *	mods -> new tty names, submit & getty functions
 *		BSB 	Feb 77
 *
 */

#define MAXBRK		40	/* break stream limit */
#define	READLIM		100	/* Limit on logname chars read */
#define	SLP_MINUTES	15	/* sleep time while offline */
#define	NPROCLIM	7	/* Default Process Limit */
#define NOLOGN	"/etc/nologin.times"
#define	BAD	1		/* bad exit code */
#define OK	0		/* not bad exit code */
#define RETRY	2		/* Retry later exit code */

int	ordinal[]	{
	"second", "third", "fourth", "fifth", "sixth",
	"seventh", "eighth", "ninth", "manyth",
};

char *overfil "/acct/over.quota";

struct	tty_limits *limp;
int	ttmode[3];
int	errno;		/* sys errors returned here */
struct	cinfo	infob;
int	cs;		/* global static character for read() */
char	name[18];	/* logname goes here */
int	spd;		/* initial and rotating speeds go here */
int	notfirst;	/* not first Login: flag */
char	submit;		/* true if called from submit */
char	quiet;		/* logname ended with '.' */
int	readlim;	/* # of chars read for logname */

main(argc, argv)
char *argv[];
{
	for(;;) {
		if(getruid())
			error("Not OPR");
		if(argc != 2 && argc != 5)
			hang(argv[1], "Bad ARGC");
		pich = 0;	/* force re-open in getubuf */
		online(argv[1]);
		main1(argc, argv);
		if(submit)
			exit(BAD);
		sleep(6 - ttmode->sg_ospd/3);
	}
}

main1(argc, argv)
char *argv[];
{
	register char *cp, *np;
	register int i;
	int j;
	int tn;
	char f, warn, *ttname, c, buf[100], ttnbuf[24];
	long nowtime;

	signal(3,1); signal(2,1);
	ttname = argv[1];
/*
 * Set us up as a process group for possible hangups from dial
 * up lines.
 */
	infob.c_uid = 0;
	infob.c_pleft = NPROCLIM;
	while ((tn=ttynum(ttname)) < 0) hang(ttname, "ttynum returned -1");
	infob.c_dev = ttydev(tn);
	close(ttn_fh);	/* save a handle */
	ttn_fh = 0;
	time(&infob.c_ltime);
	if(setcinfo(tn, &infob) == -1) {
		type(1, "??Error from setcinfo()??\r\n");
		return;
	}
	quiet = submit = (argc == 5);
	if(!submit) {
		copy(ttname, copy("/dev/", ttnbuf));
		cp = ttnbuf;
		close(0); close(1); close(2);
		if(open(cp,2) != 0)
			hang(ttname, "Can't open TTY");
		dup(0); dup(0);
		limp = getlimits(ttname);
		ttmode[0] = limp->l_n1;
		ttmode[1] = limp->l_n2;
		ttmode[2] = limp->l_n3;
		spd = ttmode[0]&017;
	}
	for(;;) {
		if (pich == 100) pich = 0;	/* force re-open in getubuf */
		if(submit)
			copy(argv[2], &name);
		else
			getln(ttname);
		if((i = getunum(&name)) < 0) {
			type(1, "Unknown.");
			if(submit) {
				type(1, "\n");
				exit(BAD);
			} else
				continue;
		}
		getubuf(i);
		close(pich);
		pich = 100;	/* fake out getubuf */
		if(submit) {
			seteuid(u_buf.usr_num);
			close(0); close(1); close(2);
			if(!(open(argv[3], 0) == 0 &&
			   (open(argv[4], 1) == 1 ||
			    creat(argv[4], 0644) == 1)))
				exit(BAD);
			seek(1, 0, 2); /* Append output for Submit */
			type(1, "\n\n~~~~~~~~~~~~~~~~~~~~\n\n\n");
			seteuid(0);
		}
		if(equal(ttname, "ttyd") && !(u_buf.priv&PRV_32)) {
type(1,"This line is 5-7631, and is reserved for lecture use.\n");
type(1,"If you dialed 5-7620, then all of the lines are busy.\n");
			return(0);
		}
		if(!equal(ttname, "cty") && nologins())
			if(submit)
				exit(RETRY);
			else
				return(0);
		if(u_buf.password[0] == 0) {
			type(1, "Access denied. See a Terminal watcher!!!\n");
			return(0);
		}
		if(submit)
			break;
		type(1, "Password:");
		cp = &buf;
		do {
			if(read(0, &cs, 1) != 1)
				exit(OK);
			if(cp < &buf[9])
				*cp++ = cs;
		} while(cs != '\n');
		*--cp = 0;
		if(buf[0] == 0)
			continue;
		cp = crypt(buf);
		move(&u_buf.password, buf, 8);
		buf[8] = 0;
		if(equal(cp, buf)) {
			type(1, "\n");
			break;
		}
		type(1, " Incorrect.");
		sleep(3);
	}
	if(!submit) {
		ttmode->sg_flag =| ECHO;
		stty(0, &ttmode);
	}
	if((u_buf.dol_used/100) > u_buf.dol_bud) {
		type(1, "You have exceeded your budget.\n");
		return(0);
	}
	if(u_buf.dsk_used > u_buf.dsk_lim) { 
		type(1,"Warning:  Disk quota exceeded as of 7pm!!\n");
		i = open(overfil,2);
		seek(i,u_buf.usr_num,0);
		cs = 0;
		read(i,&cs,1);
		if(cs > 5) {
type(1,"Login refused due to disk quota...see a Terminal Watcher!\n");
			return(0);
		}
		seek(i,u_buf.usr_num,0);
		cs =+1;
		write(i,&cs,1);
		close(i);
	}
/*
 * Change to his directory and type notices.
 */
	if(changeto(getpath(u_buf.usr_num), u_buf.usr_num) == 0)
		return(0);
/*
 * Change ownership of tty and make it "talk"able.
 */
	cp = ttnbuf;
	chown(cp, u_buf.usr_num);
	chmod(cp, 0700);	 /* enable messages */

/*
 * Set up the cinfo buffer for the setcinfo system call to
 *   log us in.
 */
	infob.c_uid = u_buf.usr_num;
	time(&infob.c_ltime);
	infob.c_pleft = u_buf.procs_lim <= NPROCLIM? NPROCLIM :
			u_buf.procs_lim;
	if(setcinfo(tn, &infob) == -1) {
		type(1, "??Error from setcinfo()??\n");
		return;
	}
	setruid(u_buf.usr_num);
	seteuid(u_buf.usr_num);
/*
 * Once we've logged us in, count the resultant simultaneous users.
 */
	i = howmany(u_buf.usr_num);
	if(!submit && i > u_buf.simul_use) {
		type(1, "?You have exceeded your limit of ");
		prndec(1, u_buf.simul_use);
		type(1, " simultaneous users.\n");
		slowexit();
	}
	time(&nowtime);
	cp = cdate(&nowtime);
	if(!quiet || submit) {
		type(1, "><><><><> ");
		type(1, cp);
		type(1, "\n");
	}
	/* 1st time, and about every 16th thereafter ... */
	if((u_buf.dol_used & 017) == 0) {
		qtype(1, "Welcome to HRSTS, ");
		unpackwds(&u_buf.first_name, &buf, 4);
		buf[12] = 0;
		if(buf[0] >= 'a' && buf[0] <= 'z') buf[0] =- 040;
		qtype(1, buf);
		qtype(1, ".\n");
	}
	i =- 2;
	if(i >= 0) {
		qtype(1, "This is your ");
		qtype(1, ordinal[i<8 ? i : 8]);
		qtype(1, " active job.\n");
	}
	qtype(1, "You have $");
	i = u_buf.dol_bud - u_buf.dol_used / 100;
	qprndec(1, i);
	qtype(1, " left in your budget.\n");
	qtype(1, "As of 7 PM, you have ");
	if((i = u_buf.dsk_lim - u_buf.dsk_used) < 0) {
		i = -i;
		qtype(1, "-");
	}
	qprndec(1, i);
	qtype(1, " Disk Blocks remaining.\n");
	if(newslog(u_buf.usr_num))
		if(!submit) type(1,"You've news to peruse.\n");
	close(pich);
	if(stat("postbox", buf) >= 0)
		if(!submit) type(1, "You have mail.\n");
	for(i=3; i<15; i++)
		close(i);
	if(u_buf.auto_st[0]) {
		u_buf.auto_st[8] = 0;
		if(submit)
			execl("/bin/sh", "--", "-*", &u_buf.auto_st, "-e", 0);
		else
			execl("/bin/sh", "--", "-*", &u_buf.auto_st, 0);
	}  else {
		if(submit)
			execl("/bin/sh", "--", "-e", 0);
		else
			execl("/bin/sh", "--", 0);
	}
	type(1, "?No shell?\n");
	slowexit();
}


move(s1, s2, sn)
char *s1, *s2;
{
	register char *c1, *c2;
	register int i;

	i = sn;
	c1 = s1; c2 = s2;
	do *c2++ = *c1++; while(--i);
}


slowexit()
{
	if(!submit)
		sleep(6 - (ttmode->sg_ospd>>2));
	exit(BAD);
}



changeto(namep, unum)
char *namep;
{
	register char *cp, *pp;
	char tbuf[100];
	register int i;
	char oldc;

	pp = namep;
    do {
	cp = pp;	/* hold start pos. of file name */
	/* find end of file name */
	while (*pp)
		if (*pp++ == '/' && *pp != '/') break;
	oldc = *pp;	/* save old char at end of name */
	*pp = 0;
	if (chdir(cp) < 0) {
		if(errno != ENOENT) {
			type(1, "??Bad Log Path.??\n");
			return(0);
		}
		i = fork();
		if(i == -1) {
			type(1, "System overloaded, try again later.\n");
			return(0);
		}
		if(i == 0) {
			execl("/bin/mkdir", "mkdir", cp, 0);
			exit(OK);
		} else {
			while(wait() != i);
			if(oldc == 0)
				chown(cp, unum);
			if(chdir(cp) < 0) {
				type(1, "??Can't create directory.\n");
				return(0);
			}
		}
	}
	if(!quiet && (i = open("notice.txt", 0)) >= 0) {
		if(oldc == 0) {
			fstat(i, tbuf);
			if(unum != (((tbuf[7]&0377)<<8) |
				(tbuf[8]&0377)))
				return(1);
		}
		while((cp = read(i, tbuf, 100)) > 0)
			write(1, tbuf, cp);
		close(i);
	}
    } while (*pp = oldc);
    return(1);
}



howmany(num)
{
	register int i, pg, n;

	n = num;
	i = pg = 0;
	while(getcinfo(pg++, &infob) != -1)
		if(infob.c_uid == n) i++;
	return(i);
}

nologins()
{
	register int i, ch;
	register char *cp;
	long now;
	struct {
		long down;
		int up;
		int nolog;
		} a;

	if((ch = open(NOLOGN, 0)) < 0) goto false;
	read(ch, &a, 8);
	close(ch);
	time(&now);
	if (now > a.down) {
		i = ldiv(now-a.down, 60);
		if(i - a.up > 0) goto false;
		i = -i;
		goto true;
	}
	cp = ctime(&a.down);
	i = ldiv(a.down-now, 60);
	if(i > 60 && i > a.nolog) {
		if(quiet) goto false;
		type(1, "Next scheduled down time is ");
		write(1, cp, 3);
		type(1, " at ");
		write(1, cp+11, 5);
		type(1, " for ");
		prndec(1, a.up);
		type(1, " minutes.\n");
		goto false;
	}
	type(1, "System going down in ");
	prndec(1, i);
	type(1, " minutes.\n");
	if(i < a.nolog) {
true:
		if(u_buf.priv & PRV_SU) {
			type(1, "Warning!! no logins allowed!\n");
			goto false;
		}
		type(1, "No logins allowed. System should be available in ");
		prndec(1, i + a.up);
		type(1, " minutes.\n");
		return(1);
	}
false:	return(0);
}


online(tname)
{
	register int i;
	struct iobuf ib;
	char buf[16];

	if(equal(tname, "cty")) return;
    for(;;) {
	if (fopen("/etc/tty-online", &ib) < 0) {
		hang(tname, "cannot open tty-online");
	} else {
		while((i = getl(&ib, buf, 16)) > 0) {
			buf[i-1] = 0;
			if(equal(tname, buf)) {
				close(ib.b_fildes);
				return;
			}
		}
		close(ib.b_fildes);
		sleep(60 * SLP_MINUTES);
	}
    }
}


char	upper, lower, crmod;

getln(ttn)
{
	register int i;

    for(;;) {
	if(spd == 0 || spd > 15) spd = 1;
	while(limp->l_ispds & (1<<spd))
		if(++spd > 15) spd = 1;
	ttmode->sg_flag =| RAW;
	ttmode->sg_flag =& ~(LCASE|ECHO);
	ttmode->sg_ospd = spd;
	ttmode->sg_ispd = spd;
	stty(0, &ttmode);
	type(1, "\r\n");
	if(getname()) {
		if(upper)
			ttmode->sg_flag =| LCASE;
		if(lower)
			ttmode->sg_flag =& ~LCASE;
		ttmode->sg_flag =& ~RAW;
		stty(0, &ttmode);
		return;
	}
	if(notfirst++)
		spd++;
	if(notfirst == MAXBRK) {
		i = open("/dev/cty", 1);
		type(i, "\n\nlogin: MAXBRK on \"");
		type(i, ttn);
		type(i, "\"\n\n");
		close(i);
		sleep(30);
		exit(BAD);
	}
    }
}


getname()
{
	register char *np;
	register c, rub;

labl:	type(1, "\007Login: ");
	rub = 0;
	upper = 0; lower = 0;
	np = name;
	do {
		if(++readlim > READLIM) {
			type(1, " [Readlim Reached]\n");
			exit(BAD);
		}
		if(read(0, &cs, 1) <= 0)
			exit(OK);
		if((c = cs&0177) == 0)
			return(0);
		if(c == CEOT)
			exit(OK);
		if(c == CERASE) {
			if(rub++ == 0)
				write(1, "\\", 1);
			if(np > name) {
				np--;
				write(1, np, 1);
			}
			continue;
		}
		if(c == CKILL) {
			type(1, "^U\r\n");
			goto labl;
		}
		if(c == CRETYPE) {
			type(1, "^R\r\nLogin: ");
			rub = np - name;
			if(rub)
				write(1, name, rub);
			rub = 0;
			continue;
		}
		if(rub) {
			write(1, "\\", 1);
			rub = 0;
		}
		write(1, &cs, 1);
		if(c >= 'a' && c <= 'z')
			lower++;
		if(c >= 'A' && c <= 'Z') {
			upper++;
			c =+ 'a' - 'A';
		}
		if(np <= &name[16])
			*np++ = c;
	} while(c != '\n' && c != '\r');
	if(*--np != c) {
		type(1, "\r\nLogname limited to 15 characters.\r\n");
		goto labl;
	}
	*np = 0;
	if(np[-1] == '.') {
		quiet = 1;
		*--np = 0;
	} else
		quiet = 0;
	if(c == '\r') {
		write(1, "\n", 1);
	} else {
		write(1, "\r", 1);
	}
	if(np == name)
		goto labl;
	return(1);
}


hang(tname, string)
{
	register int i;

	if((i = open("/dev/cty", 1)) >= 0) {
		type(i, "\r\n\r\n\r\n?? Login on \"");
		type(i, tname);
		type(i, "\"; Error: ");
		type(i, string);
		type(i, "\r\n\r\n\r\n");
		close(i);
	}
	for(;;)
		sleep(60*60);
}


qtype(chn, str)
{
	if(!quiet)
		type(chn, str);
}


qprndec(chn, num)
{
	if(!quiet)
		prndec(chn, num);
}
