struct	{
	char	low;
	char	high;
};

struct	{
	char	pag_len;
	char	lin_wid;
};

struct	s	{
	char	*exter;
	int	inter;
};

struct	t	{
	char	*keyword;
	int	(*func)();
	int	arg1;
	int	arg2;
};

extern	setup(),speed(),ispeed(),ospeed(),width(),
	length(),normal(),diabl(),nocmd();

int	database[]	{
	"ddt",		&setup,	060000,	0,
	"-ddt",		&setup,	0,	060000,
	"ppl",		&setup,	020000,	0,
	"-ppl",		&setup,	0,	020000,
	"teco",		&setup,	040000,	0,
	"-teco",	&setup,	0,	040000,
	"-tdelay",	&setup,	010000,	0,
	"tdelay",	&setup,	0,	010000,
	"altesc",	&setup,	0400,	0,
	"-altesc",	&setup,	0,	0400,
	"even",		&setup,	0200,	0,
	"-even",	&setup,	0,	0200,
	"odd",		&setup,	0100,	0,
	"-odd",		&setup,	0,	0100,
	"raw",		&setup,	040,	0,
	"-raw",		&setup,	0,	040,
	"cooked",	&setup,	0,	040,
	"crmod",	&setup,	020,	0,
	"-crmod",	&setup,	0,	020,
	"-nl",		&setup,	020,	0,
	"nl",		&setup,	0,	020,
	"echo",		&setup,	010,	0,
	"-echo",	&setup,	0,	010,
	"lcase",	&setup,	04,	0,
	"-lcase",	&setup,	0,	04,
	"ucase",	&setup,	0,	04,
	"-ucase",	&setup,	04,	0,
	"xtabs",	&setup,	02,	0,
	"-xtabs",	&setup,	0,	02,
	"tabs",		&setup,	0,	02,
	"-tabs",	&setup,	02,	0,
	"delay",	&setup,	0,	01,
	"-delay",	&setup,	01,	0,
	"speed",	&speed,	0,	0,
	"ispeed",	&ispeed,0,	0,
	"ospeed",	&ospeed,0,	0,
	"width",	&width,	0,	0,
	"length",	&length, 0,	0,
	"normal",	&normal, 0,	0,
	"ti",		&setup,	0,	05,
	"diablo",	&diabl,	0,	010007,
	"\\",		&nocmd,	0,	0,
};

int	speeds[]	{
	"zero",		0,	"50",		1,
	"75",		2,	"110",		3,
	"134",		4,	"134.5",	4,
	"150",		5,	"200",		6,
	"300",		7,	"600",		8,
	"1200",		9,	"1800",		10,
	"1760",		10,
	"2400",		11,	"4800",		12,
	"9600",		13,	"optiona",	14,
	"optionb",	15,	"\\",		-1,
};

char	*arg;
int	mode[3];
int	wrkflg	0;
int	fstatbuf[18];
char	*fspnt;
int	fscnt;
int	uid;
int	ruid;
int	noset;
int	noclr;
int	ilegl_spds;
int	inchn;
int	word1, word2, word3;
int	fout;

main(argc,argv)
char	*argv[];
{
	register struct t *i;
	char *ttyn;

	fout = 2;
	if( (fstat(1,&fstatbuf))== -1) {
		printf("?? fstat failure on channel 1\n");
		goto leave;
	}
	if(ruid=getruid()) {
		uid = getluid();
		if(uid.high != fstatbuf[3].high
			|| uid.low != fstatbuf[4].low) {
			printf("?? access denied!\n");
			goto leave;
		}
	}
	if((fstatbuf[2] & 060000) != 020000) {
		printf("standard output device is not a character special file\n");
		goto leave;
	}
	gtty(1,mode);
	ttyn = gttnum();
	if(argc==1) {
		list(ttyn);
		goto leave;
	}
	if(getres(ttyn)==0) goto leave;
	for(arg= *++argv; --argc; arg= *++argv) {
		for(i = &database ;; i++ ) {
			if(match(i->keyword,'=')) {
				(*(i->func))( i->arg1 , i->arg2 );
				break;
			}
		}
	}
	if(wrkflg)
		stty(1,mode);
leave:	flush();
}

match(string,delim)
char	*string;
{
	register char	*ptr;

	if(string[0]=='\\')
		return(1);
	ptr=arg;
loop:	if(*ptr != *string)
		if((*ptr + 040) != *string)
			return(0);
	ptr++;
	string++;
	if(*ptr == '\0')
		return(1);
	if(*ptr == delim) {
		arg = ptr;
		return(1);
	}
	goto loop;
}

nocmd(num,fum)
{
	printf("\"%s\" is not a recognizable mode\n",arg);
}

list(ttyn)
char *ttyn;
{
	register struct s *j;
	register tmp;
	register struct t *i;
	int si,so,state;

	printf("%s: ",ttyn);
	state = 0;
	so = (mode[0]>>8) & 017;
	si = mode[0] & 017;
	for( j = &speeds ;; j++ ) {
		if(so == j->inter && si == j->inter) {
			printf("terminal speed=%s",j->exter);
			break;
		} else {
			if(so == j->inter) {
				printf("output speed=%s",j->exter);
				state++;
			}
			if(si == j->inter) {
				printf("input speed=%s",j->exter);
				state++;
			}
			if(state==1) {
				printf("; ");
				state++;
			}
			if(state==3) break;
		}
	}
	printf("\n");
	if( (tmp = mode[1].pag_len) == 0)
		printf("page mode off ; ");
	else
		printf("page length=%d ; ",tmp);
	printf("line width=%d\n",mode[1].lin_wid);
	tmp = mode[2];
	for(i = &database ;; i++) {
		if(*i->keyword=='\\') {
			if(tmp)
				printf(" ...+ a few more\n",0);
			else
				printf("\n",0);
			return;
		}
		if( (tmp&i->arg2)==0 && (tmp&i->arg1)==i->arg1 &&
						(i->arg1) ) {
			printf(i->keyword,0);
			printf("  ");
			tmp =& ~i->arg1;
		}
	}
}

setup(n1,n2)
{
	if(ruid && noset&n1) {
		printf("illegal mode to set terminal in\n");
		return;
	}
	if(ruid && noclr&n2) {
		printf("illegal mode to clear for terminal\n");
		return;
	}
	mode[2]=| n1;
	mode[2]=& ~n2;
	wrkflg++;
}

gspd()
{
	register struct s *j;

	if(*arg++ != '=') {
		printf("correct format is \"speed=n\"\n");
		return(-1);
	}
	for(j = &speeds ;; j++)
		if(match(j->exter)) {
			if(j->inter >=0) {
				if(ruid&&ilegl_spds&(1<<j->inter)) {
					printf("illegal speed for terminal\n");
					return(-1);
				}
				return(j->inter);
			}
			printf("unrecognized speed \"%s\"\n",arg);
			return(-1);
		}
}

speed(n1,n2)
{
	register	int	tmp;

	if((tmp=gspd()) >= 0) {
		mode[0] = (tmp<<8) | tmp;
		wrkflg++;
	}
}

ispeed(n1,n2)
{
	register	int	tmp;

	if((tmp=gspd()) >= 0) {
		mode[0] = (mode[0]& ~0377) | tmp;
		wrkflg++;
	}
}

ospeed(n1,n2)
{
	register	int	tmp;

	if((tmp=gspd()) >= 0) {
		mode[0] = (mode[0]& 0377) | (tmp<<8);
		wrkflg++;
	}
}

getdec()
{
	register int num,ch;

	num=0;
	for(ch = *arg++ ; ch ; ch = *arg++) {
		if(ch < '0' || ch > '9')
			return(-1);
		num = (num * 10) + (ch - '0');
	}
	return(num);
}

width(n1,n2)
{
	register int num;

	if(*arg++ != '=') {
		printf("format is \"width=n\"\n");
		return;
	}
	if( (num = getdec()) <= 0177) {
		mode[1].high = num;
		wrkflg++;
		return;
	}
	printf("width range is 0 to 127\n");
}

length(n1,n2)
{
	register int num;

	if(*arg++ != '=') {
		printf("format is \"length=n\"\n");
		return;
	}
	if( (num = getdec()) <= 0377) {
		mode[1].low = num;
		wrkflg++;
		return;
	}
	printf("length range is 0 to 256\n");
}

getres(ttyn)
char *ttyn;
{
	register int num,c;
	register char *cp;

	if((inchn=open("/etc/ttylimits",0)) <=0 ){
		printf("can't find ttylimits\n");
		return(0);
	}
loop:	while( getchar() != '\n' );
	cp = ttyn;
	while(*cp) {
		c = getchar();
		if(c == '*') break;
		if(*cp++ != c) goto loop;
	}
	if(getchar() != ':') goto loop;
	noset = getfiloct();
	noclr = getfiloct();
	ilegl_spds = getfiloct();
	word1 = getfiloct();
	word2 = getfiloct();
	word3 = getfiloct();
	close(inchn);
	return(1);
}

getchar()
{
	int val;

more:	if(--fscnt >= 0) {
		val = *fspnt++;
		if(val == ' ' || val == '\t') goto more;
		return(val);
	}
	if((fscnt = read(inchn, &fstatbuf, 36)) == 0) {
		printf("??Eof encountered in 'TTYLIMITS' file??");
		flush();
		exit();
	}
	fspnt = &fstatbuf;
	goto more;
}

getfiloct()
{
	register int num,chr;

	while((chr = getchar()) < '0' || chr > '9');
	num = chr - '0';
	while ( (chr = getchar()) != ':' && chr != '\n')
		num = (num<<3) + (chr - '0');
	return(num);
}

gttnum()
{
	return(ttyname(ttyconv(fstatbuf[6])));
}

normal(a,b)
{
	mode[0] = word1;
	mode[1] = word2;
	mode[2] = word3;
	wrkflg++;
}

diabl(n1,n2)
{
	setup(n1,n2);
	printf("\r        *       *       *       *       *       *       *       *       *       *       *       *\n");
}
