/* $Header: /usr/alex/drivers/sb16/RCS/sb16.h,v 1.2 94/05/21 11:59:28 alex Exp $
 *
 * Sound Blaster 16 Driver Constants
 *
 * Copyright (c) 1994 Alex Nash, All Rights Reserved.
 *
 * This software is provided "as is" and without warranty of any kind.
 * The author accepts no responsibility for any damage caused by this
 * software.
 *
 * $Log:	sb16.h,v $
 * Revision 1.2  94/05/21  11:59:28  alex
 * DSP commands for configuring DMA/IRQ.
 * 
 * Revision 1.1  94/04/07  17:19:09  alex
 * Initial revision
 *
 */

#ifndef	__SYS_SB16_H
#define	__SYS_SB16_H

#if	!_KERNEL
#error You must be compiling the kernel to use this header!
#endif

/*--------------------------------------------------------------------------*/
/*	port address															*/
/*--------------------------------------------------------------------------*/
#define 	SB16_MIXER_ADDRESS		(sb16Port + 0x04)
#define 	SB16_MIXER_DATA			(sb16Port + 0x05)
#define 	SB16_DSP_RESET			(sb16Port + 0x06)
#define 	SB16_DSP_READ			(sb16Port + 0x0A)
#define 	SB16_DSP_WRITE			(sb16Port + 0x0C)
#define 	SB16_DSP_WR_DATA		(sb16Port + 0x0C)
#define 	SB16_DSP_WR_CMD			(sb16Port + 0x0C)
#define 	SB16_DSP_WRBUF_STATUS	(sb16Port + 0x0C)
#define 	SB16_DSP_RDBUF_STATUS	(sb16Port + 0x0E)
#define 	SB16_IRQ_RESET8			(sb16Port + 0x0E)
#define 	SB16_IRQ_RESET16		(sb16Port + 0x0F)

/*--------------------------------------------------------------------------*/
/*	DSP commands															*/
/*--------------------------------------------------------------------------*/
#define 	SB16_DSPCMD_PAUSE		0xD5
#define 	SB16_DSPCMD_CONTINUE	0xD6
#define 	SB16_DSPCMD_VERSION		0xE1

/*--------------------------------------------------------------------------*/
/*	mixer commands															*/
/*--------------------------------------------------------------------------*/
#define		SB16_MXRREG_RESET		0
#define 	SB16_MXRREG_MASTER_L	0x30
#define 	SB16_MXRREG_MASTER_R	0x31
#define 	SB16_MXRREG_VOICE_L		0x32
#define 	SB16_MXRREG_VOICE_R		0x33
#define 	SB16_MXRREG_MIDI_L		0x34
#define 	SB16_MXRREG_MIDI_R		0x35
#define 	SB16_MXRREG_CD_L		0x36
#define 	SB16_MXRREG_CD_R		0x37
#define 	SB16_MXRREG_LINE_L		0x38
#define 	SB16_MXRREG_LINE_R		0x39
#define 	SB16_MXRREG_MIC			0x3A
#define 	SB16_MXRREG_PC_SPKR		0x3B
#define 	SB16_MXRREG_OUT_SWITCH	0x3C
#define 	SB16_MXRREG_IN_L_SWITCH	0x3D
#define 	SB16_MXRREG_IN_R_SWITCH	0x3E
#define 	SB16_MXRREG_IN_GAIN_L	0x3F
#define 	SB16_MXRREG_IN_GAIN_R	0x40
#define 	SB16_MXRREG_OUT_GAIN_L	0x41
#define 	SB16_MXRREG_OUT_GAIN_R	0x42
#define 	SB16_MXRREG_AGC			0x43
#define 	SB16_MXRREG_TREBLE_L	0x44
#define 	SB16_MXRREG_TREBLE_R	0x45
#define 	SB16_MXRREG_BASS_L		0x46
#define 	SB16_MXRREG_BASS_R		0x47
#define 	SB16_MXRREG_IRQ_CFG		0x80
#define 	SB16_MXRREG_DMA_CFG		0x81
#define 	SB16_MXRREG_IRQ			0x82

/*--------------------------------------------------------------------------*/
/*	IRQ status masks														*/
/*--------------------------------------------------------------------------*/
#define 	SB16_IRQ_STATUS_8BIT	0x01
#define 	SB16_IRQ_STATUS_16BIT	0x02

/*--------------------------------------------------------------------------*/
/*	global variables														*/
/*--------------------------------------------------------------------------*/
extern int sb16Port;
extern int sb16Irq;
extern int sb16Dma8;
extern int sb16Dma16;

#endif	/* __SYS_SB16_H */

