/* $Header: /usr/alex/drivers/sb16/RCS/sound.h,v 1.2 94/05/21 11:55:54 alex Exp $
 *
 * Sound Card Structures and Constants
 *
 * Copyright (c) 1994 Alex Nash, All Rights Reserved.
 *
 * This software is provided "as is" and without warranty of any kind.
 * The author accepts no responsibility for any damage caused by this
 * software.
 *
 * $Log:	sound.h,v $
 * Revision 1.2  94/05/21  11:55:54  alex
 * SOUND_POSITION and SOUND_LEVEL ioctl support.  New mixer ioctl
 * commands to allow mono recordings.
 * 
 * Revision 1.1  94/04/07  17:19:42  alex
 * Initial revision
 *
 */

#ifndef		__SYS_SOUND_H__
#define 	__SYS_SOUND_H__

/*--------------------------------------------------------------------------*/
/*	IOCTL command prefix													*/
/*--------------------------------------------------------------------------*/
#define 	SIOCTL_PREFIX			(('s' << 24) | ('c' << 16))

/*--------------------------------------------------------------------------*/
/*	IOCTL "hint" codes (provides for faster switching of IOCTL commands)	*/
/*--------------------------------------------------------------------------*/
#define 	MXR_IOCTL_GET			(SIOCTL_PREFIX | 0x8000)
#define 	MXR_IOCTL_SET			(SIOCTL_PREFIX | 0x4000)

/*--------------------------------------------------------------------------*/
/*	mixer IOCTL commands (must be used with IOCTL hints)					*/
/*--------------------------------------------------------------------------*/
#define		MXR_MUTE				 1
#define		MXR_MASTER				 2
#define		MXR_BASS				 3
#define		MXR_TREBLE				 4
#define 	MXR_VOICE				 5
#define		MXR_LINE				 6
#define		MXR_CD					 7
#define		MXR_MIDI				 8
#define 	MXR_PC_SPKR				 9
#define		MXR_MIC					10
#define 	MXR_IN_GAIN				11
#define 	MXR_OUT_GAIN			12
#define 	MXR_AGC					13
#define 	MXR_OS_LINE				14
#define 	MXR_OS_CD				15
#define 	MXR_OS_MIC				16
#define 	MXR_IS_MIDI_L			17
#define 	MXR_IS_MIDI_R			18
#define 	MXR_IS_LINE_L			19
#define 	MXR_IS_LINE_R			20
#define 	MXR_IS_CD_L				21
#define 	MXR_IS_CD_R				22
#define 	MXR_IS_MIC				23

/*--------------------------------------------------------------------------*/
/*	ioctl() commands														*/
/*--------------------------------------------------------------------------*/
/* initialize record/playback device */
#define		SOUND_INIT			(SIOCTL_PREFIX | 0)

/* blocks until playback finishes */
#define		SOUND_END			(SIOCTL_PREFIX | 1)

/* halts playback/recording immediately */
#define		SOUND_STOP			(SIOCTL_PREFIX | 2)

/* starts recording	*/
#define		SOUND_RECORD		(SIOCTL_PREFIX | 3)

/* pause playback/recording	*/
#define		SOUND_PAUSE			(SIOCTL_PREFIX | 4)

/* continue playback/recording */
#define 	SOUND_CONTINUE		(SIOCTL_PREFIX | 5)

/* query device capabilities */
#define 	SOUND_QUERY			(SIOCTL_PREFIX | 6)

/* query playback/record level */
#define 	SOUND_LEVEL			(SIOCTL_PREFIX | 7)

/* query number of bytes played/recorded */
#define 	SOUND_POS			(SIOCTL_PREFIX | 8)

/*--------------------------------------------------------------------------*/
/*	sb16mixer ioctl() commands												*/
/*--------------------------------------------------------------------------*/
#define		MXR_SET_MUTE		(MXR_IOCTL_SET | MXR_MUTE)
#define		MXR_GET_MUTE		(MXR_IOCTL_GET | MXR_MUTE)
#define		MXR_SET_MASTER		(MXR_IOCTL_SET | MXR_MASTER)
#define		MXR_GET_MASTER		(MXR_IOCTL_GET | MXR_MASTER)
#define		MXR_SET_BASS		(MXR_IOCTL_SET | MXR_BASS)
#define		MXR_GET_BASS		(MXR_IOCTL_GET | MXR_BASS)
#define		MXR_SET_TREBLE		(MXR_IOCTL_SET | MXR_TREBLE)
#define		MXR_GET_TREBLE		(MXR_IOCTL_GET | MXR_TREBLE)
#define 	MXR_SET_VOICE		(MXR_IOCTL_SET | MXR_VOICE)
#define 	MXR_GET_VOICE		(MXR_IOCTL_GET | MXR_VOICE)
#define		MXR_SET_LINE		(MXR_IOCTL_SET | MXR_LINE)
#define		MXR_GET_LINE		(MXR_IOCTL_GET | MXR_LINE)
#define		MXR_SET_CD			(MXR_IOCTL_SET | MXR_CD)
#define		MXR_GET_CD			(MXR_IOCTL_GET | MXR_CD)
#define		MXR_SET_MIDI		(MXR_IOCTL_SET | MXR_MIDI)
#define		MXR_GET_MIDI		(MXR_IOCTL_GET | MXR_MIDI)
#define 	MXR_SET_PC_SPKR		(MXR_IOCTL_SET | MXR_PC_SPKR)
#define 	MXR_GET_PC_SPKR		(MXR_IOCTL_GET | MXR_PC_SPKR)
#define		MXR_SET_MIC			(MXR_IOCTL_SET | MXR_MIC)
#define		MXR_GET_MIC			(MXR_IOCTL_GET | MXR_MIC)
#define 	MXR_SET_IN_GAIN		(MXR_IOCTL_SET | MXR_IN_GAIN)
#define 	MXR_GET_IN_GAIN		(MXR_IOCTL_GET | MXR_IN_GAIN)
#define 	MXR_SET_OUT_GAIN	(MXR_IOCTL_SET | MXR_OUT_GAIN)
#define 	MXR_GET_OUT_GAIN	(MXR_IOCTL_GET | MXR_OUT_GAIN)
#define 	MXR_SET_AGC			(MXR_IOCTL_SET | MXR_AGC)
#define 	MXR_GET_AGC			(MXR_IOCTL_GET | MXR_AGC)
#define 	MXR_SET_OS_LINE		(MXR_IOCTL_SET | MXR_OS_LINE)
#define 	MXR_GET_OS_LINE		(MXR_IOCTL_GET | MXR_OS_LINE)
#define 	MXR_SET_OS_CD		(MXR_IOCTL_SET | MXR_OS_CD)
#define 	MXR_GET_OS_CD		(MXR_IOCTL_GET | MXR_OS_CD)
#define 	MXR_SET_OS_MIC		(MXR_IOCTL_SET | MXR_OS_MIC)
#define 	MXR_GET_OS_MIC		(MXR_IOCTL_GET | MXR_OS_MIC)
#define 	MXR_SET_IS_MIDI		(MXR_IOCTL_SET | MXR_IS_MIDI)
#define 	MXR_GET_IS_MIDI		(MXR_IOCTL_GET | MXR_IS_MIDI)
#define 	MXR_SET_IS_LINE		(MXR_IOCTL_SET | MXR_IS_LINE)
#define 	MXR_GET_IS_LINE		(MXR_IOCTL_GET | MXR_IS_LINE)
#define 	MXR_SET_IS_CD		(MXR_IOCTL_SET | MXR_IS_CD)
#define 	MXR_GET_IS_CD		(MXR_IOCTL_GET | MXR_IS_CD)
#define 	MXR_SET_IS_MIC		(MXR_IOCTL_SET | MXR_IS_MIC)
#define 	MXR_GET_IS_MIC		(MXR_IOCTL_GET | MXR_IS_MIC)

/*--------------------------------------------------------------------------*/
/*	SoundInit																*/
/*--------------------------------------------------------------------------*/
typedef struct _SoundInit
{
	int			sampleRate;	/* 5-44.1 KHz                             */
    int			bStereo;	/* stereo flag (0 = mono, 1 = stereo)     */
    int			bRecord;	/* record flag (0 = playback, 1 = record) */
	int			bits;		/* bits per sample (8/16)				  */
	unsigned	length;		/* data length in bytes (playback only)	  */
	unsigned	filterFreq;	/* filter frequency						  */
}SoundInit;

/*--------------------------------------------------------------------------*/
/*	MixerControl															*/
/*--------------------------------------------------------------------------*/
typedef struct _MixerControl
{
	int		left;		/* left/mono channel (0-255) 						*/
    int		right;		/* right channel (0-255)	 						*/
	int		levels;		/* actual number of distinct levels (get only)  	*/
	int		bRoot;		/* requires root permissions to change (get only)	*/
}MixerControl;

/*--------------------------------------------------------------------------*/
/*	SoundInfo																*/
/*--------------------------------------------------------------------------*/
typedef struct _SoundInfo
{
	int		deviceCode;			/* sound card identification code 	*/
	char	deviceName[30];		/* device name					  	*/
	int		recordFlags;		/* recording capabilities			*/
	int		playFlags;			/* playback capabilities			*/
	int		mixerFlags;			/* mixer capabilities				*/
	int		miscFlags;			/* miscellaneous capabilities		*/
}SoundInfo;

/*--------------------------------------------------------------------------*/
/*	SoundLevel																*/
/*--------------------------------------------------------------------------*/
typedef struct _SoundLevel
{
	int		left;				/* left channel level (0-65535)		*/
	int		right;				/* right channel level (0-65535)	*/
	int		bClipLeft;			/* left clipping flag				*/
	int		bClipRight;			/* right clipping flag				*/
}SoundLevel;

/*--------------------------------------------------------------------------*/
/*	SoundPosition															*/
/*--------------------------------------------------------------------------*/
typedef struct _SoundPosition
{
	unsigned	bytes;			/* number of bytes played/recorded	*/
}SoundPosition;

/*--------------------------------------------------------------------------*/
/*	SoundInfo device codes													*/
/*--------------------------------------------------------------------------*/
#define	SIDC_SOUND_BLASTER_16	1

/*--------------------------------------------------------------------------*/
/*	constants for SoundInfo.recordFlags										*/
/*--------------------------------------------------------------------------*/
#define	SIRF_PAUSE			 	1 /* device has pause/continue capability  	*/
#define	SIRF_8BIT_MONO		 	2 /* device can record 8 bit mono sound    	*/
#define	SIRF_8BIT_STEREO	 	4 /* device can record 8 bit stereo sound  	*/
#define	SIRF_16BIT_MONO		 	8 /* device can record 16 bit mono sound   	*/
#define SIRF_16BIT_STEREO	   16 /* device can record 16 bit stereo sound 	*/

/*--------------------------------------------------------------------------*/
/*	constants for SoundInfo.playFlags										*/
/*--------------------------------------------------------------------------*/
#define	SIPF_PAUSE				1 /* device has pause/continue capability	*/
#define SIPF_8BIT_MONO			2 /* device can play 8 bit mono sound		*/
#define SIPF_8BIT_STEREO		4 /* device can play 8 bit stereo sound		*/
#define SIPF_16BIT_MONO			8 /* device can play 16 bit mono sound		*/
#define SIPF_16BIT_STEREO	   16 /* device can play 16 bit stereo sound	*/

/*--------------------------------------------------------------------------*/
/*	constants for SoundInfo.mixerFlags										*/
/*--------------------------------------------------------------------------*/
#define SIMXF_CROSS				1 /* device has channel crossing ability	*/

/*--------------------------------------------------------------------------*/
/*	constants for SoundInfo.miscFlags										*/
/*--------------------------------------------------------------------------*/
#define	SIMSF_PROG_FILTER		1 /* device has sftwr programmable filters	*/
#define SIMSF_SIMUL_PR			2 /* device can simultaneously play&record 	*/


#if _KERNEL

#include <common/ccompat.h>
#include <sys/io.h>

/*--------------------------------------------------------------------------*/
/*	minor device numbers													*/
/*--------------------------------------------------------------------------*/

#define		SOUND_DSP_MINOR		0	/* DSP device minor 	*/
#define		SOUND_MIXER_MINOR	1	/* mixer device minor	*/

/* DSP function table. */
struct snd_dsp_ft {
	int		(*init)		__PROTO ((void));
	int		(*open)		__PROTO ((void));
	int		(*close)	__PROTO ((void));
	int		(*read)		__PROTO ((IO *));
	int		(*write)	__PROTO ((IO *));
	int		(*ioctl)	__PROTO ((int cmd, char * data));
};

/* Mixer function table. */
struct snd_mixer_ft {
	int		(*init)		__PROTO ((void));
	int		(*ioctl)	__PROTO ((int cmd, char * data, int mode));
};

/* DMA cookies. */
struct snd_dma_parms {
	int	dma8Page;
	int	dma8Base;
	int	dma8Count;

	int	dma16Page;
	int	dma16Base;
	int	dma16Count;
};

/* Externals determined by system configuration. */

extern struct snd_dsp_ft		* snd_dsp_ftp;
extern struct snd_mixer_ft		* snd_mixer_ftp;

#endif

#endif		/* __SYS_SOUND_H__ */
