#
# Call history program
#
GLOBALS "globals0.4gl"

#
# call history menu.
#
FUNCTION call_history_menu()
	DISPLAY FORM call_form

	MESSAGE ""

	COMMAND "Add" "Add a new call history record"
		LET answer = "y"
		WHILE answer = "y"
			CALL enter_history()

			CALL yn("Enter another call history record <y/n>")
				RETURNING answer
		END WHILE

	COMMAND "Find" "Search for a call history record."
		CALL find_history()
		IF chosen = TRUE THEN
			CALL mod_history_menu()

			LET chosen = FALSE
		END IF

	COMMAND "Report" "Run call history report"
		CALL call_history_report()

	COMMAND "Exit" "Leave the call history program."
		MESSAGE ""
		EXIT MENU		
	END MENU
END FUNCTION

#
# Menu for call history mods
#
FUNCTION mod_history_menu()
	MENU "Modify"
	COMMAND "Modify" "Modify a call history record"
		CALL modify_history()
		EXIT MENU

	COMMAND "Delete" "Delete a call history record"
		CALL yn("are you sure you want to delete this <y/n>")
			RETURNING answer
		IF answer = "y" THEN
			CALL delete_history()
		END IF
		EXIT MENU

	COMMAND "Exit" "Don't modify invoice"
		EXIT MENU		
	END MENU
END FUNCTION

#
# Get customer record
#
FUNCTION get_cust()
	LET p_cust.cust_no = NULL

	INPUT BY NAME	p_cust.cust_no  WITHOUT DEFAULTS
	AFTER FIELD cust_no
		IF p_cust.cust_no IS NULL THEN
			RETURN 0
		END IF

		SELECT * INTO p_cust.* FROM customer
		 WHERE cust_no = p_cust.cust_no
		IF status = NOTFOUND THEN
			MESSAGE "customer number not found"
			NEXT FIELD cust_no
		END IF
	END INPUT

	SELECT * INTO s_address.* FROM address
	 WHERE  cust_no = p_cust.cust_no AND
        	add_type <> "b"

	DISPLAY BY NAME	p_cust.contact,
			p_cust.phone_no,
			p_cust.club,
			s_address.line1 THRU s_address.zipcode

	RETURN 1
END FUNCTION

#
# Show the business done for the new customer.
#
FUNCTION show_business()
	DEFINE i SMALLINT
	DEFINE p ARRAY[200] OF SMALLINT

	FOR i = 1 to 200
		LET p[i] = 0
	END FOR

	DECLARE y_curs CURSOR FOR
	 SELECT inv_line.* FROM invoice, inv_line
	  WHERE invoice.cust_no = p_cust.cust_no
	    AND inv_line.invoice_no = invoice.invoice_no

	FOREACH y_curs INTO p_line.*
		LET i = p_line.prod_no
		IF i > 200 THEN
			MESSAGE "prod no > 200"
			RETURN
		END IF
		LET p[i] = p[i] + p_line.quantity
	END FOREACH

	LET s1 = NULL
	FOR i = 1 to 200
		IF p[i] != 0 THEN
			IF s1 IS NULL THEN
				LET s1 = p[i] USING "<<<",
					" of ", i USING "<<<"
			ELSE
				LET s1 = s1 CLIPPED, ", ", 
					p[i] USING "<<<",
					" of ", i USING "<<<"
			END IF
		END IF
	END FOR

	MESSAGE s1
END FUNCTION

#
# Input call history record
#
FUNCTION inp_history(sw)
	DEFINE sw SMALLINT

	IF sw = 0 THEN
		LET call_hist.cust_no = p_cust.cust_no
		LET call_hist.user_id = user_id
		LET call_hist.disposition = NULL
		LET call_hist.calldate = CURRENT
		LET call_hist.callback_date = NULL
		LET call_hist.hcomments = NULL
	ELSE
	END IF
END FUNCTION

#
# Entern call history record
#
FUNCTION enter_history()
	DEFINE csw SMALLINT

	MESSAGE ""
	CLEAR FORM

	CALL get_cust() RETURNING csw

	IF csw = 0 THEN
		RETURN
	END IF

	CALL show_business()

	CALL inp_history(0)

	INSERT INTO call_hist VALUES (
		p_cust.cust_no,
		user_id,
		p_history.disposition,
		p_history.calldate,
		p_history.callback_date,
		p_history.comments
	)
END FUNCTION
