MAIN
#DROP DATABASE mwc
CREATE DATABASE mwc

# global switches for the entire system

CREATE TABLE sws (
	systm	CHAR(20)	# Which system is this really 
)

# One for each customer

CREATE TABLE customer (
	cust_no		SERIAL,
	contact		CHAR(38),
	phone_no	CHAR(36),
	all_nfo		CHAR(1),	# y, n or NULL for non mailer
	user_id		CHAR(9),
	cust_date	DATE,		# date customer record entered
	crunch		CHAR(10),	# contact in uppercase no vowels
	inq_src		SMALLINT	# original inquiry source
)

CREATE UNIQUE CLUSTER INDEX c_customer ON customer(cust_no)
CREATE INDEX c_crunch ON customer (crunch);

# Invoice record

CREATE TABLE invoice (
	invoice_no	SERIAL(20000),	# invoice number
	cust_no		INTEGER,
	invoice_date	DATE,
	icomments	CHAR(50),
	inq_src		SMALLINT,	# magazine etc
	subtotal	MONEY(8, 2),	# total of invoice lines
	ship_no		SMALLINT,	# Shipper (UPS etc)
	card_no		CHAR(20),	# card no
	exp_date	CHAR(5),	# mm/yy
	ship_amt	MONEY(6, 2),	# Shipping charges
	discount	MONEY(8, 2),	# Customer discount
	taxes		MONEY(8, 2),	# Taxes
	itotal		MONEY(8, 2),	# Total
	ship_date	DATE,		# ship date
	term_no		SMALLINT,	# VISA MC COD etc
	user_id		CHAR(9),	# user who entered invoice
	bounce		CHAR(1),	# the check for this invoice bounced
	batch_ix	INTEGER,	# credit card entry batch no
	ref_no		INTEGER,	# credit card entry reference no
	cap_no		INTEGER,	# credit card capture number
	tym_flag	SMALLINT,	# NULL not part of system
					# 1 new 2 sent 3 approved 4 diss
					# 5 new void 6 void 7 diss void
					# 8 void in transit
	back_flag	SMALLINT
)

CREATE UNIQUE CLUSTER INDEX i_invoice_no ON invoice(invoice_no)
CREATE INDEX c_invoice ON invoice(cust_no)
CREATE INDEX b_invoice ON invoice(batch_ix)

# Address data to connect to invoice data
CREATE TABLE address (
	cust_no		INTEGER,	# customer number
	add_type	CHAR(1),	# B = bill to S = ship to x = both
	line1		CHAR(38),
	line2		CHAR(38),
	line3		CHAR(38),
	city		CHAR(20),
	state		CHAR(4),
	country		CHAR(14),
	zipcode		CHAR(11)
)

CREATE CLUSTER INDEX c_address ON address(cust_no)

# Table of states and countrys
CREATE TABLE states (
	state		CHAR(4),
	country		CHAR(14),
	blue_zone	SMALLINT,
	red_zone	SMALLINT,
	dest_no		SMALLINT
)

# Table or product, shipper, destination to calculate our
# freight charges.
CREATE TABLE prod_ship (
	prod_no		SMALLINT,
	ship_no		SMALLINT,
	dest_no		SMALLINT,
	const_cost	MONEY(6,2),
	lb_cost		MONEY(6,2)
)

CREATE UNIQUE INDEX p_s_d ON prod_ship (prod_no, ship_no, dest_no)

# Freight desitnations like Continental US, Mexico
CREATE TABLE dests (
	dest_no		SERIAL,
	dest_name	CHAR(15)
)

# an invoice line item
CREATE TABLE inv_line (
	invoice_no	INTEGER,
	prod_no		SMALLINT,
	quantity	SMALLINT,
	pack_no 	SMALLINT  # numbers of pakages
)
CREATE CLUSTER INDEX i_line ON inv_line(invoice_no)

# For each price there is a different product number thus there
# will be an introductory Coherent at 99.95 and a Coherent at
# 169.95 etc. There is also a different number for 3.5 and 5.25
# inch disks. Each royalty will produce new product numbers.

CREATE TABLE product (
	prod_no		SERIAL,
	prod_name	CHAR(30),
	comment1	CHAR(30),
	price		MONEY(8, 2),
	weight		SMALLINT,
	nolist		SMALLINT,	# don't put on product list
	b_flag		SMALLINT	# Product on back order
)

#
# Database for terms like "net 30" or "ppd"
#
CREATE TABLE terms (
	term_no		SERIAL,
	term_name	CHAR(6)
)

# Shippers such as UPS Fed ex etc
CREATE TABLE shippers (
	ship_no		SERIAL,
	ship_name	CHAR(15),
	cust_cost	MONEY(6, 2)
)

# all inquiry sources
CREATE TABLE magazines (
	inq_src		SERIAL,
	mag_name	CHAR(20),
	cost		MONEY(8, 2),
	cur_ad		SMALLINT
)

# credit card entry batch
CREATE TABLE batch (
	batch_ix	SERIAL(1000),
	batch_no	SMALLINT,
	batch_date	DATE
)

# credit memos
CREATE TABLE cmemo (
	memo_no		SERIAL(10000),	# credit memo number
	memo_date	DATE,		# credit memo date
	invoice_no	INTEGER,	# invoice number
	auth_no		INTEGER,	# return authorization no
	amount		MONEY(8, 2),	# credit amount
	com1		CHAR(50),	# comment
	com2		CHAR(50),
	batch_ix	INTEGER		# credit card entry
	ref_no		INTEGER,
	cap_no		INTEGER,
	tym_flag	SMALLINT
)

CREATE CLUSTER INDEX c_invoice_no ON cmemo(invoice_no)
CREATE INDEX b_credit ON cmemo(batch_ix)

CREATE TABLE auth (
	auth_no		SERIAL(2000),
	auth_date	DATE,
	return_date	DATE,
	invoice_no	INTEGER,
	contact		CHAR(38),
	reason		SMALLINT,
	other_reason	CHAR(38)
)

# payments
CREATE TABLE payment (
	pay_no		SERIAL(10000),	# payment number
	pay_date	DATE,		# payment date
	invoice_no	INTEGER,	# invoice number
	amount		MONEY(8, 2),	# payment amount
	com1		CHAR(50)	# comment
)

CREATE CLUSTER INDEX p_invoice_no ON payment(invoice_no)

# old registration cards
CREATE TABLE regcard (
	ser_no		INTEGER,	# fancy permuted SERIAL no
	cust_no		INTEGER,
	reg_date	DATE,
	comp_type	CHAR(38),
	disk_size	SMALLINT,	# disk size in meg
						# mag checklist
	byte		CHAR(1),
	c_gazette	CHAR(1),
	cug		CHAR(1),
	circ_cel	CHAR(1),
	comm_acm	CHAR(1),
	comp_shop	CHAR(1),
	comp_lang	CHAR(1),
	comp_world	CHAR(1),
	dr_dobbs	CHAR(1),
	unix_rev	CHAR(1),
	unix_today	CHAR(1),
	unix_world	CHAR(1),
	ee_times	CHAR(1),
	embed_sys	CHAR(1),
	ieee_spec	CHAR(1),
	info_world	CHAR(1),
	pc_comp		CHAR(1),
	personal_comp	CHAR(1),
	personal_wk	CHAR(1),
	prog_journal	CHAR(1),
	sys_integrat	CHAR(1),
	pc_mag		CHAR(1),
	pc_week		CHAR(1),
	pc_world	CHAR(1),

	exp_level	CHAR(1),

	personal_use	CHAR(1),
	business_use	CHAR(1),
	education	CHAR(1)
)
CREATE INDEX c_regcard ON regcard (cust_no)
CREATE UNIQUE CLUSTER INDEX i_ser_no ON regcard (ser_no)

# new registration cards
CREATE TABLE newreg (
	ser_no		INTEGER,	# fancy permuted SERIAL no
	cust_no		INTEGER,
	reg_date	DATE,
	comp_type	CHAR(38),
	disk_size	SMALLINT,	# disk size in meg

	develop		CHAR(1),	# How do you plan to use Coherent
	learn		CHAR(1),
	other		CHAR(1),
	communication	CHAR(1),
	business	CHAR(1),

	software_exp	SMALLINT,	# 1 < 250, 2 < 500, 3 < 1000,
					# 4 < 3000, 5 < 5000, 6 > 5000

	exp_level	CHAR(1),

	personal_use	CHAR(1),
	business_use	CHAR(1),
	education	CHAR(1),

	c_comp		CHAR(1),
	turbo_c		CHAR(1),
	microsoft_c	CHAR(1),
	other_c		CHAR(1),

	macintosh	CHAR(1),

	windows		CHAR(1),

	workstations	CHAR(1),
	sun		CHAR(1),
	ibm		CHAR(1),
	dec		CHAR(1),
	hewlett_packard	CHAR(1),

	operating_sys	CHAR(1),
	unix_v		CHAR(1),
	ultrix		CHAR(1),
	xenix		CHAR(1),
	aix		CHAR(1),
	sunos		CHAR(1),
	hpux		CHAR(1),
	esix		CHAR(1),

	other_os	CHAR(10)
)

CREATE UNIQUE CLUSTER INDEX i_nser_no ON newreg (ser_no)
CREATE INDEX c_newreg ON newreg (cust_no)

CREATE TABLE shipreg (
     cust_no INTEGER,
     ser_no INTEGER,
     trace_no DECIMAL(11,0)
)

CREATE CLUSTER INDEX ser_ship ON shipreg (ser_no);

CREATE INDEX cust_ship ON shipreg (cust_no);

# Table to take care about reshiped products
CREATE TABLE bad_disk (
     baddisk_no SERIAL,
     ser_no 	INTEGER, 	# serial number of product
     cust_no 	INTEGER,	# number of customer 
     call_d 	DATE,		# call date
     med_type 	CHAR(1),	# b = bad r = replacement
     cmnt 	CHAR(28),	# comments
     reply 	DATE,		# reply date
     ship_no 	SMALLINT,	# number of shipper
     prod_no 	SMALLINT,	# product number
     disk 	CHAR(13),	# bad disk number(s)
     head 	SMALLINT,
     cylinder 	SMALLINT,
     badfile 	CHAR(24),	# bad file(s)
     controller CHAR(38),	# 
     i_msgs 	CHAR(38)	# installation message
    )

# UPS call tag table
CREATE TABLE call_tag (
	tag_no		INTEGER,
	invoice_no	INTEGER,
	why		CHAR(70),
	action		CHAR(70),
	issue_date	DATE,
	rec_date	DATE
	)

END MAIN

#
# This table contents rows weight, zone, price
#
CREATE TABLE w_z_p(
	weight		SMALLINT,
	zone		SMALLINT,
	price	        MONEY(5,2),
	commer		SMALLINT
)
CREATE UNIQUE INDEX weight_zone ON w_z_p (weight, zone)

# If country is Canada UPS got too sophisticated rules for
# finding zone number. Zone number will be input by hands 
# for first release.
#
# International mail will not be sent by UPS (in general)
# We can print zone numbers  by hands for all two of customers.
#

# 
# This table needs for UPS reports
#
CREATE TABLE pickup_line (
	invoice_no	INTEGER,
	contact		CHAR(14),
	address		CHAR(18),
	city		CHAR(8),
	state		CHAR(3),
	country		CHAR(4),
	zipcode		CHAR(7),
	commer		SMALLINT,
	weight		SMALLINT,
	zone		SMALLINT,
	charge		MONEY(8, 2),
	dec_value	MONEY(8, 2),
	cod_amt		MONEY(8, 2),
	cod_chrg	MONEY(8, 2),
	aod		CHAR(1),
	cll		CHAR(1),
	pack_no		SMALLINT,
	closed		CHAR(1),
	cl_date		DATE,
	ship_loc	SMALLINT
)


#
# This table is for the USA ground service.
# All zipcodes between two numbers zip1 and zip2 * 100
# have the same zone number - zone. If zip code is not between
# these numbers it means that UPS doesn't have ground service
# (Alaska Rural for example).
#
CREATE TABLE ground(
	from_zip	SMALLINT,
	to_zip		SMALLINT,
	zone		SMALLINT
)

# This table should be used to calculate UPS record number.
# In practice, nobody uses it. Can be remove from database.
# But code still use it. Must be clean.
CREATE TABLE RecNumber (
	rec_number	INTEGER,
	pick_date	DATE
)

# This is a temporary file creaded by mailc.4gl and used by bigmail.4gl
CREATE TABLE workf (
	cust_no		INTEGER,
	tbl		SMALLINT,	# the mailing classification
	addons		SMALLINT	# the number of addon products
					# purchased (the definition shifts)
)

END MAIN		
