#
# Output list of names for duplicate find
# Put the output through
#
DATABASE mwc

MAIN
	DEFINE	c RECORD LIKE customer.*
	DEFINE  a RECORD LIKE address.*

	DECLARE curs CURSOR FOR
	 SELECT * FROM customer, address
	  WHERE customer.cust_no = address.cust_no
	    AND	address.add_type <> "s"

	START REPORT dup_list

	FOREACH curs INTO c.*, a.*
		IF "--" == c.contact THEN
			CALL cruncher(a.line1) RETURNING c.crunch
		END IF

		OUTPUT TO REPORT dup_list(c.*, a.*)
	END FOREACH

	FINISH REPORT dup_list

	CLOSE curs

	RUN "ph dups"	# pr to lp
	RUN "rm dups"
END MAIN

REPORT dup_list(c, a)
	DEFINE	c RECORD LIKE customer.*
	DEFINE  a RECORD LIKE address.*
	DEFINE  ct, nct, bct SMALLINT
	DEFINE  rg, bk CHAR(1)

	OUTPUT
		REPORT TO PIPE "dupwrite > dups"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY c.crunch, a.zipcode

	FORMAT
	ON EVERY ROW
		SELECT COUNT(*)
		  INTO ct
		  FROM regcard
		 WHERE cust_no = c.cust_no

		SELECT COUNT(*)
		  INTO nct
		  FROM newreg
		 WHERE cust_no = c.cust_no

		SELECT COUNT(*)
		  INTO bct
		  FROM invoice
		 WHERE cust_no = c.cust_no
		   AND back_flag = 1

		IF bct == 0 THEN
			LET bk = NULL
		ELSE
			LET bk = "B"
		END IF

		IF ct == 0 AND nct == 0 THEN
			LET rg = NULL
		ELSE
			LET rg = "R"
		END IF

		IF 	c.all_nfo == "x" THEN
			LET rg = "X"
		END IF
  
		PRINT	c.crunch CLIPPED, "@",
			a.zipcode CLIPPED, "@",
			c.contact CLIPPED, "@",
			c.cust_no USING "<<<<<<", " ",
			bk, rg, "@",
			a.line1 CLIPPED, "@",
			a.line2 CLIPPED, "@",
			a.line3 CLIPPED, "@",
			a.city CLIPPED, " ",
			a.state CLIPPED, " ",
			a.country CLIPPED, " ",
			a.zipcode CLIPPED
END REPORT
