# This program will read from the temporary table generated by boblist.4ge
# and create a list of all Coherent 4.0 customers in the US which contains
# customer contact info and a list of all 4.x products they already own.

DATABASE mwc

MAIN
	DEFINE
		OS		char(4),
		coh31U		char(1),
		coh32U		char(1),
		coh40U		char(1),
		mycust		INTEGER,
		myname		LIKE customer.contact,
		myphone		LIKE customer.phone_no,
		mystate		LIKE address.state,
		myproduct	LIKE cprodlst.prod_no

# select customer's by customer number, and get their phone number, state,

	DECLARE cust_curs CURSOR FOR
		SELECT	customer.cust_no, customer.contact,
			customer.phone_no, address.state
		INTO 	mycust, myname, myphone, mystate
		FROM 	customer, address
		WHERE	address.cust_no = customer.cust_no AND
			address.country IS NULL

	START REPORT cust_32x
	START REPORT cust_310
	START REPORT cust_300

# Now walk though the customer/product table and find out what they have
	FOREACH cust_curs
		DECLARE prod_curs CURSOR FOR
			SELECT cprodlst.prod_no
			INTO myproduct
			FROM cprodlst
			WHERE cprodlst.cust_no = mycust

			LET OS = ""
			LET coh31U = "0"
			LET coh32U = "0"
			LET coh40U = "0"

# Now look for additional operating system upgrades purchased
# a product by product comparison. When a product is matched, a string is
# set to a value which will print on the report.

		FOREACH prod_curs

# The following statements test for the original OS and then look to see
# if there is a credit memo for the OS purchase. If there is a credit
# memo for the OS, we will not send it to the report programs.

#			IF myproduct = 60 THEN LET OS = "COH4" END IF
#			IF myproduct = 61 THEN LET OS = "COH4" END IF

			IF (myproduct = 44) OR  (myproduct = 45) THEN 
				LET OS = "C321" 
			END IF

			IF (myproduct = 26) OR (myproduct = 27) THEN 
				LET OS = "C310" 
			END IF


			IF (myproduct = 1) OR (myproduct = 2) THEN
				LET OS = "C300"
			END IF


# The following statements test for updates to the original OS
			IF (myproduct = 37) OR (myproduct = 38) THEN
				LET coh31U = "1" END IF

			IF (myproduct = 56) OR (myproduct = 57) THEN
				LET coh32U = "1" END IF

			IF (myproduct = 62) OR (myproduct = 62) THEN
				LET coh40U = "1" END IF

		END FOREACH

	IF (OS = "C321") THEN
		OUTPUT TO REPORT 
			cust_32x (mycust, myname, myphone, mystate, OS,
					coh31U, coh32U, coh40U)

	END IF

	IF (OS = "C310") THEN
		OUTPUT TO REPORT 
			cust_310 (mycust, myname, myphone, mystate, OS,
					coh31U, coh32U, coh40U)

	END IF

	IF (OS = "C300") THEN
		OUTPUT TO REPORT 
			cust_300 (mycust, myname, myphone, mystate, OS,
					coh31U, coh32U, coh40U)

	END IF

	END FOREACH
	FINISH REPORT cust_32x
	FINISH REPORT cust_310
	FINISH REPORT cust_300

END MAIN


# This is the OS report for people who initially bought 3.2.x

REPORT cust_32x (mynumber, cname, cphone, cstate, cOS, c31U, c32U, c40U)

	DEFINE 	mynumber INTEGER,
		cname 	LIKE customer.contact,
		cphone	LIKE customer.phone_no,
		cstate	LIKE address.state,
		cOS	CHAR(4),
		c31U	char(1),
		c32U	char(1),
		c40U	char(1),
		counter	INTEGER,
		nolines	INTEGER

	OUTPUT
		LEFT MARGIN 0
		RIGHT MARGIN 79
		TOP MARGIN 2
		BOTTOM MARGIN 2
		PAGE LENGTH 80
		REPORT TO "market.320"
#		REPORT TO PIPE "c10 | lp"

	ORDER BY mynumber, c40U DESCENDING


	FORMAT
	PAGE HEADER
		PRINT	COLUMN 1,  PAGENO USING "Page ####",
			50 SPACES,"Date: ", TODAY

		PRINT COLUMN 22,
		"Customers Who Purchased 3.2.x as Their Initial OS"


		PRINT	COLUMN 6, "Customer Name and Phone",
			COLUMN 55, "Products"
			SKIP 1 LINE

	AFTER GROUP OF mynumber
#	ON EVERY ROW
		LET nolines = nolines + 1
		PRINT	COLUMN 1, cname CLIPPED,"(",mynumber USING "<<<<<<",")",
			COLUMN 49, cOS ,"\t","n/a","\t","n/a","\t",c40U

		PRINT COLUMN 1, cphone CLIPPED,"(",cstate CLIPPED,")"
		SKIP 1 LINE
		IF c40U = "1" THEN LET counter = counter + 1 END IF

	ON LAST ROW
		SKIP 1 LINE
		PRINT "# of customers with 3.2 as their initial OS is ", nolines USING "<<<<"
		PRINT "Customers who upgraded to 4.0 from 3.2.x is ",counter USING "<<<<"
	
END REPORT



# This is the report for people who bought 310 as their initial OS
REPORT cust_310 (mynumber, cname, cphone, cstate, cOS, c31U, c32U, c40U)

	DEFINE 	mynumber INTEGER,
		cname 	LIKE customer.contact,
		cphone	LIKE customer.phone_no,
		cstate	LIKE address.state,
		cOS	CHAR(4),
		c31U	char(1),
		c32U	char(1),
		c40U	char(1),
		cn32	INTEGER,
		cn40	INTEGER,
		cn00	INTEGER,
		cn3240	INTEGER,
		nolines	INTEGER

	OUTPUT
		LEFT MARGIN 0
		RIGHT MARGIN 79
		TOP MARGIN 2
		BOTTOM MARGIN 2
		PAGE LENGTH 80
		REPORT TO "market.310"
#		REPORT TO PIPE "c10 | lp"

	ORDER BY mynumber, c32U DESCENDING, c40U DESCENDING

	FORMAT
	PAGE HEADER
		PRINT	COLUMN 1,  PAGENO USING "Page ####",
			50 SPACES,"Date: ", TODAY

		PRINT COLUMN 22,
		"Customers Who Purchased 3.1.0 as Their Initial OS"


		PRINT	COLUMN 6, "Customer Name and Phone",
			COLUMN 55, "Products"
			SKIP 1 LINE

	AFTER GROUP OF mynumber
#	ON EVERY ROW
		LET nolines = nolines + 1
		PRINT	COLUMN 1, cname CLIPPED,"(",mynumber USING "<<<<<<",")",
			COLUMN 49, cOS ,"\t","n/a","\t",c32U,"\t",c40U

		PRINT COLUMN 1, cphone CLIPPED,"(",cstate CLIPPED,")"
		SKIP 1 LINE

# customers with NO updates	
		IF c40U = "0" AND c32U = "0" THEN LET cn00 = cn00 + 1 END IF
# customers with 3.2 updates ONLY
		IF c32U = "1" AND c40U = "0" THEN LET cn32 = cn32 + 1 END IF
# customers with 4.0 updates ONLY
		IF c32U = "0" AND c40U = "1" THEN LET cn40 = cn40 + 1 END IF
# customers with BOTH updates
		IF c32U = "1" AND c40U = "1" THEN LET cn3240 = cn3240 + 1 END IF

	ON LAST ROW
		SKIP 1 LINE
		PRINT "# of customers with 3.1 as their initial OS is ", nolines USING "<<<<<"
		PRINT "# of customers with 3.2 updates ONLY is ",cn32 USING "<<<<<"
		PRINT "# of customers with 4.0 updates ONLY is ",cn40 USING "<<<<<"
		PRINT "# of customers with 3.2 and 4.0 updates is ",cn3240 USING "<<<<<"
		PRINT "# of customers with NO updates is ",cn00 USING "<<<<<"

	
END REPORT


# This report is for customers who bought 300 as their initial OS
REPORT cust_300 (mynumber, cname, cphone, cstate, cOS, c31U, c32U, c40U)

	DEFINE 	mynumber INTEGER,
		cname 	LIKE customer.contact,
		cphone	LIKE customer.phone_no,
		cstate	LIKE address.state,
		cOS	CHAR(4),
		c31U	char(1),
		c32U	char(1),
		c40U	char(1),
		cn32	INTEGER,
		cn40	INTEGER,
		cn00	INTEGER,
		cn3240	INTEGER,
		cn31	INTEGER,
		cn3132	INTEGER,
		cn3140	INTEGER,
		cnall	INTEGER,
		nolines INTEGER

	OUTPUT
		LEFT MARGIN 0
		RIGHT MARGIN 79
		TOP MARGIN 2
		BOTTOM MARGIN 2
		PAGE LENGTH 80
		REPORT TO "market.300"
#		REPORT TO PIPE "c10 | lp"

	ORDER BY mynumber, c32U DESCENDING, c40U DESCENDING

	FORMAT
	PAGE HEADER
		PRINT	COLUMN 1,  PAGENO USING "Page ####",
			50 SPACES,"Date: ", TODAY

		PRINT COLUMN 22,
		"Customers Who Purchased 3.0.0 as Their Initial OS"


		PRINT	COLUMN 6, "Customer Name and Phone",
			COLUMN 55, "Products"
			SKIP 1 LINE

	AFTER GROUP OF mynumber
#	ON EVERY ROW
		LET nolines = nolines + 1
		PRINT	COLUMN 1, cname CLIPPED,"(",mynumber USING "<<<<<<",")",
			COLUMN 49, cOS ,"\t",c31U,"\t",c32U,"\t",c40U

		PRINT COLUMN 1, cphone CLIPPED,"(",cstate CLIPPED,")"
		SKIP 1 LINE

# customers with NO updates	
		IF c40U = "0" AND c32U = "0" AND c31U = "0" THEN LET cn00 = cn00 + 1 END IF
# customers with 3.2 updates ONLY
		IF c32U = "1" AND c40U = "0" AND c31U = "0" THEN LET cn32 = cn32 + 1 END IF
# customers with 3.1 updates ONLY
		IF c31U = "1" AND c40U = "0" AND c32U = "0" THEN LET cn31 = cn31 + 1 END IF
# customers with 4.0 updates ONLY
		IF c31U = "0" AND c32U = "0" AND c40U = "1" THEN LET cn40 = cn40 + 1 END IF
# customers with 3.2 and 4.0 updates
		IF  c31U = "0" AND c32U = "1" AND c40U = "1" THEN LET cn3240 = cn3240 + 1 END IF
# customers with 3.1 and 4.0 updates
		IF c31U = "1" AND c32U = "0" AND c40U = "1" THEN LET cn3140 = cn3140 + 1 END IF
# customers with ALL updates
		IF c31U = "1" AND c32U = "1" AND c40U = "1" THEN LET cnall = cnall + 1 END IF
# customers with 3.1 and 3.2 updates ONLY
		IF c31U = "1" AND c32U = "1" AND c40U = "0" THEN LET cn3132 = cn3132 + 1 END IF

	ON LAST ROW
		SKIP 1 LINE
		PRINT "# of customers with 3.0 as their initial OS is ", nolines USING "<<<<<"
		PRINT "# of customers with 3.1 updates ONLY is ",cn31 USING "<<<<<"
		PRINT "# of customers with 3.2 updates ONLY is ",cn32 USING "<<<<<"
		PRINT "# of customers with 4.0 updates ONLY is ",cn40 USING "<<<<<"
		PRINT "# of customers with 3.1 and 3.2 updates ONLY is ",cn3132 USING "<<<<<"
		PRINT "# of customers with 3.1 and 4.0 updates ONLY is ",cn3140 USING "<<<<<"
		PRINT "# of customers with 3.2 and 4.0 updates ONLY is ",cn3240 USING "<<<<<"
		PRINT "# of customers with ALL updates is ",cnall USING "<<<<<"
		PRINT "# of customers with NO updates is ",cn00 USING "<<<<<"

	
END REPORT
