#
# Produce Special list for fearless leader
#
DATABASE mwc

#
# Produce mailing lists set up by mailcalc
#
GLOBALS
	DEFINE  a RECORD LIKE address.*
	DEFINE	c RECORD LIKE customer.*
	DEFINE	w RECORD LIKE workf.*
END GLOBALS

MAIN
	DECLARE curs CURSOR FOR
	 SELECT workf.*, address.*, customer.*
	   FROM workf, address, customer
	  WHERE workf.tbl = 5
	    AND workf.info_date >= "4/15/93"
	    AND workf.info_date <= "7/15/93"
	    AND address.cust_no = workf.cust_no
	    AND address.country IS NULL
	    AND	address.add_type <> "s"
	    AND	customer.cust_no = address.cust_no

	START REPORT mail_list

	FOREACH curs INTO w.*, a.*, c.*
		IF a.zipcode IS NULL THEN	# prevent control breaks
			LET a.zipcode = "-"
		END IF

		OUTPUT TO REPORT mail_list(w.*, c.*, a.*)
	END FOREACH

	FINISH REPORT mail_list

	CLOSE curs
END MAIN

REPORT mail_list(w, c, a)
	DEFINE  c RECORD LIKE customer.*
	DEFINE  a RECORD LIKE address.*
	DEFINE	w RECORD LIKE workf.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY a.state, a.cust_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 20 SPACES,
			"Phone sales report 4.0 Customers 4/15/93 - 7/15/93",
			20 SPACES, TODAY
		SKIP 2 LINES

	ON EVERY ROW
		IF w.info == 1 THEN
			PRINT	c.contact CLIPPED, " ",
				a.cust_no USING "<<<<<<",
				" I ", w.info_date
		ELSE
			PRINT	c.contact CLIPPED, " ",
				a.cust_no USING "<<<<<<",
				" R ", w.info_date
		END IF
		PRINT	c.phone_no CLIPPED, " ",
			a.city CLIPPED, " ", a.state
		SKIP 1 LINE
END REPORT
