#
# Call timenet and print invoices.
#
GLOBALS "globals0.4gl"

MAIN
	OPTIONS MESSAGE LINE 22,
		PROMPT LINE 21,
		DELETE KEY CONTROL-K,
		NEXT KEY CONTROL-N,
		PREVIOUS KEY CONTROL-P

	WHENEVER ERROR GOTO no_sws
	LOCK TABLE sws IN EXCLUSIVE MODE
	WHENEVER ERROR STOP

	OPEN FORM big_form FROM "mainline"
	DISPLAY FORM big_form

	CONSTRUCT BY NAME query1 ON
		invoice.invoice_no, back_flag, invoice_date, ship_date

	MESSAGE ""	# To prevent spooler message from eating screen.

	IF query1 CLIPPED == " 1=1" THEN
		MESSAGE "Posting previous transactions"

		GOTO reread
	END IF

	MESSAGE "Finding ", query1 CLIPPED

	RUN "cat /dev/null > LOG.DAT"

	LET s1 = "SELECT * FROM invoice ",
		 " WHERE ", query1 CLIPPED,
		 "   AND tym_flag IN (1, 2, 5, 8)",
		 "   AND (back_flag IS NULL OR back_flag = 2)",
		 "   AND itotal > 0.0",
		 "   AND ship_date IS NULL"

	PREPARE s_1 FROM s1

	DECLARE t_curs CURSOR FOR s_1

	LET i_no = 0

	START REPORT y_rep

	FOREACH t_curs INTO p_invoice.*
		CASE 
		WHEN p_invoice.tym_flag = 2
			LET p_invoice.tym_flag = 1
		WHEN p_invoice.tym_flag = 8
			LET p_invoice.tym_flag = 5
		END CASE

		LET i_no = i_no + 1

		OUTPUT TO REPORT y_rep(p_invoice.*)
	END FOREACH

	CLOSE t_curs

	FINISH REPORT y_rep

	IF i_no > 0 THEN
		RUN "tmn -v"

		RUN "date >> TRAN.LOG"
		RUN "cat TBI.DAT >> TRAN.LOG"

LABEL reread:
		LET i_no = -1

		CALL tyme_in()

		RUN "ph LOG.DAT"

		IF i_no != 0 THEN # sb set to 0 by batch entry
			UNLOCK TABLE sws
			PROMPT	"Last acct ", i_no, 
				" incomplete session enter to continue"
				FOR answer
			EXIT PROGRAM
		END IF

		DISPLAY FORM big_form
	END IF
	
	IF query1 CLIPPED == " 1=1" THEN
		UNLOCK TABLE sws

		EXIT PROGRAM
	END IF

	LET s1 = "SELECT * FROM invoice, inv_line, product",
		 " WHERE ", query1 CLIPPED,
		 "   AND inv_line.invoice_no = invoice.invoice_no",
		 "   AND product.prod_no = inv_line.prod_no"

	PREPARE s_2 FROM s1

	DECLARE q_curs CURSOR FOR s_2

	MESSAGE ""	# To prevent spooler message from eating screen.

	START REPORT inv_report

	LET answer = NULL

	FOREACH q_curs INTO p_invoice.*, p_line.*, p_product.*
		OUTPUT TO REPORT inv_report(p_invoice.*, p_line.*, p_product.*)
	END FOREACH

	FINISH REPORT inv_report

	RUN "format < test.data | lp"

	UNLOCK TABLE sws

	EXIT PROGRAM

LABEL no_sws:
	PROMPT "Exclusive function in use" FOR answer
END MAIN

#
# Create output for timenet
#
REPORT y_rep(i)
	DEFINE i RECORD LIKE invoice.*
	OUTPUT
		REPORT TO PIPE "unblank > IFT.DAT"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	FORMAT
	ON EVERY ROW
		CASE
		WHEN i.tym_flag = 1
			PRINT	"I"
			PRINT	i.invoice_no USING "<<<<<<<"
			PRINT	i.card_no USING "<<<<<<<<<<<<<<<<<"
			PRINT	i.exp_date CLIPPED
			PRINT	i.itotal USING "<<<<<<<<.##"

			UPDATE invoice
			   SET tym_flag = 2,
			       frozen = "f"
			 WHERE invoice_no = i.invoice_no

		WHEN i.tym_flag = 5
			PRINT	"V"
			PRINT	i.invoice_no USING "<<<<<<<"
			PRINT	i.card_no USING "<<<<<<<<<<<<<<<<<"
			PRINT	i.exp_date CLIPPED
			PRINT	i.itotal USING "<<<<<<<<.##"
			PRINT	i.ref_no USING "<<<<<<<<<<<"

			UPDATE invoice
			   SET tym_flag = 8
			 WHERE invoice_no = i.invoice_no
		END CASE

	ON LAST ROW
		PRINT "B"	# request batch number
		PRINT "#####"
END REPORT

#
# Btymenet report in
#
FUNCTION tyme_in()
	DEFINE eofsw SMALLINT
	DEFINE tran_type CHAR(1)
	DEFINE inf_no CHAR(6)
	DEFINE cupt_code CHAR(6)
	DEFINE reference CHAR(8)
	DEFINE amount CHAR(12)
	DEFINE mess CHAR(90)

	SELECT *
	  INTO p_batch.*
	  FROM batch
	 WHERE batch_date = TODAY
	   AND batch_no = DAY(TODAY)

	IF status = NOTFOUND THEN
		LET p_batch.batch_no = DAY(TODAY)
		LET p_batch.batch_date = TODAY

		INSERT INTO batch VALUES (
			0, p_batch.batch_no, p_batch.batch_date
		)
		LET p_batch.batch_ix = SQLCA.SQLERRD[2]
	END IF

	START REPORT tym_rep
 
	WHILE 1 = 1
		CALL readfile("TBI.DAT")
			RETURNING eofsw, tran_type, inf_no, cupt_code,
				  reference, amount, mess
		IF eofsw == 0 THEN
			EXIT WHILE
		END IF

		OUTPUT TO REPORT
			tym_rep(tran_type, inf_no, cupt_code, 
				reference, amount, mess)
	END WHILE

	FINISH REPORT tym_rep
END FUNCTION

REPORT tym_rep(tran_type, inf_no, cupt_code, reference, amount, mess)
DEFINE tran_type CHAR(1)
DEFINE inf_no CHAR(6)
DEFINE cupt_code CHAR(6)
DEFINE reference CHAR(8)
DEFINE amount CHAR(12)
DEFINE mess CHAR(90)

	DEFINE b_no, ct SMALLINT

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 10 SPACES,
			"Tymenet transaction report batch",
			p_batch.batch_ix,
			10 SPACES, TODAY, " ", TIME
		PRINT	query1
		SKIP 1 LINE

	ON EVERY ROW
		LET i_no = inf_no

		CASE
		WHEN  tran_type = 'B'
			PRINT	"B ", i_no
			LET i_no = 0
			SKIP 1 LINE

		WHEN  tran_type = 'v'
			SKIP 1 LINE

			SELECT *
			  INTO p_invoice.*
			  FROM invoice
			 WHERE invoice_no = i_no

			CASE
			WHEN status = NOTFOUND
				PRINT	"v ", i_no, " NOT FOUND"
			WHEN p_invoice.tym_flag != 8
				PRINT	"v ", i_no, " tym flag", 
					p_invoice.tym_flag
			OTHERWISE
				UPDATE  invoice
				   SET	tym_flag = 7
				 WHERE  invoice_no = p_invoice.invoice_no

				PRINT	"v ",
					p_invoice.invoice_no,
					p_invoice.itotal
			END CASE
			PRINT	 mess

		WHEN  tran_type = 'i'
			SKIP 1 LINE

			SELECT *
			  INTO p_invoice.*
			  FROM invoice
			 WHERE invoice_no = i_no

			CASE
			WHEN status = NOTFOUND
				PRINT	"i ", i_no, " NOT FOUND"

			WHEN p_invoice.tym_flag != 2
				PRINT	"i ", i_no, " tym flag", 
					p_invoice.tym_flag

			WHEN reference != "0"  # Duplicate
				SELECT COUNT(*)
				  INTO ct
				  FROM invoice
				 WHERE batch_ix = p_batch.batch_ix
				   AND card_no = p_invoice.card_no
				   AND itotal = p_invoice.itotal

				IF ct IS NULL OR ct = 0 THEN
					UPDATE  invoice
					   SET  cap_no = cupt_code,
						ref_no = reference,
						tym_flag = 3,
						batch_ix = p_batch.batch_ix
					 WHERE  invoice_no =
					 	 p_invoice.invoice_no

					PRINT	"I ", p_invoice.invoice_no, " ",
						cupt_code, " ",
						reference,
						p_invoice.itotal
				ELSE
					PRINT	"i ", i_no, " DUPLICATE"
				END IF 

			OTHERWISE
				UPDATE  invoice
				   SET	tym_flag = 4,
					frozen = NULL
				 WHERE  invoice_no = p_invoice.invoice_no
				PRINT	"i ", p_invoice.invoice_no
			END CASE
			PRINT	 mess

		WHEN  tran_type = 'V'
			#
			# Voided transaction.
			# make 100% discount
			# change inv_line to no product shipped
			# comment is voided
			#
			SELECT *
			  INTO p_invoice.*
			  FROM invoice
			 WHERE invoice_no = i_no

			UPDATE  invoice
			   SET	tym_flag = 6,
				discount = 0,
				ship_amt = 0,
				taxes = 0,
				itotal = 0,
				subtotal = 0,
				icomments = "VOIDED"
			 WHERE  invoice_no = p_invoice.invoice_no

			UPDATE	inv_line
			   SET  prod_no = 7
			 WHERE	invoice_no = p_invoice.invoice_no

			PRINT	"V ", p_invoice.invoice_no, " ",
				p_invoice.cap_no,
				p_invoice.ref_no,
				p_invoice.itotal
		WHEN tran_type = 'I'
			SELECT *
			  INTO p_invoice.*
			  FROM invoice
			 WHERE invoice_no = i_no

			CASE
			WHEN status = NOTFOUND
				PRINT	"I ", i_no, " NOT FOUND"

			WHEN p_invoice.tym_flag != 2
				PRINT	"I ", i_no, " tym flag", 
					p_invoice.tym_flag

			WHEN p_invoice.itotal != amount
				PRINT	"I ", i_no, 
					" Amount mismatch? Invoice says ",
					p_invoice.itotal,
					" transaction says ", amount

			OTHERWISE
				UPDATE  invoice
				   SET  cap_no = cupt_code,
					ref_no = reference,
					tym_flag = 3,
					batch_ix = p_batch.batch_ix
				 WHERE  invoice_no = p_invoice.invoice_no

				PRINT	"I ", p_invoice.invoice_no, " ",
					cupt_code,
					reference,
					p_invoice.itotal
			END CASE
		OTHERWISE
			PRINT
			"Unknown transaction type NOTIFY PROGRAMMING! ",
				tran_type
		END CASE
END REPORT

#
# Invoice list. Reformated by format.c
#
REPORT inv_report (i, l, p)
	DEFINE	i RECORD LIKE invoice.*,
		l RECORD LIKE inv_line.*,
		p RECORD LIKE product.*
	DEFINE 	pname CHAR(60)

	OUTPUT
#		REPORT TO PIPE "format | lp"
		REPORT TO "test.data"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY i.invoice_no, l.prod_no

	FORMAT
	BEFORE GROUP OF i.invoice_no
		SELECT *
		  INTO p_cust.*
		  FROM customer
		 WHERE cust_no = i.cust_no

		PRINT	p_cust.contact CLIPPED

		SELECT *
		  INTO s_address.*
		  FROM address
		 WHERE cust_no = i.cust_no
		   AND add_type <> "b"

		PRINT	s_address.line1 CLIPPED
		PRINT	s_address.line2 CLIPPED
		PRINT	s_address.line3 CLIPPED
		CALL addline(s_address.*) RETURNING s1
		PRINT	s1 CLIPPED
		PRINT	s_address.country CLIPPED

		IF s_address.add_type = "s" THEN
			SELECT *
			  INTO b_address.*
			  FROM address
			 WHERE cust_no = i.cust_no
			   AND add_type <> "s"

			PRINT	b_address.line1 CLIPPED
			PRINT	b_address.line2 CLIPPED
			PRINT	b_address.line3 CLIPPED
			CALL addline(b_address.*) RETURNING s1
			PRINT	s1 CLIPPED
			PRINT	s_address.country CLIPPED
		ELSE
			PRINT answer CLIPPED # SKIP is buggy
			PRINT answer CLIPPED 
			PRINT answer CLIPPED 
			PRINT answer CLIPPED 
			PRINT answer CLIPPED 
		END IF

		SELECT *
		  INTO p_ship.*
		  FROM shippers
		 WHERE ship_no = i.ship_no

		SELECT *
		  INTO p_term.*
		  FROM terms
		 WHERE terms.term_no = i.term_no

		PRINT	p_cust.phone_no CLIPPED
		PRINT	i.invoice_date
		PRINT	i.invoice_no USING "<<<<<<<<<"
		PRINT	i.cust_no    USING "<<<<<<<<<"
		PRINT	p_term.term_name CLIPPED

		IF i.card_no IS NULL THEN
			PRINT answer CLIPPED 
			PRINT answer CLIPPED 
			PRINT answer CLIPPED 
		ELSE
			PRINT	i.card_no USING "<<<<<<<<<<<<<<<<<"
			PRINT	i.exp_date CLIPPED
			PRINT	i.ref_no USING "<<<<<<<<<<<"
		END IF

		CASE
		WHEN i.back_flag == 1
			PRINT	"9"
		WHEN i.tym_flag IS NULL
			PRINT	"0"
		OTHERWISE
			PRINT	i.tym_flag USING "&"
		END CASE

		PRINT	p_ship.ship_name CLIPPED
		PRINT	i.icomments CLIPPED

		PRINT	i.subtotal
		IF i.taxes > 0 THEN
			PRINT	i.taxes
		ELSE
			PRINT answer CLIPPED 
		END IF

		IF i.term_no = 11 AND
		   i.ship_amt > 10.00 THEN
			LET i.ship_amt = i.ship_amt - 10.00
			PRINT	i.ship_amt
			PRINT	" $10.00"
		ELSE
			IF i.ship_amt != 0.0 THEN
				PRINT	i.ship_amt
			ELSE
				PRINT answer CLIPPED 
			END IF
			PRINT answer CLIPPED 
		END IF

		IF i.discount = 0 THEN
			PRINT answer CLIPPED 
		ELSE
			PRINT i.discount
		END IF

		PRINT	i.itotal
		PRINT	i.user_id

	ON EVERY ROW
		LET pname = p.prod_name CLIPPED, " ",
			    p.comment1 CLIPPED
		LET rtot = p.price * l.quantity
		PRINT	l.quantity USING "####"
		PRINT	pname CLIPPED
		PRINT	p.price
		PRINT	rtot

	AFTER GROUP OF i.invoice_no
		PRINT 	"***"
	ON LAST ROW
		PRINT 	"***"
END REPORT
