GLOBALS "globals0.4gl"

DEFINE 	cur_date 	DATE,
	record_no	INTEGER

#
# Print UPS report
#
FUNCTION ups_report()
	DEFINE 	tmp_num	SMALLINT
	DEFINE 	ch_commer CHAR(5)
	DEFINE	my_count	SMALLINT

	CALL msgs("")

	SELECT MAX(rec_number) INTO record_no FROM RecNumber
	
	# Last report has number less than current on 1
	IF tbl <> "o" THEN
		LET record_no = record_no - 1
	END IF

	LET my_count = 0
	LET tmp_num = 0
	LET cur_date = TODAY

	DECLARE rep_curs CURSOR FOR SELECT * FROM pickup_line
		WHERE closed = tbl AND ship_loc = shiploc
	START REPORT ups_list

	FOREACH rep_curs INTO p_pickup.*

		LET my_count = my_count + 1
		MESSAGE "Total ", my_count

		IF p_pickup.cod_amt > 0 AND p_pickup.cll IS NULL THEN
		# Changed 3.30 to 4.00 2-20-92
		# Changed from 4.00 to 4.50 2-11-93
			LET p_pickup.cod_chrg = 4.50
		END IF
		
		LET tmp_num = tmp_num + 1

		IF p_pickup.zone < 12 THEN
			IF p_pickup.commer = 1 THEN
				LET ch_commer = "com"
			ELSE
				LET ch_commer = "res"
			END IF
		ELSE
			LET ch_commer = "n/a"
		END IF

		OUTPUT TO REPORT ups_list(p_pickup.invoice_no, 
				p_pickup.contact, 	p_pickup.address,
				p_pickup.city,		p_pickup.state,
				p_pickup.country,	p_pickup.zipcode,
				p_pickup.weight,	p_pickup.zone,
				p_pickup.dec_value,	p_pickup.charge,
				p_pickup.cod_amt,	p_pickup.cod_chrg,
				p_pickup.aod,		p_pickup.cll,
				ch_commer,		tmp_num)
	END FOREACH

	FINISH REPORT ups_list

	CLOSE rep_curs

	CALL sum_spec()
	CALL msgs("Done")

END FUNCTION

#
# Calculate summary specification and print summary report
#
FUNCTION sum_spec()
	DEFINE 	i, k, n_aod, n_cod,
		n_cll, n_dcharge, mdc,
		rg_pieces, rg_weight, 
		cg_pieces, cg_weight, 
		ta_pieces, ta_weight,
		lbpc, lrpc,		# letter blue and red pieces
		tc_pieces, tc_weight,
		ti_pieces, ti_weight	SMALLINT,

		rg_charges, cg_charges, ta_charges,
		lbch, lrch,		# letter blue and red charges
		tc_charges, ti_charges,
		aod, cod, cll, dcharge		MONEY

	# Assign the null to all indexes and accumulators
	LET i = 0
	LET n_cod = 0
	LET n_aod = 0
	LET n_cll = 0
	LET n_dcharge = 0
	LET mdc	= 0
	LET aod = 0.45		# UPS aod charges
	LET cod = 4.50		# UPS cod charges
	LET dcharge = 0.30  	# UPS charges for declare value (0.30 per $100)
	LET cll = 2.00		# UPS Call tag charges

	LET lbpc = 0
	LET lrpc = 0
	LET lbch = 0
	LET lrch = 0
	LET rg_pieces = 0	
	LET rg_weight = 0
	LET rg_charges = 0

	LET cg_pieces = 0	
	LET cg_weight = 0
	LET cg_charges = 0

	LET ta_pieces = 0
	LET ta_weight = 0
	LET ta_charges = 0

	LET tc_weight = 0
	LET tc_pieces = 0
	LET tc_charges = 0

	LET ti_weight = 0
	LET ti_pieces = 0
	LET ti_charges = 0

	FOR i = 1 TO 8			# zone number for the USA gorund < 8
		LET rgr_pieces[i] = 0
		LET rgr_weight[i] = 0
		LET rgr_charges[i] = 0
		LET cgr_pieces[i] = 0
		LET cgr_weight[i] = 0
		LET cgr_charges[i] = 0
	END FOR

	FOR i = 1 TO 8			# the USA air has 8 different zone
		LET air_pieces[i] = 0
		LET air_weight[i] = 0
		LET air_charges[i] = 0
	END FOR

	FOR i = 1 TO 5			# Canada has 5 different zones
		LET can_pieces[i] = 0
		LET can_weight[i] = 0
		LET can_charges[i] = 0
	END FOR

	FOR i = 1 TO 8			# International has 8 different zones
		LET int_pieces[i] = 0
		LET int_weight[i] = 0
		LET int_charges[i] = 0
	END FOR 

	DECLARE sum_curs CURSOR FOR SELECT * FROM pickup_line
		WHERE closed = tbl AND ship_loc = shiploc
	FOREACH sum_curs INTO p_pickup.*
		IF p_pickup.cod_amt > 0 AND p_pickup.cll IS NULL THEN
			LET n_cod = n_cod + 1
		END IF

		IF p_pickup.dec_value > 100.00 THEN
			LET n_dcharge = n_dcharge + 1 
			LET mdc = mdc +	(p_pickup.dec_value - 0.01) / 100
		END IF

		IF p_pickup.aod = "x" THEN
			LET n_aod = n_aod + 1
		END IF
		
		IF p_pickup.cll = "x" THEN
			LET n_cll = n_cll + 1
		END IF

		IF p_pickup.zone < 9 THEN	# USA ground (zone < 9)
			LET i = p_pickup.zone
			IF p_pickup.commer = 1 THEN
				LET cg_pieces = cg_pieces + p_pickup.pack_no
				LET cg_weight = cg_weight + p_pickup.weight
				LET cg_charges = cg_charges + p_pickup.charge
				LET cgr_pieces[i] = cgr_pieces[i] + p_pickup.pack_no
				LET cgr_weight[i] = cgr_weight[i] + p_pickup.weight
				LET cgr_charges[i] = cgr_charges[i] + p_pickup.charge
			ELSE
				LET rg_pieces = rg_pieces + p_pickup.pack_no
				LET rg_weight = rg_weight + p_pickup.weight
				LET rg_charges = rg_charges + p_pickup.charge
				LET rgr_pieces[i] = rgr_pieces[i] + p_pickup.pack_no
				LET rgr_weight[i] = rgr_weight[i] + p_pickup.weight
				LET rgr_charges[i] = rgr_charges[i] + p_pickup.charge
			END IF
			CONTINUE FOREACH
		END IF

		# USA air zone numbers > 10 & < 27
		IF p_pickup.zone > 10 AND p_pickup.zone < 27 THEN

			LET ta_pieces = ta_pieces + p_pickup.pack_no
			LET ta_weight = ta_weight + p_pickup.weight
			LET ta_charges = ta_charges + p_pickup.charge
#			IF p_pickup.weight = 0 THEN 	# if letters
#				IF p_pickup.zone < 20	THEN # blue zone < 20 
#					LET lbpc = lbpc + p_pickup.pack_no
#					LET lbch = lbch + p_pickup.charge
#				ELSE			# red zone > 20
#					LET lrpc = lrpc + p_pickup.pack_no
#					LET lrch = lrch + p_pickup.charge
#				END IF
#
#				CONTINUE FOREACH
#			END IF

			# Magic numbers for USA Air
			CASE
			WHEN p_pickup.zone = 12
				LET k = 1

			WHEN p_pickup.zone = 14
				LET k = 2

			WHEN p_pickup.zone = 15
				LET k = 3
	
			WHEN p_pickup.zone = 16
				LET k = 4

			WHEN p_pickup.zone = 22
				LET k = 5

			WHEN p_pickup.zone = 24
				LET k = 6
	
			WHEN p_pickup.zone = 25
				LET k = 7

			WHEN p_pickup.zone = 26
				LET k = 8
			END CASE

			# Calculate pieces, weight, & charges for the USA
			LET air_pieces[k] = air_pieces[k] + p_pickup.pack_no
			LET air_charges[k] = air_charges[k] + p_pickup.charge
			LET air_weight[k] = air_weight[k] + p_pickup.weight

			CONTINUE FOREACH
		END IF

		# Magic numbers for CANADA
		CASE
		WHEN p_pickup.zone = 51
			LET k = 1

		WHEN p_pickup.zone = 52
			LET k = 2

		WHEN p_pickup.zone = 53
			LET k = 3

		WHEN p_pickup.zone = 87
			LET k = 4

		WHEN p_pickup.zone = 88
			LET k = 5

		WHEN p_pickup.zone = 89
			LET k = 6
		END CASE

		IF p_pickup.zone < 90 THEN	# CANADA zone number < 90
			LET can_pieces[k] = can_pieces[k] + p_pickup.pack_no
			LET can_weight[k] = can_weight[k] + p_pickup.weight
			LET can_charges[k] = can_charges[k] + p_pickup.charge
			LET tc_pieces = tc_pieces + p_pickup.pack_no
			LET tc_weight = tc_weight + p_pickup.weight
			LET tc_charges = tc_charges + p_pickup.charge
			CONTINUE FOREACH
		END IF

		# Magic international UPS numbers
		CASE
		WHEN p_pickup.zone = 92
			LET k = 1

		WHEN p_pickup.zone = 93
			LET k = 2

		WHEN p_pickup.zone = 94
			LET k = 3

		WHEN p_pickup.zone = 95
			LET k = 4

		WHEN p_pickup.zone = 96
			LET k = 5

		WHEN p_pickup.zone = 97
			LET k = 6

		WHEN p_pickup.zone = 98
			LET k = 7

		WHEN p_pickup.zone = 99
			LET k = 8
		END CASE

		# International summary
		LET int_pieces[k] = int_pieces[k] + p_pickup.pack_no
		LET int_weight[k] = int_weight[k] + p_pickup.weight
		LET int_charges[k] = int_charges[k] + p_pickup.charge
		LET ti_pieces = ti_pieces + p_pickup.pack_no
		LET ti_weight = ti_weight + p_pickup.weight
		LET ti_charges = ti_charges + p_pickup.charge
	END FOREACH

	CLOSE sum_curs

	LET cod = n_cod * cod
	LET aod = n_aod * aod
	LET cll = n_cll * cll
	LET dcharge = mdc * dcharge

	START REPORT ups_sum

	OUTPUT TO REPORT 
		ups_sum(cg_pieces, cg_weight, cg_charges, 
			rg_pieces, rg_weight, rg_charges, 
			lbpc, lbch, lrpc, lrch,
			ta_pieces, ta_weight, ta_charges, 
			tc_pieces, tc_weight, tc_charges, 
			ti_pieces, ti_weight, ti_charges, 
			n_cod, n_aod, n_cll, n_dcharge,
			cod, aod, cll, dcharge)

	FINISH REPORT ups_sum
END FUNCTION

#
# Print summary
#
REPORT ups_sum(	cg_pieces, cg_weight, cg_charges, 
		rg_pieces, rg_weight, rg_charges, 
		lbpc, lbch, lrpc, lrch,
		ta_pieces, ta_weight, ta_charges, 
		tc_pieces, tc_weight, tc_charges, 
		ti_pieces, ti_weight, ti_charges, 
		n_cod, n_aod, n_cll, n_dcharge,
		cod, aod, cll, dcharge)

	DEFINE 	rg_pieces, rg_weight, 
		cg_pieces, cg_weight, 
		lbpc, lrpc,
		ta_pieces, ta_weight,
		tc_pieces, tc_weight, 
		ti_pieces, ti_weight, 
		n_cod, n_aod, n_cll, n_dcharge	SMALLINT

	DEFINE	rg_charges, cg_charges, ta_charges,
		lbch, lrch,
		tc_charges, ti_charges, 
		cod, aod, cll, dcharge		MONEY

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		TOP MARGIN 0
		BOTTOM MARGIN 0
		LEFT MARGIN 5
		PAGE LENGTH 80

	FORMAT

	PAGE HEADER
		IF shiploc = 0 THEN
			PRINT "Mark Williams Co", COLUMN 60, "IL 612-750"
		ELSE
			PRINT "Mark Williams Co", COLUMN 60, "IL 581-7E8"
		END IF		
		PRINT "60 Revere Drive",  COLUMN 50,"UPS Pickup Record Number"
		PRINT "Northbrook, IL 60062", COLUMN 55, 
			record_no USING " ### ### ###"
		SKIP 2 LINES	
		PRINT "Date Shipped  ", cur_date USING "mmm dd, yyyy" 
		SKIP 5 LINES
		PRINT COLUMN 5, "Common Carrier Residential", 
			COLUMN 45, "Common Carrier Commercial",
			COLUMN 95, "Air"
		PRINT
		PRINT "Zone   Pieces   Weight   Charges        Zone   ",
		      	"Pieces   Weight   Charges",
			COLUMN 84, "Zone   Pieces   Weight   Charges"
		PRINT
#		PRINT COLUMN 84, "LtrR",
#			lrpc USING "      ##&       0  ", 
#			lrch USING " $###&.##"#
#		PRINT COLUMN 84, "LtrB",
#			lbpc USING "      ##&       0  ", 
#			lbch USING " $###&.##"
		PRINT " 2     ", 
		      rgr_pieces[2]  USING "   ##&  ", 
		      rgr_weight[2]  USING "   ##&  ", 
		      rgr_charges[2]  USING  " $###&.##         2     ", 
		      cgr_pieces[2] USING "   ##&  ", 
		      cgr_weight[2] USING "   ##&  ",
		      cgr_charges[2] USING  " $###&.##            12     ",
		      air_pieces[1] USING "  ##&  ", 
		      air_weight[1] USING "   ##&  ",
		      air_charges[1] USING  " $###&.## "
		PRINT " 3     ", 
		      rgr_pieces[3]  USING "   ##&  ", 
		      rgr_weight[3]  USING "   ##&  ", 
		      rgr_charges[3]  USING  " $###&.##         3     ", 
		      cgr_pieces[3] USING "   ##&  ", 
		      cgr_weight[3] USING "   ##&  ",
		      cgr_charges[3] USING  " $###&.##            14     ",
		      air_pieces[2] USING "  ##&  ", 
		      air_weight[2] USING "   ##&  ",
		      air_charges[2] USING  " $###&.## "
		PRINT " 4     ", 
		      rgr_pieces[4]  USING "   ##&  ", 
		      rgr_weight[4]  USING "   ##&  ",
		      rgr_charges[4]  USING  " $###&.##         4     ", 
		      cgr_pieces[4] USING "   ##&  ", 
		      cgr_weight[4] USING "   ##&  ", 
		      cgr_charges[4] USING  " $###&.##            15     ",
		      air_pieces[3] USING "  ##&  ", 
		      air_weight[3] USING "   ##&  ",
		      air_charges[3] USING  " $###&.## "
		PRINT " 5     ", 
		      rgr_pieces[5]  USING "   ##&  ", 
		      rgr_weight[5]  USING "   ##&  ", 
		      rgr_charges[5]  USING  " $###&.##         5     ", 
		      cgr_pieces[5] USING "   ##&  ", 
		      cgr_weight[5] USING "   ##&  ", 
		      cgr_charges[5] USING  " $###&.##            16     ",
		      air_pieces[4] USING "  ##&  ", 
		      air_weight[4] USING "   ##&  ",
		      air_charges[4] USING  " $###&.## "
		PRINT " 6     ", 
		      rgr_pieces[6]  USING "   ##&  ", 
		      rgr_weight[6]  USING "   ##&  ",
		      rgr_charges[6]  USING  " $###&.##         6     ", 
		      cgr_pieces[6] USING "   ##&  ", 
  		      cgr_weight[6] USING "   ##&  ", 
		      cgr_charges[6] USING  " $###&.##            22     ",
		      air_pieces[5] USING "  ##&  ", 
		      air_weight[5] USING "   ##&  ",
		      air_charges[5] USING  " $###&.## "
		PRINT " 7     ", 
		      rgr_pieces[7]  USING "   ##&  ", 
		      rgr_weight[7]  USING "   ##&  ",
		      rgr_charges[7]  USING  " $###&.##         7     ", 
		      cgr_pieces[7] USING "   ##&  ", 
		      cgr_weight[7] USING "   ##&  ", 
		      cgr_charges[7] USING  " $###&.##            24     ",
		      air_pieces[6] USING "  ##&  ", 
		      air_weight[6] USING "   ##&  ",
		      air_charges[6] USING  " $###&.## "
		PRINT " 8     ", 
		      rgr_pieces[8]  USING "   ##&  ", 
		      rgr_weight[8]  USING "   ##&  ", 
		      rgr_charges[8]  USING  " $###&.##         8     ", 
		      cgr_pieces[8] USING "   ##&  ", 
		      cgr_weight[8] USING "   ##&  ", 
		      cgr_charges[8] USING  " $###&.##            25     ",
		      air_pieces[7] USING "  ##&  ", 
		      air_weight[7] USING "   ##&  ",
		      air_charges[7] USING  " $###&.## "
		PRINT COLUMN 85, "26     ",
		      air_pieces[8] USING "  ##&  ", 
		      air_weight[8] USING "   ##&  ",
		      air_charges[8] USING  " $###&.## "
		PRINT "TOTAL  ______   ______   _______               ",
		      "______   ______   _______                  ",
		      "______   ______   _______"
		PRINT "       ", 
		      rg_pieces USING "   ##&  ", 
		      rg_weight USING "  ###&  ", 
		      rg_charges USING       " $###&.##               ", 
		      cg_pieces USING "   ##&  ", 
		      cg_weight USING "   ##&  ", 
		      cg_charges USING       " $###&.##                  ",
		      ta_pieces USING "   ##&  ", 
		      ta_weight USING "   ##&  ", 
		      ta_charges USING       " $###&.##"
		SKIP 4 LINES
		PRINT COLUMN 10, "Canada", COLUMN 60, "Inernational",
			COLUMN 90, "Ground Track com/res"
		PRINT
		PRINT "Zone   Pieces   Weight   Charges            Zone   ",
		      "Pieces   Weight   Charges"
		PRINT
		PRINT " 51    ", can_pieces[1]  USING "   ##&  ", 
		      can_weight[1]  USING "   ##&  ",
		      can_charges[1]  USING  " $###&.##             92    ", 
		      int_pieces[1] USING "   ##&  ", 
		      int_weight[1] USING "   ##&  ", 
		      int_charges[1] USING  " $###&.## ",
		      COLUMN 85, "-------- Not Used --------"
		PRINT " 52    ", can_pieces[2]  USING "   ##&  ", 
		      can_weight[2]  USING "   ##&  ",
		      can_charges[2]  USING  " $###&.##             93    ", 
		      int_pieces[2] USING "   ##&  ", 
		      int_weight[2] USING "   ##&  ", 
		      int_charges[2] USING  " $###&.## "
		PRINT " 53    ", can_pieces[3]  USING "   ##&  ", 
		      can_weight[3]  USING "   ##&  ",
		      can_charges[3]  USING  " $###&.##             94    ", 
		      int_pieces[3] USING "   ##&  ", 
		      int_weight[3] USING "   ##&  ", 
		      int_charges[3] USING  " $###&.## "
		PRINT " 87    ", can_pieces[4]  USING "   ##&  ", 
		      can_weight[4]  USING "   ##&  ",
		      can_charges[4]  USING  " $###&.##             95    ", 
		      int_pieces[4] USING "   ##&  ", 
		      int_weight[4] USING "   ##&  ", 
		      int_charges[4] USING  " $###&.## "
		PRINT " 88    ", can_pieces[5]  USING "   ##&  ", 
		      can_weight[5]  USING "   ##&  ",
		      can_charges[5]  USING  " $###&.##             96    ", 
		      int_pieces[5] USING "   ##&  ", 
		      int_weight[5] USING "   ##&  ", 
		      int_charges[5] USING  " $###&.## "
		PRINT " 89    ", can_pieces[6]  USING "   ##&  ", 
		      can_weight[6]  USING "   ##&  ",
		      can_charges[6]  USING  " $###&.##             97    ", 
		      int_pieces[6] USING "   ##&  ", 
		      int_weight[6] USING "   ##&  ", 
		      int_charges[6] USING  " $###&.## ",
		      COLUMN 90, "3 Day Select"
		PRINT	COLUMN 45, " 98    ", int_pieces[6] USING "   ##&  ", 
		      int_weight[7] USING "   ##&  ", 
		      int_charges[7] USING  " $###&.## "
		PRINT	COLUMN 45, " 99    ", int_pieces[6] USING "   ##&  ", 
		      int_weight[8] USING "   ##&  ", 
		      int_charges[8] USING  " $###&.## "
		PRINT "TOTAL  ______   ______   _______                   ",
		      "______   ______   _______",
		      COLUMN 85, "-------- Not used --------"
		PRINT "       ", tc_pieces USING "   ##&  ", 
		      tc_weight USING "   ##&  ", 
		      tc_charges USING " $###&.##                   ", 
		      ti_pieces USING "   ##&  ", ti_weight USING "   ##&  ", 
		      ti_charges USING       " $###&.##"
		SKIP 4 LINES
		PRINT COLUMN 30, "NUMBER OF AOD'S ", n_aod USING "##&   ", 
		      "AOD CHARGES  ", aod USING "$###&.##"
		PRINT COLUMN 30, "NUMBER OF COD'S ", n_cod USING "##&   ", 
		      "COD CHARGES  ", cod USING "$###&.##"
		PRINT COLUMN 30, "Call's Tags     ", n_cll USING "##&   ",
		      "Call Charges ", cll USING "$###&.##"
		PRINT COLUMN 30, "Declare Values  ", n_dcharge USING "##&   ",
		      "D V Charges  ", dcharge USING "$###&.##"
		PRINT
		PRINT COLUMN 40, "TOTAL UPS REVENUE ", aod + cod + dcharge
		      + cll + rg_charges + cg_charges + ta_charges
		      + tc_charges + ti_charges  USING "$####&.##"

		SKIP 2 LINES
		PRINT "------------------------------------------------------",
		"--------------------------------------------------------------"
		SKIP 2 LINES
		PRINT COLUMN 5, "Total UPS Ground", 
			COLUMN 45, "Total UPS (without Ground)", 
			COLUMN 90, "Total UPS (with Ground)"
		PRINT
		PRINT "Pieces   Weight   Charges ", 
		      	COLUMN 45, "Pieces   Weight   Charges",
			COLUMN 90, "Pieces   Weight   Charges"
		PRINT
		PRINT rg_pieces + cg_pieces USING "   ##&  ", 
			rg_weight + cg_weight USING "  ###&  ", 
		      	rg_charges + cg_charges USING " $###&.##", 
			COLUMN 45,
		      ta_pieces + tc_pieces + ti_pieces USING "   ##&  ", 
		      ta_weight + tc_weight + ti_weight USING "  ###&  ", 
		      ta_charges + tc_charges + ti_charges USING " $###&.##",
			COLUMN 90,
		      ta_pieces + tc_pieces + ti_pieces + rg_pieces + cg_pieces
			 USING "   ##&  ", 
		      ta_weight + tc_weight + ti_weight + rg_weight + cg_weight
			 USING "  ###&  ", 
		      ta_charges + tc_charges + ti_charges + rg_charges + 
					cg_charges USING " $###&.##"
END REPORT

#
# Print detail report
#
REPORT ups_list(inv, cnt, ln, ct, st, cntr, zp, wgh1, zn1, 
		dec_value, chrgs, amt, cod_chgs, aod, cll, commer, r_num)
	DEFINE inv	INTEGER
	DEFINE cnt	CHAR(14)
	DEFINE ln	CHAR(18)
	DEFINE ct	CHAR(8)
	DEFINE st	CHAR(3)
	DEFINE cntr	CHAR(4)
	DEFINE zp	CHAR(7)
	DEFINE commer	CHAR(5)
	DEFINE wgh1, r_num, zn1	SMALLINT
	DEFINE chrgs, amt, cod_chgs, dec_value	MONEY(8, 2)
	DEFINE aod, cll	CHAR(1)

	OUTPUT
		REPORT TO PIPE "print_land | lp"
		TOP MARGIN 0
		BOTTOM MARGIN 1
		LEFT MARGIN 9
		PAGE LENGTH 60
	
	ORDER BY r_num

	FORMAT 
	
	PAGE HEADER
		PRINT
		COLUMN 0, "-------------------",
			COLUMN 26, "MARK WILLIAMS CO.",
			COLUMN 51, "------------------"
		IF shiploc = 0 THEN
			PRINT
				COLUMN 0, "| date            |",
				COLUMN 26, "60 Revere Dr.",
				COLUMN 51, "| Pickup rec. no.|",
				COLUMN 85, "IL 612-750"
		ELSE
			PRINT
				COLUMN 0, "| date            |",
				COLUMN 26, "60 Revere Dr.",
				COLUMN 51, "| Pickup rec. no.|",
				COLUMN 85, "IL 581-7E8"
		END IF
		PRINT   "|", cur_date USING "    mm / dd / yy ", "|", 
			COLUMN 26, "Northbrook, IL 60062", COLUMN 51, "|", 
			record_no USING "   ### ### ###  ", "|"
		PRINT "-------------------------------------------------------",
		 "------------------------------------------------------------"
		
     PRINT COLUMN 66, "|   |  | |        |       |        |    |A|C| Com."
     PRINT COLUMN 66, "|   | L|O| declare|       | cod*** |cod |o|a| or"
     PRINT "------------------------------------------------------",
           "-----------|zon| b|s| value  |charges| amount |chgs|d|l| res."
	     PRINT "   |Ref.nm|     Name     |", "     Address      |",
	  	   "  City  |ST.|  Zip  ",
		   "|   | s| |        |       |        |    | |l| addr"
		PRINT "=======================================================",
		 "============================================================"
			
	ON EVERY ROW
		PRINT 	r_num USING "###", "|", inv USING "&&&&&&", "|", cnt, 
		    " ", ln, " ", ct, "|", st, "|", zp, "|", zn1 USING "###",
    		    "|", wgh1 USING "##", "| |", dec_value USING "#####.##",
		    "|", chrgs USING " ###.##", "|", amt USING "#####.##", "|", 
	            cod_chgs USING "#.##", "|", aod, "|", cll, "|", commer
		PRINT "-------------------------------------------------------",
		 "------------------------------------------------------------"

	PAGE TRAILER
		PRINT "=======================================================",
		 "============================================================"
			     
		PRINT COLUMN 50, PAGENO USING " Page ##"
END REPORT
