/* $Header: $ */

#define	_DDI_DKI	1
#define	_SYSV4		1

/*
 * This file contains the implementation of the DDI/DKI function
 * drv_setparm ().
 *
 * $Log: $
 */

/*
 *-IMPORTS:
 *	<common/ccompat.h>
 *		__USE_PROTO__
 *		__ARGS ()
 */

#include <common/ccompat.h>
#include <sys/types.h>
#include <sys/ddi.h>

/*
 *-STATUS:
 *	DDI/DKI
 *
 *-NAME:
 *	drv_setparm	Set kernel state information.
 *
 *-SYNOPSIS:
 *	#include <sys/types.h>
 *	#include <sys/ddi.h>
 *
 *	int drv_setparm (ulong_t parm, ulong_t value);
 *
 *-ARGUMENTS:
 *	parm		The kernel parameter to be updated. Possible values
 *			are:
 *			SYSCANC	Add "value" to the count of the number of
 *				characters received from a terminal device
 *				after the characters have been processed to
 *				remove special characters such as "break" or
 *				"backspace".
 *
 *			SYSMINT	Add "value" to the count of the number of
 *				modem interrupts received.
 *
 *			SYSOUTC	Add "value" to the count of the number of
 *				characters output to a terminal device.
 *
 *			SYSRAWC	Add "value" to the count of the number of
 *				characters received from a terminal device,
 *				before canonical processing has occurred.
 *
 *			SYSRINT	Add "value" to the count of the number of
 *				interrupts generated by data ready to be
 *				received from a terminal device.
 *
 *			SYSXINT	Add "value" to the count of the number of
 *				interrupts generated by data ready to be
 *				transmitted to a terminal device.
 *
 *	value		The value to be added to the parameter.
 *
 *-DESCRIPTION:
 *	drv_setparm () verifies that "parm" corresponds to a kernel parameter
 *	that may be modified. If the value of "parm" correspoonds to a
 *	parameter that may not be modified, -1 is returned. Otherwise, the
 *	parameter is incremented by "value".
 *
 *	No checking is performed to determine the validity of "value". It is
 *	the driver's reponsibility to guarantee the correctness of "value".
 *
 *-RETURN VALUE:
 *	If the function is successful, 0 is returned. Otherwise, -1 is
 *	returned to indicate that "parm" specified an invalid parameter.
 *
 *-LEVEL:
 *	Base or interrupt.
 *
 *-NOTES:
 *	Does not sleep.
 *
 *	Driver-defined basic locks, read/write locks, and sleep locks may be
 *	held across calls to this function.
 *
 *-SEE ALSO:
 *	drv_getparm ()
 */

#if	__USE_PROTO__
int (drv_setparm) (ulong_t parm, ulong_t value)
#else
int
drv_setparm __ARGS ((parm, value))
ulong_t		parm;
ulong_t		value;
#endif
{
	switch (parm) {

	case SYSCANC:
	case SYSMINT:
	case SYSOUTC:
	case SYSRAWC:
	case SYSRINT:
	case SYSXINT:
		break;

	default:
		return -1;
	}

	return 0;
}
