/*
 *	fio.c
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\inode.h"
#include "h\filsys.h"
#include "h\conf.h"
#include "h\file.h"
#include "h\systm.h"

struct file file[NFILE];

/*
 * convert a file descriptor to a ptr to the corresponding file struct
 *    mainly just error checking
 */

struct file *getf(rf)
register int rf;
	{
	register struct file *fp;

	if (rf<0||rf>=NOFILE)
		goto BAD;
	fp=u->u_ofile[rf];
	if(fp!=NULL)
		return(fp);
BAD:
	u->u_error=EBADF;
	return(NULL);
	}

/*
 * internal of close, decrement file ref cnt, lastly close inode
 */
void closef(rfp)
register struct file *rfp;
	{
	register struct inode *ip;

	if(rfp->f_flag&FPIPE)		/* pipes are different	*/
		{
		ip=rfp->f_inode;
		ip->i_mode&= ~(IREAD|IWRITE);
		wakeup((int)ip+1);
		wakeup((int)ip+2);
		}
	if(rfp->f_count<=1)
		closei(rfp->f_inode,rfp->f_flag&FWRITE);
	rfp->f_count--;
	}
/*
 * close an inode, lastly close device
 */

void closei(rip,rw)
register struct inode *rip;
int rw;
	{
	register int maj;
	int dev;

	dev=rip->i_addr[0];
	maj=major(dev);
	if(rip->i_count<=1)
		{
		switch(rip->i_mode&IFMT)
			{
			case IFCHR:
				(*cdevsw[maj].d_close)(dev,rw);
				break;
			case IFBLK:
				(*bdevsw[maj].d_close)(dev,rw);
			}
		}
	iput(rip);
	}

/*
 * open an inode, if special file open the device
 */

void openi(rip,rw)
register struct inode *rip;
int rw;
	{
	register int maj;
	int dev;

	dev=rip->i_addr[0];
	maj=major(dev);
	switch(rip->i_mode&IFMT)
		{
		case IFCHR:
			if (maj>=nchrdev)
				goto BAD;
			(*cdevsw[maj].d_open)(dev,rw);
			break;
		case IFBLK:
			if (maj>=nblkdev)
				goto BAD;
			(*bdevsw[maj].d_open)(dev,rw);
		}
	return;
BAD:
	u->u_error=ENXIO;
	}

/*
 * examine access rights to an inode for READ,WRITE,EXEC
 * including read only mounted fs-s for WRITE
 */

access(ip,m)
register struct inode *ip;
register int m;
	{

	if(m==IWRITE)
		{
		if((getfs(ip->i_dev))->s_ronly!=0)
			{
			u->u_error=EROFS;
			return(1);
			}
		if(ip->i_flag & ITEXT)
			{
			u->u_error=ETXTBSY;
			return(1);
			}
		}
	if(u->u_uid==0)		/* even root needs one x-bit to EXEC	*/
		{
		if(m==IEXEC && (ip->i_mode&(IEXEC|(IEXEC>>3)|(IEXEC>>6)))==0)
			goto BAD;
		return(0);
		}

	if(u->u_uid!=ip->i_uid)		/* not owner		*/
		{
		m >>= 3;
		if (u->u_gid!=ip->i_gid)/* not in the same group*/
			m>>=3;
		}
	if((ip->i_mode&m)!=0)
		return(0);
BAD:
	u->u_error=EACCES;
	return(1);
	}

/*
 * examine if a pathname translates to an inode with the same owner as
 * the current process, returns inode if success
 * su always succeeds
 */
struct inode *owner()
	{
	register struct inode *ip;

	if ((ip=namei(uchar,0)) ==NULL)
		return(NULL);

	if (u->u_uid==ip->i_uid)	/* is owner?	*/
		return(ip);
	if (suser())			/* is su	*/
		return(ip);
	iput(ip);
	return(NULL);
	}
/*
 * examine if current user is superuser
 */

suser(void)
	{
	if(u->u_uid==0)			/* uid 0 is root (of course!)	*/
		return(1);
	u->u_error=EPERM;
	return(0);
	}

/*
 * allocate a user file descriptor
 */

ufalloc(void)
	{
	register int i;
	for(i=0;i<NOFILE;i++)
		if(u->u_ofile[i]==NULL)
			{
			u->u_rv=i;
			return(i);
			}
	u->u_error=EMFILE;
	return(-1);
	}
/*
 * allocate a user file descriptor and a file struct
 */
struct file *falloc()
	{
	register struct file *fp;
	register i;

	if ((i=ufalloc())<0)
		return(NULL);

	for(fp=&file[0];fp<&file[NFILE];fp++)
		if(fp->f_count==0)
			{
			u->u_ofile[i]=fp;
			fp->f_count++;
			fp->f_offset=0;
			return(fp);
			}
	printf("no file\n");
	u->u_error=ENFILE;
	return(NULL);
	}
