/*
 *	iget.c
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\inode.h"
#include "h\filsys.h"
#include "h\buf.h"
#include "h\systm.h"


/*#define IUPDMOD  */	/* define this if you don't want to sync inodes	*/
			/* that are already updated, good on floppy	*/

struct inode *rootdir;

/*
 * get a ptr to the specified inode, if in core return, if not
 * read in
 */

struct inode *iget(dev,ino)
dev_t dev;
ino_t ino;
	{
	register struct inode *p;
	register int *ip2,*ip1;
	struct mount *ip;

printf ("Iget:%u num:%x\n",dev,ino);
LOOP:
	ip=NULL;
	for (p=&inode[0];p<&inode[NINODE];p++)		/* first search	*/
		{					/* the in core	*/
		if(dev==p->i_dev && ino==p->i_number)	/* inode table	*/
			{
			if((p->i_flag&ILOCK)!=0)
				{
				p->i_flag|=IWANT;
				sleep((int)p,PINOD);
				goto LOOP;
				}
			if ((p->i_flag&IMOUNT)!=0)	/* look for mount*/
				{
				for(ip=&mount[0];ip<&mount[NMOUNT];ip++)
				if(ip->m_inodp==p)
					{
					dev=ip->m_dev;
					ino=ROOTINO;
					goto LOOP;
					}
				panic ("No imt");
				}
			p->i_count++;
			p->i_flag|=ILOCK;
printf("inode incore %u %x\n",p->i_number,p->i_mode);
			return (p);
			}
		if (ip==NULL && p->i_count==0)
			ip=(struct mount*)p;
		}
	if ((p=(struct inode*)ip)==NULL)
		{
		printf ("Inode table overflow\n");
		u->u_error=ENFILE;
		return (NULL);
		}
	p->i_dev=dev;					/* not in core	*/
	p->i_number=ino;				/* read in from	*/
	p->i_flag=ILOCK;				/* device	*/
	p->i_count++;
	p->i_lastr=-1;
	ip=(struct mount*) bread(dev,(ino+31)/16);
	if (((struct buf*)ip)->b_flags&B_ERROR)
		{
		brelse((struct buf*)ip);
		iput(p);
printf("Error in iget\n");
		return(NULL);
		}
	ip1=(int*)(((struct buf*)ip)->b_addr+32*((ino+31)%16));
	ip2=&p->i_mode;
	while(ip2<(int*)&p->i_addr[8])
		*ip2++=*ip1++;
	brelse((struct buf*)ip);
printf ("Got:%u %x %x\n",p->i_dev,p->i_number,p->i_mode);
	return(p);
	}

/*
 * decrement inode reference count, write back inode and truncate
 */

void iput(rp)
register struct inode *rp;
	{

	if (rp->i_count==1)
		{
		rp->i_flag|=ILOCK;
		if (rp->i_nlink<=0)
			{
			itrunc(rp);
			rp->i_mode=0;
			ifree(rp->i_dev,rp->i_number);
			}
		iupdat(rp,time);
		prele(rp);
		rp->i_flag=0;
		rp->i_number=0;
		}
	rp->i_count--;
	prele(rp);
	}

/*
 * refresh accessed and modified times on inode
 */

void iupdat(rp,tm)
register struct inode *rp;
time_t tm;
	{
	register *ip1;
	int *ip2,i;
	struct buf *bp;
	if ((rp->i_flag&(IUPD|IACC))!=0)
		{


		if (((struct filsys *)getfs(rp->i_dev))->s_ronly)
			return;
		i=rp->i_number+31;
		bp=(struct buf*)bread(rp->i_dev,i/16);
		ip1=(int*)(bp->b_addr+32*(i%16));
		ip2=(int*)&rp->i_mode;
		while(ip2<(int*)&rp->i_addr[8])
			*ip1++ = *ip2++;
		if (rp->i_flag&IACC)
			{
			*(long*)(ip1)=time;
			}
		ip1+=2;
		if (rp->i_flag&IUPD)
			{
			*(long*)(ip1)=tm;
			}
#ifdef IUPDMOD
		rp->i_flag&=~(IUPD|IACC);
#endif
		bwrite(bp);
		}
	}

/*
 * free all blocks belonging to the inode
 */

void itrunc(rp)
register struct inode *rp;
	{
	register struct buf *bp,*dp;
	int *cp,*ep,*ip;

	if ((rp->i_mode&(IFCHR&IFBLK))!=0)
		return;

	for (ip=(int*)&rp->i_addr[7];ip>=(int*)&rp->i_addr[0];ip--)
	if (*ip)
		{
		if ((rp->i_mode&ILARG)!=0)
			{
			bp=bread(rp->i_dev,*ip);
			for (cp=(int*)(bp->b_addr+512);
				cp>=(int*)bp->b_addr;cp--)
			if (*cp)
				{
				if(ip==(int*)&rp->i_addr[7])
					{
					dp=bread(rp->i_dev,*cp);
					for(ep=(int*)(dp->b_addr+512);
						ep>=(int*)dp->b_addr;ep--);
						if (*ep)
							free(rp->i_dev,*ep);
						brelse(dp);
					}
				free(rp->i_dev,*cp);
				}
			brelse(bp);
			}
		free(rp->i_dev,*ip);
		*ip=0;
		}
	rp->i_mode&=~ILARG;
	rp->i_size0=0;
	rp->i_size1=0;
	rp->i_flag|=IUPD;
	}

/*
 * make a new file
 */

struct inode *maknode(mode)
int mode;
	{
	register struct inode *ip;

	ip=ialloc(u->u_pdir->i_dev);
	if (ip==NULL)
		return(NULL);
	ip->i_flag|=IACC|IUPD;
	ip->i_mode=mode|IALLOC;
	ip->i_nlink=1;
	ip->i_uid=u->u_uid;
	ip->i_gid=u->u_gid;
	wdir(ip);
	return(ip);
	}

/*
 * write a directory entry, based on parameters left from namei
 */

void wdir(ip)
struct inode *ip;
	{
	register char *cp1,*cp2;

	u->u_dent.u_ino=ip->i_number;
	cp1=&u->u_dent.u_name[0];
	for (cp2=&u->u_dbuf[0];cp2<&u->u_dbuf[DIRSIZ];)
		*cp1++=*cp2++;
	u->u_count = DIRSIZ+2;
	u->u_segflg=1;			/* write from kernel mem	*/
	u->u_base=(char*)&u->u_dent;
	writei(u->u_pdir);
	iput(u->u_pdir);
	}