/*
 *	slp.c
 *	process scheduling
 */
#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\malloc.h"
#include "h\file.h"
#include "h\text.h"
#include "h\inode.h"
#include "h\buf.h"
#include "h\systm.h"


extern	struct tss swtch_tss;
extern	struct sys_desc swtch_tsk;
extern  int idlemode;

struct proc proc[NPROC];
struct user user[NPROC];
struct proc *cup;
struct user *u;

pid_t mpid;
int runrun,runin,runout;
int lastmode;
char curpri;
char kstack[NPROC][KSSIZ];	/* shouldn't be here	*/

/*
 *	swtch is a task, so there is a small assembly routine
 *	that call -with task switch- _swtch
 */

_swtch()
	{
	register int i;
	register struct proc *rp;
	struct proc *op;
	int hipri;
	static struct proc *pscan=NULL;
SWTCH:
	op=cup;
	if (pscan==NULL)
		pscan=&proc[0];
	cup=&proc[0];
	u=cup->p_u;
SWLOOP:
	runrun=0;		/* no need for sheduling	*/
	rp=pscan;
	pscan=NULL;
	hipri=MAXPRI;


	i=NPROC;
	lock();
	do			/* select the process with the		*/
		{		/* highest (most negative) priority	*/
		++rp;
		if (rp>= &proc[NPROC])
			rp= &proc[0];
		if (rp->p_stat==SRUN &&(rp->p_flag&SLOAD)!=0)
			{
			if (rp->p_pri<hipri)
				{
				pscan=rp;
				hipri=rp->p_pri;
				}
			}
		}
	while (--i);

	if (pscan==NULL)    	/* no runnable process			*/
		{
		pscan=rp;
		idlemode=1;	/* we are at kernel level, but idling   */
		enable();
		asm hlt;	/* wait till an interrupt		*/
		lock();
		idlemode=0;
		goto SWLOOP;
		}
	rp=pscan;
	curpri=hipri;		/* new current pri			*/

	if (rp->p_flag&SSWAP)
		rp->p_flag&=~SSWAP;

	(gdt_beg+(op->p_tss_sel>>3))->rights=SYS_PRES|SYS_ATSS|SYS_DPL0;
				/* mark previous proc's tss as free	*/
	cup=rp;
	u=rp->p_u;

	swtch_tss.blink=rp->p_tss_sel;
				/* change bck.link.selector to new proc	*/

	(gdt_beg+(rp->p_tss_sel>>3))->rights=SYS_PRES|SYS_BTSS|SYS_DPL0;
				/* mark new as busy			*/
	asm {
		pushf;           /* Set Nested Task Bit to task change	*/
		pop ax;
		or ax,16384;
		push ax;
		popf;
		iret;            /* iret makes task switch		*/
	    }
	goto SWTCH;		 /* next call to swtch land here	*/

	}



/*
 *	calculate new priority
 */
void setpri(pp)
register struct proc *pp;
	{
	register char p;
	p=(pp->p_cpu>>4);
	p+=pp->p_nice+PUSER;
	if ((byte)p>127)
		p=127;
	if (p<curpri)		/* New highest pri, swtch needed	*/
		runrun++;
	pp->p_pri=p;

	}





/*
 *	stop process untill specific event
 */
void sleep(chan,pri)
int chan,pri;
	 {
	 register word save;
	 register struct proc *pp=cup;

	 save=lock1();
	 if (pri>=0)			/* low pri sleep	*/
		{
		if(issig())
			goto PSIG;
		lock();
		pp->p_wchan=chan;	/* sleep event	*/
		pp->p_pri=pri;		/* pri at wakeup*/
		pp->p_stat=SWAIT;
		unlock(save);
		if (runin!=0)
			{
			runin=0;
			wakeup((int)&runin);
			}
		swtch();		/* get next proc	*/
		if(issig())
			goto PSIG;
		}
	 else
		{
		lock();
		pp->p_wchan=chan;
		pp->p_pri=pri;
		pp->p_stat=SSLEEP;	/* high pri sleep	*/
		unlock(save);
		swtch();
		}
	 unlock(save);
	 return;

PSIG:
	aretu(u->u_qsav);

	}

/*
 *	wakeup everyone waitig for event
 */
void wakeup(chan)
register int chan;
	{
	int i=NPROC;
	register struct proc *p=&proc[0];

	do
		{
		if (p->p_wchan==chan)
			{
			setrun(p);
			}
		p++;
		}
	while (--i);
	}

/*
 *	mark a process as runnable
 */
void setrun(pr)
register struct proc *pr;
	{
	pr->p_wchan=NULL;
	pr->p_stat=SRUN;
	if (pr->p_pri<curpri)			/* shoul swtch to here	*/
		runrun++;
	if (runout!=0 &&(pr->p_flag&SLOAD)==0)	/* will have to be	*/
		{				/* swapped in, wakeup	*/
		runout=0;			/* swapper process	*/
		wakeup((int)&runout);
		}

	}
/*
 *     	set lasmode to reflect last run mode: kernel/user
 *	we extract the last tss from the current and examine cs
 */

lmod(s)
int s;
	{

	register word tsk;
	register struct tss *tss;
	dword tssa;

	tsk=((hint0_tss+s)->blink&~3)/8;
			/* tss that got interrupted	*/
	tssa=(gdt_beg+tsk)->base_l+((dword)((gdt_beg+tsk)->base_h)<<16);
			/* it's physycal address	*/
	tss=(struct tss*)(tssa-((dword)kdata<<4));
			/* it's kernel virual address	*/
	lastmode=((tss->cs&3)>0);

	return;
	}

/*
 *  the swapper process
 */
#ifdef NOSWAP
void sched()
	{
	static ns;

	sleep ((int)&ns,0);
	panic ("Noswap sched");
	}
#else
void sched()
	{
	struct proc *p1;
	register struct proc *rp;
	register struct text *tp;
	dword a;
	register int n;

	goto LOOP;
SLOOP:
	runin++;
	sleep((int)&runin,PSWP);	/* wait for someone to go out	*/

LOOP:
	lock();
	n=-1;		       		/* get the one longest out	*/
	for (rp=&proc[0];rp<&proc[NPROC];rp++)
	if (rp->p_stat==SRUN &&(rp->p_flag&SLOAD)==0 &&rp->p_time>n)
		{
		p1=rp;
		n=rp->p_time;
		}
	if (n==-1)
		{
		runout++;
		sleep((int)&runout,PSWP);/* noone to swap in, sleep	*/

		goto LOOP;
		}

	enable();
	rp=p1;
	a=rp->p_size;			/* size to make room for	*/
	if ((rp=(struct proc*)rp->p_textp)!=NULL)
		if (((struct text*)rp)->x_ccount==0)
			a+=((struct text*)rp)->x_size;	/* also get text*/
	if ((a=malloc(coremap,a))!=NULL)
		goto FOUND2;

	lock();
					/* not enough room, push 	*/
					/* somebody out			*/
	for (rp=&proc[0];rp<&proc[NPROC];rp++)
		if ((rp->p_flag&(SSYS|SLOCK|SLOAD))==SLOAD &&
		(rp->p_stat==SWAIT||rp->p_stat==SSTOP))
			goto FOUND1;

	if (n<3)
		goto SLOOP;
	n=-1;				/* desperate: must swap out	*/
	for (rp=&proc[0];rp<&proc[NPROC];rp++)
	if ((rp->p_flag&(SSYS|SLOCK|SLOAD))==SLOAD &&
	   (rp->p_stat==SRUN||rp->p_stat==SSLEEP) &&
	    rp->p_time>n)
		{
		p1=rp;
		n=rp->p_time;
		}

	if(n<2)
		goto SLOOP;
	rp=p1;

FOUND1:                                 /* kick a process to swapdev	*/
	enable();
	rp->p_flag&=~SLOAD;
	xswap(rp,1,0);
	goto LOOP;

FOUND2:					/* and get the new one in	*/
	if (p1->p_textp==0)
	if ((tp=p1->p_textp)!=NULL)
		{
		if (tp->x_ccount==0)    /* get its text if needed	*/
			{
			if(swap(tp->x_daddr,a,tp->x_size,B_READ))
				goto SWAPER;
			tp->x_caddr=a;
			ldtfil(TEXTS,a,p1);
			a+=tp->x_size;
			}
		tp->x_ccount++;
		}
	rp=p1;				/* and get its data 		*/
	if (swap((word)rp->p_addr,a,rp->p_size,B_READ))
		goto SWAPER;
	ldtfil (DATAS,a,rp);
	ldtfil (STACKS,a,rp);
	mfree(swapmap,(dword)(rp->p_size+511)>>9,rp->p_addr);
	rp->p_addr=a;
	rp->p_flag|=SLOAD;
	rp->p_time=0;
	goto LOOP;

SWAPER:
	panic ("Swap error slp");
	}
#endif /* NOSWAP */

/*
 * internal of fork, duplicate a process
 *	the new process returns to user level, not like on the PDP
 *	it's needed 'cause the kernel stacks cannot be mapped to
 *	the same virtual addresses.
 */
newproc(void)
	{
	int n;
	struct proc *p;
	register struct proc *rpp,*rip;
	char *udp,*usp;
	dword a1,a2;

	p=NULL;
RETRY:
	mpid++;

	for(rpp=&proc[0];rpp<&proc[NPROC];rpp++)
		{
		if(rpp->p_stat==NULL && p==NULL)
			p=rpp;
		if(rpp->p_pid==mpid)
			goto RETRY;
		}
	if ((rpp=p)==NULL)		/* can't happen, fork already	*/
		panic("No procs");	/* checked for an empty slot	*/
	rip=cup;

	rpp->p_stat = SWAIT;      	/* set up new flags		*/
	rpp->p_flag = 0;/*SLOAD;*/
	rpp->p_uid  = rip->p_uid;
	rpp->p_ttyp = rip->p_ttyp;
	rpp->p_nice = rip->p_nice;
	rpp->p_textp= rip->p_textp;
	rpp->p_pid  = mpid;
	rpp->p_ppid = rip->p_pid;
	rpp->p_time = 0;



	for (usp=(char*)&u->u_ofile[0];	/* duplicate open files		*/
			usp<(char*)&u->u_ofile[NOFILE];)
		if((rpp=(struct proc*)*(((int*)usp)++))!=NULL)
			((struct file*)rpp)->f_count++;

	if((cup->p_textp)!=NULL)	/*text is used twice now	*/
		{
		cup->p_textp->x_count++;
		cup->p_textp->x_ccount++;
		}
	u->u_cdir->i_count++;

	rpp=p;
	rip=cup;

	n=sizeof(struct user);
	usp=(char *)u;
	udp=(char *)rpp->p_u;
	while (n--)			/* duplicate u struct		*/
		*(udp++)=*(usp++);

	n =rip->p_size;
	a1=rip->p_addr;

	rpp->p_size=n;

	rpp->p_tss.ax = 0;		/* child returns with zero	*/
	rpp->p_tss.dx = rip->p_pid;

	rpp->p_tss.ds =
	rpp->p_tss.es = DATAS|SEL_TIL|SEL_RPL3;

	rpp->p_tss.ss = *(cup->p_kstck-1);	/* child's return stck	*/
	rpp->p_tss.sp = *(cup->p_kstck-2)+10;	/* and return address	*/
	rpp->p_tss.ss0= STACK0S|SEL_TIL|SEL_RPL0;
	rpp->p_tss.sp0= (word)rpp->p_kstck;

	rpp->p_tss.cs = *(cup->p_kstck-8);
	rpp->p_tss.ip = *(cup->p_kstck-9);

	rpp->p_tss.bp = *(cup->p_kstck-10);
	rpp->p_tss.di = u->u_ssav[1];
	rpp->p_tss.si = u->u_ssav[0];
	rpp->p_tss.flag=512;


	rpp->p_u->u_cstime=0;
	rpp->p_u->u_stime =0;
	rpp->p_u->u_cutime=0;
	rpp->p_u->u_utime =0;

//	ldtfil(STACK0S,((dword)kdata)<<4,rpp);

	rpp->p_ldt[TEXTS/8].rights=
		ACC_PRES|ACC_EXEC|ACC_READ|ACC_DATA|ACC_DPL3;
	rpp->p_ldt[DATAS/8].rights=
		ACC_PRES|ACC_WRIT|ACC_DPL3|ACC_DATA;
	rpp->p_ldt[STACKS/8].rights=
			ACC_PRES|ACC_WRIT|ACC_DATA|ACC_DPL3;
	ldtfil(TEXTS, rpp->p_textp->x_caddr,rpp);
	estabur(rpp->p_u->u_tsize,rpp->p_u->u_dsize,
		rpp->p_u->u_ssize,rpp);

	a2=malloc(coremap,(dword)n);
	if(a2==NULL)		/* if no room for data, kick some ass	*/
		{
#ifdef NOSWAP
		panic ("Noswap newproc");
#else
		rip->p_stat=SIDL;
		rpp->p_addr=a1;
		rpp->p_flag&=~(SLOAD|SLOCK);
		xswap(rpp,0,0);
		rpp->p_flag|=SSWAP;
		rip->p_stat=SRUN;
#endif /* NOSWAP */
		}
	else
		{
		rpp->p_addr=a2;
		ldtfil(DATAS, a2 ,rpp);
		ldtfil(STACKS,a2 ,rpp);
//		ldtfil(TEXTS, rpp->p_textp->x_caddr,rpp);

		copyseg(a1,a2,n);	/* duplicate data seg		*/
		}
	rpp->p_flag=SLOAD;
	rpp->p_stat=SRUN;
	return(rpp->p_pid);             /* only parent gets here	*/
	}

/*
 * expand a process's data to newsize, swap if must
 */
void expand(newsize)
word newsize;
	{
	register int n;
	register struct proc *p;
	dword a1,a2;

	p=cup;
	n=p->p_size;
	p->p_size=newsize;
	a1=p->p_addr;
	if(n>=newsize)		/* size shrinks		*/
		{
		mfree(coremap,(dword)n-newsize,(dword)a1+newsize);
		p->p_ldt[DATAS/8].limit=newsize;
		return;
		}
	a2=malloc(coremap,(dword)newsize);
	if(a2==NULL)
		{
#ifdef NOSWAP
		panic ("Noswap expand");
#else
		xswap(p,1,n);
#endif /* NOSWAP */
		p->p_flag|=SSWAP;
		swtch();	/* swap in will expand	*/
		return;
		}
	p->p_addr=a2;
	ldtfil(DATAS,a2,cup);
	ldtfil(STACKS,a2,cup);
	p->p_ldt[DATAS/8].limit=newsize;
	copyseg(a1,a2,n);
	mfree(coremap,(dword)n,a1);
	return;
	}

