/*
 *	sysent.c
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\machine.h"
#include "h\systm.h"

void 	nosys(void);
void	nullsys(void);
extern	long (*sysent[])(int,int,int,int);
long sys1(int,int,int,int,int);

/*
 * system call entry
 * the parameters come here by 2 ways:
 *	1-- the number of the syscall is in BX
 *	2-- the parameters are on the stack, thru a call gate
 */

#pragma warn -par	/* dm1,dm2,dm3 are never used, but they are	*/
			/* on the stack, as they are the return address	*/
			/* from sysentrym, since p1..4 get on the stack	*/
			/* before trap is called			*/
long sysentry(dm1,dm2,dm3,p1,p2,p3,p4)

int dm1,dm2,dm3,p1,p2,p3,p4;
	{
	long rval;
	int sn=_DX;
	u->u_ssav[0]=_SI;
	u->u_ssav[1]=_DI;
	if (sn==0)		/* indirect call */
		{
		int *pt=(int*)(++p1);
		sn = fuword((word)pt++);
		p1 = fuword((word)pt++);
		p2 = fuword((word)pt++);
		p3 = fuword((word)pt++);
		p4 = fuword((word)pt);
		}
	u->u_error = 0;
	u->u_dirp = (char *)p1;
	if (sn>64)
		nosys();
	else
		rval=sys1 (sn,p1,p2,p3,p4);
	if (u->u_intflg)
		u->u_error=EINTR;
	setpri(cup);
	asm cld;
	if (u->u_error<100)
		{
		if (u->u_error)
			{
#ifdef DEBUG
			printf("Call:%u UERROR:%u \n",sn,u->u_error);
#endif
			rval=u->u_error;
			asm std;
			}
		}
		else    {
printf ("SYSSIG:%u\n",sn);
			psignal(cup,SIGSYS);
			}

	if(issig())
		psig(0);
	setpri(cup);
	return (rval);
	}
#pragma warn +par

long sys1(sn,p1,p2,p3,p4)
int sn,p1,p2,p3,p4;
	{
	long rval;

	u->u_intflg=1;	/* if syscall is interrupted, u_intflg remains 1*/
	savu(u->u_qsav);
	rval=(*sysent[sn])(p1,p2,p3,p4);/* call fn from jumptable	*/
	u->u_intflg=0;	/* normal ending, clear u_intflg		*/
	return(rval);
	}

void nosys(void)
	{
#ifdef DEBUG
	printf("NOSYS called\n");
#endif /* DEBUG */
	u->u_error=EFAULT;
	}

void nullsys(void)
	{
	}