
/**********************************************************************
 *   Copyright (c) Digital Equipment Corporation 1984, 1985, 1986.    *
 *   All Rights Reserved. 					      *
 *   Reference "/usr/src/COPYRIGHT" for applicable restrictions.      *
 **********************************************************************/

static char Sccsid[] = "@(#)M%	3.0	4/22/86";
# include "mfile2"

# define AWD SNAME|SOREG|SCON|STARNM|STARREG|SAREG
# define LWD SNAME|SOREG|SCON|SAREG

struct optab  table[] = {

ASSIGN,	INAREG|FOREFF|FORCC,
	AWD,	TPOINT|TINT|TUNSIGNED|TCHAR|TUCHAR,
	SZERO,	TANY,
		0,	RLEFT|RRIGHT|RESCC,
		"	clrZB	AL\n",

ASSIGN,	INAREG|FOREFF|FORCC,
	AWD,	TINT|TUNSIGNED,
	AWD,	TCHAR,
		NAREG|NASR,	RLEFT|RESC1|RESCC,
		"	movb	AR,A1\n	mov	A1,AL\n",

ASSIGN,	INAREG|FOREFF|FORCC,
	AWD,	TINT|TUNSIGNED,
	AWD,	TUCHAR,
		0,	RLEFT|RESCC,
		"	movb	AR,AL\n	bic	$!377,AL\n",

ASSIGN,	INAREG|FOREFF|FORCC,
	AWD,	TPOINT|TINT|TUNSIGNED|TCHAR|TUCHAR,
	AWD,	TPOINT|TINT|TUNSIGNED|TCHAR|TUCHAR,
		0,	RLEFT|RRIGHT|RESCC,
		"	movZB	AR,AL\n",

ASSIGN,	INAREG|FOREFF,
	LWD,	TLONG|TULONG,
	SZERO,	TANY,
		0,	RLEFT|RRIGHT,
		"	clr	AL\n	clr	UL\n",

ASSIGN,	INAREG|FOREFF,
	LWD,	TLONG|TULONG,
	LWD,	TLONG|TULONG,
		0,	RLEFT|RRIGHT,
		"	mov	AR,AL\n	mov	UR,UL\n",

ASSIGN,	FOREFF|INAREG,
	STARNM,		TLONG|TULONG,
	LWD,	TLONG|TULONG,
		NAREG|NASL,	RRIGHT,
		"	mov	ZU,A1\n	mov	AR,(A1)+\n	mov	UR,(A1)\n",

ASSIGN,	FOREFF,
	STARNM,	TLONG|TULONG,
	AWD,	TUNSIGNED|TPOINT,
		NAREG|NASL,	RRIGHT,
		"	mov	ZU,A1\n	clr	(A1)+\n	mov	AR,(A1)\n",

ASSIGN,	FOREFF,
	STARNM,	TLONG|TULONG,
	AWD,	TINT,
		NAREG|NASL,	RRIGHT,
		"	mov	ZU,A1\n	mov	AR,2(A1)\n	sxt	(A1)\n",

	/* PANIC! */
ASSIGN,	FOREFF|INAREG,
	STARNM,	TLONG|TULONG,
	AWD,	TUNSIGNED|TPOINT,
		NAREG|NASL|NASR,	RESC1,
		"\tmov\tAR,-(sp)\n\tmov\tZU,A1\n\tclr\t(A1)+\n\tmov\t(sp)+,(A1)\
		\nF\tmov\t(A1),U1\nF\tclr\tA1\n",

ASSIGN,	FOREFF|INAREG,
	STARNM,	TLONG|TULONG,
	AWD,	TINT,
		NAREG|NASL|NASR,	RESC1,
		"\tmov\tAR,-(sp)\n\tmov\tZU,A1\n\tmov\t(sp)+,2(A1)\nF\tmov\t2(A1),U1\
		\n\tsxt\t(A1)\nF\tsxt\tA1\n",

ASSIGN,	FOREFF|INAREG,
	STARNM,	TLONG|TULONG,
	SAREG,	TLONG|TULONG,
		0,	RRIGHT,
		"	mov	AR,AL\n	mov	ZU,AR\n	mov	UR,2(AR)\nF	mov	(AR),AR\n",

ASSIGN,	INAREG|FOREFF,
	LWD,	TLONG|TULONG,
	AWD,	TCHAR,
		NAREG,	RESC1,
		"	movb	AR,U1\n	mov	U1,UL\n	sxt	AL\nF	sxt	A1\n",

ASSIGN,	INAREG|FOREFF,
	LWD,	TLONG|TULONG,
	AWD,	TUCHAR,
		0,	RLEFT,
		"	movb	AR,UL\n	bic	$!377,UL\n	clr	AL\n",

ASSIGN,	INAREG|FOREFF,
	LWD,	TLONG|TULONG,
	AWD,	TINT,
		0,	RLEFT,
		"	mov	AR,UL\n	sxt	AL\n",

ASSIGN,	INAREG|FOREFF,
	LWD,	TLONG|TULONG,
	AWD,	TUNSIGNED|TPOINT,
		0,	RLEFT,
		"	mov	AR,UL\n	clr	AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	AWD,	TDOUBLE,
	SBREG,	TDOUBLE,
		0,	RRIGHT,
		"	movf	AR,AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	AWD,	TFLOAT,
	SBREG,	TDOUBLE,
		0,	RRIGHT,
		"	movfo	AR,AL\n",

ASSIGN, INAREG|FOREFF,
	SFLD,	TANY,
	SZERO,	TANY,
		0,	RRIGHT,
		"	bic	$M.,AL\n",

ASSIGN, INTAREG|INAREG|FOREFF,
	SFLD,	TANY,
	STAREG,	TANY,
		0,	RRIGHT,
		"F\tmov\tAR,-(sp)\n\tash\t$H.,AR\n\tbic\t$!M.,AR\n\tbic\t$M.,AL\n\tbis\tAR,AL\nF\tmov\t(sp)+,AR\n",

ASSIGN, INAREG|FOREFF,
	SFLD,	TANY,
	AWD,	TANY,
		NAREG,	RRIGHT,
		"\tmov\tAR,A1\n\tash\t$H.,A1\n\tbic\t$!M.,A1\n\tbic\t$M.,AL\n\tbis\tA1,AL\n",

ASSIGN,	FOREFF,
	AWD,	TFLOAT,
	AWD,	TFLOAT,
		NBREG,	RESC1,
		"	movof	AR,A1\n	movfo	A1,AL\n",

/* put this here so UNARY MUL nodes match OPLTYPE when appropriate */
UNARY MUL,	INTAREG|INAREG,
	SANY,	TANY,
	STARNM,	TLONG|TULONG,
		NAREG|NASR,	RESC1,
		"	mov	AL,U1\n	mov	(U1)+,A1\n	mov	(U1),U1\n",

OPLTYPE,	FOREFF,
	SANY,	TANY,
	LWD,	TANY,
		0,	RRIGHT,
		"",   /* this entry throws away computations which don't do anything */
OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	SZERO,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NAREG|NASR,	RESC1,
		"	clr	A1\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	SZERO,	TLONG|TULONG,
		NAREG|NASR,	RESC1,
		"	clr	A1\n	clr	U1\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR,
		NAREG|NASR,	RESC1,
		"	movZB	AR,A1\n",

OPLTYPE,	INTEMP,
	SANY,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NTEMP,	RESC1,
		"	mov	AR,A1\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,	RESCC,
		"	tstZB	AR\n",


OPLTYPE,	FORARG,
	SANY,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RNULL,
		"	mov	AR,Z-\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	AWD,	TUCHAR,
		NAREG|NASR,	RESC1,
		"	movb	AR,A1\n	bic	$!377,A1\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	LWD,	TLONG|TULONG,
		NAREG,	RESC1,
		"	mov	UR,U1\n	mov	AR,A1\n",

OPLTYPE,	INTAREG|INAREG,  /* for use when there are no free regs */
	SANY,	TANY,
	LWD,	TLONG|TULONG,
		NAREG|NASR,	RESC1,
		"	mov	AR,-(sp)\n	mov	UR,U1\n	mov	(sp)+,A1\n",

OPLTYPE,	INTEMP,
	SANY,	TANY,
	LWD,	TLONG|TULONG,
		2*NTEMP,	RESC1,
		"	mov	AR,A1\n	mov	UR,U1\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	LWD,	TLONG|TULONG,
		0,	RESCC,
		"ZA",

OPLTYPE, FORARG,
	SANY,	TANY,
	LWD,	TLONG|TULONG,
		0,	RNULL,
		"	mov	UR,Z-\n	mov	AR,Z-\n",

UNARY MUL,	FORARG,
	STARNM,	TANY,
	SANY,	TLONG|TULONG,
		NAREG|NASR,	RNULL,
		"	mov	AL,A1\n	mov	2(A1),Z-\n	mov	(A1),Z-\n",

OPLTYPE, FORARG,
	SANY,	TANY,
	SBREG,	TDOUBLE,
		0,	RNULL,
		"	movf	AR,Z4\n",

OPLTYPE,	INTBREG|INBREG,
	SANY,	TANY,
	AWD,	TDOUBLE,
		NBREG,	RESC1,
		"	movf	AR,A1\n",

OPLTYPE,	INTEMP,
	SANY,	TANY,
	SBREG,	TDOUBLE,
		4*NTEMP,	RESC1,
		"	movf	AR,A1\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	AWD,	TDOUBLE,
		0,	RESCC,
		"	tstf	AR\n	cfcc\n",

OPLTYPE,	INTBREG|INBREG,
	SANY,	TANY,
	AWD,	TFLOAT,
		NBREG,	RESC1,
		"	movof	AR,A1\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	AWD,	TFLOAT,
		NBREG,	RESCC,
		"	movof	AR,A1\n	cfcc\n",


OPLOG,	FORCC,
	AWD,	TPOINT|TINT|TUNSIGNED,
	AWD,	TPOINT|TINT|TUNSIGNED,
		0,	RESCC,
		"	cmp	AL,AR\nZI",

OPLOG,	FORCC,
	AWD,	TCHAR|TUCHAR,
	AWD,	TCHAR|TUCHAR,
		0,	RESCC,
		"	cmpb	AL,AR\nZI",

OPLOG,	FORCC,
	AWD,	TCHAR|TUCHAR,
	SCCON,	TINT,				/* look for constants between -128 and 127 */
		0,	RESCC,
		"	cmpb	AL,AR\nZI",

OPLOG,	FORCC,
	LWD,	TLONG|TULONG,
	LWD,	TLONG|TULONG,
		0,	RESCC,
		"ZCZI",

OPLOG,	FORCC,
	SBREG,	TDOUBLE,
	AWD,	TFLOAT,
		NBREG,	RESCC,
		"	movof	AR,A1\n	cmpf	A1,AL\n	cfcc\nZF",

OPLOG,	FORCC,
	SBREG,	TDOUBLE,
	SBREG|AWD,	TDOUBLE,
		0,	RESCC,
		"	cmpf	AR,AL\n	cfcc\nZF",

CCODES,	INTAREG|INAREG,
	SANY,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NAREG,	RESC1,
		"	mov	$1,A1\nZN",

CCODES,	INTAREG|INAREG,
	SANY,	TANY,
	SANY,	TLONG|TULONG,
		NAREG,	RESC1,
		"	clr	A1\n	mov	$1,U1\nZN",

UNARY MINUS,	INTAREG|INAREG,
	STAREG,	TINT|TUNSIGNED,
	SANY,	TANY,
		0,	RLEFT,
		"	neg	AL\n",

UNARY MINUS,	INTAREG|INAREG,
	STAREG,	TLONG|TULONG,
	SANY,	TANY,
		0,	RLEFT,
		"	neg	AL\n	neg	UL\n	sbc	AL\n",

UNARY MINUS,	INTBREG|INBREG,
	STBREG,	TDOUBLE,
	SANY,	TANY,
		0,	RLEFT,
		"	negf	AL\n",

COMPL,	INTAREG|INAREG,
	STAREG,	TINT|TUNSIGNED,
	SANY,	TANY,
		0,	RLEFT,
		"	com	AL\n",

INCR,	INTAREG|INAREG|FOREFF,
	AWD,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TANY,
		NAREG,	RESC1,
		"F	movZB	AL,A1\n	incZB	AL\n",

DECR,	INTAREG|INAREG|FOREFF,
	AWD,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TANY,
		NAREG,	RESC1,
		"F	movZB	AL,A1\n	decZB	AL\n",

INCR,	INTAREG|INAREG|FOREFF,
	AWD,	TINT|TUNSIGNED|TPOINT,
	SCON,	TANY,
		NAREG,	RESC1,
		"F	mov	AL,A1\n	add	AR,AL\n",

DECR,	INTAREG|INAREG|FOREFF,
	AWD,	TINT|TUNSIGNED|TPOINT,
	SCON,	TANY,
		NAREG,	RESC1,
		"F	mov	AL,A1\n	sub	AR,AL\n",

INCR,	INTAREG|INAREG|FOREFF,
	LWD,	TLONG|TULONG,
	SCON,	TANY,
		NAREG,	RESC1,
		"F	mov	AL,A1\nF	mov	UL,U1\n	add	AR,AL\n	add	UR,UL\n	adc	AL\n",

DECR,	INTAREG|INAREG|FOREFF,
	LWD,	TLONG|TULONG,
	SCON,	TANY,
		NAREG,	RESC1,
		"F	mov	AL,A1\nF	mov	UL,U1\n	sub	AR,AL\n	sub	UR,UL\n	sbc	AL\n",

COMPL,	INTAREG|INAREG,
	STAREG,	TLONG|TULONG,
	SANY,	TANY,
		0,	RLEFT,
		"	com	AL\n	com	UL\n",

AND,	FORCC,
	AWD,	TINT|TUNSIGNED|TPOINT,
	SCON,	TANY,
		0,	RESCC,
		"	bit	AL,$Z~\n",

ASG MUL,	INAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		NAREG,	RLEFT,
		"	mul	AR,AL\n",

ASG DIV,	INAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		NAREG,	RESC1,
		"ZV	div	AR,r0\n",  /* since lhs must be in r1 */

ASG MOD,	INAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		NAREG,	RLEFT,
		"ZV	div	AR,r0\n",  /* since lhs must be in r1 */

ASG PLUS,	INAREG|FORCC,
	AWD,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TINT,
		0,	RLEFT|RESCC,
		"	incZB	AL\n",

ASG PLUS,	INAREG|FORCC,
	AWD,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT|RESCC,
		"	add	AR,AL\n",

ASG MINUS,	INAREG|FORCC,
	AWD,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TINT,
		0,	RLEFT|RESCC,
		"	decZB	AL\n",

ASG MINUS,	INAREG|FORCC,
	AWD,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT|RESCC,
		"	sub	AR,AL\n",

ASG OR, 	INAREG|FORCC,
	AWD,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT|RESCC,
		"	bis	AR,AL\n",

/* AND transformed to "pdp11 bic" in first pass. */
ASG AND,	INAREG|FORCC,
	AWD,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT|RESCC,
		"	bic	AR,AL\n",

ASG ER, 	INAREG|FORCC,
	AWD,	TINT|TUNSIGNED|TPOINT,
	SAREG,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT|RESCC,
		"	xor	AR,AL\n",

ASG OPSHFT, 	INAREG,
	SAREG,	TINT|TUNSIGNED|TPOINT,
	SONE,	TINT,
		0,	RLEFT,
		"	OI	AL\nZH",

ASG LS, 	INAREG,
	SAREG,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"	ash	AR,AL\n",

ASG RS, 	INAREG,
	SAREG,	TINT|TUNSIGNED|TPOINT,
	SCON,	TANY,
		0,	RLEFT,
		"	ash	$ZM,AL\nZH",

ASG RS, 	INAREG,
	SAREG,	TINT|TUNSIGNED|TPOINT,
	STAREG,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"	neg	AR\n	ash	AR,AL\nZH",

ASG RS, 	INAREG,
	SAREG,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		NAREG|NASR,	RLEFT,
		"	mov	AR,A1\n	neg	A1\n	ash	A1,AL\nZH",

ASG RS, 	INAREG,
	SAREG,	TINT,
	AWD,	TINT,
		0,	RLEFT,
		"	mov	AR,-(sp)\n	neg	(sp)\n	ash	(sp)+,AL\nZH",

ASG RS, 	INAREG,
	SAREG,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		NTEMP,	RLEFT,
		"	mov	AR,A1\n	neg	A1\n	ash	A1,AL\nZH",

ASG OR, 	INAREG|FORCC,
	AWD,	TCHAR|TUCHAR,
	AWD,	TCHAR|TUCHAR,
		0,	RLEFT|RESCC,
		"	bisb	AR,AL\n",

/* AND transformed to "pdp11 bic" in first pass. */
ASG AND,	INAREG|FORCC,
	AWD,	TCHAR|TUCHAR,
	AWD,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,	RLEFT|RESCC,
		"	bicb	AR,AL\n",

ASG PLUS,	INAREG,
	LWD,	TLONG|TULONG,
	SICON,	TINT|TLONG|TULONG,
		0,	RLEFT,
		"	add	UR,UL\n	adc	AL\n",

ASG PLUS,	INAREG,
	STARNM,	TLONG|TULONG,
	LWD,	TLONG|TULONG,
		NAREG,	RLEFT,
		"	mov	ZU,A1\n	add	AR,(A1)+\n	add	UR,(A1)\n	adc	-(A1)\n",

ASG PLUS,	INAREG,
	LWD,	TLONG|TULONG,
	LWD,	TLONG|TULONG,
		0,	RLEFT,
		"	add	AR,AL\n	add	UR,UL\n	adc	AL\n",

ASG PLUS,	INAREG,
	AWD,	TPOINT,
	LWD,	TLONG|TULONG,
		0,	RLEFT,
		"	add	UR,AL\n",

ASG MINUS,	INAREG,
	LWD,	TLONG|TULONG,
	SICON,	TINT|TLONG|TULONG,
		0,	RLEFT,
		"	sub	UR,UL\n	sbc	AL\n",

ASG MINUS,	INAREG,
	STARNM,	TLONG|TULONG,
	LWD,	TLONG|TULONG,
		NAREG,	RLEFT,
		"	mov	ZU,A1\n	sub	AR,(A1)+\n	sub	UR,(A1)\n	sbc	-(A1)\n",

ASG MINUS,	INAREG,
	LWD,	TLONG|TULONG,
	LWD,	TLONG|TULONG,
		0,	RLEFT,
		"	sub	AR,AL\n	sub	UR,UL\n	sbc	AL\n",

ASG MINUS,	INAREG,
	AWD,	TPOINT,
	LWD,	TLONG|TULONG,
		0,	RLEFT,
		"	sub	UR,AL\n",

ASG OR, 	INAREG,
	LWD,	TLONG|TULONG,
	LWD,	TLONG|TULONG,
		0,	RLEFT,
		"	bis	AR,AL\n	bis	UR,UL\n",

/* AND transformed to "pdp11 bic" in first pass. */
ASG AND,	INAREG,
	LWD,	TLONG|TULONG,
	LWD,	TLONG|TULONG,
		0,	RLEFT,
		"	bic	AR,AL\n	bic	UR,UL\n",

ASG ER, 	INAREG,
	LWD,	TLONG|TULONG,
	SAREG,	TLONG|TULONG,
		0,	RLEFT,
		"	xor	AR,AL\n	xor	UR,UL\n",

	/* table entries for ^ which correspond to the usual way of doing busingess
		(rhs in a temp register */

ASG ER,	INAREG|INTAREG,
	STAREG,	TLONG|TULONG,
	LWD,	TLONG|TULONG,
		0,	RLEFT,
		"\tmov\tAL,-(sp)\n\tmov\tUR,AL\n\txor\tAL,UL\n\tmov\tAR,AL\n\txor\tAL,(sp)\n\tmov\t(sp)+,AL\n",

ASG ER,	INAREG|INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	AWD,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"\tmov\tAL,-(sp)\n\tmov\tAR,AL\n\txor\tAL,(sp)\n\tmov\t(sp)+,AL\n",

ASG LS, 	INAREG,
	SAREG,	TLONG|TULONG,
	AWD,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"	ashc	AR,AL\n",

ASG RS, 	INAREG,
	SAREG,	TLONG|TULONG,
	SCON,	TANY,
		0,	RLEFT,
		"	ashc	$ZM,AL\nZH",

ASG RS, 	INAREG,
	SAREG,	TLONG|TULONG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"	neg	AR\n	ashc	AR,AL\nZH",

ASG RS, 	INAREG,
	SAREG,	TLONG|TULONG,
	AWD,	TINT|TUNSIGNED|TPOINT,
		NAREG|NASR,	RLEFT,
		"	mov	AR,A1\n	neg	A1\n	ashc	A1,AL\nZH",

ASG RS, 	INAREG,
	SAREG,	TLONG|TULONG,
	AWD,	TINT|TUNSIGNED|TPOINT,
		NTEMP,	RLEFT,
		"	mov	AR,A1\n	neg	A1\n	ashc	A1,AL\nZH",

ASG OPFLOAT,	INBREG|INTBREG,
	STBREG,	TDOUBLE,
	SBREG|AWD,	TDOUBLE,
		0,	RLEFT|RESCC,
		"	OF	AR,AL\n",

ASG OPFLOAT,	INBREG|INTBREG,
	STBREG,	TDOUBLE,
	AWD,	TFLOAT,
		NBREG|NBSR,	RLEFT|RESCC,
		"	movof	AR,A1\n	OF	A1,AL\n",

ASG OPFLOAT,	FORCC,
	STBREG,	TDOUBLE,
	SBREG|AWD,	TDOUBLE,
		0,	RESCC,
		"	OF	AR,AL\n	cfcc\n",

ASG OPFLOAT,	FORCC,
	STBREG,	TDOUBLE,
	AWD,	TFLOAT,
		NBREG|NBSR,	RESCC,
		"	movof	AR,A1\n	OF	A1,AL\n	cfcc\n",

UNARY CALL,	INTAREG,
	SAREG|SNAME|SOREG|SCON,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR|TLONG|TULONG,
		NAREG|NASL,	RESC1, /* should be register 0 */
		"	jsr	pc,*AL\n",

UNARY CALL,	INTBREG,
	SAREG|SNAME|SOREG|SCON,	TANY,
	SANY,	TDOUBLE|TFLOAT,
		NBREG,	RESC1, /* should be register FR0 */
		"	jsr	pc,*AL\n",

SCONV,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SANY,	TUCHAR,
		0,	RLEFT,
		"	bic	$!377,AL\n",

SCONV,	INTAREG,
	AWD,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SANY,	TCHAR|TINT,
		NAREG|NASL,	RESC1,
		"	movZB	AL,A1\n",

SCONV,	INAREG|INTAREG,
	LWD,	TLONG|TULONG,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,	RLEFT,
		"ZT",

SCONV,	INTAREG,
	AWD,	TUCHAR,
	SANY,	TLONG|TULONG,
		NAREG|NASL,	RESC1,
		"	movb	AL,U1\n	bic	$!377,U1\n	clr	A1\n",

SCONV,	INTAREG,
	AWD,	TINT,
	SANY,	TLONG|TULONG,
		NAREG|NASL,	RESC1,
		"	mov	AL,U1\n	sxt	A1\n",

SCONV,	INTAREG,
	AWD,	TUNSIGNED|TPOINT,
	SANY,	TLONG|TULONG,
		NAREG|NASL,	RESC1,
		"	mov	AL,U1\n	clr	A1\n",

SCONV,	INTAREG,
	SBREG,	TDOUBLE,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NAREG,	RESC1,
		"	movfi	AL,A1\n",

SCONV,	INTAREG,
	STBREG,	TDOUBLE,
	SANY,	TLONG|TULONG,
		NAREG,	RESC1,
		"	setl\n	movfi	AL,-(sp)\n	seti\n	mov	(sp)+,A1\n	mov	(sp)+,U1\n",

SCONV,	FORARG,
	STBREG,	TDOUBLE,
	SANY,	TLONG|TULONG,
		0,	RNULL,
		"	setl\n	movfi	AL,Z4\n	seti\n",

SCONV,	INTBREG,
	SAREG,	TLONG,
	SANY,	TANY,
		NBREG,	RESC1,
		"\tmov\tUL,-(sp)\n\tmov\tAL,-(sp)\n\tsetl\n\tmovif\t(sp)+,A1\n\tseti\n",

SCONV,	INTBREG,
	LWD,	TLONG,
	SANY,	TANY,
		NBREG,	RESC1,
		"\tsetl\n\tmovif\tAL,A1\n\tseti\n",

SCONV,	INTBREG,
	AWD,	TINT,
	SANY,	TANY,
		NBREG,	RESC1,
		"	movif	AL,A1\n",

SCONV,	INTBREG,
	SAREG,	TULONG,
	SANY,	TANY,
		NBREG,	RESC1,
		"\tmov\tUL,-(sp)\n\tmov\tAL,-(sp)\n\tsetl\n\tmovif\t(sp)+,A1\n\tseti\n\tcfcc\n\tbpl\t1f\n\taddf\t$050200,A1\n1:\n",

SCONV,	INTBREG,
	LWD,	TULONG,
	SANY,	TANY,
		NBREG,	RESC1,
		"\tsetl\n\tmovif\tAL,A1\n\tseti\n\tcfcc\n\tbpl\t1f\n\taddf\t$050200,A1\n1:\n",

SCONV,	INTBREG,
	STAREG,	TUNSIGNED|TPOINT,
	SANY,	TANY,
		NBREG,	RESC1,
		"\tmovif\tAL,A1\n\tcfcc\n\tbpl\t1f\n\taddf\t$044200,A1\n1:\n",

PCONV,	INTAREG,
	AWD,	TCHAR|TUCHAR,
	SANY,	TPOINT,
		NAREG|NASL,	RESC1,
		"	movb	AL,A1\n",

PCONV,	INAREG|INTAREG,
	LWD,	TLONG|TULONG,
	SANY,	TPOINT,
		0,	RLEFT,
		"ZT",

STARG,	FORARG,
	SNAME|SOREG,	TANY,
	SANY,	TANY,
		0,	RNULL,
		"ZS",

STASG,	FOREFF,
	SNAME|SOREG,	TANY,
	SCON|SAREG,	TANY,
		0,	RNOP,
		"ZS",

STASG,	INTAREG|INAREG,
	SNAME|SOREG,	TANY,
	STAREG,	TANY,
		0,	RRIGHT,
		"ZS",

STASG, INAREG|INTAREG,
	SNAME|SOREG,	TANY,
	SCON|SAREG,	TANY,
		NAREG,	RESC1,
		"ZS	mov	AR,A1\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RNOP,
		"	CL\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TLONG|TULONG,
		0,	RNOP,
		"ZL",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TCHAR|TUCHAR,
		0,	RNOP,
		"	.byte	CL\n",

	/* for the use of fortran only */

GOTO,	FOREFF,
	SCON,	TANY,
	SANY,	TANY,
		0,	RNOP,
		"	jbr	CL\n",

GOTO,	FOREFF,
	SNAME,	TLONG|TULONG,
	SANY,	TANY,
		0,	RNOP,
		"	jmp	*UL\n",

GOTO,	FOREFF,
	SNAME,	TINT|TUNSIGNED|TCHAR|TUCHAR|TPOINT,
	SANY,	TANY,
		0,	RNOP,
		"	jmp	*AL\n",

	/* Default actions for hard trees ... */

# define DF(x) FORREW,SANY,TANY,SANY,TANY,REWRITE,x,""

UNARY MUL, DF( UNARY MUL ),

INCR, DF(INCR),

DECR, DF(INCR),

ASSIGN, DF(ASSIGN),

STASG, DF(STASG),

OPLEAF, DF(NAME),

OPLOG,	FORCC,
	SANY,	TANY,
	SANY,	TANY,
		REWRITE,	BITYPE,
		"",

OPLOG,	DF(NOT),

COMOP, DF(COMOP),

INIT, DF(INIT),

OPUNARY, DF(UNARY MINUS),


ASG OPANY, DF(ASG PLUS),

OPANY, DF(BITYPE),

FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	"help; I'm in trouble\n" };
