static	char	*rcsid =
	"$Header: dosys.c,v 1.4 83/11/28 10:03:27 tony Exp $";

/*	@(#)/usr/src/cmd/make/dosys.c	3.2	*/

/*	@(#)dosys.c	3.1	*/

/*
 * $Log:	dosys.c,v $
 * Revision 1.4  83/11/28  10:03:27  tony
 * Installed a bug fix that came in on net.unix-wizards. The old code
 * is ifdef`d out to make the intent of the routine apparent.
 * 
 * Revision 1.3  83/10/06  16:07:10  tony
 * Converted to use new directory routines. Call closedir
 * instead of fclose in routine doclose.
 * 
 * Revision 1.2  83/10/06  10:50:24  tony
 * Added code from physics for RCS.
 * 
 */

# include "defs.h"

extern char Makecall;


dosys(comstring, nohalt)
register CHARSTAR comstring;
int nohalt;
{
	register CHARSTAR p;
	register int i;
	int status;

	p = comstring;
	while(	*p == BLANK ||
		*p == TAB ||
		*p == AT ||
		*p == MINUS ||
		*p == NULL) p++;

	if(IS_ON(NOEX) && Makecall == NO)
		return(0);

	if(metas(comstring))
		status = doshell(comstring,nohalt);
	else
		status = doexec(comstring);

	return(status);
}



metas(s)   /* Are there are any  Shell meta-characters? */
register CHARSTAR s;
{
	while(*s)
		if( funny[*s++] & META)
			return(YES);

	return(NO);
}

doshell(comstring,nohalt)
register CHARSTAR comstring;
register int nohalt;
{
	register CHARSTAR shell;

	if((waitpid = fork()) == 0)
	{
		enbint(0);
		doclose();

		setenv();
		shell = varptr("SHELL")->varval;
		if(shell == 0 || shell[0] == CNULL)
			shell = SHELLCOM;
		execl(shell, "sh", (nohalt ? "-c" : "-ce"), comstring, 0);
		fatal("Couldn't load Shell");
	}

	return( await() );
}




await()
{
	int intrupt();
	int status;
	int pid;

	enbint(intrupt);
	while( (pid = wait(&status)) != waitpid)
		if(pid == -1)
			fatal("bad wait code");
	waitpid = 0;
	return(status);
}






doclose()	/* Close open directory files before exec'ing */
{
	register OPENDIR od;

#ifdef	FOOBAR
	for (od = firstod; od != 0; od = od->nextopendir)
		if (od->dirfc != NULL) {
			closedir(od->dirfc);
			od->dirfc = NULL;
		}
#else
	/* This fix comes from sdcsvax!greg via net.unix-wizards 
	 *
	 * We have done a vfork, so we can`t do anything to stomp on our
	 * paren`t address space.  Unfortunately, the code above doesn`t
	 * work since our parent`s files remain open. And we can`t just
	 * do a closedir, since it will free a dynamically-allocated table
	 * entry. So we use this hack, calling close directly. If the
	 * interface ever changes, we are going to be out of luck.
	 */

	 for (od = firstod; od ;od = od->nextopendir)
		if (od->dirfc != NULL)
			close(od->dirfc->dd_fd);
#endif	FOOBAR
}





doexec(str)
register CHARSTAR str;
{
	register CHARSTAR t;
	register CHARSTAR *p;
	CHARSTAR argv[200];
	int status;

	while( *str==BLANK || *str==TAB )
		++str;
	if( *str == CNULL )
		return(-1);	/* no command */

	p = argv;
	for(t = str ; *t ; )
	{
		*p++ = t;
		while(*t!=BLANK && *t!=TAB && *t!=CNULL)
			++t;
		if(*t)
			for( *t++ = CNULL ; *t==BLANK || *t==TAB  ; ++t);
	}

	*p = NULL;

	if((waitpid = fork()) == 0)
	{
		enbint(0);
		doclose();
		setenv();
		execvp(str, argv);
		fatal1("Cannot load %s",str);
	}

	return( await() );
}

touch(s)
register CHARSTAR s;
{
	if(junkname[0] == 0)
		sprintf(junkname,  "MAKEJUNK%d", getpid() );

	link(s, junkname);
	unlink(junkname);
	sleep(1);
}
