#include	"link.h"

pass2()
{
	register int t;
	register int **pp;
	register char *rr1;
	int mag[8];
	extern	ofd;

	/* if no object desired, skip this phase */
	if(flags&NO)
		return;

	/* initialize input and output */

	if(objyes == NIL)
		objyes = ext(firstfile,".out");
	close(creat(objyes, 0701));
	ofd = open(objyes, 2);
	if(ofd == -1)
		ferror("Cannot create out file.");
	init_in();

	objwrite(-1);

	/* library pointers */

	act_sec = NIL;
	libpnt = libuse;
	curmod = NIL;
	psecte = (*segwk)[0].segpsect;

	/*
	 * Force linker to write out very last byte
	 */
	if (nseg > 1)
		objwrite(4, ROUNDX, "", 1, flast);

	/* main loop on record type */

	while(t=getrec())
	switch(t) {

	case LMOD:
		textdump();
		if(*libpnt++ == 0) {
			slewto(EMOD);
			break;
		}
		slewto(GSD);

	case GSD:
		textdump();
		while((t=getgsd())>=0)
			if(t == MDN) {
				if (curmod == NIL)
					curmod = (*segwk)[segment].segmod;
				else
					curmod = curmod->mpnt;
				pp = pcorres;
				for (rr1 = curmod->mpsl; rr1 != NIL; rr1 = rr1->pll) {
					*pp++ = rr1;
					if((flags&NS)==0)
						for(t=rr1->plg; t!= NIL; t = t->gglp)
							symout(t->glp->gname,t->glp->gvalue);
				}
			}
		break;

	case TXT:
		textdump();
		movbyte(&load_addr,2);
		text_act = 1;
		rldcount = bcount;
		if(rldcount)
			movbyte(rldbuf,rldcount);
		break;

	case SDR:
		textdump();
		if(flags & (NS|GO))
			break;
		while(getgsd()>=0) {
			if(gsdent.fbyte & 1)
				continue;	/* ignore register declaractions */
			t = gsdent.val;
			if(gsdent.fbyte & REL)
				t =+ pcorres[gsdent.gtype]->llimlow;
			symout(gsdent.nm,t);
		}
		break;

	case RLD:
		rldproc();
		break;

	case PSD:
		textdump();
		psdproc();
		break;

	default:
		textdump();
		
	}

	/* now,  seek to start of file and write out magic header */


	mag[0] = flags & P1 ? 0407:
		 flags & ID ? 0411:
			txtsize == 0 ? 0407 : 0410;
	mag[1] = txtsize;
	mag[2] = datsize;
	mag[3] = ovrsize+bsssize;
	mag[4] = symcount * 12;
	mag[5] = mag[6] = 0;
	if (trmod != NIL)
		mag[5] = tradrs|01;
	mag[7] = 1;

	if (nseg > 1)
	{
		wovl();
		if (msym != symcount)
			printf("BUG: symbol count mismatch - %u/%u\n", msym, symcount);
	}
	objwrite(3, 0, mag, 16);
	return;

}

textdump()
{
	register struct psectl *p1;
	register struct psect  *p2;
	register int t;
	int stype;

	if(text_act == 0)
		return;

	text_act = 0;
	p1 = act_sec;
	p2 = p1->plp;

	if(p2->pflags & BSS)
		return;
	stype = 0;
	t = p1->llimlow + load_addr;
	if (p2->pflags & OVLY) {
		/*
		 * fraction of offset from segment's core
		 * address to it's file address
		 */
		t =- (*psrtable)[(*segwk)[segment].segreg - 1];
		objwrite(4, t, rldbuf, rldcount, (*psstable)[segment - 1].segfadr);
		return;
	}
	if((p2->pflags&SHR)==0) {
		t =- datstart;
		stype++;
	}
	objwrite(stype,t,rldbuf,rldcount);
}

struct	{
	char	sn[8];
	int	fl;
	int	nvl;
} sbb;

symout(np,vl)
int *np;
int vl;
{

	register char *r1,*r2;
	register int t;

	radcon(np, sbb.sn);
	for(r1 = &sbb.sn[6]; r1 > sbb.sn;) {
		if(*--r1 == ' ') *r1 = 0;
/* removed August 1980 KFH
		if(*r1 == '$') *r1 = '_';
*/
	}
	sbb.fl = 01;
	sbb.nvl = vl;
	if (symcount > 5400) {
		if (symovr == 0) {
			symovr++;
			printf("symbol table overflow -- ");
			printf("last symbol output was %.6s\n",
				sbb.sn);
		}
	return;
	}
	objwrite(2,12*symcount,&sbb,12);
	symcount++;
}
rldproc()
{
	char	rldtype;
	int	disp;
	int	addrp2;
	register int *q; register char *r;
	char	*val;
	extern char	*ggvalue();

	while(movbyte(&rldtype,1)) {
		bytflg = 0;
		movbyte(&disp,1);
		disp =& 0377;
		r = rldbuf - 4 + disp;
		addrp2 = disp - 2 + load_addr + act_sec->llimlow;

		if (rldtype & 0200) {
			bytflg = 1;
			rldtype =& 0177;
		}
		switch(rldtype) {
		
		case 1:		setup(r,getcon() + act_sec->llimlow);
				break;
		case 2:		setup(r, ggvalue(getnam())); break;
		case 3:		setup(r,getcon()-addrp2); break;
		case 4:		setup(r,ggvalue(getnam())-addrp2); break;
		case 5:		val = ggvalue(getnam());
				setup(r,getcon()+val); break;
		case 6:		val = ggvalue(getnam());
				setup(r, getcon()+val-addrp2);
				break;
		case 7:		textdump();
				act_sec = getsec(getnam());
		case 8:		textdump();
				getcon(); break;
		case 9:		setup(r,0); setup(r+2,bssstart+bsssize);
				break;
		case 10:	q = getsec(getnam());
				setup(r,q->llimlow); break;
		case 12:	q = getsec(getnam());
				setup(r,q->llimlow-addrp2); break;
		case 13:	q = getsec(getnam());
				setup(r, q->llimlow+getcon()); break;
		case 14:	q = getsec(getnam());
				setup(r,q->llimlow+getcon()-addrp2);
				break;

		}

	}
}



struct global *ggsearch(s)
int *s;
{
	register struct global *q;
	q = gsearch(s);
	if((q->gflags&DEF)==0) {
		printf("Reference of <");
		radout(q->gname);
		printf("> in <");
		radout(curmod->mname);
		printf(">\n");
	}
	return(q);
}

char *
ggvalue(nm)
int	nm[2];
{
	register struct global	*gp;
	union	{
		unsigned int	uint;
		char		*charp;
		} fiddle;

	gp = ggsearch(nm);
	if (gp->gflags & AUTO) {
		fiddle.charp = gp->gvalue;
		if (gp->gsegment == segment)
			return((*autotab)[fiddle.uint].kentry);
		else {
			if ((*segwk)[segment].segreg == (*segwk)[gp->gsegment].segreg)
				printf("Warning: Segment %u. references segment %u. in same region!\n", segment, gp->gsegment);
			return(&(*auttadr)[fiddle.uint]);
		}
	}
	return(gp->gvalue);
}

psdproc()
{
	char	keybyte,valmod;
	int	valwd;
	register int *ip,*vp;
	register char *q;

	vp = &clcsym.symval;
	while(movbyte(&keybyte,1)) {
		*vp = 0;
		clcsym.raw[0] = control.cnm[0];
		clcsym.raw[1] = control.cnm[1];
		if(keybyte&CCNAM) {
			movbyte(clcsym.raw,4);
			if(keybyte&CCSEC) {
				*vp = getsec(clcsym.raw)->llimlow;
			} else {
				if(clcsym.raw[0]) {
					*vp = ggvalue(clcsym.raw);
				} else
					*vp = oprbuf[clcsym.raw[1] - 1];
			}
		} else
			if(keybyte&CCSEC)
				*vp = control.consec->llimlow;

		if(keybyte&CCVAL) {
			valwd = 0;
			if(keybyte&RBYTE)
				movbyte(&valwd,1);
			else
				movbyte(&valwd,2);
			*vp =+ valwd;
		}

		if(keybyte&CCDSP)
			*vp =- control.conloc + 2;

		if((keybyte&CCOPR)==0) {
			valmod = control.consec->plp->pflags;
			valmod = valmod&BSS ? 2 : valmod&SHR ? 0 : 1;
			if (control.consec->plp->pflags & OVLY)
				valmod = 4;
			if (valmod == 1)
				q = datstart;
			else if (valmod == 4)
				q = (*psrtable)[(*segwk)[segment].segreg - 1];
			else
				q = 0;
			valwd = keybyte&RBYTE ? 1: 2;
			if(valmod != 2)
				objwrite(valmod, control.conloc-q, vp, valwd);
			control.conloc =+ valwd;
			continue;
		}

		movbyte(&keybyte,1);
		if(keybyte&RBYTE)
			keybyte =& ~RBYTE;
		else {
			if(keybyte) {
				switch(keybyte) {
			
				case 1:	*vp = 0; break;
				case 2:	*vp = bssstart + bsssize; break;
				case 3: movbyte(clcsym.raw,4);
					if ((q = getsec(clcsym.raw)) != NIL)
						q = q->plp;
					else
						q = psearch(clcsym.raw);
					*vp = q->plimlow; break;
				case 4: movbyte(clcsym.raw,4);
					if ((q = getsec(clcsym.raw)) != NIL)
						q = q->plp;
					else
						q = psearch(clcsym.raw);
					*vp = q->plimhigh; break;
				case 5:	*vp = ~ *vp; break;
				case 6:	*vp = - *vp; break;

				}
				keybyte = 0;
			} else {
				control.consec = getsec(clcsym.raw);
				control.conloc = *vp;
				control.cnm[0] = clcsym.raw[0];
				control.cnm[1] = clcsym.raw[1];
				continue;
			}
		}

		movbyte(&valmod,1);
		ip = &oprbuf[valmod - 1];

		switch(keybyte) {

		case 0:	*ip = *vp; break;
		case 1:	*ip =+ *vp; break;
		case 2:	*ip =- *vp; break;
		case 3:	*ip =* *vp; break;
		case 4:	*ip =/ *vp; break;
		case 5:	*ip =& *vp; break;
		case 6:	*ip =| *vp; break;

		}
	}
}


/*
 * output overlay stuff to load file
 */
wovl()
{
	register unsigned int		i;
	register struct segtable	*sp;
	struct segtable			*segp;

	objwrite(0, 0, ovscode, ovslcode);	/* shared region */
	objwrite(1, 0, ovpcode, ovplcode);	/* private region */

	/* segment table */
	objwrite(0, (*segtadr), (*psstable), (nseg-1)*SSEG);
	/* auto-load vectors */
	objwrite(0, (*auttadr), (*autotab), nauto*SLINK);

	/*
	 * Write segment table pointers into segments
	 */
	for (i = 1, sp = (*psstable); i < nseg; i++, sp++) {
		segp = &(*segtadr)[i - 1];
		objwrite(4, 0, &segp, sizeof segp, sp->segfadr);
	}
}
