#

#include "../gpac.h"
#include "../error_codes.h"
#include "null.h"

#define GWSNAP "/usr/graf/stogw"
#define VPSNAP "/bin/opr"

snap(device)
	char *device;
	{
	register file, process;
	register save_dev;
	int arg;
	int fd[2];

	process = 0;
	switch(device[0] | device[1]<<8)
		{
		case 'nu' :
			if((file = creat("snap.out", 0644)) < 0)
				return(Gerror(OPEN_ERR, "snap.out"));
			break;
		case 'gw' :
		case 'vp' :
			if(pipe(fd) < 0)
				return(Gerror(OPEN_ERR, "snap-pipe"));
			file = fd[1];
			if((process = fork()) < 0)
				{
				close(fd[0]);
				close(fd[1]);
				return(Gerror(FORK_ERR, "snap"));
				}
			if(process == 0)
				{
				close(0);
				close(fd[1]);
				dup(fd[0]);
				switch(device[0] | device[1]<<8)
					{
					case 'gw' :
						execl(GWSNAP, "snap", 0);
						exit();
					case 'vp' :
						execl(VPSNAP, "snap", "-vp", "-t", 0);
						exit();
					}
				}
			close(fd[0]);
			break;
		default :
			if((file = creat(device, 0644)) < 0)
				return(Gerror(OPEN_ERR, device));
		}
	save_dev = Gdev_file;
	Gdev_file = file;
	arg = STANDARD_FORMAT_MAGIC_NUMBER;
	write(Gdev_file, &arg, 2);
	update();
	arg = END_OF_DATA_COMMAND;
	write(Gdev_file, &arg, 2);
	close(file);
	Gdev_file = save_dev;
	if(process)
		wait(&arg);
	return(process);
	}
