#

/*
 *	TRANSFORMATION MODULE OF GPAC
 */

#include "../gpac.h"
#include "../error_codes.h"

translate(dx, dy)
	double dx, dy;
	{

	Gctm_pu++;
	Gctm_mod++;
	Gctmc =+ dx;
	Gctmf =+ dy;
	GOOD_RETURN;
	}


scale(sx, sy)
	double sx, sy;
	{

	if(sx <= 0.0 || sy <= 0.0)
		return(Gerror(SCALE_INVAL, sx, sy));
	Gctm_pu++;
	Gctm_mod++;
	Gctma =* sx;
	Gctmb =* sx;
	Gctmc =* sx;
	Gctmd =* sy;
	Gctme =* sy;
	Gctmf =* sy;
	GOOD_RETURN;
	}


rotate(angle)
	double angle;
	{
	double sa, ca, t;
	double sin(), cos();

	Gctm_pu++;
	Gctm_mod++;
	sa = sin(angle);
	ca = cos(angle);

	t = Gctma*ca-Gctmd*sa;
	Gctmd = Gctmd*ca+Gctma*sa;
	Gctma = t;

	t = Gctmb*ca-Gctme*sa;
	Gctme = Gctme*ca+Gctmb*sa;
	Gctmb = t;

	t = Gctmc*ca-Gctmf*sa;
	Gctmf = Gctmf*ca+Gctmc*sa;
	Gctmc = t;
	GOOD_RETURN;
	}
