#
int df[4096] 0;
char copr[] "Copyright (c) 1976 William T. Reeves, Thomas S. Duff";
/*
 * New previewer
 * Maintains an array of light buttons for controlling the GRAPHIC
 * WONDER playback program with the digitizing tablet.
 * prev [-b] [-t] playbackfile
 */
#define Z_AXIS_DOWN 6
#define TI_SEG 1
#define TRK_SEG 2
#define FIRSTMENUSEG 3
#define START	0
#define STOP	1
#define CONTINUE 2
#define STFRAME	3
#define ENDFRAME 4
#define FPS	5
#define FINCR	6
#define CYCLE	7
#define FCOUNTER 8
#define SNAP	9
#define EXIT	10
char *menu[]{
	"Start",
	"Stop",
	"Continue",
	"Start frame",
	"End frame",
	"Frames per second",
	"Frame increment",
	"Cycle on",
	"Frame counter off",
	"Snap",
	"Exit",
	0
};
struct event{
	int type;
	int x;
	int y;
	int status;
	int *iptr;
};
char cbuf[40];
char cyl_s 'o';
char fc_s 'n';
int ttyname;
int scrlviewport[]{250, 10, 700, 1000};
int scrldefault[]{1010, 4, 4, 1010};
main(argc, argv)
char *argv[];
{
	register struct event *ep;
	register char *cp;
	register i;
	int piper[2];
	int pcomm;
	if(argc<2){
		printf("Arg count\n");
		exit();
	}
	if(pipe(piper)<0){
		printf("Can't create pipe\n");
		exit();
	}
	if((pcomm=fork()) == -1){
		printf("Can't fork\n");
		exit();
	}
	if(pcomm==0){
		close(0);
		dup(piper[0]);
		close(piper[1]);
		close(piper[0]);
		if(argc>2 && argv[1][0]=='-' && argv[1][1]=='b' && argv[1][2]=='\0')
			execl("/mnt/bill/play/pcomm", "pcomm", argv[1], argv[2], 0);
		else
			execl("/mnt/bill/play/pcomm", "pcomm", argv[1], 0);
		printf("Exec failed\n");
		exit();
	}
	close(piper[0]);
	if(init("gw", 2048, 1, 15, "fontf.k") < 0)
		{
		printf("prev: No Core\n");
		write(piper[1], "qu\n", 3);
		exit();
		}
	ttyname=ttyn(2);
	if(ttyname=='d')
		scroller(3, scrlviewport);
	gopen(TI_SEG);
	moveto(400., 180.);
	schars(14, "PLAYBACK");
	moveto(0., 263.);
	line(1023., 0.);
	move(0., -2.);
	line(-1023., 0.);
	move(0., -2.);
	line(1023., 0.);
	move(0., -2.);
	line(-1023., 0.);
	post(TI_SEG);
	gopen(TRK_SEG);
	moveto(512., 512.);
	line(-7., -0.);
	move(7., -7.);
	line(0., 14.);
	move(7., -7.);
	line(-7., 0.);
	gclose();
	track(TRK_SEG);
	activate(Z_AXIS_DOWN);
	tabsize(0);
	cmenu();
	for(;;){
		ep=get_event();
		if(ep->type==Z_AXIS_DOWN)
			switch(hitdetect(ep->x, ep->y)){
			case START:
				write(piper[1], "st\n", 3);
				remove();
				for(;;){
					ep=get_event();
					if(hitdetect(ep->x, ep->y)==STOP)
						break;
					printf("?\n");
				}
			case STOP:
				write(piper[1], "sp\n", 3);
				for(i=0;menu[i];i++)
					post(i+FIRSTMENUSEG);
				break;
			case CONTINUE:
				write(piper[1], "co\n", 3);
				remove();
				break;
			case STFRAME:
				printf("Start frame?");
				write(piper[1], stringf(cbuf, "sf %7d\n", rin()), 11);
				break;
			case ENDFRAME:
				printf("End frame?");
				write(piper[1], stringf(cbuf, "ef %7d\n", rin()), 11);
				break;
			case FPS:
				printf("Fps?");
				write(piper[1], stringf(cbuf, "fp %2d\n", rin()), 6);
				break;
			case FINCR:
				printf("Increment?");
				write(piper[1], stringf(cbuf, "fi %2d\n", rin()), 6);
				break;
			case CYCLE:
				if(cyl_s=='o'){
					cyl_s='n';
					menu[CYCLE]="Cycle off";
				}
				else{
					cyl_s='o';
					menu[CYCLE]="Cycle on";
				}
				write(piper[1], stringf(cbuf, "cf%c\n", cyl_s), 4);
				cmenu();
				break;
			case FCOUNTER:
				if(fc_s=='o'){
					fc_s='n';
					menu[FCOUNTER]="Frame counter off";
				}
				else{
					fc_s='o';
					menu[FCOUNTER]="Frame counter on";
				}
				write(piper[1], stringf(cbuf, "fl%c\n", fc_s), 4);
				cmenu();
				break;
			case SNAP:
				write(piper[1], "sn\n", 3);
				break;
			case EXIT:
				write(piper[1], "qu\n", 3);
				if(ttyname == 'd')
					scroller(3, scrldefault);
				exit();
			default:
				printf("?\n");
			}
	}
}
cmenu(){
	register i;
	for(i=0;menu[i];i++){
		gopen(FIRSTMENUSEG+i);
		moveto(25.+(i/3)*200., 50.+(i%3)*50.);
		chars(menu[i]);
		post(FIRSTMENUSEG+i);
	}
}
hitdetect(x, y){
	register i, t;
	/*
	 * Do dead space tests & (some) range checking,
	 * then convert (x, y) into a command using the inverse
	 * of the algorithm in cmenu.
	 */
	t=(y-25)%50;
	if(t<10 || t>40)
		return(-1);
	t=(x-25)%200;
	if(t<0 || t>150)
		return(-1);
	i=(y-25)/50;
	if(i<0 || i>=3)
		return(-1);
	return((x-25)/200*3+i);
}
remove(){
	register i;
	clear();
	post(TRK_SEG);
	post(TI_SEG);
	post(FIRSTMENUSEG+STOP);
}
