#


#include "../gpac.h"
#include "../error_codes.h"
#include "cv.h"

update()
	{
	register i, *addr, *a;
	int *array;
	int w_cnt, *nxt_seg;

	if(!Gfil_start)	/*  DO not clear on first update  */
		{
		w_cnt = CLEAR_COMMAND;
		write(Gdev_file, &w_cnt, 2);
		}
	   else
		Gfil_start = 0;
	if((i = alloc(Gmax_segs*2)) == -1)
		return(Gerror(ALLOC_ERR, "update"));
	array = i;
	for(i = 0; i < Gmax_segs; i++)
		array[i] = i+1;
	Gbubble(array, Gmax_segs);
	for(i = 0; i < Gmax_segs; i++)
		if((addr = Gseg_table[array[i]].start_address) && (Gpda_table[array[i]] & POST))
			{
			nxt_seg = Gnxt_seg(Gseg_table[array[i]].end_address);
			do
				{
				w_cnt = 0;
				for(a = addr+1; *a != TERM; a++)
					w_cnt++;
				write(Gdev_file, addr+1, w_cnt<<1);
				}  while((addr = Gnxt_blk(addr)) != nxt_seg);
			}
	w_cnt = UPDATE_COMMAND;
	write(Gdev_file, &w_cnt, 2);
	free(array);
	GOOD_RETURN;
	}


Gbubble(array, n)
	int *array;
	{
	register *arr;
	register *bound, *t;
	int temp;

	bound = array+n-1;
	do
		{
		t = 0;
		for(arr = array; arr < bound; arr++)
			if(Gdepth_table[*arr] > Gdepth_table[*(arr+1)])
				{
				temp = *arr;
				*arr = *(arr+1);
				*(arr+1) = temp;
				t = arr;
				}
		} while((bound = t) != 0);
	}
