#

#include "../gpac.h"
#include "../error_codes.h"
#include "tek.h"

#define GWSNAP "/usr/graf/stogw"
#define VPSNAP "/bin/opr"

snap(device)
	char *device;
	{
	register file, process;
	int fd[2];

	process = 0;
	switch(device[0] | device[1]<<8)
		{
		case 'nu' :
			if((file = creat("snap.out", 0644)) < 0)
				return(Gerror(OPEN_ERR, "snap.out"));
			break;
		case 'gw' :
		case 'vp' :
			if(pipe(fd) < 0)
				return(Gerror(OPEN_ERR, "snap-pipe"));
			file = fd[1];
			if((process = fork()) < 0)
				{
				close(fd[0]);
				close(fd[1]);
				return(Gerror(FORK_ERR, "snap"));
				}
			if(process == 0)
				{
				close(0);
				close(fd[1]);
				dup(fd[0]);
				switch(device[0] | device[1]<<8)
					{
					case 'gw' :
						execl(GWSNAP, "snap", 0);
						exit();
					case 'vp' :
						execl(VPSNAP, "snap", "-vp", "-t", 0);
						exit();
					}
				}
			close(fd[0]);
			break;
		default :
			if((file = creat(device, 0644)) < 0)
				return(Gerror(OPEN_ERR, device));
		}
	Gsnapout(file);
	close(file);
	if(process)
		wait(&fd[1]);
	return(process);
	}


Gsnapout(filed)
	int filed;
	{
	register i, w_cnt, *a;
	int *next_seg;
	int *addr;
	int arg, args[2];

	args[0] = STANDARD_FORMAT_MAGIC_NUMBER;
	for(i = 0; Gfont[i] != '\0'; i++);
	i = (i+2)>>1;
	args[1] = SET_FONT | i;
	write(filed, args, 4);
	write(filed, Gfont, i<<1);
	for(i = 1; i <= Gmax_segs; i++)
		if(addr = Gseg_table[i].start_address)
			{
			next_seg = Gnxt_seg(Gseg_table[i].end_address);
			do
				{
				w_cnt = 0;
				for(a = addr+1; *a != TERM; a++)
					w_cnt++;
				write(filed, addr+1, w_cnt<<1);
				} while((addr = Gnxt_blk(addr)) != next_seg);
			}
	args[0] = UPDATE_COMMAND;
	args[1] = END_OF_DATA_COMMAND;
	write(filed, args, 4);
	}
