#
char	*dargv[]{
	"/dev/root",
	"/dev/sys",
	"/dev/mnt",
	0
};
#define	NINODE	16*16
#include "/srce/usr/sys/ino.h"
#include "/srce/usr/sys/filsys.h"
struct	inode	inode[NINODE];
struct	filsys	sblock;
int	fi;
int	nifiles;
int	ino;
int	ndup;
int	nerror;
int	bmap[4096];
main(argc, argv)
char **argv;
{
	register char **p;
	register int n, *lp;
	if (argc == 1) {
		for (p = dargv; *p;)
			check(*p++);
	}
	else
		while (--argc) {
			argv++;
			check(*argv);
		}
	return(nerror);
}
check(file)
char *file;
{
	register *ip, i, j;
	fi = open(file, 0);
	if (fi < 0) {
		printf("cannot open %s\n", file);
		nerror =| 04;
		return;
	}
	printf("%s:\n", file);
	ndup = 0;
	for (ip = bmap; ip < &bmap[4096];)
		*ip++ = 0;
	sync();
	bread(1, &sblock, 512);
	nifiles = sblock.s_isize*16;
	for(i=0; ino < nifiles; i =+ NINODE/16) {
		bread(i+2, inode, sizeof inode);
		for(j=0; j<NINODE && ino<nifiles; j++) {
			ino++;
			pass1(&inode[j]);
		}
	}
	ino = 0;
	sync();
	bread(1, &sblock, 512);
	while(i = alloc())
		if (chk(i, "free"))
			break;
	if (ndup) {
		printf("%l dups in free\n", ndup);
		nerror =| 02;
	}
	j = 0;
	for(i=sblock.s_isize+2;i!=sblock.s_fsize;i++)
		if((bmap[(i>>4)&07777]&(1<<(i&017)))==0){
			printf("missing: %d\n", i);
			j++;
		}
	if (j)
		printf("%d blocks missing\n", j);
	close(fi);
}
pass1(aip)
struct inode *aip;
{
	int buf[256], vbuf[256];
	register i, j, *ip;
	ip = aip;
	if ((ip->i_mode&IALLOC) == 0)
		return;
	if ((ip->i_mode&IFCHR&IFBLK) != 0)
		return;
	if ((ip->i_mode&ILARG) != 0) {
		for(i=0; i<7; i++)
		if (ip->i_addr[i] != 0) {
			if (chk(ip->i_addr[i], "indirect"))
				continue;
			bread(ip->i_addr[i], buf, 512);
			for(j=0; j<256; j++)
			if (buf[j] != 0)
				chk(buf[j], "data (large)");
		}
		if (ip->i_addr[7]) {
			if (chk(ip->i_addr[7], "indirect"))
				return;
			bread(ip->i_addr[7], buf, 512);
			for(i=0; i<256; i++)
			if (buf[i] != 0) {
				if (chk(buf[i], "2nd indirect"))
					continue;
				bread(buf[i], vbuf, 512);
				for(j=0; j<256; j++)
				if (vbuf[j])
					chk(vbuf[j], "data (very large)");
			}
		}
		return;
	}
	for(i=0; i<8; i++) {
		if (ip->i_addr[i] != 0)
			chk(ip->i_addr[i], "data (small)");
	}
}
chk(ab, s)
char *ab;
{
	register char *b;
	register n, m;
	b = ab;
	if (b<sblock.s_isize+2 || b>=sblock.s_fsize) {
		printf("%l bad; inode=%l, class=%s\n", b, ino, s);
		return(1);
	}
	m = 1 << (b&017);
	n = (b>>4) & 07777;
	if (bmap[n]&m) {
		printf("%l dup; inode=%l, class=%s\n", b, ino, s);
		ndup++;
	}
	bmap[n] =| m;
	return(0);
}
alloc()
{
	register b, i;
	int buf[256];
	i = --sblock.s_nfree;
	if (i<0 || i>=100) {
		printf("bad freeblock\n");
		return(0);
	}
	b = sblock.s_free[i];
	if (b == 0)
		return(0);
	if (sblock.s_nfree <= 0) {
		bread(b, buf, 512);
		sblock.s_nfree = buf[0];
		for(i=0; i<100; i++)
			sblock.s_free[i] = buf[i+1];
	}
	return(b);
}
bread(bno, buf, cnt)
int *buf;
{
	register *ip;
	seek(fi, bno, 3);
	if (read(fi, buf, cnt) != cnt) {
		printf("read error %d\n", bno);
		for (ip = buf; ip < &buf[256];)
			*ip++ = 0;
	}
}
