#
char copr[] "Copyright (c) 1976 Thomas S. Duff";
/*
 * Speed: Filter to do lineprinter escapes & underscores w much speed
 * by minimising the number of carriage returns
 * since the dmr-klt lineprinter driver is so dumb.
 */
struct iobuf{
	int fdes;
	int count;
	char *cptr;
	char buff[512];
}inbuf;
#define LINESIZE 132
#define NLINES 2 /* should be a dynamic allocation */
char line[NLINES][LINESIZE];
int argc;
char **argv;
main(ac, av)
char *av[];
{
	extern struct iobuf fout;
	register c, column, i;
	fout.fdes=dup(1); /* Thank you klt */
	clear();
	column=0;
	argc=ac-1;
	argv=av+1;
	if(argc==0)
		inbuf.fdes=dup(0);
	else
		getfile();
	for(;;){
		switch(c=getc(&inbuf)){
		case -1:
			close(inbuf.fdes);
			getfile();
			break;
		case '\n':
			flushline('\n');
			column=0;
			break;
		case '\r':
			column=0;
			break;
		case '\t':
			column= (column+8)&~7;
			break;
		case ' ':
			column++;
			break;
		case '\b':
			--column;
			break;
		case '{':
			c='(';
			goto Escape;
		case '}':
			c=')';
			goto Escape;
		case '~':
			c='^';
			goto Escape;
		case '|':
			c='!';
			goto Escape;
		case '`':
			c='\'';
		Escape:
			if(0<=column && column<=LINESIZE){
				for(i=0;i!=NLINES;i++)
					if(line[i][column]==' '){
						line[i][column]='-';
						break;
					}
				if(i==NLINES){
					flushline('\r');
					line[0][column]='-';
				}
			}
		default:
			if(0<=column && column<=LINESIZE){
				for(i=0;i!=NLINES;i++)
					if(line[i][column]==' '){
						line[i][column]=c;
						break;
					}
				if(i==NLINES){
					flushline('\r');
					line[0][column]=c;
				}
			}
			column++;
			break;
		}
	}
}
clear(){
	register char *p;
	for(p=line;p != &line[NLINES][0];*p++=' ');
}
flushline(c){
	register i, j, nblanks;
	int needcr;
	needcr=0;
	for(i=0;i!=NLINES;i++){
		nblanks=0;
		for(j=0;j!=LINESIZE;j++){
			if(line[i][j]==' ')
				nblanks++;
			else{
				if(needcr){
					putchar('\r');
					needcr=0;
				}
				while(nblanks){
					putchar(' ');
					--nblanks;
				}
				putchar(line[i][j]);
			}
		}
		needcr++;
	}
	putchar(c);
	clear();
}
getfile(){
	for(;;){
		if(argc==0){
			flushline(0);
			flush();
			exit();
		}
		--argc;
		if(fopen(*argv++, &inbuf)<0)
			perror(argv[-1]);
		else
			break;
	}
}
