MODULE t8a4;

(* General arithmetic test case:

Quicksort - nonrecursive. Algorithm from A+DS=Programs, page 80.

*)

CONST n=20;   (* number of items to be sorted *)

TYPE item=RECORD
            key, value : integer
          END;
     index=integer;

VAR a : ARRAY 1:n OF item;
    i : integer;

PROCEDURE quicksort(VAR a : ARRAY integer OF item);
CONST m=12;
VAR i, j, l, r : index;
    x, w : item;
    s : integer;
    stack : ARRAY 1:m OF
              RECORD
                l, r : index
              END;
BEGIN
s:=1; stack[1].l:=1; stack[1].r:=high(a);
REPEAT
   l:=stack[s].l; r:=stack[s].r; dec(s);
   REPEAT
      i:=l; j:=r; x:=a[(l+r)/2];  (* / = DIV *)
      REPEAT
         WHILE a[i].key < x.key DO inc(i) END;
         WHILE x.key < a[j].key DO dec (j) END;
         IF i <= j THEN
            w:=a[i]; a[i]:=a[j]; a[j]:=w;
            inc(i); dec(j)
         END
      UNTIL i > j;
      IF i < r THEN
         inc(s); stack[s].l:=i; stack[s].r:=r
      END;
      r:=j
   UNTIL l >= r
UNTIL s = 0
END quicksort;

BEGIN
a[1].key:=3;  a[1].value:=2;
a[2].key:=2;  a[2].value:=1;
a[3].key:=5;  a[3].value:=3;
a[4].key:=11; a[4].value:=5;
a[5].key:=7;  a[5].value:=4;
a[6].key:=13; a[6].value:=6;
a[7].key:=19; a[7].value:=8;
a[8].key:=17; a[8].value:=7;
a[9].key:=23; a[9].value:=9;
a[10].key:=31; a[10].value:=11;
a[11].key:=29; a[11].value:=10;
a[12].key:=37; a[12].value:=12;
a[13].key:=43; a[13].value:=14;
a[14].key:=41; a[14].value:=13;
a[15].key:=47; a[15].value:=15;
a[16].key:=59; a[16].value:=17;
a[17].key:=57; a[17].value:=16;
a[18].key:=61; a[18].value:=18;
a[19].key:=71; a[19].value:=20;
a[20].key:=67; a[20].value:=19;
quicksort(a);
rewrite('a.tst');
writes('Expected:- 1234567891011121314151617181920'); newline;
writes('Obtained:- ');
i:=1;
WHILE i <= n DO
 writen(a[i].value);
   inc(i)
END; newline
END t8a4.
{
.bp
}
