; The use and distribution of the information
; contained herein may be restricted.
;
.iif	ndf	$list$	.nlist
title	sysa,<saint interpreter definitions>,24,26-jun-74,tph/jdm
;
;syntax analyzer - a set of operators used for many messy statements
;names of the micro-coded operators have following syntax:
;	[r][n][d][f][j]
;	      [v][i]
;	      [x][s]
;	        [e]
;	        [t]
;	or  c([b]
;	      [a]
;	      [t]
;	      [i]
;	      [s])
;the letters stand for:
;	a	any formula from input stream
;	b	the byte following
;	c	compile
;	d	data, i.e. an actual number or string
;	e	end of statement-cr,:,if,for,unless,while, until,then
;	f	floating
;	i	integer
;	j	jump to following location if satis.
;	n	not matching
;	r	read a new token
;	s	string
;	t	a token
;	v	variable
;	x	matrix variable
;there are a number of other operators without such regular names
;the names of the first set of operators is interpretable as follows:
;	1)  if r present, first read a new token
;	2)  n means the implied predicate is satisfied if three
;	    do not match; no match is attempted unless
;	    some character of the 4 the class is present
;	3)  if d present then insist that current token be actual data
;	    if v insist it be a variable
;	    if x insist it be an array
;	4)  if one of the fourth group occurs, the currrent token must
;	    be of that class
;	5)  if j is not present then a fatal error is caused by failure
;	    of the match; if j is present a branch to the location 
;	    which is given as the second argument will occur when the
;	    condition  is satisfied
;the names of the second set of operators is interpretable as "compile
;the indicated quantity".  in particular:
;	cb	compile the following byte--no effect on token pointer
;	ca	compile a formula from the input stream
;	ct	compile the current token (2 bytes)
;	ci	compile a formula and insist that it be integer - use
;		type comversion routine if possible.
;	cs	compile a string
;all calls to the formula compiler assume that the current token is
;the first in the formula and is one past the formula at return.
;for example:
;	t comma		means "error if not a comma" 
;	rs		means read a token, error if not a string
;	nvj loc		jump to "loc" if current token not a variable
;	rntj comma,loc	means read a token; if it is not a comma jump
;			to "loc"

;...;...;...;...;...;...;...;...
;   ;   ;   ;       ;       ;   
; r ; n ; j ; d v x ; f i s ; - 
;   ;   ;   ;   ;   ;   ;   ;   
;...;...;...;...;...;...;...;...
;r=200	n=100	j=40	d=10	f=2
;			v=20	i=4
;			x=30	s=6
;			   e=20
;			   t=10
; micro coded op defs
;some macros to do the work

	.macro	d0	name,value	;no args
	.macro	name
				.byte	value
	.endm
	.endm

	.macro	d1	name,value	;one abs arg
	.macro	name	q1
				.byte	value,q1
	.endm
	.endm

	.macro	d2	name,value	;one abs arg, one rel arg
	.macro	name	q1,q2
				.if	gt	q2-.-177
				.error	;address error
				.endc
				.if	lt	q2-.+200
				.error	;address error
				.endc
				.byte	value,q1,q2-.
	.endm
	.endm

	.macro	d4	name,value	;one rel arg
	.macro	name	q1
				.if	gt	q1-.-177
				.error	;address error
				.endc
				.if	lt	q1-.+200
				.error	;address error
				.endc
				.byte	value,q1-.
	.endm
	.endm
	d0	r,201
	d0	e,21
	d0	re,221
	d4	ej,61
	d4	nej,161
	d4	rej,261
	d4	rnej,361
	d0	s,7
	d0	ds,17
	d4	ndsj,157
	d0	rs,207
	d0	rds,216
	d4	rnsj,347
	d4	nsj,147
	d0	rvs,227
	d1	t,11
	d1	rt,211
	d1	nt,111
	d2	rtj,251
	d2	rntj,351
	d2	ntj,151
	d2	tj,51
	d4	vfj,63
	d4	nvfj,163
	d4	nvij,165
	d4	nvsj,167
	d4	rvfj,263
	d4	rxfj,273
	d4	xij,75
	d0	xi,35
	d0	xf,33
	d0	xs,37
	d4	rvsj,267
	d4	vij,65
	d0	vs,27
	d0	x,31
	d0	rx,231
	d0	rdi,215
; the macros defin - are
;used to define ops.
; *** beware of globals generated by macros ***
.sbttl	globals are generated by saint macros
.sbttl					

	.macro	d.fin0	name	;define op with no args
				.macro	name
				.byte	$'name
				.globl	$'name
				.endm
	.endm

	.macro	d.fin1	name	;one absolute arg
				.macro	name	q1
				.byte	$'name,q1
				.globl	$'name
				.endm
	.endm

	.macro	d.fin2	name	;one abs,one rel
				.macro	name	q1,q2
				.globl	$'name
				.if	gt	q2-.-177
				.error	;address error
				.endc
				.if	lt	q2-.+200
				.error	;address error
				.endc
				.byte	$'name,q1,q2-.
				.endm
	.endm

	.macro	d.fin3	name	;one relative arg
				.macro	name	q1
				.globl	$'name
				.if	gt	q1-.-177
				.error	;address error
				.endc
				.if	lt	q1-.+200
				.error	;address error
				.endc
				.byte	$'name,q1-.
				.endm
	.endm
	;d.fin0	sexit		;external jump
				.macro	sexit	q1
				.byte	$sexit
				.globl	$sexit
				.even
				.word	q1
				.endm
	;d.fin0	quitd		;return to machine code
				.macro	quitd
				.byte	$quitd
				.globl	$quitd
				.even
				.endm
	d.fin0	rcs		;read and compile string
	d.fin0	cs		;compile a string expression
	d.fin0	cn		;compile an expression for a number
	d.fin1	cb		;(byte) compile in-line byte
	d.fin0	cbs		;compile a byte from stack
	d.fin0	pt		;push token
	d.fin0	sarf		;set array flag for la
	d.fin3	calls		;subroutine call
	d.fin3	b		;location branch
	d.fin1	pbs		;(byte) push byte (use word) of stack
	d.fin0	tst1ai		;test & remove word from stack
	d.fin0	p0		;push zero
	d.fin0	ptype		;push type of toka
	d.fin0	quit		;leave via dogto3
	d.fin0	rci		;read and compile integer
	d.fin0	ci		;compile an integer expression
	d.fin3	copr		;(table) use value in tlcomr
	d.fin0	matcht		;
	d.fin0	quitn		;for statements not taking modifiers
	d.fin0	sharf		;set flag for la
	d.fin0	quits		;return from interp subr
	d.fin0	rints		;read and stack a constant - make fixed
	d.fin0	ca		;compile a formula
	d.fin0	c2of1		;compile byte from 2nd word of stack
	d.fin0	ccb		;close code block
	d.fin0	cf		;compile field left side a la tom e
	d.fin0	tc		;r1-aided type conversion a la tom e
	d.fin0	cfa		;compile field address
	d.fin0	cl		;compile left side (of let)
	d.fin1	sf		;set flag byte
	d.fin3	copt		;(table) compile one byte from table
	d.fin0	ct		;compile 2 bytes of token
	d.fin0	cw		;compile word from stack
	d.fin2	bfs		;branch on flags set
	d.fin2	bfc		;branch on flag clear
	d.fin0	arys		;

.iif	ndf	$list$	.list
