	.psect	.text.,con,shr
	.iif ndf mcexec,	.nlist
;the following macro causes assembly options to be
;printed on the loader map and any implications
;(second argument) to be defined.  options are
;selected by equating them to zero.
	.macro	ldrmap	mne,implies
	.if df	mne
	.list
;	.globl	mne
	.nlist
	.irp	x,<implies>
x=	0			;invoke implications
	.endm
	.endc
	.endm	ldrmap
;the following group enables functions
	ldrmap	pal11r,	<dosv4,	xmacro,	x40,	x45,	xedpic>
	ldrmap	pal11r,	<xedlsb,xedpnc,	xedlc,	xlcttm>
	ldrmap	pal11r,	<xzerr,	xreskb,	traps,	xcref>
	ldrmap	rsx11d,<dflgtb,yphase>	;rsx11d "features"
	ldrmap	debug		;debug version
	ldrmap	dosv4,<xrun,xtime>	;dos v4 compatible
	ldrmap	pdpv45		;pdp-11/45 instructions
	ldrmap	traps		;enable traps for calls
	ldrmap	dblbuf		;tran'd input
	ldrmap	yphase		;.phase/.dephas
	ldrmap	fixstk		;fixed stack location
;the following group disables functions
	.iif df	x40&x45,	xfltg=	0
	ldrmap	xbaw		;no bells and whistles
	ldrmap	xswit,xcref	;no switches
	ldrmap	xrel,xedpic	;abs output only
	ldrmap	xmacro,xsml	;all generated code (macro, rept, etc.)
	ldrmap	xsml		;system macros
	ldrmap	x40		;pdp-11/40 features
	ldrmap	x45		;pdp-11/45 features
	ldrmap	xfltg,xedfpt	;floating point evaluation
	ldrmap	xedabs		;ed.abs
	ldrmap	xedama		;ed.ama
	ldrmap	xedpic		;ed.pic
	ldrmap	xedfpt		;ed.fpt
	ldrmap	xedlsb		;ed.lsb
	ldrmap	xedpnc		;ed.pnc
	ldrmap	xedlc		;ed.lc
	ldrmap	xedcdr		;card reader format
	ldrmap	xzerr		;"z" errors
	ldrmap	xlcttm		;no lpt listing format
	ldrmap	xlcseq		;sequence numbers
	ldrmap	xcref,xrun	;cref suppression
	ldrmap	xrun		;no .run emt used
;	ldrmap	xreskb		;no resident kb
	ldrmap	xtime		;no time & date on header
	ldrmap	dflgtb		;?????????
;the following parameters can be modified
;at assembly time.
	.macro	param	mne,	value	;define default parameters
	.iif ndf mne,	mne=	value
	.list
mne=	mne
	.nlist
	.endm
	param	cpl,	80.	;characters per listing line
	param	lpp,	60.	;lines per page
	.if ndf	pal11r
	param	srclen,	132.	;source statement length
	.iff
	param	srclen,	84.
	.endc
linlen=	srclen
octlen=	^d<8*6>
lstlen=	octlen+linlen+1
	param	bpmb,	20	;bytes per macro block
	param	objlen,	42.	;object block length
	param	rldlen,	42.	;rld block length
	param	cmilen,	83.
	param	smllen,	80.
	param	crflen,	132.
	param	ttllen,32.		;title length
	param	stllen,64.		;sub-title length
	param	sysuic,	000401	;system uic [1,1]
tab=	11
lf=	12
vt=	13
ff=	14
cr=	15
space=	40
;the macro "call" is the equivalent of "jsr pc," and
;is used for simplicity.  the macro "return" is the
;equivalent of "rts pc".
	.macro	call	address
	jsr	pc,address
	.endm
	.macro	return
	rts	pc
	.endm
	.macro	putkb	addr	;list to kb
	mov	addr,r0
	call	putkb
	.endm
	.macro	putlp	addr	;list to lp
	mov	addr,r0
	call	putlp
	.endm
	.macro	putkbl	addr	;list to kb and lp
	mov	addr,r0
	call	putkbl
	.endm
	.macro	xmit	wrdcnt	;move small # of words
	call	xmit0-<wrdcnt*2>
	.endm	xmit
	.iif ndf mcexec,	.list
xcref=0
xbaw=0
xsml=0
xrun=0
