#include	<stdio.h>


/*
 *PARA [-d[symbol -dsymbol ... ] -o "directive ... " -t "title" -p -c] file ...
 *
 *FLAGS
 *	-d	Causes #ifdef, #ifndef, #else, #endif to be interpreted
 *		and if a symbol is given that symbol becomes a defined
 *		identifier.
 *
 *	-c	Produce C compileable code.
 *
 *	-o	Allows the entry of any number of the legal para directives,
 *		except the "t" directive.
 *
 *	-p	The output from para is sent to the printer instead of
 *		being printed on standard output.
 *
 *	-t	allows up to an 80 character title to be entered for the
 *		use of the "h" directive. NOTE=> Max length dependant on
 *		line length.
 *
 *PARA STANDARD FORMAT
 *
 *	1. 	Assignment operators are bracketted by spaces.
 *
 *	2. 	Binary operators (E.I. "binop") are bracketted by spaces if
 *		the line length permits.
 *
 *	3. 	Unary operators are closed up to their operands, if possible.
 *
 *	4. 	Function names in function calls are closed up to their
 *		parameter list.
 *
 *	5. 	The keywords :
 *				goto, if, else, for, do, while, switch, case
 *				and default
 *		are separated from the following expression or statement
 *		by a space.
 *
 *	6. 	The separators , ; are followed by a space.
 *
 *	7. 	Parentheses and square brackets are closed up to their
 *		contents.
 *
 *	8. 	Opening curly brackets are printed on a line by themselves,
 *		at the current indent level, and the statement list is
 *		indented by one more tab stop.
 *
 *	9. 	Close curly brackets change the indentation by one tab stop
 *		fewer, and are printed on a line by themselves.
 *
 *	10. 	Levels are shown whenever a curly bracket appears. The
 *		left level number refers to the newly entered level, the
 *		right level no. to the level ended.
 *
 *	11.	Case and default lines outdented 1, ':' followed by a new line.
 *
 *	12.	Break statement followed by a blank line.
 *
 *DIRECTIVES
 *	Para directives are input lines of the form	/*para dir1 dir2 ...*/
/*	Directives take the form	[sign]key
 *			      or	      key
 *	Where an optional sign is specified and no sign is given, the
 *	setting of the directive is reversed. Where no optional sign
 *	is specified, any actual sign will be ignored.
 *DIRECTIVES ARE :-
 *[sign]b	+ Print the block levels at the side of the program.
 *		- Directive is disabled.
 *
 *[sign]cp	+ print conditional code levels.
 *		- Directive is disabled.
 *
 *[sign]e	+ Maps exit(); to exit(0);.
 *		- Directive is disabled.
 *
 *[sign]fp	+ Each function is printed on a new page.
 *		- Directive is disabled.
 *
 *[sign]ft	+ Prints an index at the end listing the name and the
 *		  page number of all functions.
 *		- No index printed.
 *
 *[sign]ff	+ Form feed useing the form feed character.
 *		- Form feed useing carraige returns.
 *
 *[sign]h	+ Print a heading line at the beginning of every page.
 *		- Directive is disabled.
 *
 *[sign]i	+ Read #include files, noting defined symbols.
 *		- Directive is disabled.
 *
 *[sign]in      + Print any #include files read.
 *		- When reading #include files, do not print them.
 *
 *	l[1-9]	  Print 1-9 new lines.
 *
 *[sign]ln	+ print line numbers down the side of the page.
 *		- Directive is disabled.
 *
 *	lln	  Set line length to n characters . Max value is 132
 *		  (default to max). NOTE=> this effects the title length.
 *
 *	p	  Print a new page.
 *
 *	pln	  Set the page length to the integer n.(must be more than 3)
 *
 *[sign]pf	+ Enable para formatting.
 *		- Directive is disabled.
 *
 *[sign]pp	+ print para directives
 *		- Directive is disabled.
 *
 *[sign]s	+ Print spaces around binary operators.
 *		- Directive is disabled.
 *
 *	t" ... "  Enter up to an 80 character title for the use of the
 *		  "h" directive.
 */
/*para p*/
/* defines and macros */
#define	tabstop(l)	(8+l)-((8+l)%8)
#define	usage	"USAGE : para [-d[symbol -dsymbol ...] -o \"directive(s)\" -t \"title\" -p -c] file(s)"
#define	line	"\t\t-------------------------\n"
#define	tabhead	"\t\t: FUNCTION\tPAGE\t:\n"
#define	tab	'	'

/* define bit codes for c only directives */
#define	e	      01
#define	i	      02
#define	pp	      04
#define	pf	     010
#define	s	     020
#define	dt	     040
#define	an	    0100

/* define bit codes for printer only directives */
#define	b	      01
#define	cp	      02
#define	fp	      04
#define	ft	     010
#define	h	     020
#define	in	     040
#define	ln	    0100
#define	ff	    0200

/*define lexical symbols */
#define	eof	       0
#define	assop	       1
#define	binarop	       2
#define	colon	       3
#define	ccurly	       4
#define	comment	       5
#define	func	       6
#define	ident	       7
#define	illegal	       8
#define	keyword	       9
#define	newlin	      10
#define	number	      11
#define	ocurly	      12
#define	oparent	      13
#define	cparent	      14
#define	seper	      15
#define	specif	      16
#define	specop	      17
#define	osqbrac	      18
#define csqbrac	      19
#define	string	      20
#define	unaryop	      21
#define	structs	      22
#define	include	      23
#define	define	      24
#define	ifdef	      25
#define	ifndef	      26
#define	elses	      27
#define	endif	      28
#define	forsy	      29
#define	dosy	      30
#define	whilesy	      31
#define	ifsy	      32
#define	elsesy	      33
#define	breaks	      34
#define	typdef	      35
#define	exits	      36
#define switsy	      37
#define	strid	      38

/* initializations */

/*
 * initialize arrays containing the keywords.
 */
char	*keys[]{
	"goto",
	"return",
	"case",
	0},
	*spec[]{
	"auto",
	"static",
	"extern",
	"register",
	"int",
	"unsigned",
	"char",
	"float",
	"long",
	"double",
	"union",
	0},
	*therest[]{
	"sizeof",
	"struct",
	"#include",
	"#define",
	"#ifdef",
	"#ifndef",
	"#else",
	"#endif",
	"for",
	"do",
	"while",
	"if",
	"else",
	"break",
	"typedef",
	"exit",
	"switch",
	0};

/* declarations */

/*
 * these are all the global stuctures para uses to 
 * pass information between routines.
 */

struct	treen
/*
 * this is the structure which forms the nodes used
 * by def,found,funcent.
 */

{
	char	*nam;	/* name of node */
/*
 * 'type' is used by found to record the type of word found.
 * and used by funcent to record the page number on which the function occured.
 * and not used at all by def.
 */
	int	type;
	struct	treen	*l,*g;	/* pointer to greater and less subtrees */
};
typedef struct	treen	node;	/* makes definitions of nodes easier */
node	funcroot;	/* the root of the function tree */
node	defroot;	/* the root of the defined symbols tree */
node	keyroot;	/* the root of the keysymbol tree */
struct	inpout
/*
 * this structure is used for all large scale input and output.
 */
{
	int	sym,lsym,le,dent;	/* lsym is the last symbol, le is length of current symbol */
	char	*str,*fr,*ba;	/* pointer to current symbol string and front and back of current output string */
	FILE	*optr;		/* current output FILE */
};

/* storage arrays */
char	title[80],		/* array for storing title */
	file[24],		/* array for storing name of current input file */
	*thetime,	/* array for storing the time when para was called */
	*workf	0,	/* pointer workbuf */
	*lpr	0,	/* pointer to lpbuf */
	workbuf[14]	"/tmp/paXXXXX",	/* array for storing name of current workfile */
	lpbuf[14]	"/tmp/paXXXXX",	/* array for the lpr work file */
	funchd[]	/* array of the name for the page containing the function table */
	{"function table"};

/* counters */
int	pagenum,linec,	/* the page count and line count for "page()" */
	blevel	0,	/* for counting block levels */
	linenum	0,	/* for counting the total number of lines in the program */
	wcount	0;	/* wcount for monitoring length of lines */
int	llength	120,	/* 132characters - 12 for line no.s and block levels */
	plength	57,	/* 60 lines -3 for heading and spaces */
	delta	8;	/* delta increment for indentation */
int	indent	0,	/* counts the indent level */
	topdent	0;	/* the point at which a workfile is opened */

/* flags */
int	oblock	0,	/* block flag */
	cblock	0,	/* block flag */
	backup	0,	/* flag whether to backup */
	nodent	0,	/* flags a line to be printed without indentation */
	cdef	0,	/* flags whether to interpret #ifdefs etc. */
	macro	0,	/* flags whether a macro was just defined */
	binar	0,	/* flag if ':' is binary op */
	cond	0;	/* flags if conditional code */
int	lpdir	0177777,	/* printer only directives bit pattern */
	cdir	0177777;	/* c compilable directives bit pattern */

/* and finally SPECIALS */
FILE	*outf;		/* standard output file */

main(c,v)
char	**v;
int	c;
/*
 * main program cracks the parameters and calls the appropriate
 * functions to deal with them. It checks to see that all the files
 * available then calls handler for each file.
 */
{
	register	int	tempc;	/* pointers so as not to destroy args */
	register	char	**tempv;
	char	buff[36];	/* checking permissions */
	int	tc;
	char	**tv;
	int	oldir,ass	0;	/* flag if assembler file and temp save for cdir */

	strcpy(file,*v);	/* set file name to called file */
	thetime = ijtime(time());	/* get the time for later use */
	outf = stdout;	/* default at standard output */
	tempc = c; tempv = v;
	while(--tempc && **(++tempv) == '-')
	{
		switch(*(++(*tempv)))
		{
		case 'd':
		case 'D':
			cdef = 1;
			if(*(++(*tempv))) ent(&defroot,*tempv,1);	/* enter the symbol(if there) into the def table */
			break;

		case 'o':
		case 'O':
			if(!--tempc) error(usage);
			dir(*(++tempv),outf);
			break;

		case 't':
		case 'T':
			if(!--tempc) error(usage);
			strcpy(title,*(++tempv));
			break;

		case 'p':
		case 'P':
			fclose(outf);	/* close last file */
			lpr = mktemp(lpbuf);
			if(!(outf=fopen(lpr,"w"))) error("can't create temp file");
			break;

		case 'c':
		case 'C':
			llength =+ 12;	/* because b,cp & ln are off Z*/
			lpdir = 0;	/* set print directives to '-' */
			break;

		case '\0':
			--(*tempv);	/* reset pointer to '-' */
			goto getout;
			break;
		default:
			error(usage);
		}
	}
getout:
	if(!tempc) error(usage);
	tc = tempc;
	tv = tempv;
	while(tc--)
		if(strcmp(*tv,"-"))
			if(access(*tv++,0100004))	/* see if file readable */
	 			perror(*(--tv));	/* error message if not readable */
	init();	/* initialize everything */
	tc = tempc;	/* for checking if first file */
	while(tempc--)
	{
		if(**tempv == '-')
			strcpy(file,"stdin");
		else
			strcpy(file,*tempv);	/* set current file name */
		page(tempc==tc-1);
		if( cdir & an &&(ass = check(*tempv)))
		{
			oldir = cdir;
			cdir =& ~pf;
		}
		if(**tempv == '-')
		{
			tempv++;
			handler(stdin,outf);
		}
		else
			fclose(handler(fopen(*(tempv++),"r"),outf));
		if(ass)
		{
			ass = 0;
			cdir = oldir;
		}
	}
	if(lpdir&ft)
	{
		strcpy(file,funchd);
		page(0);
		if(*(funcroot.nam) == '\0') fputs("\tNO FUNCTIONS ENTERED\n",outf);
		else
		{
			fputs(line,outf);
			fputs(tabhead,outf);
			fputs(line,outf);
			print(&funcroot);
			fputs(line,outf);
		}
	}
	fclose(outf);	/*tidy up*/
	if(lpr) execl("/bin/lpr","lpr","-r",lpr,0);
}

init()
/*
 * initializes the keyword tree.
 */
{
	register	count;
	register	char	**tpnt;

	*(funcroot.nam) = '\0';
	*(keyroot.nam) = '\0';
	*(defroot.nam) = '\0';
	tpnt = keys;
	while(**tpnt != '\0') ent(&keyroot, *tpnt++, keyword);
	tpnt = spec;
	while(**tpnt != '\0') ent(&keyroot, *tpnt++, specif);
	tpnt = therest;
	for(count = 0; **tpnt != '\0'; count++) ent(&keyroot, *tpnt++, count+21);
}

error(st)
char	*st;
/*
 * simply writes the passed string onto stderr.
 */
{
	fputs(st,stderr);
	putc('\n',stderr);	/* put a new line */
	unlink(lpr);
	unlink(workf);	/* tidy up */
	exit(1);
}

int	errno;
int	sys_nerr;
char	*sys_errlist[];
perror(name)
char	*name;
/*
 * this function uses system generated error messages.
 */
{
	register	char	*cha;

	cha = "unknown error";
	if(errno < sys_nerr)
		cha = sys_errlist[errno];
	fputs("para: ",stderr);
	fputs(name,stderr);
	putc(' ',stderr);
	fputs(cha,stderr);
	putc('\n',stderr);
	unlink(lpr);
	unlink(workf);	/* tidy up */
	exit(1);
}

check(name)
char	*name;
/*
 * searches the passed name for the suffix '.s'
 */
{
	while(*name != '.' && *name != '\0') name++;
	if(*name++ == '.' && *name++ == 's' && *name == '\0')
		return(1);
	else
		return(0);
}

handler(iptr,optr)
FILE	*iptr,*optr;
/*
 * main function.
 * this function does the actual lexical analyses
 * decides what to do with everything.
 */
{
	struct	inpout	io;
	char	linbuf[132];	/* the line buffer */
	char	lbuf[16],fbuf[16];	/* buffer for logical exppressions and function names */
	char	*lpnt,*funcs	0;	/* pointers to the buffers */
	FILE	*tptr;	/* a temporary pointer */
	int	parent	0;	/* count the parenthesis */
	char	logical	0,	/* flag logical statements */
		dos	0,	/* count the dos */
		end	0,	/* flag end of statement */
		specs	0,	/* flag specifiers */
		one	0,	/* flag the use of a close parent */
		specifs	0;	/* flag a specification block */

	lpnt = lbuf;
	io.dent = 0;
	wcount = indent * delta;	/* add the indent length to the word length */
	io.ba = io.fr = linbuf;	/* synchronize pointers */
	io.optr = optr;	/* set it's idea of the current output file */
	while(readsym(iptr,&io))
	{
		switch(io.sym)
		{
		case comment:
				if(io.lsym == seper) --io.ba;	/* get past the space */
				if((io.lsym == seper || io.lsym == cparent || io.lsym == csqbrac) && cdir&pf)
				{
					*(io.ba)++ = tab;
					io.le =+ 8-(wcount % 8);
				}
				testl(&io);
				break;

		case illegal:
		case specop:
		case osqbrac:
		case csqbrac:
				if (!specs && specifs && cdir&pf)
				{
					put(&io);
					specifs = 0;
				}
				testl(&io); /* check string length */
				break;

		case number:
				funcs = 0;
				if(specs &&(io.lsym == ident || io.lsym == csqbrac)) *(io.ba)++ = tab;
				testl(&io); /* check string length */
				break;

		case ident:
				if(!specs && specifs && cdir & pf)
				{
					put(&io);
					specifs = 0;
				}
				if(io.lsym == define && cdir & dt) def(&io);
				testl(&io);
				if(io.lsym == structs)
				{
					key(io.str,io.le,strid);
					specs = 0;	/* a structure definition follows */
					if(cdir&pf)
					{
						*(io.ba)++ = tab;
						wcount =+ 8-(wcount%8);
					}
				}
				break;

		case string:
				if(io.lsym == include)
				{
					testl(&io);
					if(cdir&pf) put(&io);	/* new line afterwards */
					if(cdir & i)
						if(lpdir & in)
						{
							char	*tpnt1;
							char	tfil[24];	/* a temporay pointer and buffer */

							tpnt1 = file;
							strcpy(tfil,file);	/* save the current name */
							if(*(io.str)++ ==  '<')
							{
								strcpy(tpnt1,"/usr/include/");
								while(*(++tpnt1));
							}
							while((*tpnt1 = *io.str++) !='"'&&*tpnt1!='>') tpnt1++;
							*tpnt1 = '\0';
							linec =+ 3;
							if(linec < plength) fputs("\n\n\n",outf);
							if(!(tptr = fopen(file,"r"))) perror(file);
							fclose(handler(tptr,io.optr));
							strcpy(file,tfil);	/* get the original name back */
							page(0);	/* new page afterwards */
						}
						else
							if(cdef)	search(io.str);
				}
				else
				{
					if(io.lsym == csqbrac && cdir & pf)
					{
						wcount =+ 8 - (wcount % 8);
						*(io.ba)++ = tab;
					}
					testl(&io);
				}
				break;

		case oparent:
				parent++;
				testl(&io);
				break;

		case cparent:
				if(--parent == 0 && macro && cdir&pf) io.le = 8;	/* allow for tab */
				testl(&io);
				if(io.le == 8)	/* only occurs when previous 'if' true */
				{
					funcs = 0;
					*(io.ba)++ = tab;
					macro = 0;
				}
				else
					if(!parent && logical && !one && cdir & pf)
					{
						io.le++;
						one++;
						*(io.ba)++ = ' ';
					}
				break;

		case ifsy:
				if(!specs && specifs && cdir & pf)
				{
					put(&io);
					specifs = 0;
				}
				funcs = 0;
				one = 0;
				if(logical&&cdir&pf)
				{
					*(io.ba)++ = tab;	/* if lots on one line */
					wcount =+ 8-(wcount%8);
				}
				*++lpnt = 0;	/* make sure it's 0 */
				*lpnt =| 0100;	/* flag the if */
				*lpnt =| io.dent+logical;	/* remember present indent */
				logical++;
				io.le++;
				testl(&io);
				if(cdir&pf) *(io.ba)++ = ' ';	/* add trailing space */
				break;

		case switsy:
		case forsy:
				if(!specs && specifs && cdir & pf)
				{
					put(&io);
					specifs = 0;
				}
				funcs = 0;
				one = 0;
				if(logical&&cdir&pf)
				{
					*(io.ba)++ = tab;	/* if lots on one line */
					wcount =+ 8-(wcount%8);
				}
				*++lpnt = 0;	/* make sure it always points to 0 */
				*lpnt =| io.dent+logical;	/* remember present indent */
				logical++;
				io.le++;
				testl(&io);
				if(cdir&pf) *(io.ba)++ = ' ';	/* add trailing space */
				break;

		case elsesy:
				funcs = 0;
				one = 0;
				if(logical&&cdir&pf)
				{
					*(io.ba)++ = tab;	/* if lots on one line */
					wcount =+ 8-(wcount%8);
				}
				while(lpnt != lbuf &&!(*lpnt&0100)) lpnt--;
				io.dent = (*lpnt--^0100)&077;
				logical++;
				io.le++;
				testl(&io);
				if(cdir&pf) *(io.ba)++ = ' ';	/* add trailing space */
				break;

		case dosy:
				if(!specs && specifs && cdir & pf)
				{
					put(&io);
					specifs = 0;
				}
				funcs = 0;
				one = 0;
				if(logical&&cdir&pf)
				{
					*(io.ba)++ = tab;	/* if lots on one line */
					wcount =+ 8-(wcount%8);
				}
				*++lpnt = 0;	/* make sure it always points to 0 */
				*lpnt =| io.dent+logical;	/* remember present indent */
				logical++;

				dos++;
				io.le++;
				testl(&io);
				if(cdir&pf) *(io.ba)++ = ' ';	/* add trailing space */
				break;

		case whilesy:
				if(!specs && specifs && cdir & pf)
				{
					put(&io);
					specifs = 0;
				}
				funcs = 0;
				one = 0;
				if(logical&&cdir&pf)
				{
					*(io.ba)++ = tab;	/* if lots on one line */
					wcount =+ 8-(wcount%8);
				}
				if(dos)
					dos--;
				else
				{
					logical++;
					*++lpnt = 0;	/* make sure it always points to 0 */
					*lpnt =| io.dent+logical;	/* remember present indent */
				}
				io.le++;
				testl(&io);
				if(cdir&pf) *(io.ba)++ = ' ';	/* add trailing space */
				break;

		case include:
		case define:
				funcs = 0;
				specifs = 0;
				if(io.fr != io.ba && cdir&pf) put(&io);	/* force printing on a new line */
				nodent++;	/* force printing with no indentation */
				io.le =+ 8-(io.le%8);
				testl(&io); /* check string length */
				if(cdir&pf) *(io.ba)++=tab;
				break;

		case structs:
		case specif:
				specifs++;
				specs++;
				if(io.lsym != ident && io.lsym != specif && io.lsym != structs)
					if(io.ba != io.fr && cdir&pf)
						put(&io);
				testl(&io); /* check string length */
				if(cdir & pf)
				{
					wcount =+ 8-(wcount%8);
					*(io.ba)++=tab;
				}
				break;

		case assop:
				io.le++;
				if(cdir&pf) *(io.ba)++ = ' ';	/* print a leading space */
		case keyword:
		case seper:
				if(!parent) funcs = 0;
				io.le++;
				testl(&io); /* seperators are all one character */
				if(*(io.str) == ';')
					if(((io.dent || logical)&& !parent) || specs) end = 1;	/* if end of statement */
					else
						if(lpnt != lbuf && !io.dent && !parent)
							lpnt = lbuf;
				if(cdir&pf) *(io.ba)++ = ' ';	/* add trailing space */
				break;

		case exits:
				if(cdir & e)
				{
					testl(&io);
					if(readsym(iptr,&io))
						if(io.sym == oparent)
						{
							testl(&io);
							if(readsym(iptr,&io))
								if(io.sym == cparent)
									*(io.ba)++ = '0';
						}
				}
				testl(&io);
				break;

		case func:
				if(!specs && specifs && cdir & pf)
				{
					put(&io);
					specifs = 0;
				}
				if(io.lsym == define && cdir & dt) def(&io);
				else
					if((io.ba == io.fr && !indent)|| io.lsym == specif || io.lsym == specop)
					{
						funcs = fbuf;
						strcpy(fbuf,io.str);
					}
				testl(&io); /* check string length */
				break;

		case ifdef:
		case ifndef:
		case elses:
		case endif:
				funcs = 0;
				if(io.fr != io.ba && cdir&pf) put(&io);	/* print on new line */
				if(cdef) if(checkde(&io,iptr)) return(io.sym);
				if(!cdef)
				{
					nodent++;	/* force printing without indentation */
					testl(&io);
					if(cdir&pf) *(io.ba)++=tab;
				}
				break;

		case breaks:
				if(!logical && io.fr != io.ba && cdir&pf) put(&io);	/* force printing on new line */
				testl(&io);
				if(cdir&pf)
				{
					if(readsym(iptr,&io)) testl(&io);
					end = 1;
					put(&io);
					put(&io);	/* put a newline after a break */
				}
				break;

		case colon:
				funcs = 0;
				indent--;	/* set indent back one level */
				testl(&io);
				if(cdir & pf) put(&io);	/* write a new line */
				indent++;	/* reset indent */
				break;

		case newlin:
				if(funcs)
				{
					funcs = 0;
					specs = 0;
					if(linec && lpdir & fp) page(0);
					if(lpdir & ft) funcent(fbuf,strlen(fbuf));
				}
				if(cdir&pf)
				{
					if(io.fr != io.ba)	/* if there is something other than just a new line to write do it */
						if(io.lsym != include && io.lsym != define && io.lsym != specif &&
						io.lsym != structs && io.lsym != typdef)
							put(&io);	/* no newlines after these symbols */
					if(end)
					{
						logical = 0;
						io.dent = 0;
						end = 0;
						specs = 0;
					}
					else
						if(logical && !parent)
						{
							io.dent =+ logical;
							logical = 0;
						}
					if(specs) io.dent = specs;
				}
				break;

		case binarop:
				funcs = 0;
				if(cdir&pf && cdir&s)
				{
					io.le =+ 2;
					*(io.ba)++ = ' ';
				}
				testl(&io);
				if(cdir&pf && cdir&s) *(io.ba)++ = ' ';
				break;

		case unaryop:
				funcs = 0;
				if((io.lsym == unaryop || io.lsym == binarop) && *(io.str) != 's' && cdir&pf)
				{
					io.le++;
					*(io.ba)++ = ' ';	/* write a space if last symbol was a unary op */
				}
				if(io.str == 's') io.le++;
				testl(&io);
				if(*(io.str) == 's' && cdir&pf) *(io.ba)++ = ' ';	/* write a space if 'sizeof' */
				break;

		case ocurly:
				if(funcs)
				{
					funcs = 0;
					specs = 0;
					if(linec && lpdir & fp) page(0);
					if(lpdir & ft) funcent(fbuf,strlen(fbuf));
				}
				if(io.fr != io.ba && cdir&pf) put(&io);
				parent = 0;	/* no parenthesis around '{' */
				if(!specs) end = 1;	/* the end of any statement */
				if(io.dent) io.dent--;
				testl(&io);
				oblock++;	/* flag that a block was opened */
				if(cdir & pf) put(&io);
				if(++indent == llength/delta/2 && cdir&pf)
				{
					workf = mktemp(workbuf);
					if(!(io.optr = fopen((workf),"w"))) error("Can't make work file");
					topdent = llength/delta/2;	/* set the point at which entered */
				}
				indent =+ io.dent;
				handler(iptr,io.optr);
				if(cdir&pf) io.ba = io.fr;
				indent =- io.dent;
				if(optr != io.optr)
				{
					workout(io.optr);
					fclose(io.optr);
					unlink(workf);
					workf = 0;
					topdent = 0;
					io.optr = optr;	/* reset pointer */
				}
				break;

		case ccurly:
				if(io.fr != io.ba && cdir & pf) put(&io);
				cblock++;	/* flag that a block has been closed */
				indent--;
				io.dent = 0;
				testl(&io);
				if(cdir & pf) put(&io);
				return(iptr);
				break;

		case typdef:
				if(io.fr != io.ba && cdir&pf) put(&io);
				specs++;
				specifs++;
				io.le =+ 8-(io.le%8);
				testl(&io);
				if(cdir&pf) *(io.ba)++ = tab;
				while(readsym(iptr,&io) && (io.sym == specif || io.sym == structs || io.sym == newlin))
				{
					io.le =+ 8-(io.le%8);
					testl(&io);
					if(cdir&pf) *(io.ba)++ = tab;
				}
				if(io.sym == ident) key(io.str,io.le,specif);
				testl(&io);
		}
	}
	return(iptr);
}

testl(io1)
struct inpout *io1;
/*
 * checks line length and copies the new
 * string to the output buffer.
 */
{
	register	char	*pnt;

	if(cdir&pf)	/* if para formatting go ahead */
	{
		if((wcount=+ io1->le) >llength)
			if(workf)	/* if using a workfile */
				backup++;
			else
			{
				if(io1->fr != io1->ba) put(io1);
				wcount =+ io1->le;	/* set new length */
			}
		pnt = io1->str;		/* set temporary pointer */
		while(*pnt) *(io1->ba)++ = *pnt++;
	}
}

def(io)
struct	inpout	*io;
/*
 * this function enters a word into the defined symbols tree
 * and appends a tab to the end of the symbol.
 */
{
	register	char	*tpnt,*tpnt1;
	char	*p1;

	if((p1 = tpnt = calloc(1,io->le+2)) == 0) error("define table overflow");
	tpnt1 = io->str;
	while(*tpnt++ = *tpnt1++);
	ent(&defroot,p1,1);
	if(io->sym != func)
	{
		*(--tpnt1) = tab;	/* if not a macro write a tab afterwards */
		io->le =+ 8-(io->le%8);
		*(++tpnt1) = '\0';
	}
	else	macro++;		/* flag the macro */
}

key(p1,p2,type)
register	char	*p1;
int	p2,type;
/*
 * enters an identifier into the keyword table
 */
{
	char	*tpnt,*tpnt1;

	if((tpnt1 = tpnt = calloc(1,p2+2)) == 0) error("specifier table overflow");
	while(*tpnt++ = *p1++);
	ent(&keyroot,tpnt1,type);
}

tree(root,new)
node	*root,*new;
/*
 * iteratively enters the new node 'new' into the tree
 * pointed to by 'root'.
 */
{
	int	cmp;

	if(*(root->nam) == '\0')	/* if nothing assigned to root yet then new is a roo t*/
	{
		root->nam = new->nam;
		root->l = root->g = 0;
		root->type = new->type;
	}
	else
		while(new)
			if((cmp = strcmp(root->nam,new->nam)) > 0)
				if(root->l)	root = root ->l;	/* search left subtree */
				else
				{
					root->l = new;	/* put new as the new subtree */
					new = 0;	/* flag node placed */
				}
			else
				if(!cmp) return(1);	/* if equal */
				else
					if(root->g)	root = root->g;	/* search the right subtree */
					else
					{
						root->g = new;
						new = 0;
					}
	return(0);
}

node	*stree(str,root)	/* function returns pointer node containing samme string */
char	*str;
node	*root;
/*
 * searches the given tree 'root' for a node containing the 
 * string 'str' and returns a pointer to that node.
 */
{
	int	cmp;

	while(root)
		if((cmp = strcmp(root->nam,str)) > 0) root = root->l;	/* search left subtree */
		else	if(cmp) root = root->g;	/* search right subtree */
			else	return(root);
	return(0);
}

print(root)
node	*root;
/*
 * used to print the function table...RECURSIVE...
 */
{
	if(root)	/* if not nill */
	{
		print(root->l);
		fprintf(outf,"\t\t: %s\t",root->nam);
		if(strlen(root->nam) < 6)	putc(tab,outf);
		fprintf(outf,"  %d\t:\n",root->type);
		print(root->g);
	}
}

ent(root,pnt,ty)
node	*root;
char	*pnt;
int	ty;
/*
 * creates anew node using calloc and enters the node into
 * the tree pointed to by 'root'.
 */
{
	node	*new;	/* used to allocate free space */

	if((new = calloc(1,8)) == 0) error("table overflow");
	new->l = new->g = 0;	/* set pointers to nil */
	new->type = ty;
	new->nam = pnt;
	tree(root,new);
}

funcent(pnt,le)
char	*pnt;
int	le;
/*
 * same as above but only for functions.
 */
{
	node	*new;	/* used to allocate free space */
	char	*tpnt,*tpnt1;	/* for copying string across */

	if((tpnt1 = tpnt = calloc(1,le+2)) == 0) error("table overflow");
	while(*tpnt++ = *pnt++);
	if((new = calloc(1,8)) == 0) error("table overflow");
	new->l = new->g = 0;	/* set pointers to nil */
	new->type = pagenum;
	new->nam = tpnt1;
	tree(&funcroot,new);
}

put(io1)
struct	inpout	*io1;
/*
 * writes the line of output and prints the pretty bits.
 */
{
	if(io1->fr == io1->ba)
	{
		nodent++;
		*(io1->ba)++ = '\n';
		*(io1->ba) = '\0';
	}
	else
	{
		while(*(--(io1->ba)) == ' ' || *(io1->ba) ==  tab);
		*(++(io1->ba)) = '\n';	/* put the new line */
		*(++(io1->ba)) = '\0';	/* and null terminate */
	}
	if(!workf) format(io1->dent);	/* if not a work file add the formatting */
	else
	{
		putc('0'+oblock,io1->optr);
		oblock = 0;	/* reset it */
		putc('0'+cblock,io1->optr);
		cblock = 0;	/* reset it */
		putc('0'+cond,io1->optr);	/* flag if conditional code */
		if(nodent)
		{
			putc('0',io1->optr);	/* write 0 indentation */
			nodent = 0;		/* turn off flag */
		}
		else putc('0'+indent+io1->dent,io1->optr);	/* write the indent level of this line */
	}
	fputs(io1->fr,io1->optr);	/* write the string */
	io1->ba = io1->fr; 	/* reset pointers */
	wcount = indent*delta;	/* and reset word count to 0 */
}

format(exdent)
int	exdent;
/*
 * generates the line numbers, blocklevels and indentation
 * for a given line and writes it to outf.
 */
{
	int	count;

	linenum++;	/* count number of lines printed */
	if(++linec >= plength) page(0);
	if(lpdir & ln) fputs(conv(linenum),outf);	/* write line numbers */
	if(lpdir & b)		/* write block levels */
	{
		putc(' ',outf);	/* write a leading space */
		if(oblock)	/* if a block entered */
		{
			putc('0'+blevel%10,outf);
			oblock = 0;
			blevel++;
		}
		else putc('-',outf);	/* default at a minus sign */
		if(cblock)			/* if leaving a block */
		{
			blevel--;
			putc('0'+blevel%10,outf);
			cblock = 0;
		}
		else putc('-',outf);
		putc(' ',outf);
	}
	if(lpdir&cp && cdef)	/* if i print cond flags */
	{
		if(cond) putc('0'+cond,outf);
		else putc('-',outf);
		putc(' ',outf);
	}
	if(!nodent && cdir &pf)
	{
		if(delta != 8)
			for(count=0;count++<(indent+exdent)*delta;) putc(' ',outf);	/* if not tab then just write spaces */
		else
		{
			for(count=0;count<llength/16+2&&count++<indent+exdent;) putc(tab,outf);
			for(;count<indent+exdent;count++) putc(' ',outf);
		}
	}
	else nodent = 0;
}

conv(cter)
int	cter;
/*
 * conv an integer to a 4 digit line number E.G. '0001'.
 */
{
	static	char	buf[7];
	register	char	*bpnt;

	buf[7] = '\0';	/* null terminate it */
	buf[6] = ' ';	/* write a space after the line number */
	bpnt = &buf[5];
	while(bpnt != buf)
	{
		*bpnt-- = '0' + cter % 10;
		cter =- cter % 10;
		cter =/ 10;
	}
	*bpnt = ' ';
	return(bpnt);
}

workout(optr)
FILE	*optr;
/*
 * writes a workfile to outf.
 */
{
	int	tind,tcon,	/* temporary safe keeping for indent */
		back	0;	/* how much to back up */
	char	buff[132],*tbp;	/* buffer for reading the workfile */

	if(!freopen(workf,"r",optr))	perror(workf);
	tind = indent;	/* safe gaurd present indent level */
	indent = 0;
	tbp = buff;	/* get head of buffer */
	if(backup)
	{
		backup = 0;	/* reset flag */
		back = topdent;	/* back up half way */
		format(0);	/* count as line */
		fputs("/*",outf);
		for(tcon=llength-4;tcon--;) putc('<',outf);	/* write pretty line */
		fputs("*/\n",outf);
	}
	tcon = cond;
	while(fgets(tbp,llength,optr))
	{
		oblock = *tbp++ - '0';
		cblock = *tbp++ - '0';
		cond = *tbp++ - '0';
		indent = *tbp++ - '0' - back;
		if(backup && indent+back < topdent)
		{
			indent =+ back;
			format(0);	/* count as line */
			fputs("/*",outf);
			for(back = llength-4;back--;) putc('>',outf);
			fputs("*/\n",outf);
		}
		format(0);
		fputs(tbp,outf);
		tbp = buff;
	}
	oblock = cblock = 0;
	indent = tind;	/* reset correct indent level */
	cond = tcon;
	topdent = 0;	/* reset dentation back up */
}

page(flag)
int	flag;
/*
 * writes a new page and the associated heading if needed.
 */
{
	register	char	*tb;	/* a quick pointer */
	register	int	count,t;	/* some quick pointers */

	pagenum++;		/* increment page count */
	if(!flag)
		if(lpdir&ff) putc('\014',outf);	/* a form feed */
		else
			for(count=0;count++<plength - linec;) putc('\n',outf);
	if(lpdir&h)
	{
		putc(' ',outf);
		count = 0;
		tb = file;
		while(*tb && count++<16)
			putc(*tb++,outf);
		while(count++<17) putc(' ',outf);
		tb = thetime;	/* get the time */
		while(*tb != '\n') putc(*tb++,outf);
		fputs("  ",outf);
		tb = title;
		count = 0;
		while(*tb && count < llength-52)
		{
			putc(*tb++,outf);
			count++;
		}
		count = llength-count-52;
		t = count % 8;
		count =/ 8;
		while(count--) putc('	',outf);
		while(t--) putc(' ',outf);
		fprintf(outf," page %d.\n\n",pagenum);
	}
	linec = 0;	/* reset the line counter */
}

dir(str,optr)
char	*str;
FILE	*optr;
/*
 * dir interprets para directives.
 */
{
	int	toggle;
	register	char	*tpt;

	while(*str)
	{
		while(*str == tab || *str == ' ') ++str;
		if(*str == '+')
		{
			toggle = 1;	/* flag to switch on */
			str++;		/* get past the '+' */
		}
		else
			if(*str == '-')
			{
				toggle = -1;	/* flag off */
				str++;
			}
			else toggle = 0;	/* flag to toggle */
		switch(*str)
		{
		case 'a':
			if(*(++str) == 'n')
				if(toggle < 0)
					cdir =& ~an;
				else
					if(toggle > 0)
						cdir =| an;
					else
						cdir =^ an;
			break;

		case 'b':
			if(toggle < 0)	if(lpdir&b)
					{
						lpdir =& ~b;	/* turn it off */
						llength =+ 4;	/* reset llength */
					}
			if(toggle > 0)	if(!(lpdir&b))
					{
						lpdir =| b;
						llength =- 4;
					}
			if(!toggle)
			{
				lpdir =^ b;
				if(lpdir&b) llength =- 4;
				else llength =+ 4;
			}
			break;

		case 'c':
			if(*(++str) == 'p')
			{
				if(toggle < 0)	if(lpdir&cp)
						{
							lpdir =& ~cp;	/* turn it off */
							llength =+ 2;	/* reset llength */
						}
				if(toggle > 0)	if(!(lpdir&cp))
						{
							lpdir =| cp;
							llength =- 2;
						}
				if(!toggle)
				{
					lpdir =^ cp;
					if(lpdir&cp) llength =- 2;
					else llength =+ 2;
				}
			}
			break;

		case 'd':
			if(*(++str) == 't')
				if(toggle < 0) cdir =& ~dt;
				else	if(toggle > 0) cdir =| dt;
					else cdir =^ dt;
			break;

		case 'e':
			if(toggle < 0) cdir =& ~e;
			else	if(toggle > 0) cdir =| e;
				else cdir =^ e;
			break;

		case 'f':
			if(*(++str) == 'f')
				if(toggle < 0) lpdir =& ~ff;
				else	if(toggle > 0) lpdir =| ff;
					else lpdir =^ ff;
			else
				if(*str == 'p')
					if(toggle < 0) lpdir =& ~fp;
					else	if(toggle > 0) lpdir =| fp;
						else lpdir =^ fp;
				else	if(*str == 't')
						if(toggle < 0) lpdir =& ~ft;
						else	if(toggle > 0) lpdir =| ft;
							else lpdir =^ ft;
			break;

		case 'h':
			if(toggle < 0)	if(lpdir&h)
					{
						lpdir =& ~h;	/* turn it off */
						plength =+ 3;	/* reset llength */
					}
			if(toggle > 0)	if(!(lpdir&h))
					{
						lpdir =| h;
						plength =- 3;
					}
			if(!toggle)
			{
				lpdir =^ h;
				if(lpdir&h) plength =- 3;
				else plength =+ 3;
			}
			break;

		case 'i':
			if(*(++str) == ' ' || *str == tab || !*str)
				if(toggle < 0) cdir =& ~i;
				else	if(toggle > 0) cdir =| i;
					else cdir =^ i;
			else	if(*str == 'n')
					if(toggle < 0) lpdir =& ~in;
					else	if(toggle > 0) lpdir =| in;
						else lpdir =^ in;
			break;

		case 'l':
			str++;
			if(*str >= '1' && *str <= '9')
				for(toggle= *str-'0';toggle-->0;) putc('\n',optr);
			if(*str == 'n')
			{
				if(toggle < 0)	if(lpdir&ln)
						{
							lpdir =& ~ln;	/* turn it off */
							llength =+ 6;	/* reset llength */
						}
				if(toggle > 0)	if(!(lpdir&ln))
						{
							lpdir =| ln;
							llength =- 6;
						}
				if(!toggle)
				{
					lpdir =^ ln;
					if(lpdir&ln) llength =- 6;
					else llength =+ 6;
				}
			}
			if(*str == 'l')
			{
				toggle = 0;	/* make sure toggle is 0 */
				while(*(++str)>='0' && *str<='9')	/* while numbers */
				{
					toggle =* 10;	/* multiply last number by ten */
					toggle =+ *str-'0';	/* add next number to it */
				}
				if(toggle>=52 || toggle<=132)
				{
					if(lpdir&b) toggle =- 4;
					if(lpdir&cp) toggle =- 2;
					if(lpdir&ln) toggle =- 6;
					llength = toggle;
				}
			}
			break;

		case 'p':
			if(*(++str) == ' ' || *str == tab || !*str) page(0);
			else	if(*str == 'p')
					if(toggle < 0) cdir =& ~pp;
					else	if(toggle > 0) cdir =| pp;
						else cdir =^ pp;
				else	if(*str == 'f')
						if(toggle < 0) cdir =& ~pf;
						else	if(toggle > 0) cdir =| pf;
							else cdir =^ pf;
					else	if(*str == 'l')
						{
							toggle = 0;
							while(*(++str) >= '0' && *str <= '9')
							{
								toggle =* 10;
								toggle =+ *str - '0';
							}
							if(toggle>3) plength = toggle;
							if(lpdir & h) plength =- 3;
						}
			break;

		case 's':
			if(toggle < 0) cdir =& ~s;
			else	if(toggle > 0) cdir =| s;
				else cdir =^ s;
			break;

		case 't':
			++str; ++str;		/* get past the 't' and the '"' */
			tpt = title;
			while(*str && *str != '"') *tpt++ = *str++;	/* put it in */
			*tpt = '\0';	/* terminate */
			break;

		}
		while(*str && *str!=tab && *str++!=' ');	/* get to next identifier */
	}
}

checkde(io,iptr)
struct	inpout	*io;
FILE	*iptr;
/*
 * handles #ifdefs, etc. intelligently.
 */
{
	int	sym,
		go	1;

	wcount = 0;
	io->ba = io->fr;	/* forget it */
	sym = io->sym;	/* remember the current symbol */
	if(sym == elses || sym == endif)
	{
		linenum++;	/* count the line */
		while(readsym(iptr,io) && io->sym != newlin);	/* get to end of line */
		io->sym = sym;	/* for the return */
		return(sym);
	}
	if(!readsym(iptr,io)) return(0);	/* eof */
	if((sym==ifdef&&stree(io->str,&defroot))||(sym==ifndef&&!stree(io->str,&defroot)))
	{
		cond++;	/* flag conditional code */
		linenum++;	/* count the lines */
		while(io->sym != newlin && readsym(iptr,io));	/* get to the end */
		while((sym = handler(iptr,io->optr)) != elses && sym != endif) if(feof(iptr)) return(0);
		cond--;	/* reset flag */
		if(sym == elses)
			while( io->sym != endif && readsym(iptr,io))
				if(io->sym == newlin) linenum++;	/* count the lines */
	}
	else
		while(go && readsym(iptr,io))
			if(io->sym == newlin)
				linenum++;
			else
				if((go == 1 && io->sym == elses)|| io->sym == endif)	/* ignore all except last else */
					go--;
				else
					if(io->sym == ifdef || io->sym == ifndef)
						go++;
	if(io->sym == elses)
	{
		cond++;	/* flag conditional code */
		linenum++;	/* count the lines */
		while(readsym(iptr,io) && io->sym != newlin);
		while(handler(iptr,io->optr) != endif) if(feof(iptr)) return(0);
		cond--;	/* reset flag */
	}
	while(io->sym != newlin && readsym(iptr,io));	/* get to the end */
	linenum++;
	wcount = 0;
	io->ba = io->fr;
	return(0);
}

search(name)
char	*name;
/*
 * calls handler with /dev/null as the output file.
 */
{
	FILE	*ptr,*optr;
	register	char	*tpnt1;
	char	tpnt2[24];

	tpnt1 = tpnt2;
	if(*name++ == '<')	/* angle brackets */
	{
		strcpy(tpnt1,"/usr/include/");
		while(*(++tpnt1));
	}
	while((*tpnt1 = *name++) != '"' && *tpnt1 != '>') tpnt1++;
	*tpnt1 = '\0';
	if(!(ptr = fopen(tpnt2,"r"))) perror(tpnt2);
	optr = outf;	/* save the current output file */
	if(!(outf = fopen("/dev/null","w"))) perror("/dev/null");
	handler(ptr,outf);
	fclose(ptr);
	fclose(outf);
	outf = optr;	/* reset the output file */
}

readsym(iptr,io)
FILE	*iptr;
struct	inpout	*io;
/*
 * this reads from the file pointed to by iptr 1 line
 * at a time and sends the information up to handler i lexical symbol
 * at a time.
 */
{
	static	char	linbuf[132]	{"\0"},	/* the line buffer */
			symbuf[132],	/* the symbol string buffer */
			*bpnt	0;		/* the line pointer */
	static	int	print	1,		/* flag if line is to be printed */
			comm	0;		/* flag if still looking for the end of a comment */
	char	*tpnt1,*tpnt;	/* a temporary pointer */
	node	*tnode;		/* a temporary node */

	io->str = symbuf;
	if(*bpnt == '\0' || !bpnt)
	{
		if(!(cdir&pf) && print && bpnt)
		{
			tpnt = io->fr;
			io->fr = linbuf;
			io->ba = --bpnt;	/* get back past the '\n' */
			put(io);		/* write the line out */
			io->fr = io->ba = tpnt;	/* reset the pointers */
		}
		else	print = 1;	/* reset print flag */
		if(!(fgets(linbuf,132,iptr)))
			if(ferror(iptr))	error("read error");
			else
			{
				io->lsym = io->sym;
				io->sym = eof;
				*(io->str) = io->le = bpnt = 0;
				return(0);
			}
		else bpnt = linbuf;		/* set the pointer */
	}
	io->lsym = io->sym;
	io->le = 0;
	*(io->str) = '\0';
	tpnt = io->str;
	if(comm && *bpnt != '\n')
	{
		while(*bpnt == tab) bpnt++;	/* get rid of leading tabs */
		while(comm && *bpnt != '\n')
		{
			io->le++;	/* count the length */
			if((*tpnt++ = *bpnt++) == '*')
				if(*bpnt == '/')
				{
					io->le++;
					*tpnt++ = *bpnt++;
					comm = 0;	/* reset flag */
				}
		}
		io->sym = comment;
		*tpnt = '\0';
		return(1);
	}
	while(*bpnt == ' ' || *bpnt == tab) bpnt++;	/* get past garbage */
	if(*bpnt == '\n')
	{
		bpnt++;
		io->sym = newlin;
		return(1);
	}
	if((*bpnt >= 'A' && *bpnt <= 'Z') || (*bpnt >= 'a' && *bpnt <='z')
	|| *bpnt == '_')
	{
		*tpnt++ = *bpnt++;
		io->le++;
		while((*bpnt >= 'a' && *bpnt <= 'z') || (*bpnt >= 'A' && *bpnt <='Z')
		|| (*bpnt >= '0' && *bpnt <= '9') || *bpnt == '_')
		{
			*tpnt++ = *bpnt++;
			io->le++;
		}
		*tpnt = '\0';
		if(tnode = stree(io->str,&keyroot))
			if(tnode->type == strid)
				if(io->lsym == structs) io->sym = specif;
				else io->sym = ident;
			else
				io->sym = tnode->type;
		else
			if(*bpnt == '(')	io->sym = func;
			else	io->sym = ident;
		return(1);
	}
	if(*bpnt >= '0' && *bpnt <= '9')
	{
		*tpnt++ = *bpnt++;
		io->le++;
		while(*bpnt >= '0' && *bpnt <='9')
		{
			io->le++;
			*tpnt++ = *bpnt++;
		}
		if(*bpnt == '.')
		{
			io->le++;
			*tpnt++ = *bpnt++;
			if(*bpnt < '0' || *bpnt > '9')
			{
				io->sym = illegal;
				*tpnt = '\0';
				return(1);
			}
			else
				while(*bpnt >= '0' && *bpnt <= '9')
				{
					io->le++;
					*tpnt++ = *bpnt++;
				}
		}
		if(*bpnt == 'e')
		{
			io->le++;
			*tpnt++ = *bpnt++;
			if(*bpnt < '0' || *bpnt > ' 9')
			{
				io->sym = illegal;
				*tpnt = '\0';
				return(1);
			}
			else
				while(*bpnt >= '0' && *bpnt <='9')
				{
					io->le++;
					*tpnt++ = *bpnt++;
				}
		}
		*tpnt = '\0';
		io->sym = number;
		return(1);
	}
	switch(*bpnt)
	{
	case ',':
	case ';':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = seper;
		break;

	case '?':
		binar++;	/* flag that a ':' is expected */
	case '%':
	case '^':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = binarop;
		break;

	case '.':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = specop;
		break;

	case '~':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = unaryop;
		break;

	case '{':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = ocurly;
		break;

	case '}':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = ccurly;
		break;

	case '[':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = osqbrac;
		break;

	case ']':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = csqbrac;
		break;

	case '(':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = oparent;
		break;

	case ')':
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = cparent;
		break;

	case '!':
		io->le++;
		*tpnt++ = *bpnt++;
		if(*bpnt == '=')
		{
			io->le++;
			*tpnt++ = *bpnt++;
			io->sym = binarop;
		}
		else io->sym = unaryop;
		break;

	case ':':
		io->le++;
		*tpnt++ = *bpnt++;
		if(!binar) io->sym = colon;
		else
		{
			binar = 0;
			io->sym = binarop;
		}
		break;

	case '+':
		io->le++;
		*tpnt++ = *bpnt++;
		if(*bpnt == '+')
		{
			io->le++;
			*tpnt++ = *bpnt++;
			io->sym = unaryop;
		}
		else io->sym = binarop;
		break;

	case '|':
		io->le++;
		*tpnt++ = *bpnt++;
		if(*bpnt == '|')
		{
			io->le++;
			*tpnt++ = *bpnt++;
		}
		io->sym = binarop;
		break;

	case '<':
		io->le++;
		*tpnt++ = *bpnt++;
		if(io->lsym == include)	/* a string for a #include */
		{
			while(*bpnt != '\n' && *bpnt != '>')
			{
				io->le++;
				*tpnt++ = *bpnt++;
			}
			if(*bpnt == '>')
			{
				io->le++;
				*tpnt++ = *bpnt++;
				io->sym = string;
			}
			else io->sym = illegal;
		}
		else
		{
			if(*bpnt == '<' || *bpnt == '=')
			{
				io->le++;
				*tpnt++ = *bpnt++;
			}
			io->sym = binarop;
		}
		break;

	case '>':
		io->le++;
		*tpnt++ = *bpnt++;
		if(*bpnt == '>' || *bpnt == '=')
		{
			io->le++;
			*tpnt++ = *bpnt++;
		}
		io->sym = binarop;
		break;

	case '-':
		io->le++;
		*tpnt++ = *bpnt++;
		if(*bpnt == '-')
		{
			io->le++;
			*tpnt++ = *bpnt++;
			io->sym = unaryop;
		}
		else
			if(*bpnt == '>')
			{
				io->le++;
				*tpnt++ = *bpnt++;
				io->sym = specop;
			}
			else
				if(io->lsym == assop || io->lsym == binarop || io->lsym == unaryop
				|| io->lsym == oparent || io->lsym == seper || io->lsym == ocurly)
					io->sym = unaryop;
				else
					io->sym = binarop;
		break;

	case '&':
		io->le++;
		*tpnt++ = *bpnt++;
		if(*bpnt == '&')
		{
			io->le++;
			*tpnt++ = *bpnt++;
			io->sym = binarop;
		}
		else
			if(io->lsym == assop || io->lsym == binarop || io->lsym == unaryop
			|| io->lsym == oparent || io->lsym == seper || io->lsym == ocurly)
				io->sym = unaryop;
			else	io->sym = binarop;
		break;

	case '#':
		io->le++;
		*tpnt++ = *bpnt++;
		while(*bpnt == ' ' || *bpnt == tab) bpnt++;
		while(*bpnt >= 'a' && *bpnt <= 'z')
		{
			io->le++;
			*tpnt++ = *bpnt++;
		}
		*tpnt = '\0';
		if(tnode = stree(io->str,&keyroot)) io->sym = tnode ->type;
		else io->sym = illegal;
		break;

	case '\'':
		io->le++;
		*tpnt++ = *bpnt++;
		while(*bpnt != '\'' && *bpnt != '\n' && *bpnt)
		{
			if(*bpnt == '\\')
			{
				io->le++;
				*tpnt++ = *bpnt++;	/* bypass next symbol */
			}
			io->le++;
			*tpnt++ = *bpnt++;
		}
		if(*bpnt == '\n' || !(*bpnt))
		{
			if(!(*bpnt))
			{
				bpnt--;	/* back up because he escaped a newline */
				tpnt--;
				io->le--;
			}
			io->sym = illegal;
		}
		else
		{
			io->le++;
			*tpnt++ = *bpnt++;
			io->sym = string;
		}
		break;

	case '"':
		io->le++;
		*tpnt++ = *bpnt++;
		while(*bpnt != '"' && *bpnt != '\n' && *bpnt)
		{
			if(*bpnt == '\\')
			{
				io->le++;
				*tpnt++ = *bpnt++;	/* bypass next symbol */
			}
			io->le++;
			*tpnt++ = *bpnt++;
		}
		if(*bpnt == '\n' || !(*bpnt))
		{
			if(!(*bpnt))
			{
				bpnt--;	/* back up because he escaped a newline */
				tpnt--;
				io->le--;
			}
			io->sym = illegal;
		}
		else
		{
			io->le++;
			*tpnt++ = *bpnt++;
			io->sym = string;
		}
		break;

	case '=':
		io->le++;
		*tpnt++ = *bpnt++;
		if(*bpnt == '+' || *bpnt == '-' || *bpnt == '*' || *bpnt == '/'
		|| *bpnt == '%' || *bpnt == '&' || *bpnt == '^' || *bpnt == '|')
		{
			io->le++;
			*tpnt++ = *bpnt++;
			io->sym = assop;
		}
		else
			if(*bpnt == '<' || *bpnt == '>')
			{
				io->le++;
				*tpnt++ = *bpnt++;
				if(*bpnt == '<' || *bpnt == '>')
				{
					io->le++;
					*tpnt++ = *bpnt++;
					io->sym = assop;
				}
				else io->sym = illegal;
			}
			else
				if(*bpnt == '=')
				{
					io->le++;
					*tpnt++ = *bpnt++;
					io->sym = binarop;
				}
				else io->sym = assop;
		break;

	case '*':
		io->le++;
		*tpnt++ = *bpnt++;
		if(io->lsym == assop || io->lsym == specif || io->lsym == binarop
		|| io->lsym == unaryop || io->lsym == oparent || io->lsym == seper
		|| io->lsym == ocurly || io->lsym == specop || io->fr == io->ba)	/* all exclusive of binarops */
			io->sym = specop;
		else
			io->sym = binarop;
		break;

	case '/':
		io->le++;
		*tpnt++ = *bpnt++;
		if(*bpnt == '*')	/* comment */
		{
			io->le++;
			*tpnt++ = *bpnt++;
			while(*bpnt >= 'a' && *bpnt <= 'z')
			{
				io->le++;
				*tpnt++ = *bpnt++;
			}
			*tpnt = '\0';
			if(!(strcmp(io->str,"/*para")))	/* para directives */
				if(*bpnt == ' ' || *bpnt == tab)
				{
					tpnt1 = tpnt;	/* remeber this place */
					while(*bpnt != '\n' && *bpnt != '*')
					{
						io->le++;
						*tpnt++ = *bpnt++;
					}
					*tpnt = '\0';	/* null terminate */
					dir(tpnt1,io->optr);
					if(!(cdir&pp))	/* if don't print para directives */
						if(*bpnt == '*' && *(++bpnt) == '/')
						{	/* a full comment */
							bpnt++;	/* get past the '/' */
							*(io->str) = '\0';
							io->le = 0;
							io->sym = comment;
							comm = 0;
							return(1);
						}
						else
						{
							tpnt = io->str;
							tpnt++;
							tpnt++;
							tpnt++;	/* leave only '/*' behind */
							io->le = 2;
						}
					else
					{
						bpnt--;
						tpnt--;	/* back up past the '*' */
						io->le--;
					}
				}
			comm = 1;	/* flag the comment */
			while(*bpnt != '\n')
			{
				io->le++;
				if((*tpnt++ = *bpnt++) == '*')
					if(*bpnt == '/')
					{
						io->le++;
						*tpnt++ = *bpnt++;
						comm = 0;	/* end of comment */
					}
			}
			io->sym = comment;
		}
		else io->sym = binarop;
		break;

	default:
		io->le++;
		*tpnt++ = *bpnt++;
		io->sym = illegal;
	}
	*tpnt = '\0';
	return(1);
}
