;;;	/ p o p / m a n d c 2 . p
lib mandc1;	;;; This package uses /pop/mandc1.p
;;;
;;;
;;;	This package contains some refinements to the /pop/mandc1.p
;;;	package, in particular:
;;;		(a) It allows the 'move` BACKUP
;;;		(b) It keeps a record of the moves made
;;;		(c) It detects looping
;;;		(d) It detects success
;;;		(e) It prints a messagg saying WHY a move is unacceptable
;;;
;;;	Global variables used herein
vars statelist movelist;
;;;
;;;	The following function returns TRUE if given two equivalent states.
;;;	A state is represented by its LEFTBANK.
function samestate stateone statetwo;
	count("m",stateone) == count("m",statetwo)
	and	count("c",stateone) == count("c",statetwo)
	and	count("boat",stateone) == count("boat",statetwo)
end;
;;;
;;;	The following function returns TRUE if, and only if, everybody
;;;	has been conveyed to the RIGHTBANk - that is no one is keft on the LEFTBANK.
function succeeded;
	samestate(leftbank,[])
end;
;;;
;;;	The following function returns TRUE if the given state occurs in the given list
;;;	of states
function stateoccurs state list;
	if	list == []
	then	false
	elseif	samestate(state,hd(list))
	then	true
	else	stateoccurs(state,tl(list))
	close
end;
;;;
;;;	The following function detects looping
function leadstoloop move;
	vars leftbank rightbank;
	domove(move);
	stateoccurs(leftbank,statelist)
end;
;;;
;;;	The following function checks for an allowable move
function allowablemove move;
	if	not(boatokay(move))
	then	prstring('Boat not okay\n');
		false
	elseif	not(frombankokay(move))
	then	prstring('From bank not okay\n');
		false
	elseif	not(tobankokay(move))
	then	prstring('To bank not okay\n');
		false
	elseif	leadstoloop(move)
	then	prstring('Leads to a loop\n');
		false
	else	true
	close
end;
;;;
;;;	The following function prints out a list of moves.
;;;	(in reverse order)
function printmoves movelist;
	unless	movelist == []
	then	printmoves(tl(movelist));
		pr(hd(movelist));
		nl(1);
	close
end;
;;;
;;;	The following function explores a move to see if leads to the goal
;;;	state
function explore move leftbank rightbank movelist statelist;
	domove(move);
	move :: movelist -> movelist;
	leftbank :: statelist -> statelist;
	makemoves();
end;
;;;
;;;	The following function explores the current state,
;;;	returning TRUE if it leads to the goal state.
function makemoves;
	if	succeeded()
	then	prstring('Well done, everyone across with the moves:\n');
		printmoves(movelist);
		setpop();
	else	vars move;
		requestamove() -> move;
		if	member("backup",move)
		then	prstring('Backing up\n');
		elseif	allowablemove(move)
		then	explore(move,leftbank,rightbank,movelist,statelist);
			makemoves()
		else	prstring('Move not acceptable\n');
			makemoves()
		close
	close
end;
;;;
;;;	The following function initialies this grander version of mandc
function startmandc;
	[m m m c c c boat] -> leftbank;
	[] -> rightbank;
	[] -> movelist;
	[% leftbank %] ->statelist;
end;
;;;
;;;	And a modified version of MANDC itself:
function mandc;
	startmandc();
	makemoves();
	prstring('No solution found\n');
end;
