#include "draw.h"

struct table table[] = {
	{"e",		ed,		2, 0,	"e modulename"},
	{"p",		print,		2, 1,	"p modulename"},
	{"c",		clr,		1, 1,	""},
	{"grid",	grid,		1, 1,	""},
	{"w",		writef,		2, 0,	"w filename"},
	{"r",		readf,		2, 0,	"r filename"},
	{"lib",		lib,		2, 0,	"lib filename"},
	{"reset",	reset,		1, 0,	""},
	{"new",		new,		2, 0,	"new filename"},
	{"level",	setlevel,	0, 1,	"level levnum levnem ..."},	/* any number of arguments */
	{"list",	list,		1, 1,	""},
	{"rename",	rename,		3, 1,	"rename oldmodulename newmodulename"},
	{"wplot",	wplot,		3, 0,	"wplot modulename filename"},
	{"plot",	plot,		2, 1,	"plot modulename"},
	{"set",		set,		2, 1,	"set sheetsize"},
	{"q",		endit,		1, 0,	""},
	{"size",	size,		2, 1,	"size [123]"},
	{"debug",	debug,		1, 1,	""},
	{0,		0,		0, 0,	0}
};

cmd(buf, flg)
char *buf;
{
	register struct table *q;

	char cmdb[BUFSZ];
	char arg1[BUFSZ];
	char arg2[BUFSZ];
	char arg3[BUFSZ];
	char arg4[BUFSZ];
	char arg5[BUFSZ];
	char arg6[BUFSZ];
	char arg7[BUFSZ];
	char arg8[BUFSZ];
	char arg9[BUFSZ];
	register argcount;

	argcount = sscanf(buf, "%s%s%s%s%s%s%s%s%s%s", cmdb, arg1, arg2,
			arg3, arg4, arg5, arg6, arg7, arg8, arg9);
	if(argcount == 0)
		return;
	for(q = table;q->cmd != NULL; q++)
		if(strcmp(cmdb, q->cmd) == 0)
			break;
	if(q->cmd == NULL)
	{
		if(buf[0] == '!')
		{
			system(&buf[1]);
			oldline();
		}
		else
			warn("unknown command\n");
		return;
	}
	if(q->argc != 0)
	{
		if(flg == 1 && q->flg == 0)
		{
			fprintf(stderr, "command cannot be executed from edit mode\n");
			oldline();
			return;
		}
		if(q->argc != argcount)
		{
			fprintf(stderr, "usage : %s\n", q->usage);
			oldline();
			return;
		}
		(*q->f)(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
	}
	else
	{
		(*q->f)(argcount-1, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
	}
}

/* clear the screen */
clr()
{
	erase(); 
	home();
	fflush(stdout);
	oldline();
}

struct symbol *lookup(p)
char *p;
{
	register unsigned i;

	for(i = 0;i < nsyms; i++)
		if(strncmp(symtab[i].name, p, NAMESIZ) == 0)
			return &symtab[i];
	return NULL;
}

round(p)
float *p;
{

	if(*p < 0)
		*p = (float)((long)(*p * gridscale - 0.5))/gridscale;
	else
		*p = (float)((long)(*p * gridscale + 0.5))/gridscale;
}

grid()
{
	float x1, y1, z1;
	float xb, yb;
	float save;

	save = gridscale;
	x1 = xbottom + 50.0 * g_uxtrans;
	y1 = ybottom + 50.0 * g_uytrans;
	gridscale = 10.0;

	round(&x1);
	round(&y1);
	if(xbottom < 0.0 && 0.0 < xtop)
		x1 = 0.0;
	if(ybottom < 0.0 && 0.0 < ytop)
		y1 = 0.0;

	umovea(x1, ybottom);
	udrawr(0, ytop - ybottom);
	umovea(xbottom, y1);
	udrawr(xtop - xbottom, 0.0);

	yb = ybottom;
	round(&yb);
	umovea(x1, yb);
	z1 = ybottom;
	for(;z1 < ytop;z1 += 0.1)
	{
		umover(-0.05, 0.1);
		udrawr(0.05, 0.0);
	}

	xb = xbottom;
	round(&xb);
	umovea(xb, y1);
	z1 = xbottom;
	for(;z1 < xtop; z1 += 0.1)
	{
		umover(0.1, -0.05);
		udrawr(0.0, 0.05);
	}

	gridscale = 1.0;
	round(&xb);
	round(&yb);
	umovea(x1, yb);
	z1 = ybottom;
	for(;z1 < ytop; z1 += 1.0)
	{
		umover(-0.1, 1.0);
		udrawr(0.1, 0.0);
	}

	umovea(xb, y1);
	z1 = xbottom;
	for(;z1 < xtop; z1 += 1.0)
	{
		umover(1.0, -0.1);
		udrawr(0.0, 0.1);
	}
	gridscale = save;
}
reset()
{
	register i;

	for(i = 0;i < nsyms;i++)
		deleteincore(1, &symtab[i]);

	nsyms = 0;
}

/* edit a new file */
new(arg1)
char *arg1;
{
	register i, j;

	for(i = 0; i < nsyms; i++)
		if(!(symtab[i].def & LIB))
			break;
	for(j = i; j < nsyms; j++)
		deleteincore(1, &symtab[i]);
	nsyms = i;
	readf1(arg1, 0);
}

setlevel(ac, a1)
char *a1;
{
	register char **p;
	register i;

	i = ac;
	p = &a1;
	levelmask = 0;
	while(i--)
	{
		if((**p >= '1') && (**p <='9'))
		{
			levelmask |= (1 << (**p -'0'-1));
		}
		p++;
	}
}

/* list the entries in the symbole table */
list()
{
	register i;

	for(i = 0;i < nsyms;i++)
	{
		fprintf(stdout, "%.*s\n", NAMESIZ, symtab[i].name);
	}
	oldline();
}

rename(arg1, arg2)
char *arg1 , *arg2;
{
	register struct symbol *p;

	if((p = lookup(arg1)) == NULL)
	{
		fprintf(stderr, "unknown module %s\n", arg1);
		oldline();
		return;
	}
	if(lookup(arg2) != NULL)
	{
		fprintf(stderr, "%s already exists\n", arg2);
		oldline();
		return;
	}
	strncpy(p->name, arg2, NAMESIZ);
}

int CHANGED;
endit()
{
	char buf[80];
	if(CHANGED)
	{
		fprintf(stderr, "are you sure?");
		gets(buf);
		oldline();
		if(strcmp("y", buf) && strcmp("yes", buf))
			return;
	}
	unlink(tempname);
	exit(0);
}

warn(cp)
char *cp;
{

	newline();
	fprintf(stderr, "warning %s", cp);
	oldline();
}

error(cp)
char *cp;
{
	newline();
	fprintf(stderr, "error %s", cp);
	oldline();
}

set(arg)
char *arg;
{
	static struct sett {
		char	*cset;
		float	xl, xh, yl, yh;
	} sett[] = {
		{"a1", -0.5, 34.5, -0.5, 26.2},
		{"a2", -0.5, 24.5, -0.5, 19.1},
		{"a3", -0.5, 17.5, -0.5, 13.2},
		{"a4", -0.5, 12.5, -0.5, 9.4},
		0
	};
	register struct sett *p;

	for(p = sett; p->cset != 0; p++)
		if(strcmp(arg, p->cset) == 0)
		{
			xbottom = p->xl;
			xtop = p->xh;
			ybottom = p->yl;
			ytop = p->yh;
			uwindow(xbottom, xtop, ybottom, ytop);
			return;
		}
	warn("bad arg to set (a1, a2, a3, a4)\n");
}

int charscale;

size(cp)
char *cp;
{

	if(*cp == '1')
	{
		charscale = 12;
	}
	else if(*cp == '2')
	{
		charscale = 9;
	}
	else if(*cp == '3')
	{
		charscale = 6;
	}
	else
		warn("only sizes 1 2 3");
}
insert(p1, p2)
union unit *p1, *p2;
{

	if(p1 == NULL || p2 == NULL)
	{
		warn("bad argument to insert");
		abort();
	}

	while(p1->mod.up != NULL)
	{
		if(p1->mod.up->mod.x > p2->mod.x ||
			(p1->mod.up->mod.x == p2->mod.x && p1->mod.up->mod.y > p2->mod.y))
		{
			p2->mod.up = p1->mod.up;
			p1->mod.up = p2;
			return;
		}
		p1 = p1->mod.up;
	}
	p2->mod.up = NULL;
	p1->mod.up = p2;
}
