/*
 *	These programs pack file pathnames into a file so that
 *	they may be quickly retrieved. It is assumed that
 *	the maximum file size can be stored in 24 bits.
 *
 *  The format:
 *	the first byte in the file is a flag indicating whether the pathnames
 *		come from / or not;
 *	the next three bytes form a pointer to the root node of the list;
 *	the first byte of each node is a flag field; its value indicates
 *	which of the following are present (and in what form):
 *	   a list pointer - 2 or 3 bytes, points to the next node
 *		in this directory;
 *	   a directory pointer - 2 or 3 bytes, points to the subdirectory
 *		list that comes from this node (directory name);
 *	   a name field - a string of up to 14 chars (not null-terminated).
 */

#define	FSIZE	14	/* max. filename length - DO NOT ALTER */
#define	NNODES	50	/* maximum depth of pathnames */
#define	MAXNODE (1+3+3+14)	/* maximum size of a node */

/*
 *	some flags for the flag field
 *	(the lower 4 bits indicate the size of the name field in bytes)
 */

#define	SIZE	0017		/* mask to get size field */
#define	DIRNODE	0020		/* subdirectory comes off this node */
#define	LONGDIR	0040		/* need 3 bytes to store its address */
#define	LSTNODE	0100		/* there are more nodes at the same level */
#define	LONGLST	0200		/* as for LONGDIR so shall it be for LONGLST */

#define	MAXPATH	200		/*  maximum pathlength size */
char	pathbuf[MAXPATH];	/* buffer for the path names */
long	rootaddr;		/* address of root node */
char	fromslash;		/* set if pathnames are from / */

struct grot
{
	char	lo_byte;
	char	hi_byte;
};

struct fudge
{
	short	hi_word;
	short	lo_word;
};
