#define	WTMPF		"/usr/adm/wtmp"
typedef char		tty_t[2];	/* two char terminal mnemonic */
typedef	char		cput_t[3];	/* 24 bits for cpu tics ==> 93 hours */

/*
**	uwtmp structure for logins
**
**	written into	WTMPF
**		by	"login"
*/
#define	U_TYPE	'\n'
struct	uwtmp
{
	short		uw_type;
	uid_t		uw_uid;
	tty_t		uw_ttyid;
	cput_t		uw_fill1;
	cput_t		uw_fill2;
	time_t		uw_logintime;
};
#define	UWTMPSIZ	(sizeof (struct uwtmp))

/*
**	otmp structure for logoffs
**
**	written into	WTMPF
**		by	"init"
*/
#define	O_TYPE	0
struct	otmp
{
	short		o_type;
	uid_t		o_uid;
	tty_t		o_ttyid;
	cput_t		o_usertime;
	cput_t		o_systime;
	time_t		o_logofftime;
};
#define	OTMPSIZ	(sizeof (struct otmp))

/*
**	wtmp structure for process termination
**
**	written into	WTMPF
**		by	"init"
*/
#define	W_TYPE	1
struct	wtmp
{
	short		w_type;
	uid_t		w_uid;
	tty_t		w_ttyid;
	cput_t		w_usertime;
	cput_t		w_systime;
	time_t		w_finishtime;
};
#define	WTMPSIZ	(sizeof (struct wtmp))

/*
**	stmp structure for system boot
**
**	written into	WTMPF
**		by	"init"
*/
#define	S_TYPE	2
struct	stmp
{
	short		s_type;
	uid_t		s_uid;
	tty_t		s_ttyid;
	cput_t		s_fill3;
	cput_t		s_fill4;
	time_t		s_boottime;
};
#define	STMPSIZ	(sizeof (struct stmp))

/*
**	dtmp structure for date changes
**
**	written into	WTMPF
**		by	"date"
*/
#define	D_TYPE	3
struct	dtmp
{
	short		d_type;
	uid_t		d_uid;
	tty_t		d_ttyid;
	char		d_fill3[2];
	time_t		d_oldtime;
	time_t		d_newtime;
};
#define	DTMPSIZ	(sizeof (struct dtmp))

/*
**	sutmp structure for "su" command
**
**	written into	WTMPF
**		by	"su"
*/
#define	SU_TYPE	4
struct	sutmp
{
	short		su_type;
	uid_t		su_newuid;
	tty_t		su_ttyid;
	uid_t		su_olduid;
	char		su_fill2[4];
	time_t		su_usetime;
};
#define	SUTMPSIZ	(sizeof (struct sutmp))

/*
**	ttmp structure for system shutdowm
**
**	written into	WTMPF
**		by	"init"
*/
#define	T_TYPE	5
struct	ttmp
{
	short		t_type;
	uid_t		t_uid;
	tty_t		t_ttyid;
	cput_t		t_fill3;
	cput_t		t_fill4;
	time_t		t_downtime;
};
#define	TTMPSIZ	(sizeof (struct ttmp))
