#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * EM1 - UNIX as translator
 *
 * procedures for fake-stack manipulation
 *
 */

/*
 * push frame fp onto the fake-stack
 */
pshfk (fp) fake_t *fp; {

	if (fsp >= &fake[MAXFAKE-1]) {
		empty_fake(ALL);
		/* error("*** FAKE EXHAUSTED : NON FATAL"); */
	}
	copyf(fp,++fsp);
}

/*
 * return the number of words contained in a frame
 */
int wrdsof (fp) fake_t *fp; {
	return(fp->flags & INT?1:2);
}

/*
 * pop n frames from the fake-stack
 */
popfk (n) int n; {
	register fake_t *p;
	register i;

	p = fsp;
	i = 0;
	while (i<n && p>fake)
		i =+ wrdsof(p--);
	fsp = p;
	if (i>n) {
		stk.flags = INT;
		pshfk(&stk);
	}
}

/*
 * copy two fake-frames and update registers
 */
copyf(fsrc,fdst) fake_t *fsrc,*fdst; {
	register fake_t *src,*dst;

	src=fsrc;
	dst=fdst;
	dst->type  = src->type;
	dst->flags = src->flags;
	dst->offset = src->offset;
	dst->index = src->index;
	set_reg(dst);
}


/*
 * empty fake from bottom to a frame fp (if it exists)
 */
empty_to (fp) fake_t *fp; {
	register fake_t *p,*f,*ftop;
	int found;

	ftop = p = fsp;
	found = FALSE;
	f = fp;

	while (p>fake) {
		if (p->flags & IND) {
			/* frame on fake is indirect : source is unknown */
			found=TRUE;
			break;
		}
		if (p->type!=f->type || p->index!=f->index) {
			/* frame on fake is of same type and */
			p--;
			continue;
		}
		if (f->offset==p->offset) {
			/* indices are identical  */
			found=TRUE;
			break;
		}
		if (!(p->flags & INT) && (p->offset==(f->offset - 2))) {
			/* f points to high word of double fake-frame */
			found=TRUE;
			break;
		}
		if (!(f->flags & INT) && (f->offset==(p->offset - 2))) {
			/* p points to high word of double fake-frame */
			found=TRUE;
			break;
		}
		p--;
	}
	if (found) {
		fsp = p;
		empty_fake(ALL);
		fsp = ftop;
	}
}

int words_on_fake() {
	register n;
	register fake_t *fp;

	n = 0;
	fp = fsp;
	while (fp>fake)
		n =+ wrdsof(fp--);
	return(n);
}

int STKs_on_fake (n) int n; {
	register fake_t *fp;
	register k,j;
	int i;

	k = i = 0;
	fp = fsp;
	while (k<n) {
		j=wrdsof(fp);
		k =+ j;
		if (fp->type==STK)
			i =+ k>n? 1 : j;
		fp--;
	}
	return(i);
}

/*
 * copy top n words on fake-stack to real stack
 */
empty_fake (n) int n; {
	register fake_t *fp;
	register i,k;
	int totalw,off;

	if ( (totalw=words_on_fake())==0 )
		return;		/* fake already empty */
	if ( n==ALL || n>totalw )
		n = totalw;	/* empty all */
	/*
	 * if necessary, stack registers
	 */
	i = 0;
	fp = fake;
	while (i<totalw-n)
		i =+ wrdsof(++fp);
	REGs_to_stack(fp);
	/*
	 * relocate already stacked items
	 */
	k = STKs_on_fake(n);	/* total nr of STKs in top n words */
	i = 0;
	fp = fsp;
	while (i<n) {
		i =+ wrdsof(fp);
		if (fp->type==STK) {
		 	if ( !(fp->flags & INT) ) {
				off = n - (i-1) - (--k);
				if (off==0) {
					n = i-2;
					break;
					/* no more stacks on fake */
				}
				gen2(MOV,POP,indstk(2*off));
			}
			off = n - i - (--k);
			if (off==0) {
				n = i-1;
				break;
				/* no more stacks on fake */
			}
			gen2(MOV,POP,indstk(2*off));
		}
		--fp;
	}
	++fp;

	/*
	 * stack the remaining top n words
	 */
	while (fp<=fsp)
		if (fp->type==STK) {
			i = wrdsof(fp);
			while (++fp<=fsp && fp->type==STK)
				i =+ wrdsof(fp);
			if (i==1)
				gen1(TST,PSH);
			else if (i==2)
				gen2(op_cmi,PSH,PSH);
			else
				gen2(op_add,imm(2*i),SPX);
		} else {
			stk.flags = fp->flags & INT;
			move(fp++,&stk);
		}
	clr_fake_if_all_STKs();
}

/*
 * return the number of words on fake-stack (a float is two words)
 */
/*
 * push registers onto the (real) stack
 */
REGs_to_stack (fp) fake_t *fp; {
	register fake_t *p;

	p = fake;
	while (++p <= fp)
		if (p->type==REG) {
			stk.flags = p->flags & INT;
			move(p,&stk);
		}
}

/*
 * return the number of words on the (real) stack
 * in the top n words
 */
/*
 * clear the fake if only STK entries exist
 */
clr_fake_if_all_STKs() {
	register fake_t *p;

	p = fake;
	while (++p<=fsp)
		if (p->type != STK)
			return;
	fsp = fake;	/* i.e.: fake becomes empty */
}

/* this routine sets the fake-entries to type STK,
 * except of the top n words.
 * It is used only by 'RET'.
 */
set_to_stk (n) int n; {
	register fake_t *p;
	register i;

	p = fsp;
	i = 0;
	while (i<n && p>fake)
		i =+ wrdsof(p--);
	while (p>fake) {
		free_reg(p);
		p->type=STK;
		p--;
	}
}

/*
 * get me a register (integer or floating)
 */
getreg (fp,request) fake_t *fp; int request; {
	register fake_t *p,*r;
	register nr;
	fake_t f;
	int i,intflag,other,max;
	char *s;

	nr = fp->index;
	intflag = fp->flags & INT;
	if (nr==ANY) {
		if ((nr=reg_avail(intflag,request)) == -1){
			if (request==REG_or_STK) {
				fp->type=STK;
				fp->flags = intflag;
				return;
				/* STK will do aswell */
			}
			max = (intflag?MAXIREG:MAXFREG);
			if (intflag)
				p=((request==REG0||request==ODD_REG)?
						iregs[REG1]:
						iregs[REG0]);
			else
				p = (request==REG0?
					fregs[REG1]:
					fregs[REG0]);
			for (i=0; i<max ;i++)
				if (i!=request &&
				    (r=(intflag?iregs[i]:fregs[i]))<=p
				   && (request==ODD_REG?i%2==1:1)) {
					p=r;
					nr=i;
				}
			REGs_to_stack(p);
		}
	} else {
		p = (intflag?iregs[nr]:fregs[nr]);
		if (p!=FREE) {
			if ((other=reg_avail(intflag,request)) != -1 ){
				if(is_reg(p)==IREG) { /* copy reg contents */
					iregs[other]=p;
					copyf(fp,&f);
					s = str1(&f);
					f.index=p->index=other;
					gen2(MOV,s,str(&f));
				} else {
					fp->index=other;
					move(p,fp);
				}
			} else
				REGs_to_stack(p);
		}
	}
	fp->index = nr;
	if (intflag)
		iregs[nr] = FREE;
	else
		fregs[nr] = FREE;
}

/*
 * return the number of an available register (if it exist)
 */
int reg_avail (iflag,request) int iflag,request; {
	register i,max,nr;

	nr = max = (iflag?MAXIREG:MAXFREG);
	for (i=0; i<max ;i++)
		if (i!=request && (iflag?iregs[i]:fregs[i])==FREE
		  && (request!=ODD_REG || i%2 == 1)) {
			nr=i;
			break;
		}
	if (nr<max)
		return(nr);
	else
		return(-1);
}

/*
 * release all registers
 */
clearegs() {
	register i;

	for(i=0; i<MAXIREG ;i++)
		iregs[i]=FREE;
	for(i=0; i<MAXFREG ;i++)
		fregs[i]=FREE;
}

/*
 * 
 */
fake_t *to_reg0 (ints,empties,s) int ints,empties; char *s; {
	register fake_t *ftop;
	fake_t f;
	char sb[MAXSTRL];

	if (s)
		strcpy(sb,s);
	reg_frame(&f);
	f.index=REG0;
	make_int(ints,empties);
	ftop = fsp;
	if (fsp-ints > fake) {
		while (ints > 0)
			if (fsp->type != STK) {
				fsp--;
				ints--;
			} else
				break;
		empty_fake(empties ? empties+ints : ALL);
		popfk(ints);
	} else
		fsp = fake;
		/* else there are no fake-elements under the top 'ints' words: */
	if (s) {
		getreg(&f,ONLY_REG);
		gen2(MOV,sb,R0);
	} else
		mv_to_reg(ftop,REG0);
	iregs[REG0] = FREE;
	return( s ? ftop : --ftop);
}

/*
 * move a frame to a (integer) register
 */
mv_to_reg (fp,nr) int nr; fake_t *fp; {
	fake_t f;

	reg_frame(&f);
	f.index=nr;
	if ( is_reg(fp)==IREG && (fp->flags & INT)
	   && (nr==ANY || nr==fp->index) )
		f.index=fp->index;
	else
		getreg(&f,ONLY_REG);
	move(fp,&f);
}

/*
 * return IREG or FREG or FALSE if fp is
 * an integer register, floating register or no register at all
 */
int is_reg (fp) fake_t *fp; {
	register char flag;

	if (fp->type != REG)
		return(FALSE);
	if ((flag=fp->flags) & (IND|OFF))
		return(IREG);
	else if (flag & CONV) {
		if (flag & IFC)
			return(IREG);
		else
			return(FREG);
	} else if (flag & INT)
		return(IREG);
	else
		return(FREG);
}

/*
 * if fp is a register, release it
 */
free_reg(fp) fake_t *fp; {
	if (is_reg(fp)==IREG)
		iregs[fp->index] = FREE;
	else if (is_reg(fp)==FREG)
		fregs[fp->index] = FREE;
}

/*
 * if fp is a register, mark it
 */
set_reg(fp) fake_t *fp; {
	
	if (is_reg(fp)==IREG)
		iregs[fp->index] = fp;
	else if (is_reg(fp)==FREG)
		fregs[fp->index] = fp;
}
