/	SUBTITLE	b-gcalter.s	relocate a pointer
/	Written by Steven Hardy on 14 April 1976
/	This function relocates a pointer.
/	the pointer itself is in r0 and the address of the pointer is in
/	-2(r2). (If this sounds funny look at the definition of
/	gcscan which invokes this function).
/
sgcalter:
	mov	-(r0),r3		/ get key to r3
	cmp	r0,bgclused		/ above last record scanned?
	blo	1f			/ br if not
	cmp	r0,bgclfree		/ above its relocation point?
	bhi	1f			/ br if so
	mov	bgclfree,r0
	br	2f
1:
	mov	r0,bgclused		/ set low point
1:
	bic	$mbutsize,r3		/ clear off all but size
	add	r3,r0			/ make r0 point to key of next record
	mov	(r0),r3			/ get key to r3
	bit	r4,r3			/ is it marked?
	bne	1b			/ br if so
	mov	r0,bgclfree		/ set high point
2:
	sub	2(r0),-2(r2)		/ relocate pointer
	rts	pc
