/	SUBTITLE	b-gcmark.s	mark record pointed to
/	Written by Steven Hardy on 21 April 1976
/
/	This function marks all records pointed to (directly or
/	indirectly) by r0.
/	It notifies a stack overflow by setting r1 to the argument ignored
/
sgcmark:
	bit	r4,okey(r0)		/ is record already marked?
	bne	2f			/ br if so
	bis	r4,okey(r0)		/ set mark bit
	cmp	r0,r1			/ is record above scan point?
	bhis	2f			/ br if so
	tst	okey(r0)		/ does record contain pointers?
	bge	2f			/ br if not
	cmp	sp,$ospred		/ are we in danger of a stack overflow?
	blo	1f			/ br if so
	mov	r0,r2			/ set up for gcscan
	mov	-(r0),r3		/ key of r3 to r0
	bic	$mbutsize,r3		/ clear all but size
	add	r2,r3			/ r3 now points to to next record
	sub	$2,r3			/ r3 points to end of this record
	jbr	sgcscan
1:
	mov	r0,r1			/ notify stack overflow
2:
	rts	pc
