;;;	Prolog interpreter
;;;	Written by Claude Sammut, UNSW.
;;;	Installed 16/7/80

vars termb indexb dummy_stack stack database last env;
vars index1 index2 prvars clist cl parent;
vars tracing Index2 make old_stack;

[] ->> stack -> env; false -> tracing;

function dump(env);
	prstring('---------------------------'); pr(newline);
	until env == [] then
		if env == parent then prstring('+ ')
		else prstring('  ') close;
		pr(hd(env)(1)); pr(space);
		pr(hd(env)(2)); pr(newline);
		env.tl -> env
	close;
	prstring('==========================='); pr(newline);
end;

function variable(x);
	if x.isword.not then return(false) close;
	hd(datalist(x)) -> x;
	return((`A <= x) and (x <= `Z))
end;

operation save_env;
	{%cl, index1, clist.tl, index2, parent, old_stack%} :: env -> env;
end;

operation backtrack;
	dest(env) -> env;
	appdata(identfn)->stack->parent->index2->clist->index1->cl;
end;

function pop(x);
	appdata(x.hd, identfn)->dummy_stack->parent->Index2->clist->index1->cl;
end;

function isbound(v, i);
	vars bnd binding key;

	stack -> bnd; cons(v, i) -> key;
	until bnd == [] then
		bnd.hd -> binding;
		if binding.hd = key then
			dest(binding.tl) -> indexb -> termb;
			return(true)
		close;
		bnd.tl -> bnd
	close;
	return(false)
end;

function bind(v, i, t, j);
	cons(cons(cons(v, i), cons(t, j)), stack) -> stack;
end;

function unify(term1, index1, term2, index2);
	if term1 = term2 and index1 == index2 then return(true)
	elseif variable(term1) then
		if isbound(term1, index1) then
			return(unify(termb, indexb, term2, index2))
		else
			bind(term1, index1, term2, index2);
			return(true)
		close
	elseif variable(term2) then
		return(unify(term2, index2, term1, index1))
	elseif term1 == term2 and atom(term1) then return(true)
	elseif not(islist(term1) and islist(term2)) then return(false)
	elseif term1.hd /= term2.hd or length(term1) /= length(term2) then
		return(false)
	else
		vars i;
		for 2 -> i step 1 + i -> i till i > length(term1) then
			if not(unify(term1(i), index1, term2(i), index2)) then
				return(false)
			close
		close;
		return(true)
	close
end;

operation <-(varlist, cl);
	vars successful;

	true -> successful; [] ->> stack ->> env -> parent;
	database -> clist; 1 ->> index1 -> index2;
	lush:
		until cl == [] or not(successful) then
			if cl.hd == "!" then
;;;				dump(env);
				if parent == [] then [] -> env
				else parent.tl -> env
				close;
				cl.tl -> cl
			elseif cl.hd.isfunc then
				cl.hd() -> successful;
				parent.tl -> env;
				[] -> cl;
			elseif variable(cl.hd) then
				make(cl.hd, index2) :: cl.tl -> cl;
			else
				false -> successful;
				index2 + 1 -> index2;
				stack -> old_stack;
				until clist == [] or successful then
					if unify(clist.hd.hd,index2,cl.hd,index1) then
						if tracing then
							prstring('==> ');
							pr(make(clist.hd.hd, index2));
							pr(newline);
						close;
						save_env;
						clist.hd.tl -> cl;
						database -> clist;
						env -> parent;
						index2 -> index1;
						true -> successful
					else
						old_stack -> stack;
						clist.tl -> clist
					close
				close
			close
		close;
		if successful then
			if parent == [] then
				prvars(varlist);
				if env == [] then return
				else backtrack
				close
			else
				pop(parent); cl.tl -> cl;
				database -> clist;
			close
		elseif env == [] then prstring('?\n'); return
		else
;;;			prstring('@ ');
;;;			if clist /== [] then pr(clist.hd) close;
;;;			pr(newline);
			backtrack;
			true -> successful
		close;
	goto lush;
end;

operation add;
	vars l;
	'* ' -> popmess(Prompt);
	until (listread() ->> l) == termin then
		if l.islist then
			if database == [] then
				[% l %] ->> database -> last
			else
				[% l %] -> last.tl;
				last.tl -> last
			close
		else prstring('Eh?\n')
		close
	close;
	': ' -> popmess(Prompt);
	pr(newline);
end;

function make(x, index);
	if x == [] then []
	elseif atom(x) then
		if variable(x) and isbound(x, index) then
			make(termb, indexb);
		else x close
	else make(x.hd, index) :: make(x.tl, index) close
end;

function prvars(varlist);
	until varlist == [] then
		pr(varlist.hd); prstring(' = ');
		pr(make(varlist.hd, 1));
		pr(newline);
		varlist.tl -> varlist
	close
end;

function unbind(term, index);
	if variable(term) and isbound(term, index) then 
		unbind(termb, indexb)
	else return(term, index) close
end;
;;;	Built-in predicates for Prolog

function sum;
	vars x, xi, y, yi, z, zi;

	unbind("X", index2) -> xi -> x;
	unbind("Y", index2) -> yi -> y;
	unbind("Z", index2) -> zi -> z;
	if x.isnumber then
		if y.isnumber then
			if z.isnumber then return(x + y == z)
			else bind(z, zi, x + y, 1)
			close
		elseif z.isnumber then
			bind(y, yi, z - x, 1)
		else return(false)
		close
	elseif y.isnumber and z.isnumber then
			bind(x, xi, z - y, 1)
	else return(false)
	close;
	return(true)
end;

function lt;
	vars x, xi, y, yi;

	unbind("X", index2) -> xi -> x;
	unbind("Y", index2) -> yi -> y;
	if x.isnumber and y.isnumber then return(x < y)
	elseif x.isword and y.isword then return(alphabefore(x, y))
	else return(false) close
end;

function integer;
	vars x xi;

	unbind("X", index2) -> xi -> x;
	if x.isinteger then true
	elseif variable(x) then false
	else false
	close
end;

function output;
	vars x;

	make("X", index2) -> x;
	if x.isstring then prstring(x) else pr(x) close;
	return(true);
end;

function outline;
	pr(newline);
	return(true);
end;

function fail;
	return(false)
end;

function univ1(x);
	if x == [] then "nil"
	elseif atom(x) then x
	else [. %x.hd, univ1(x.tl)%]
	close
end;

function univ;
	vars x xi;

	unbind("X", index2) -> xi -> x;
	if atom(x) then return(unify("Y", index2, [. %x% nil], 1)) close;
	return(unify("Y", index2, univ1(make("X", index2)), 1))
end;

vars qqq; [qqq N] -> qqq;

function mkground;
	vars N;

	function mkground1(x, index);
		if x == [] then return
		elseif atom(x) then
			if variable(x) then
				if isbound(x, index) then
					mkground1(termb, indexb)
				else
					index2 + 1 -> index2;
					bind(x, index, qqq, index2);
					bind("N", index2, N, 1);
					N + 1 -> N;
				close
			close
		else mkground1(x.hd, index); mkground1(x.tl, index)
		close
	end;

	0 -> N;
	mkground1("X", index2);
	return(true)
end;

function settrace;
	true -> tracing;
	return(true);
end;

function unsettrace;
	false -> tracing;
	return(true);
end;

function isprologvar;
	vars x xi;

	unbind("X", index2) -> xi -> x;
	return(variable(x))
end;

function interm();
	unify("X", index2, listread(), 1)
end;

function isprologatom;
	vars x xi;

	unbind("X", index2) -> xi -> x;
	if variable(X) then return(false)
	else return(atom(x))
	close
end;

[
	[fail %fail%]
	[trace %settrace%]
	[untrace %unsettrace%]
	[[sum X Y Z] %sum%]
	[[< X Y] %lt%]
	[[atom X] %isprologatom%]
	[[integer X] %integer%]
	[[variable X] %isprologvar%]
	[[output X] %output%]
	[newline %outline%]
	[[univ X Y] %univ%]
	[[interm X] %interm%]
	[[mkground X] %mkground%]
	[[member X [. X Y]] !]
	[[member X [. A B]] ! [member X B]]
	[[= X X] !]
	[[not X] X ! fail]
	[[not X]]
] -> database;

if database.islist then
	database -> last;
	until last.tl == [] then last.tl -> last close
close;

vars user; last -> user;
