/*
**	log  remote_tty
**
**  File exchange package for remote unices.
**
**  Authors:	too modest to mention
**		June '80
**
**  Also has transparent mode for talking to
**  other operating systems as if local tty.
**
**  For the following reasons this program must be
**  setuid to root for successful use:
**	1. The tty to be used for communication with other machine
**	   is to be owned by root and is to have a mode of 600.
**	2. Needs to run at fairly high priority,
**	   so nice will be used to obtain same.
**	3. The connect system call only allowed to be
**	   used by root, to prevent abuse.
**
** Multiple opens of the same tty are assumed
**  to be taken care of by the appropriate tty
**  drivers (eg dz & dj) supporting the notion
**  of certain ttys being single open, and that
**  ttys used by 'log' for communications are
**  setup as single open.
*/

#define	INIT_DATA
#include	"log.h"
#include	"bytes.h"
#include	"proto.h"
#include	<signal.h>
/*
#include	<param.h>
*/
#include	<lnode.h>




main(argc, argv)
	char *		argv[];
{
	register	ret = 1;
	register char *	cp;
	struct lnode	ln;
	extern char *	strrchr();

	signal(SIGINT, SIG_IGN);
	/*signal(SIGQUIT, SIG_IGN);*/
	nice(HIPRIORITY);

	xfd = 2;


	if ( limits(&ln, L_MYLIM) == SYSERROR )
	{
		perror("limits");
		return ret;
	}
	else
	{
		uid = ln.l_uid;
		dlimit = ln.l_dlimit;
	}

	sentinel();	/* catch all real-time limit expiries */

	if ( (cp = strrchr(argv[0], '/')) == (char *)0 )
		cp = argv[0];
	else
		cp++;

	switch ( *cp )
	{
    case 'l':	if (okuse())
		{
			if ( !(ln.l_flags & USELOG) && ln.l_uid )
			{
				printf("You are not authorised for %s\n", argv[0]);
				return ret;
			}

			log (argc,argv);
			errors();	/* tell about the errors encountered */
			ret = 0;
		}
		else printf("Illegal usage!\n");
		break;

    case 's':	ret = (int)send(argc,argv);
		write(2, MTERMINATE);
#		ifdef	DEBUGSEND
		errors();
#		endif	DEBUGSEND
		break;

    case 'r':	ret = receive (argc,argv);
		write(2, MTERMINATE);
#		ifdef	DEBUGRECV
		errors();
#		endif	DEBUGRECV
		break;

    default:	write(2, MTERMINATE);
	}

	return ret;
}
