/*
**	Transmit protocol handler
**
**	send ahead NBUFS and then start looking for acknowledgements
*/

#include	"log.h"
#include	"proto.h"
#include	"err.h"
#include	"bytes.h"
#include	"list.h"
#include	"timeouts.h"
#include	"jmp.h"


enum r_states
xproto(local, remote)
{
	register listp	lp;
	register	nextseq = 0;
	register long	nextaddr = 0;
	register	retrys = 0;
	listp		alp;

	if ( setjmp(localerr) )
		return r_localerr;

	filesize = 0;
	starting = 1;
	terminate = 0;

	for ( lp = activelist ; lp < &activelist[NBUFS] && !terminate ; lp++ )
	{
		lp->l_seq = nextseq++;
		lp->l_addr = nextaddr;
		nextaddr += putblk(lp, local, remote);
	}

	for(;;)
		switch ( getreply(&alp, remote) )
		{
		 case ETX:	return r_remoterr;
		 case ACK:	retrys = 0;
				lp = alp;
				filesize += lp->l_size;
				if ( terminate )
				{
					register	more = 0;

					lp->l_state = ok_st;

					for ( lp = activelist ; lp < &activelist[NBUFS] ; lp++ )
						if ( lp->l_state == wait_st )
						{
							more++;
							break;
						}

					if ( !more )
						return r_ok;

					continue;
				}

				if ( (lp->l_seq = nextseq++) == MAXSEQ )
					nextseq = 0;
				lp->l_addr = nextaddr;
				nextaddr += putblk(lp, local, remote);
				continue;
		 case NAK:	if ( retrys++ < XRETRYS )
				{
					errs[E_RETRYS].e_count++;
					putblk(alp, local, remote);
					continue;
				}
				return r_remoterr;
		 default:	if ( retrys++ < XRETRYS )
				{
					for ( lp = activelist ; lp < &activelist[NBUFS] ; lp++ )
						if ( lp->l_state == wait_st )
						{
							errs[E_RETRYS].e_count++;
							putblk(lp, local, remote);
						}
					continue;
				}
				return r_remoterr;
		}
}
