#include	<signal.h>

#define	LCASE	01
#define	UCASE	02
#define	SWAB	04
#define	NERR	010
#define	SYNC	020
#define	BTL	040
#define	IBM	0100

int	cflag;
int	fflag;
char	*string;
char	*ifile;
char	*ofile;
char	*ibuf;
char	*obuf;
char	*sbrk();
unsigned	count;
unsigned	skip;
unsigned	iseek;
unsigned	oseek;
unsigned	ibs =	512;
unsigned	obs =	512;
unsigned	bs;
unsigned	cbs;
unsigned	ibc;
unsigned	obc;
unsigned	cbc;
int	nifr;
int	nipr;
int	nofr;
int	nopr;
int	ntrunc;
int	ibf;
int	obf;
char	*op;
int	nspace;

/*
 * EBCDIC to ASCII conversion table
 * based on CACM Nov 68
 */
char	etoa[] =
{
	0000, 0001, 0002, 0003, 0234, 0011, 0206, 0177,
	0227, 0215, 0216, 0013, 0014, 0015, 0016, 0017,
	0020, 0021, 0022, 0023, 0235, 0205, 0010, 0207,
	0030, 0031, 0222, 0217, 0034, 0035, 0036, 0037,
	0200, 0201, 0202, 0203, 0204, 0012, 0027, 0033,
	0210, 0211, 0212, 0213, 0214, 0005, 0006, 0007,
	0220, 0221, 0026, 0223, 0224, 0225, 0226, 0004,
	0230, 0231, 0232, 0233, 0024, 0025, 0236, 0032,
	0040, 0240, 0241, 0242, 0243, 0244, 0245, 0246,
	0247, 0250, 0133, 0056, 0074, 0050, 0053, 0041,
	0046, 0251, 0252, 0253, 0254, 0255, 0256, 0257,
	0260, 0261, 0135, 0044, 0052, 0051, 0073, 0136,
	0055, 0057, 0262, 0263, 0264, 0265, 0266, 0267,
	0270, 0271, 0174, 0054, 0045, 0137, 0076, 0077,
	0272, 0273, 0274, 0275, 0276, 0277, 0300, 0301,
	0302, 0140, 0072, 0043, 0100, 0047, 0075, 0042,
	0303, 0141, 0142, 0143, 0144, 0145, 0146, 0147,
	0150, 0151, 0304, 0305, 0306, 0307, 0310, 0311,
	0312, 0152, 0153, 0154, 0155, 0156, 0157, 0160,
	0161, 0162, 0313, 0314, 0315, 0316, 0317, 0320,
	0321, 0176, 0163, 0164, 0165, 0166, 0167, 0170,
	0171, 0172, 0322, 0323, 0324, 0325, 0326, 0327,
	0330, 0331, 0332, 0333, 0334, 0335, 0336, 0337,
	0340, 0341, 0342, 0343, 0344, 0345, 0346, 0347,
	0173, 0101, 0102, 0103, 0104, 0105, 0106, 0107,
	0110, 0111, 0350, 0351, 0352, 0353, 0354, 0355,
	0175, 0112, 0113, 0114, 0115, 0116, 0117, 0120,
	0121, 0122, 0356, 0357, 0360, 0361, 0362, 0363,
	0134, 0237, 0123, 0124, 0125, 0126, 0127, 0130,
	0131, 0132, 0364, 0365, 0366, 0367, 0370, 0371,
	0060, 0061, 0062, 0063, 0064, 0065, 0066, 0067,
	0070, 0071, 0372, 0373, 0374, 0375, 0376, 0377,
};

/*
 * ASCII to EBCDIC conversion table
 * based on CACM Nov 68
 */
char	atoe[] =
{
	0000, 0001, 0002, 0003, 0067, 0055, 0056, 0057,
	0026, 0005, 0045, 0013, 0014, 0015, 0016, 0017,
	0020, 0021, 0022, 0023, 0074, 0075, 0062, 0046,
	0030, 0031, 0077, 0047, 0034, 0035, 0036, 0037,
	0100, 0117, 0177, 0173, 0133, 0154, 0120, 0175,
	0115, 0135, 0134, 0116, 0153, 0140, 0113, 0141,
	0360, 0361, 0362, 0363, 0364, 0365, 0366, 0367,
	0370, 0371, 0172, 0136, 0114, 0176, 0156, 0157,
	0174, 0301, 0302, 0303, 0304, 0305, 0306, 0307,
	0310, 0311, 0321, 0322, 0323, 0324, 0325, 0326,
	0327, 0330, 0331, 0342, 0343, 0344, 0345, 0346,
	0347, 0350, 0351, 0112, 0340, 0132, 0137, 0155,
	0171, 0201, 0202, 0203, 0204, 0205, 0206, 0207,
	0210, 0211, 0221, 0222, 0223, 0224, 0225, 0226,
	0227, 0230, 0231, 0242, 0243, 0244, 0245, 0246,
	0247, 0250, 0251, 0300, 0152, 0320, 0241, 0007,
	0040, 0041, 0042, 0043, 0044, 0025, 0006, 0027,
	0050, 0051, 0052, 0053, 0054, 0011, 0012, 0033,
	0060, 0061, 0032, 0063, 0064, 0065, 0066, 0010,
	0070, 0071, 0072, 0073, 0004, 0024, 0076, 0341,
	0101, 0102, 0103, 0104, 0105, 0106, 0107, 0110,
	0111, 0121, 0122, 0123, 0124, 0125, 0126, 0127,
	0130, 0131, 0142, 0143, 0144, 0145, 0146, 0147,
	0150, 0151, 0160, 0161, 0162, 0163, 0164, 0165,
	0166, 0167, 0170, 0200, 0212, 0213, 0214, 0215,
	0216, 0217, 0220, 0232, 0233, 0234, 0235, 0236,
	0237, 0240, 0252, 0253, 0254, 0255, 0256, 0257,
	0260, 0261, 0262, 0263, 0264, 0265, 0266, 0267,
	0270, 0271, 0272, 0273, 0274, 0275, 0276, 0277,
	0312, 0313, 0314, 0315, 0316, 0317, 0332, 0333,
	0334, 0335, 0336, 0337, 0352, 0353, 0354, 0355,
	0356, 0357, 0372, 0373, 0374, 0375, 0376, 0377,
};


main(argc, argv)
int	argc;
char	**argv;
{
	register (*conv)();
	register char *ip;
	register c;
	int ebcdic(), ascii(), null(), cnull(), term(), pad(), trim();

	conv = null;
	for (c = 1; c < argc; c++)
	{
		string = argv[c];
		if (match("ibs="))
		{
			ibs = number();
			continue;
		}
		if (match("obs="))
		{
			obs = number();
			continue;
		}
		if (match("cbs="))
		{
			cbs = number();
			continue;
		}
		if (match("bs="))
		{
			bs = number();
			continue;
		}
		if (match("if="))
		{
			ifile = string;
			continue;
		}
		if (match("of="))
		{
			ofile = string;
			continue;
		}
		if (match("skip="))
		{
			skip = number();
			continue;
		}
		if (match("iseek="))
		{
			iseek = number();
			continue;
		}
		if (match("oseek="))
		{
			oseek = number();
			continue;
		}
		if (match("count="))
		{
			count = number();
			continue;
		}
		if (match("conv="))
		{
			while (*string)
			{
				if (match(","))
					continue;
				if (match("ebcdic"))
				{
					conv = ebcdic;
					continue;
				}
				if (match("ascii"))
				{
					conv = ascii;
					continue;
				}
				if (match("btl"))
				{
					cflag |= BTL;
					continue;
				}
				if (match("ibm"))
				{
					cflag |= IBM;
					continue;
				}
				if (match("lcase"))
				{
					cflag |= LCASE;
					continue;
				}
				if (match("ucase"))
				{
					cflag |= UCASE;
					continue;
				}
				if (match("pad"))
				{
					conv = pad;
					continue;
				}
				if (match("trim"))
				{
					conv = trim;
					continue;
				}
				if (match("swab"))
				{
					cflag |= SWAB;
					continue;
				}
				if (match("noerror"))
				{
					cflag |= NERR;
					continue;
				}
				if (match("sync"))
				{
					cflag |= SYNC;
					continue;
				}
				break;
			}
			if (*string == 0)
				continue;
		}
		prints(string);
		prints(": unrecognised\n");
		prints("Usage: dd [option=value] ...\n");
		prints("  options: [if of] [bs ibs obs] [iseek oseek skip] [conv cbs] [count]\n");
		prints("   conv values: ebcdic,ascii,pad,trim\n");
		prints("      and     : btl,ibm,lcase,ucase,swab,noerror,sync\n");
		exit(1);
	}
	if (conv == null && cflag & (LCASE|UCASE))
		conv = cnull;
	if (ifile)
		ibf = open(ifile, 0);
	else
		ibf = 0;		/* use standard input */
	if (ibf < 0)
	{
		perror(ifile);
		exit(1);
	}
	if (ofile)
		if (oseek)		/* implies file already exists */
			obf = open(ofile, 1);
		else
			obf = creat(ofile, 0600);
	else
		obf = 1;		/* use standard output */
	if (obf < 0)
	{
		perror(ofile);
		exit(1);
	}
	if (bs)
	{
		ibs = obs = bs;
	}
	if (ibs == obs && conv == null)
		fflag++;
	if (ibs == 0 || obs == 0)
	{
		prints("I/O block size not specified\n");
		exit(1);
	}
	if (cbs == 0 && (conv == pad || conv == trim))
	{
		prints("Conversion buffer size not specified\n");
		exit(1);
	}
	if (cflag & (BTL|IBM) && conv != ebcdic && conv != ascii)
	{
		prints("Must also specify ebcdic or ascii conversion\n");
		exit(1);
	}
	if (cflag & BTL)
		btl();
	if (cflag & IBM)
		ibm();
	if (iseek)
	{
		lseek(ibf, (long)iseek * (long)ibs, 0);
	}
	if (oseek)
	{
		lseek(obf, (long)oseek * (long)obs, 0);
	}
	ibuf = sbrk(ibs);
	if (fflag)
		obuf = ibuf;
	else
		obuf = sbrk(obs);
	if (ibuf == (char *)-1 || obuf == (char *)-1)
	{
		prints("Not enough memory\n");
		exit(1);
	}
	ibc = 0;
	obc = 0;
	cbc = 0;
	op = obuf;
	if (signal(SIGINT, SIG_IGN) == 0)
		signal(SIGINT, term);

	while (skip)
	{
		if (read(ibf, ibuf, ibs) == -1 && (cflag & NERR) == 0)
		{
			perror("skip");
			exit(1);
		}
		skip--;
	}

	for (;;)
	{
		if (ibc--)
		{
			(*conv)(*ip++ & 0377);
			continue;
		}
		ibc = 0;
		/*
		 * count == 0  implies unlimited - go to EOF
		 */
		if (count == 0 || nifr + nipr != count)
		{
			if (cflag & (NERR | SYNC))
				for (ip = ibuf; ip < &ibuf[ibs]; *ip++ = 0);
			ibc = read(ibf, ibuf, ibs);
		}
		if (ibc == -1)
		{
			perror("read");
			if ((cflag & NERR) == 0)
			{
				flsh();
				term(1);
			}
			ibc = 0;
			for (c = 0; c < ibs; c++)
				if (ibuf[c] != 0)
					ibc = c;	/* find the high water mark */
			printn(ibc);
			prints(" bytes OK in last read\n");
			stats();
		}
		if (ibc == 0)		/* EOF */
		{
			flsh();
			term(0);
		}
		if (ibc != ibs)
		{
			nipr++;
			if (cflag & SYNC)
				ibc = ibs;
		}
		else
			nifr++;
		ip = ibuf;
		if (cflag & SWAB)
		{
			c = ibc >> 1;	/* number of words (truncated) */
			while (c--)
			{
				char a;

				a = *ip++;
				ip[-1] = *ip;
				*ip++ = a;
			}
		}
		ip = ibuf;
		if (fflag)
		{
			obc = ibc;
			flsh();
			ibc = 0;
		}
	}
}

/*
 *	Convert CACM standard ASCII/EBCDIC tables to
 *	a proposed BTL standard dated April 16, 1979
 */
btl()
{
	etoa[0112] = 0325; etoa[0117] = 0174;
	etoa[0132] = 0041; etoa[0137] = 0176;
	etoa[0152] = 0313; etoa[0232] = 0136;
	etoa[0241] = 0345; etoa[0255] = 0133;
	etoa[0275] = 0135;
	atoe[0041] = 0132; atoe[0133] = 0255;
	atoe[0135] = 0275; atoe[0136] = 0232;
	atoe[0174] = 0117; atoe[0176] = 0137;
	atoe[0313] = 0152; atoe[0325] = 0112;
	atoe[0345] = 0241;
}

/*
 *	Convert CACM standard EBCDIC table to
 *	a form better understood by some IBM print trains
 *	NOTE: conversion is NOT unique
 */
ibm()
{
	atoe[0041] = 0132; atoe[0133] = 0255;
	atoe[0135] = 0275; atoe[0174] = 0117;
}

flsh()
{
	register c;

	if (obc)
	{
		if (obc == obs)
			nofr++;
		else
			nopr++;
		c = write(obf, obuf, obc);
		if (c != obc)
		{
			perror("write");
			term(1);
		}
		obc = 0;
	}
}

match(s)
register char *s;
{
	register char *cs;

	cs = string;
	while (*cs++ == *s)
	{
		if (*s == '\0')
			break;
		s++;
	}
	if (*s != '\0')
		return(0);
	cs--;
	string = cs;
	return(1);
}

number()
{
	register char *cs;
	register n, base;

	cs = string;
	n = 0;
	base = 10;
	if (*cs == '0')
	{
		base = 8;
		cs++;
	}
	while (*cs >= '0' && *cs <= '9')
		n = n * base + *cs++ - '0';
	for (;;)
	{
		switch(*cs++)
		{
	    case 'k':	n *= 1024;
			continue;

	    case 'w':	n *= 2;
			continue;

	    case 'b':	n *= 512;
			continue;

	    case '*':	string = cs;
			n *= number();
	    case '\0':	return(n);

		}
		break;
	}

	prints(string);
	prints(": number expected\n");
	exit(1);
}

cnull(c)
register c;
{
	if (cflag & UCASE && c >= 'a' && c <= 'z')
		c += 'A'-'a';
	if (cflag & LCASE && c >= 'A' && c <= 'Z')
		c += 'a' - 'A';
	null(c);
}

null(c)
{
	*op++ = c;
	if (++obc >= obs)
	{
		flsh();
		op = obuf;
	}
}

ascii(c)
register c;
{
	c = etoa[c] & 0377;
	if (cbs == 0)
	{
		cnull(c);
		return;
	}
	trim(c);
}

trim(c)
{
	if (c == ' ')
		nspace++;
	else
	{
		while (nspace > 0)
		{
			null(' ');
			nspace--;
		}
		cnull(c);
	}
	if (++cbc >= cbs)
	{
		null('\n');
		cbc = 0;
		nspace = 0;
	}
}

ebcdic(c)
register c;
{
	register wasnl;

	wasnl = c == '\n';
	if (cflag & UCASE && c >= 'a' && c <= 'z')
		c += 'A'-'a';
	if (cflag & LCASE && c >= 'A' && c <= 'Z')
		c += 'a'-'A';
	c = atoe[c] & 0377;
	if (cbs == 0)
	{
		null(c);
		return;
	}
	if (wasnl)
	{
		while (cbc < cbs)
		{
			null(atoe[' ']);
			cbc++;
		}
		cbc = 0;
		return;
	}
	if (cbc == cbs)
		ntrunc++;
	cbc++;
	if (cbc <= cbs)
		null(c);
}

pad(c)
register c;
{
	if (c == '\n')
	{
		while (cbc < cbs)
		{
			null(' ');
			cbc++;
		}
		cbc = 0;
		return;
	}
	if (cbc == cbs)
		cbc = 0;	/* pad to nearest multiple of cbs */
	cbc++;
	cnull(c);
}

term(status)
{
	signal(2, 1);
	stats();
	exit(status);
}

stats()
{
	printn(nifr);
	prints("+");
	printn(nipr);
	prints(" records in\n");
	printn(nofr);
	prints("+");
	printn(nopr);
	prints(" records out\n");
	if (ntrunc)
	{
		printn(ntrunc);
		prints(" truncated records\n");
	}
}

printn(n)
register unsigned n;
{
	register char *cp, *s;

	s = "0123456789";
	cp = &s[10];
	do
	{
		*--cp = n % 10 + '0';
		n /= 10;
	} while (n);
	prints(cp);
}

prints(s)
char *s;
{
	write(2, s, strlen(s));
}
