#include "signal.h"
#include "stdio.h"
#include "lrnref"

wrapup(n)
int n;
{
	/* this routine does not use 'system' because it wants
	 interrupts turned off */
	int retval, pid, pidw;

	signal(SIGINT, SIG_IGN);
	chdir("..");
	if ( (pid=fork()) ==0) {
		signal(SIGHUP, SIG_IGN);
		execl("/bin/rm", "rm", "-r", dir, 0);
		execl("/usr/bin/rm", "rm", "-r", dir, 0);
		fprintf(stderr, "Can't find 'rm' command.\n");
		exit(0);
	}
#ifdef UNSW
	if (lastlesson != NULL)
	{
		printf("The last lesson you did was %s\n",lastlesson);
		printf("Remember this number for your next learning session.\n");
		fflush(stdout);
	}
	if (shpid)
		kill(shpid,9);  /* inhibit times from interactive shell */
	printf("Goodbye, Mr/Ms %s.\n", lastname);
#else
	printf ("Bye.\n");  /* not only does this reassure the user,
			it stalls for time while deleting directory */
#endif
	fflush(stdout);  sleep(2);	/* wait for flushing */
	/* printf("Wantd %d got %d val %d\n",pid, pidw, retval); */
	exit(n);
}
